/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import java.io.Serializable;

public class TagRational
extends Number
implements Serializable {
    private static final long serialVersionUID = 3088068438676854749L;
    private int numerator;
    private int denominator;

    public TagRational(int i, int j) {
        this.numerator = i;
        this.denominator = j;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public final byte byteValue() {
        return (byte)this.doubleValue();
    }

    public final int intValue() {
        return (int)(this.doubleValue() + 0.5);
    }

    public final long longValue() {
        return (long)this.doubleValue();
    }

    public final short shortValue() {
        return (short)this.doubleValue();
    }

    public final int getDenominator() {
        return this.denominator;
    }

    public final int getNumerator() {
        return this.numerator;
    }

    public TagRational reciprocal() {
        return new TagRational(this.denominator, this.numerator);
    }

    public void multiply(int i, int j) {
        this.numerator *= i;
        this.denominator *= j;
    }

    public boolean isInteger() {
        return this.denominator == 1 || this.denominator != 0 && this.numerator % this.denominator == 0 || this.denominator == 0 && this.numerator == 0;
    }

    public String toString() {
        return this.numerator + "/" + this.denominator;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TagRational)) {
            return false;
        }
        TagRational rational = (TagRational)obj;
        return this.numerator == rational.numerator && this.denominator == rational.denominator;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this.numerator;
        hash = 89 * hash + this.denominator;
        return hash;
    }
}

