/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.arw;

import it.tidalwave.imageio.arw.ARWMetadata;
import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ARWSizeOperation
extends SizeOperation {
    private static final Logger logger = ARWSizeOperation.getLogger(ARWSizeOperation.class);
    @CheckForNull
    private Insets crop;
    @CheckForNull
    private Dimension size;

    public void init(@Nonnull PipelineArtifact artifact) throws Exception {
        logger.fine("init(%s)", artifact);
        ARWMetadata metadata = (ARWMetadata)artifact.getRAWMetadata();
        MinoltaRawData.PRD prd = metadata.getMinoltaRawData().getPRD();
        this.size = prd.getImageSize();
        Dimension sensorSize = prd.getCcdSize();
        this.crop = new Insets((sensorSize.height - this.size.height) / 2, (sensorSize.width - this.size.width) / 2, (sensorSize.height - this.size.height) / 2, (sensorSize.width - this.size.width) / 2);
        logger.finer(">>>> sensor size: %s, size: %s, crop: %s", sensorSize, this.size, this.crop);
    }

    @Nonnull
    protected Insets getCrop(@Nonnull PipelineArtifact artifact) {
        return this.crop;
    }

    @Nonnull
    protected Dimension getSize(@Nonnull PipelineArtifact artifact) {
        return this.size;
    }
}

