/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.mrw;

import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.mrw.MRWMetadata;
import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;

public class MRWWhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = MRWWhiteBalanceOperation.getLogger(MRWWhiteBalanceOperation.class);

    public MRWWhiteBalanceOperation() {
        super(Source.Type.RAW);
    }

    public void process(PipelineArtifact artifact) {
        logger.fine("process()", new Object[0]);
        MRWMetadata metadata = (MRWMetadata)artifact.getRAWMetadata();
        MinoltaRawData.WBG wbg = metadata.getMinoltaRawData().getWBG();
        artifact.multiplyRedCoefficient(wbg.getRedCoefficient().doubleValue());
        artifact.multiplyGreenCoefficient(wbg.getGreen1Coefficient().doubleValue());
        artifact.multiplyBlueCoefficient(wbg.getBlueCoefficient().doubleValue());
    }
}

