/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.srf;

import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.tiff.IFDSupport;

public class SonySRFMakerNoteSupport
extends IFDSupport {
    private static final long serialVersionUID = 3029403930493230394L;
    public static final TagRegistry REGISTRY = TagRegistry.getRegistry("SonySRF");
    public static final Object SRF2_KEY = REGISTRY.register(0, "SRF2 Key");
    public static final Object RASTER_KEY = REGISTRY.register(1, "Raster Key");
    public static final Object RASTER_OFFSET = REGISTRY.register(4, "Raster Offset");
    public static final Object RASTER_BYTE_COUNT = REGISTRY.register(5, "Raster Byte Count");
    public static final Object SENSOR_SIZE = REGISTRY.register(45099, "Sensor Size");
    public static final Object THUMBNAIL_SIZE = REGISTRY.register(45100, "Thumbnail Size");

    public SonySRFMakerNoteSupport() {
        super(REGISTRY);
    }

    public boolean isSRF2KeyAvailable() {
        return this.containsTag(SRF2_KEY);
    }

    public int getSRF2Key() {
        return this.getInteger(SRF2_KEY);
    }

    public boolean isRasterKeyAvailable() {
        return this.containsTag(RASTER_KEY);
    }

    public int getRasterKey() {
        return this.getInteger(RASTER_KEY);
    }

    public boolean isRasterOffsetAvailable() {
        return this.containsTag(RASTER_OFFSET);
    }

    public int getRasterOffset() {
        return this.getInteger(RASTER_OFFSET);
    }

    public boolean isRasterByteCountAvailable() {
        return this.containsTag(RASTER_BYTE_COUNT);
    }

    public int getRasterByteCount() {
        return this.getInteger(RASTER_BYTE_COUNT);
    }

    public boolean isSensorSizeAvailable() {
        return this.containsTag(SENSOR_SIZE);
    }

    public int[] getSensorSize() {
        return this.getIntegers(SENSOR_SIZE);
    }

    public boolean isThumbnailSizeAvailable() {
        return this.containsTag(THUMBNAIL_SIZE);
    }

    public int[] getThumbnailSize() {
        return this.getIntegers(THUMBNAIL_SIZE);
    }
}

