/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import java.io.File;
import javax.swing.filechooser.FileFilter;

class ImageExtensionFileFilter
extends FileFilter {
    String description;
    String[] extensions;

    public ImageExtensionFileFilter(String description, String extension) {
        this(description, new String[]{extension});
    }

    public ImageExtensionFileFilter(String description, String[] extensions) {
        this.description = description == null ? extensions[0] : description;
        this.extensions = (String[])extensions.clone();
        this.toLower(this.extensions);
    }

    private void toLower(String[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = array[i].toLowerCase();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String path = file.getAbsolutePath().toLowerCase();
        for (String extension : this.extensions) {
            if (!path.endsWith(extension) || path.charAt(path.length() - extension.length() - 1) != '.') continue;
            return true;
        }
        return false;
    }
}

