/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.TextNumericTextField;
import WatermarkHelper.JFontChooser;
import WatermarkHelper.WaterMarkHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextGUI
extends JFrame {
    WaterMarkHelper textHelper;
    Font textFont = null;
    Color textColor = new Color(0, 0, 0);
    boolean isUpdate = false;
    int updateIndex;
    private JColorChooser jFColorChooser1;
    private JLabel HspaceLabel;
    private JTextField HspaceTextField;
    private JTextField VSpaceTextField;
    private JLabel VspaceLabel;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;

    public TextGUI(WaterMarkHelper helper, boolean Update, int Index) {
        this.textHelper = helper;
        this.textHelper.getMainStatus().setText(this.textHelper.getProperty("message.text.open"));
        this.isUpdate = Update;
        this.updateIndex = Index;
        this.initComponents();
    }

    public TextGUI(WaterMarkHelper helper) {
        this.textHelper = helper;
        this.textHelper.getMainStatus().setText(this.textHelper.getProperty("message.text.open"));
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextField1 = new JTextField();
        this.jSlider1 = new JSlider();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.HspaceLabel = new JLabel();
        this.VspaceLabel = new JLabel();
        this.jTextField2 = new TextNumericTextField();
        this.jTextField3 = new TextNumericTextField();
        this.HspaceTextField = new TextNumericTextField();
        this.VSpaceTextField = new TextNumericTextField();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.textFont = new Font("Arial", 1, 12);
        this.setTitle(this.textHelper.getProperty("title.text.gui"));
        this.setDefaultCloseOperation(0);
        this.setBackground(new Color(51, 51, 51));
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Frame frame = (Frame)evt.getSource();
                frame.dispose();
                TextGUI.this.textHelper.setEnable(TextGUI.this.textHelper.getMainFrame());
                TextGUI.this.textHelper.getMainStatus().setText(TextGUI.this.textHelper.getProperty("message.text.close"));
            }
        });
        this.jPanel1.setBackground(new Color(51, 51, 51));
        this.jLabel1.setBackground(new Color(204, 204, 204));
        this.jLabel1.setFont(new Font("Palatino Linotype", 0, 18));
        this.jLabel1.setForeground(new Color(204, 204, 204));
        this.jLabel1.setText("Text Watermarker");
        this.jLabel2.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel2.setForeground(new Color(255, 102, 0));
        this.jLabel2.setText("[?]");
        this.jLabel2.setToolTipText(this.textHelper.getProperty("help.text"));
        this.jPanel2.setBackground(new Color(51, 51, 51));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Set details", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jPanel2.setForeground(new Color(51, 51, 51));
        this.jLabel3.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel3.setForeground(new Color(204, 204, 204));
        this.jLabel3.setText("Set Font");
        this.jLabel4.setBackground(new Color(204, 204, 204));
        this.jLabel4.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel4.setForeground(new Color(204, 204, 204));
        this.jLabel4.setText("Choose Color");
        this.jLabel6.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel6.setForeground(new Color(204, 204, 204));
        this.jLabel6.setText("Set Fill");
        this.jButton1.setText("Select Font");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextGUI.this.selectFontAction(evt);
            }
        });
        this.jButton2.setText("Choose Colour");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextGUI.this.chooseColourAction(evt);
            }
        });
        this.jTextField1.setText("100%");
        this.jTextField1.setEditable(false);
        this.jTextField1.setToolTipText("Fill/Opacity");
        this.jSlider1.setMinimum(5);
        this.jSlider1.setValue(100);
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TextGUI.this.FillChangeAction(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2)).addComponent(this.jSlider1, -1, 191, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jButton1).addComponent(this.jLabel4).addComponent(this.jButton2)).addGap(11, 11, 11).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSlider1, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBackground(new Color(51, 51, 51));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Position Select", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jLabel7.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel7.setForeground(new Color(204, 204, 204));
        this.jLabel7.setText("Choose Position");
        this.jLabel8.setBackground(new Color(204, 204, 204));
        this.jLabel8.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel8.setForeground(new Color(204, 204, 204));
        this.jLabel8.setText("X");
        this.jLabel9.setFont(new Font("Palatino Linotype", 0, 11));
        this.jLabel9.setForeground(new Color(204, 204, 204));
        this.jLabel9.setText("Y");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Horizontal Top Left", "Horizontal Top Center", "Horizontal Top Right", "Horizontal Middle Left", "Horizontal Middle Center", "Horizontal Middle Right", "Horizontal Bottom Left", "Horizontal Bottom Center", "Horizontal Bottom Right", "Horizontal Coustome", "Top-Bottom Diognal", "Bottom-Top Diognal", "Vertical Top Left", "Vertical Top Center", "Vertical Top Right", "Vertical Middle Left", "Vertical Middle Center", "Vertical Middle Right", "Vertical Bottom Left", "Vertical Bottom Center", "Vertical Bottom Right", "Vertical Coustome"}));
        this.jComboBox1.setToolTipText("Select Position to Watermark");
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextGUI.this.CheckCustomePosition(evt);
            }
        });
        this.HspaceLabel.setFont(new Font("Palatino Linotype", 0, 11));
        this.HspaceLabel.setForeground(new Color(204, 204, 204));
        this.HspaceLabel.setText("Space from Left Edge");
        this.VspaceLabel.setFont(new Font("Palatino Linotype", 0, 11));
        this.VspaceLabel.setForeground(new Color(204, 204, 204));
        this.VspaceLabel.setText("Space from Top Edge");
        this.jTextField2.setText("0");
        this.jTextField2.setToolTipText("X position");
        this.jTextField2.setEnabled(false);
        this.jTextField2.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextGUI.this.XcheckNumber(evt);
            }
        });
        this.jTextField3.setText("0");
        this.jTextField3.setEnabled(false);
        this.jTextField3.setToolTipText("Y position");
        this.jTextField3.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextGUI.this.YcheckNumber(evt);
            }
        });
        this.HspaceTextField.setText("0");
        this.HspaceTextField.setToolTipText("Set Horizontal spacing (pix) from image Edge");
        this.HspaceTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextGUI.this.HspaceNumberCheck(evt);
            }
        });
        this.VSpaceTextField.setText("0");
        this.VSpaceTextField.setToolTipText("Set Vertical spacing (pix) from image Edge");
        this.VSpaceTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                TextGUI.this.VspaceNumberCheck(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8)).addGap(33, 33, 33).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField2, 0, 0, Short.MAX_VALUE).addComponent(this.jTextField3, -2, 41, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.VspaceLabel, -1, -1, Short.MAX_VALUE).addComponent(this.HspaceLabel, -1, 175, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.HspaceTextField).addComponent(this.VSpaceTextField, -1, 42, Short.MAX_VALUE))).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE)).addGap(14, 14, 14)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.HspaceLabel).addComponent(this.HspaceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.VSpaceTextField, -2, -1, -2).addComponent(this.VspaceLabel)).addContainerGap(10, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jLabel9)).addContainerGap()));
        this.jButton3.setText("Add");
        this.jButton3.setToolTipText("Add Text Watermarker");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextGUI.this.AddTextWatermarker(evt);
            }
        });
        this.jButton4.setText("Cancel");
        this.jButton4.setText("Cancel");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextGUI.this.CancelFont(evt);
            }
        });
        this.jPanel4.setBackground(new Color(51, 51, 51));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 153, 255), 1, true), "Set Text for Watermarking", 0, 0, new Font("Palatino Linotype", 0, 11), new Color(0, 153, 255)));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        if (this.isUpdate) {
            ArrayList EditList = (ArrayList)this.textHelper.getWaterMarkerList().get(this.updateIndex);
            String[] text = (String[])EditList.get(1);
            Font f = (Font)EditList.get(7);
            Color c = (Color)EditList.get(8);
            int Fill = Integer.parseInt(EditList.get(9).toString());
            String textPosition = EditList.get(10).toString();
            String X = EditList.get(11).toString();
            String Y = EditList.get(12).toString();
            String hSpace = EditList.get(13).toString();
            String vSpace = EditList.get(14).toString();
            String textValue = "";
            for (int i = 0; i < text.length; ++i) {
                textValue = textValue + text[i] + "\n";
            }
            this.jTextArea1.setText(textValue);
            this.textFont = f;
            this.textColor = c;
            this.jTextArea1.setFont(this.textFont);
            this.jTextArea1.setForeground(c);
            this.jSlider1.setValue(Fill);
            this.jTextField1.setText(EditList.get(9).toString() + "%");
            this.jComboBox1.setSelectedItem(textPosition);
            this.jTextField2.setText(X);
            this.jTextField3.setText(Y);
            this.HspaceTextField.setText(hSpace);
            this.VSpaceTextField.setText(vSpace);
            this.jButton3.setText("Update");
        } else {
            this.jTextArea1.setFont(this.textFont);
            this.jTextArea1.setForeground(Color.BLACK);
            this.jTextField2.setText("0");
            this.jTextField3.setText("0");
            this.HspaceTextField.setText("0");
            this.VSpaceTextField.setText("0");
            this.jButton3.setText("Add");
            this.jTextField1.setText("100%");
        }
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 335, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 81, Short.MAX_VALUE).addGap(10, 10, 10)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(53, 53, 53).addComponent(this.jButton3, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 101, Short.MAX_VALUE).addComponent(this.jButton4, -2, 94, -2).addGap(53, 53, 53)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(118, Short.MAX_VALUE).addComponent(this.jLabel1).addGap(98, 98, 98).addComponent(this.jLabel2).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, 113, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4).addComponent(this.jButton3)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(34, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 425) / 2, (screenSize.height - 440) / 2, 425, 440);
    }

    private void FillChangeAction(ChangeEvent evt) {
        this.textHelper.sliderChangeAction(this.jSlider1, this.jTextField1);
    }

    private void XcheckNumber(FocusEvent evt) {
        this.textHelper.checkNumber(this.jTextField2);
    }

    private void YcheckNumber(FocusEvent evt) {
        this.textHelper.checkNumber(this.jTextField3);
    }

    private void HspaceNumberCheck(FocusEvent evt) {
        this.textHelper.checkNumber(this.HspaceTextField);
    }

    private void VspaceNumberCheck(FocusEvent evt) {
        this.textHelper.checkNumber(this.VSpaceTextField);
    }

    private void AddTextWatermarker(ActionEvent evt) {
        if (this.jTextArea1.getText().length() >= 1) {
            ArrayList<Object> textData = new ArrayList<Object>();
            String text = this.jTextArea1.getText();
            String[] textString = text.split("\n");
            textData.add("TEXT");
            textData.add(textString);
            textData.add(null);
            textData.add(null);
            textData.add(null);
            textData.add(null);
            textData.add(null);
            textData.add(this.textFont);
            textData.add(this.textColor);
            textData.add(this.jSlider1.getValue());
            textData.add(this.jComboBox1.getSelectedItem().toString());
            textData.add(this.jTextField2.getText());
            textData.add(this.jTextField3.getText());
            textData.add(this.HspaceTextField.getText());
            textData.add(this.VSpaceTextField.getText());
            if (this.isUpdate) {
                this.textHelper.getWaterMarkerList().set(this.updateIndex, textData);
                this.textHelper.Info("Updating Text Watermarker at Index:" + this.updateIndex + " with Parameters List: " + textData);
            } else {
                this.textHelper.getWaterMarkerList().add(textData);
                this.textHelper.Info("Adding Text Watermarker with Parameters List: " + textData);
            }
            this.dispose();
            this.textHelper.setEnable(this.textHelper.getMainFrame());
            this.textHelper.getMainWaterMarksDetails().removeAll();
            this.textHelper.setWaterMarkDetails();
            this.textHelper.getMainStatus().setText(this.textHelper.getProperty("message.text.success"));
        } else {
            JOptionPane.showMessageDialog(this.jPanel1, this.textHelper.getProperty("message.text.warning.text"));
        }
    }

    private void CheckCustomePosition(ActionEvent evt) {
        String position = this.jComboBox1.getSelectedItem().toString();
        if (position.equalsIgnoreCase("Horizontal Coustome") || position.equalsIgnoreCase("Vertical Coustome")) {
            this.jTextField2.setEnabled(true);
            this.jTextField3.setEnabled(true);
            this.VSpaceTextField.setEnabled(false);
            this.VSpaceTextField.setText("0");
            this.HspaceTextField.setEnabled(false);
            this.HspaceTextField.setText("0");
            this.HspaceLabel.setText("Not Applicable");
            this.VspaceLabel.setText("Not Applicable");
        } else {
            this.jTextField2.setEnabled(false);
            this.jTextField2.setText("0");
            this.jTextField3.setEnabled(false);
            this.jTextField3.setText("0");
            if (position.equalsIgnoreCase("Horizontal Top Left") || position.equalsIgnoreCase("Vertical Top Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.VspaceLabel.setText("Space from Top Edge");
                this.HspaceTextField.setEnabled(true);
                this.HspaceTextField.setText("0");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (position.equalsIgnoreCase("Horizontal Top Center") || position.equalsIgnoreCase("Vertical Top Center")) {
                this.HspaceLabel.setText("Not Applicable");
                this.VspaceLabel.setText("Space from Top Edge");
                this.HspaceTextField.setEnabled(false);
                this.HspaceTextField.setText("0");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (position.equalsIgnoreCase("Horizontal Top Right") || position.equalsIgnoreCase("Vertical Top Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.VspaceLabel.setText("Space from Top Edge");
                this.HspaceTextField.setEnabled(true);
                this.HspaceTextField.setText("0");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (position.equalsIgnoreCase("Horizontal Middle Left") || position.equalsIgnoreCase("Vertical Middle Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.VspaceLabel.setText("Not Applicable");
                this.HspaceTextField.setEnabled(true);
                this.HspaceTextField.setText("0");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
            } else if (position.equalsIgnoreCase("Horizontal Middle Center") || position.equalsIgnoreCase("Vertical Middle Center") || position.equalsIgnoreCase("Top-Bottom Diognal") || position.equalsIgnoreCase("Bottom-Top Diognal")) {
                this.HspaceLabel.setText("Not Applicable");
                this.VspaceLabel.setText("Not Applicable");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
                this.HspaceTextField.setEnabled(false);
                this.HspaceTextField.setText("0");
            } else if (position.equalsIgnoreCase("Horizontal Middle Right") || position.equalsIgnoreCase("Vertical Middle Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.VspaceLabel.setText("Not Applicable");
                this.HspaceTextField.setEnabled(true);
                this.HspaceTextField.setText("0");
                this.VSpaceTextField.setEnabled(false);
                this.VSpaceTextField.setText("0");
            } else if (position.equalsIgnoreCase("Horizontal Bottom Left") || position.equalsIgnoreCase("Vertical Bottom Left")) {
                this.HspaceLabel.setText("Space from Left Edge");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.HspaceTextField.setEnabled(true);
                this.HspaceTextField.setText("0");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (position.equalsIgnoreCase("Horizontal Bottom Center") || position.equalsIgnoreCase("Vertical Bottom Center")) {
                this.HspaceLabel.setText("Not Applicable");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.HspaceTextField.setEnabled(false);
                this.HspaceTextField.setText("0");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            } else if (position.equalsIgnoreCase("Horizontal Bottom Right") || position.equalsIgnoreCase("Vertical Bottom Right")) {
                this.HspaceLabel.setText("Space from Right Edge");
                this.VspaceLabel.setText("Space from Bottom Edge");
                this.HspaceTextField.setEnabled(true);
                this.HspaceTextField.setText("0");
                this.VSpaceTextField.setEnabled(true);
                this.VSpaceTextField.setText("0");
            }
        }
    }

    private void chooseColourAction(ActionEvent evt) {
        this.jFColorChooser1 = new JColorChooser();
        this.textColor = JColorChooser.showDialog(this, "Choose Color", this.jTextArea1.getBackground());
        if (this.textColor != null) {
            this.jTextArea1.setForeground(this.textColor);
        } else {
            this.textColor = this.jTextArea1.getBackground();
        }
    }

    private void selectFontAction(ActionEvent evt) {
        JFontChooser chooser = new JFontChooser(this.jTextArea1.getFont());
        if (chooser.showDialog(this, "Choose a font...") == 2 && this.textFont != null) {
            this.textFont = chooser.getSelectedFont();
            this.jTextArea1.setFont(this.textFont);
        }
    }

    private void CancelFont(ActionEvent evt) {
        this.dispose();
        this.textHelper.setEnable(this.textHelper.getMainFrame());
        this.textHelper.getMainStatus().setText(this.textHelper.getProperty("message.text.close"));
    }
}

