/*
 * Decompiled with CFR 0.152.
 */
package WaterMarker;

import WaterMarker.RescaleImage;
import WatermarkHelper.WaterMarkHelper;
import WatermarkHelper.WriteToPDF;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.RenderedOp;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.jpeg.exifRewrite.ExifRewriter;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.ExifTagConstants;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.constants.TiffFieldTypeConstants;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputField;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;

public class WaterMarkImages
implements Runnable {
    ArrayList ImageList;
    String outPutFilePath;
    float imageQuality;
    double MaxHeight;
    double MaxWidth;
    ArrayList watermarker;
    File OutputFile = null;
    int i = 0;
    WaterMarkHelper helper;
    boolean isPreview;
    JLabel[] jFileListLabelStatus;

    public WaterMarkImages(WaterMarkHelper WMHelper, JLabel[] jFileListLabelstatus) {
        this.helper = WMHelper;
        this.jFileListLabelStatus = jFileListLabelstatus;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public void writeJPEG(BufferedImage input, String name, float quality, WaterMarkHelper helper, int Index) throws Exception {
        helper.MakeOutputDirectory();
        File inputFile = (File)helper.getInputFiles().get(Index);
        this.OutputFile = this.getOutputFile(name, ".jpg");
        this.addImageHistoryTag(inputFile, input, this.OutputFile, helper);
    }

    public byte[] bufferedImageToByteArray(BufferedImage img) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        ImageIO.write((RenderedImage)img, "jpeg", baos);
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    public File getOutputFile(String name, String format) {
        String nameWithoutExtension = name.substring(0, name.lastIndexOf("."));
        File f = new File(name);
        if (f.exists()) {
            boolean isNotFile = true;
            int i = 1;
            String nameWithoutExt = "";
            while (isNotFile) {
                if (f.exists()) {
                    nameWithoutExt = nameWithoutExtension + "_" + i;
                    isNotFile = true;
                } else {
                    isNotFile = false;
                }
                name = nameWithoutExt + format;
                f = new File(name);
                ++i;
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageHistoryTag(File file, BufferedImage image, File outputFile, WaterMarkHelper helper) throws Exception {
        File dst = null;
        IImageMetadata metadata = null;
        JpegImageMetadata jpegMetadata = null;
        TiffImageMetadata exif = null;
        OutputStream os = null;
        TiffOutputSet outputSet = new TiffOutputSet();
        String extension = file.getPath().substring(file.getPath().lastIndexOf(".") + 1, file.getPath().length());
        try {
            metadata = Sanselan.getMetadata((File)file);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("jfif")) {
            if (metadata != null) {
                jpegMetadata = (JpegImageMetadata)metadata;
            }
            if (jpegMetadata != null) {
                exif = jpegMetadata.getExif();
            }
        } else {
            exif = null;
        }
        if (exif != null) {
            try {
                outputSet = exif.getOutputSet();
            }
            catch (ImageWriteException e) {
                // empty catch block
            }
        }
        if (outputSet != null) {
            TiffOutputField commentTag;
            TiffOutputField creationSoftwareTag = outputSet.findField(TiffConstants.EXIF_TAG_SOFTWARE);
            if (creationSoftwareTag != null) {
                outputSet.removeField(TiffConstants.EXIF_TAG_SOFTWARE);
            }
            if ((commentTag = outputSet.findField(TiffConstants.EXIF_TAG_XPCOMMENT)) != null) {
                outputSet.removeField(TiffConstants.EXIF_TAG_XPCOMMENT);
            }
            try {
                String fieldData = "Hitesh S J Sathawane Watermarker";
                TiffOutputField creationSoftware = new TiffOutputField(ExifTagConstants.EXIF_TAG_SOFTWARE, (FieldType)TiffFieldTypeConstants.FIELD_TYPE_ASCII, fieldData.length(), fieldData.getBytes());
                TiffOutputDirectory exifDirectory = outputSet.getOrCreateExifDirectory();
                exifDirectory.add(creationSoftware);
                String comments = helper.getProperty("constants.metaTag.Comments");
                TiffOutputField comment = new TiffOutputField(ExifTagConstants.EXIF_TAG_XPCOMMENT, (FieldType)TiffFieldTypeConstants.FIELD_TYPE_ASCII, comments.length(), comments.getBytes());
                exifDirectory.add(comment);
            }
            catch (ImageWriteException e) {
                // empty catch block
            }
        }
        try {
            dst = outputFile;
            os = new FileOutputStream(dst);
            os = new BufferedOutputStream(os);
            if (helper.isLosseless()) {
                new ExifRewriter().updateExifMetadataLossless(this.bufferedImageToByteArray(image), os, outputSet);
            } else {
                new ExifRewriter().updateExifMetadataLossy(this.bufferedImageToByteArray(image), os, outputSet);
            }
        }
        catch (Exception e) {
            outputSet = null;
            String fieldData = "Hitesh S J Sathawane Watermarker";
            TiffOutputField creationSoftware = new TiffOutputField(ExifTagConstants.EXIF_TAG_SOFTWARE, (FieldType)TiffFieldTypeConstants.FIELD_TYPE_ASCII, fieldData.length(), fieldData.getBytes());
            TiffOutputDirectory exifDirectory = outputSet.getOrCreateExifDirectory();
            exifDirectory.add(creationSoftware);
            String comments = helper.getProperty("constants.metaTag.Comments");
            TiffOutputField comment = new TiffOutputField(ExifTagConstants.EXIF_TAG_XPCOMMENT, (FieldType)TiffFieldTypeConstants.FIELD_TYPE_ASCII, comments.length(), comments.getBytes());
            exifDirectory.add(comment);
            if (helper.isLosseless()) {
                new ExifRewriter().updateExifMetadataLossless(this.bufferedImageToByteArray(image), os, outputSet);
            } else {
                new ExifRewriter().updateExifMetadataLossy(this.bufferedImageToByteArray(image), os, outputSet);
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void run() {
        this.ImageList = this.helper.getInputFiles();
        this.outPutFilePath = this.helper.getOutputImageFolderPath().getPath() + File.separator + this.helper.getOutputFolderName();
        this.imageQuality = (float)this.helper.getImageQuality() / 100.0f;
        this.MaxHeight = this.helper.getMaxImageHeight();
        this.MaxWidth = this.helper.getMaxImageWidth();
        this.watermarker = this.helper.getWaterMarkerList();
        RescaleImage previewImage = new RescaleImage();
        Iterator its = this.ImageList.iterator();
        for (int x = 1; x < this.helper.getCompleteImageList(); ++x) {
            its.next();
        }
        while (its.hasNext()) {
            File inputImage;
            block18: {
                inputImage = (File)its.next();
                try {
                    URL is;
                    String inputFileName = inputImage.getPath();
                    String inputFileExtension = inputFileName.substring(inputFileName.lastIndexOf("."));
                    BufferedImage source = null;
                    ArrayList<BufferedImage> sources = new ArrayList<BufferedImage>();
                    if (inputFileExtension.equalsIgnoreCase(".tiff") || inputFileExtension.equalsIgnoreCase(".tif")) {
                        FileSeekableStream s = new FileSeekableStream(inputImage.getPath());
                        ImageDecodeParam param = null;
                        ImageDecoder dec = ImageCodec.createImageDecoder("tiff", s, param);
                        NullOpImage op = null;
                        for (int i = 0; i < dec.getNumPages(); ++i) {
                            op = new NullOpImage(dec.decodeAsRenderedImage(i), null, 2, null);
                            source = this.helper.convertRenderedImage((RenderedImage)op);
                            sources.add(source);
                        }
                    } else {
                        source = ImageIO.read(new File(inputImage.getPath()));
                        sources.add(source);
                    }
                    ArrayList results = this.multiSourceMarker(sources);
                    if (!this.helper.isLosseless()) {
                        this.writePDF(results, inputImage);
                    } else {
                        this.weriteJPEG(results, inputImage);
                    }
                    if (this.OutputFile.isFile()) {
                        BufferedImage correct = null;
                        is = this.getClass().getResource("/image/correct.png");
                        try {
                            correct = ImageIO.read(is);
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        correct = previewImage.RescaleImage(this.helper, correct, 15.0, 15.0);
                        ImageIcon correctIcon = new ImageIcon(correct);
                        this.jFileListLabelStatus[this.i].setIcon(correctIcon);
                        break block18;
                    }
                    this.helper.appendReport(this.i + 1 + "]\tError\t\t" + this.helper.getInputFiles().get(this.i) + "\n");
                    this.helper.severe("\tError\t\t" + this.helper.getInputFiles().get(this.i) + "\n");
                    BufferedImage error = null;
                    is = this.getClass().getResource("/image/error.png");
                    try {
                        error = ImageIO.read(is);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    error = previewImage.RescaleImage(this.helper, error, 15.0, 15.0);
                    ImageIcon errorIcon = new ImageIcon(error);
                    this.jFileListLabelStatus[this.i].setIcon(errorIcon);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.helper.appendReport(this.i + 1 + "]\tError\t\t" + this.helper.getInputFiles().get(this.i) + "\n");
                    this.helper.severe("\tError\t\t" + this.helper.getInputFiles().get(this.i) + "\n");
                    BufferedImage error = null;
                    URL is = this.getClass().getResource("/image/error.png");
                    try {
                        error = ImageIO.read(is);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    error = previewImage.RescaleImage(this.helper, error, 15.0, 15.0);
                    ImageIcon errorIcon = new ImageIcon(error);
                    this.jFileListLabelStatus[this.i].setIcon(errorIcon);
                }
            }
            this.i = this.ImageList.indexOf(inputImage) + 1;
            this.helper.getMainProgressBar().setValue(this.i);
            if (this.helper.isPause() && this.helper.getWorker().isAlive()) {
                this.helper.setCompleteImageList(this.i);
                this.helper.getMainStatus().setText(this.helper.getProperty("message.watermarking.pause"));
                this.helper.getWorker().stop();
                this.helper.warning("Pause");
            }
            if (!this.helper.isStop() || !this.helper.getWorker().isAlive()) continue;
            this.helper.getMainProgressBar().setValue(0);
            this.helper.getMainStatus().setText(this.helper.getProperty("message.watermarking.stop"));
            this.helper.setInputFiles(new ArrayList());
            this.helper.setCompleteImageList(0);
            this.helper.getWorker().stop();
            this.helper.warning("Stop");
        }
        if (!this.helper.isStop() || !this.helper.isPause()) {
            this.helper.getMainStatus().setText(this.helper.getProperty("message.watermarking.complete"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList multiSourceMarker(ArrayList sources) throws Exception {
        ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
        int imgNo = 0;
        for (BufferedImage source : sources) {
            double height = source.getHeight();
            double width = source.getWidth();
            String imageSizeString = this.helper.imageSize(height, width, this.MaxHeight, this.MaxWidth);
            String[] imageSize = imageSizeString.split("##@@##");
            height = Double.parseDouble(imageSize[0]);
            width = Double.parseDouble(imageSize[1]);
            Object interpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            int sourceWidth = source.getWidth();
            int sourceHeight = source.getHeight();
            double xScale = width / (double)sourceWidth;
            double yScale = height / (double)sourceHeight;
            if (height <= 0.0) {
                xScale = yScale;
                width = (int)Math.rint(xScale * (double)sourceWidth);
            }
            if (height <= 0.0) {
                yScale = xScale;
                width = (int)Math.rint(yScale * (double)sourceHeight);
            }
            GraphicsConfiguration gc = WaterMarkImages.getDefaultConfiguration();
            BufferedImage result = gc.createCompatibleImage((int)width, (int)height, source.getColorModel().getTransparency());
            Graphics2D g2d = null;
            try {
                g2d = result.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
                AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
                g2d.drawRenderedImage(source, at);
                for (ArrayList waterMarkerList : this.watermarker) {
                    int i;
                    String positionSelect = waterMarkerList.get(10).toString();
                    int hSpace = Integer.parseInt(waterMarkerList.get(13).toString());
                    int vSpace = Integer.parseInt(waterMarkerList.get(14).toString());
                    int x = 0;
                    int y = 0;
                    float fill = (float)(Double.valueOf(waterMarkerList.get(9).toString()) / 100.0);
                    if (waterMarkerList.get(0).toString().equalsIgnoreCase("TEXT")) {
                        Font font = (Font)waterMarkerList.get(7);
                        FontMetrics outMetrics = g2d.getFontMetrics(font);
                        g2d.setFont(font);
                        g2d.setColor((Color)waterMarkerList.get(8));
                        g2d.setComposite(AlphaComposite.getInstance(3, fill));
                        String[] WatermarkingText = (String[])waterMarkerList.get(1);
                        int blockHeight = 0;
                        int blockWidth = 0;
                        if (positionSelect.equalsIgnoreCase("Horizontal Top Left") || positionSelect.equalsIgnoreCase("Horizontal Top Center") || positionSelect.equalsIgnoreCase("Horizontal Top Right") || positionSelect.equalsIgnoreCase("Horizontal Middle Left") || positionSelect.equalsIgnoreCase("Horizontal Middle Center") || positionSelect.equalsIgnoreCase("Horizontal Middle Right") || positionSelect.equalsIgnoreCase("Horizontal Bottom Left") || positionSelect.equalsIgnoreCase("Horizontal Bottom Center") || positionSelect.equalsIgnoreCase("Horizontal Bottom Right") || positionSelect.equalsIgnoreCase("Horizontal Coustome")) {
                            for (int r = 0; r < WatermarkingText.length; ++r) {
                                Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[r], g2d);
                                int textHeight = (int)rect.getHeight();
                                int textWidth = (int)rect.getWidth();
                                blockHeight += textHeight;
                                if (blockWidth >= textWidth) continue;
                                blockWidth = textWidth;
                            }
                            Rectangle2D rect0Posn = outMetrics.getStringBounds(WatermarkingText[0], g2d);
                            int textHeight0Posn = (int)rect0Posn.getHeight();
                            int topYposition = vSpace - textHeight0Posn;
                            int middleYPosition = result.getHeight() / 2 - blockHeight / 2 - textHeight0Posn + outMetrics.getAscent();
                            int bottomYPosition = result.getHeight() - blockHeight - vSpace - textHeight0Posn + outMetrics.getAscent();
                            int coustomYPosition = Integer.parseInt(waterMarkerList.get(12).toString()) - textHeight0Posn;
                            for (i = 0; i < WatermarkingText.length; ++i) {
                                Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[i], g2d);
                                int textHeight = (int)rect.getHeight();
                                int textWidth = (int)rect.getWidth();
                                if (positionSelect.equalsIgnoreCase("Horizontal Top Left")) {
                                    x = hSpace;
                                    y = (topYposition += textHeight) + outMetrics.getAscent();
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Top Center")) {
                                    x = result.getWidth() / 2 - textWidth / 2;
                                    y = (topYposition += textHeight) + outMetrics.getAscent();
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Top Right")) {
                                    x = result.getWidth() - blockWidth - hSpace;
                                    y = (topYposition += textHeight) + outMetrics.getAscent();
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Middle Left")) {
                                    x = hSpace;
                                    y = middleYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Middle Center")) {
                                    x = result.getWidth() / 2 - textWidth / 2;
                                    y = middleYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Middle Right")) {
                                    x = result.getWidth() - blockWidth - hSpace;
                                    y = middleYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Bottom Left")) {
                                    x = hSpace;
                                    y = bottomYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Bottom Center")) {
                                    x = result.getWidth() / 2 - textWidth / 2;
                                    y = bottomYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Bottom Right")) {
                                    x = result.getWidth() - blockWidth - hSpace;
                                    y = bottomYPosition += textHeight;
                                } else if (positionSelect.equalsIgnoreCase("Horizontal Coustome")) {
                                    x = Integer.parseInt(waterMarkerList.get(11).toString());
                                    y = coustomYPosition += textHeight;
                                }
                                g2d.drawString(WatermarkingText[i], x, y);
                            }
                            continue;
                        }
                        if (positionSelect.equalsIgnoreCase("Vertical Top Left") || positionSelect.equalsIgnoreCase("Vertical Top Center") || positionSelect.equalsIgnoreCase("Vertical Top Right") || positionSelect.equalsIgnoreCase("Vertical Middle Left") || positionSelect.equalsIgnoreCase("Vertical Middle Center") || positionSelect.equalsIgnoreCase("Vertical Middle Right") || positionSelect.equalsIgnoreCase("Vertical Bottom Left") || positionSelect.equalsIgnoreCase("Vertical Bottom Center") || positionSelect.equalsIgnoreCase("Vertical Bottom Right") || positionSelect.equalsIgnoreCase("Vertical Coustome")) {
                            ArrayList<Integer> lineWidthList = new ArrayList<Integer>();
                            ArrayList<Integer> lineHeightList = new ArrayList<Integer>();
                            for (int r = 0; r < WatermarkingText.length; ++r) {
                                char[] CurrentLine = WatermarkingText[r].toString().toCharArray();
                                int lineHeight = 0;
                                int lineWidth = 0;
                                for (i = 0; i < CurrentLine.length; ++i) {
                                    String Character = String.valueOf(CurrentLine[i]);
                                    Rectangle2D rect = outMetrics.getStringBounds(Character, g2d);
                                    int charHeight = (int)rect.getHeight();
                                    int charWidth = (int)rect.getWidth();
                                    lineHeight += charHeight;
                                    if (lineWidth >= charWidth) continue;
                                    lineWidth = charWidth;
                                }
                                blockWidth += lineWidth;
                                if (blockHeight < lineHeight) {
                                    blockHeight = lineHeight;
                                }
                                lineWidthList.add(lineWidth);
                                lineHeightList.add(lineHeight);
                            }
                            int TopLeftXPosition = 0;
                            int TopLeftYPosition = 0;
                            if (positionSelect.equalsIgnoreCase("Vertical Top Left")) {
                                TopLeftXPosition = hSpace;
                                TopLeftYPosition = vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Top Center")) {
                                TopLeftXPosition = result.getWidth() / 2 - blockWidth / 2;
                                TopLeftYPosition = vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Top Right")) {
                                TopLeftXPosition = result.getWidth() - blockWidth - hSpace;
                                TopLeftYPosition = vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Middle Left")) {
                                TopLeftXPosition = hSpace;
                                TopLeftYPosition = result.getHeight() / 2 - blockHeight / 2;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Middle Center")) {
                                TopLeftXPosition = result.getWidth() / 2 - blockWidth / 2;
                                TopLeftYPosition = result.getHeight() / 2 - blockHeight / 2;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Middle Right")) {
                                TopLeftXPosition = x = result.getWidth() - blockWidth - hSpace;
                                TopLeftYPosition = result.getHeight() / 2 - blockHeight / 2;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Bottom Left")) {
                                TopLeftXPosition = hSpace;
                                TopLeftYPosition = result.getHeight() - blockHeight - vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Bottom Center")) {
                                TopLeftXPosition = result.getWidth() / 2 - blockWidth / 2;
                                TopLeftYPosition = result.getHeight() - blockHeight - vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Bottom Right")) {
                                TopLeftXPosition = x = result.getWidth() - blockWidth - hSpace;
                                TopLeftYPosition = result.getHeight() - blockHeight - vSpace;
                            } else if (positionSelect.equalsIgnoreCase("Vertical Coustome")) {
                                TopLeftXPosition = Integer.parseInt(waterMarkerList.get(11).toString());
                                TopLeftYPosition = Integer.parseInt(waterMarkerList.get(12).toString());
                            }
                            int currentXPosition = TopLeftXPosition - Integer.parseInt(lineWidthList.get(0).toString());
                            for (int r1 = 0; r1 < WatermarkingText.length; ++r1) {
                                int lineHeight = Integer.parseInt(lineHeightList.get(r1).toString());
                                int lineWidth = Integer.parseInt(lineWidthList.get(r1).toString());
                                currentXPosition += lineWidth;
                                char[] CurrentLine = WatermarkingText[r1].toString().toCharArray();
                                String firstChar = WatermarkingText[r1].toString().substring(0, 1);
                                Rectangle2D rect0Posn = outMetrics.getStringBounds(firstChar, g2d);
                                int charHeight0Posn = (int)rect0Posn.getHeight();
                                int currentYPosition = TopLeftYPosition;
                                int modifiedYposition = currentYPosition + (blockHeight - lineHeight) / 2;
                                for (int i1 = 0; i1 < CurrentLine.length; ++i1) {
                                    String Character = String.valueOf(CurrentLine[i1]);
                                    Rectangle2D rect = outMetrics.getStringBounds(Character, g2d);
                                    int charHeight = (int)rect.getHeight();
                                    int charWidth = (int)rect.getWidth();
                                    int modifiedXPosition = currentXPosition + (lineWidth - charWidth) / 2;
                                    g2d.drawString(Character, modifiedXPosition, modifiedYposition += charHeight);
                                }
                            }
                            continue;
                        }
                        if (positionSelect.equalsIgnoreCase("Bottom-Top Diognal") || positionSelect.equalsIgnoreCase("Top-Bottom Diognal")) {
                            double resHeight = result.getHeight();
                            double resWidth = result.getWidth();
                            double angle = Math.atan2(resHeight, resWidth);
                            if (positionSelect.equalsIgnoreCase("Bottom-Top Diognal")) {
                                angle *= -1.0;
                            }
                            for (int r = 0; r < WatermarkingText.length; ++r) {
                                Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[r], g2d);
                                int textHeight = (int)rect.getHeight();
                                int textWidth = (int)rect.getWidth();
                                blockHeight += textHeight;
                                if (blockWidth >= textWidth) continue;
                                blockWidth = textWidth;
                            }
                            Rectangle2D rect0Posn = outMetrics.getStringBounds(WatermarkingText[0], g2d);
                            int textHeight0Posn = (int)rect0Posn.getHeight();
                            int middleYPosition = result.getHeight() / 2 - blockHeight / 2 - textHeight0Posn + outMetrics.getAscent();
                            for (int i2 = 0; i2 < WatermarkingText.length; ++i2) {
                                Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[i2], g2d);
                                int textHeight = (int)rect.getHeight();
                                int textWidth = (int)rect.getWidth();
                                x = result.getWidth() / 2 - textWidth / 2;
                                y = middleYPosition += textHeight;
                                AffineTransform affineTransform = new AffineTransform();
                                affineTransform.rotate(angle, result.getWidth() / 2, result.getHeight() / 2);
                                g2d.transform(affineTransform);
                                g2d.drawString(WatermarkingText[i2], x, y);
                                AffineTransform affineTransformRev = new AffineTransform();
                                affineTransformRev.rotate(-angle, result.getWidth() / 2, result.getHeight() / 2);
                                g2d.transform(affineTransformRev);
                            }
                            continue;
                        }
                        Integer.parseInt("s");
                        continue;
                    }
                    if (waterMarkerList.get(0).toString().equalsIgnoreCase("SHAPE")) {
                        int ShapeHeight = Integer.parseInt(waterMarkerList.get(6).toString());
                        int ShapeWidth = Integer.parseInt(waterMarkerList.get(5).toString());
                        if (positionSelect.equalsIgnoreCase("Top Left")) {
                            x = hSpace;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Top Center")) {
                            x = result.getWidth() / 2 - ShapeWidth / 2;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Top Right")) {
                            x = result.getWidth() - ShapeWidth - hSpace;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Middle Left")) {
                            x = hSpace;
                            y = result.getHeight() / 2 - ShapeHeight / 2;
                        } else if (positionSelect.equalsIgnoreCase("Middle Center")) {
                            x = result.getWidth() / 2 - ShapeWidth / 2;
                            y = result.getHeight() / 2 - ShapeHeight / 2;
                        } else if (positionSelect.equalsIgnoreCase("Middle Right")) {
                            x = result.getWidth() - ShapeWidth - hSpace;
                            y = result.getHeight() / 2 - ShapeHeight / 2;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Left")) {
                            x = hSpace;
                            y = result.getHeight() - ShapeHeight - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Center")) {
                            x = result.getWidth() / 2 - ShapeWidth / 2;
                            y = result.getHeight() - ShapeHeight - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Right")) {
                            x = result.getWidth() - ShapeWidth - hSpace;
                            y = result.getHeight() - ShapeHeight - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Coustome")) {
                            x = Integer.parseInt(waterMarkerList.get(11).toString());
                            y = Integer.parseInt(waterMarkerList.get(12).toString());
                        }
                        g2d.setComposite(AlphaComposite.getInstance(3, fill));
                        g2d.setColor((Color)waterMarkerList.get(8));
                        if (waterMarkerList.get(2).toString().equalsIgnoreCase("RECTRANGLE")) {
                            g2d.fillRect(x, y, ShapeWidth, ShapeHeight);
                            continue;
                        }
                        if (waterMarkerList.get(2).toString().equalsIgnoreCase("OVEL")) {
                            g2d.fillOval(x, y, ShapeWidth, ShapeHeight);
                            continue;
                        }
                        Integer.parseInt("s");
                        continue;
                    }
                    if (waterMarkerList.get(0).toString().equalsIgnoreCase("IMAGE")) {
                        File f = (File)waterMarkerList.get(3);
                        RenderedOp image2 = JAI.create((String)"fileload", (Object)f.getPath());
                        BufferedImage waterMarkImage = this.helper.convertRenderedImage((RenderedImage)image2);
                        double imageScale = Double.parseDouble(waterMarkerList.get(4).toString()) / 100.0;
                        RescaleImage RescaleImage2 = new RescaleImage();
                        BufferedImage im2 = RescaleImage2.RescaleImage(this.helper, waterMarkImage, (double)waterMarkImage.getHeight() * imageScale, (double)waterMarkImage.getWidth() * imageScale);
                        if (positionSelect.equalsIgnoreCase("Top Left")) {
                            x = hSpace;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Top Center")) {
                            x = result.getWidth() / 2 - im2.getWidth() / 2;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Top Right")) {
                            x = result.getWidth() - im2.getWidth() - hSpace;
                            y = vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Middle Left")) {
                            x = hSpace;
                            y = result.getHeight() / 2 - im2.getHeight() / 2;
                        } else if (positionSelect.equalsIgnoreCase("Middle Center")) {
                            x = result.getWidth() / 2 - im2.getWidth() / 2;
                            y = result.getHeight() / 2 - im2.getHeight() / 2;
                        } else if (positionSelect.equalsIgnoreCase("Middle Right")) {
                            x = result.getWidth() - im2.getWidth() - hSpace;
                            y = result.getHeight() / 2 - im2.getHeight() / 2;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Left")) {
                            x = hSpace;
                            y = result.getHeight() - im2.getHeight() - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Center")) {
                            x = result.getWidth() / 2 - im2.getWidth() / 2;
                            y = result.getHeight() - im2.getHeight() - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Bottom Right")) {
                            x = result.getWidth() - im2.getWidth() - hSpace;
                            y = result.getHeight() - im2.getHeight() - vSpace;
                        } else if (positionSelect.equalsIgnoreCase("Coustome")) {
                            x = Integer.parseInt(waterMarkerList.get(11).toString());
                            y = Integer.parseInt(waterMarkerList.get(12).toString());
                        }
                        g2d.setComposite(AlphaComposite.getInstance(3, fill));
                        g2d.drawImage((Image)im2, x, y, null);
                        continue;
                    }
                    if (waterMarkerList.get(0).toString().equalsIgnoreCase("CAPTION")) {
                        String[] WatermarkingText = (String[])this.helper.getInputFilesCaption().get(this.i);
                        String checkNull = WatermarkingText[0];
                        if (WatermarkingText.length < 2 && checkNull == null) continue;
                        Font font = (Font)waterMarkerList.get(7);
                        FontMetrics outMetrics = g2d.getFontMetrics(font);
                        g2d.setFont(font);
                        g2d.setColor((Color)waterMarkerList.get(8));
                        g2d.setComposite(AlphaComposite.getInstance(3, fill));
                        int blockHeight = 0;
                        int blockWidth = 0;
                        for (int r = 0; r < WatermarkingText.length; ++r) {
                            Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[r], g2d);
                            int textHeight = (int)rect.getHeight();
                            int textWidth = (int)rect.getWidth();
                            blockHeight += textHeight;
                            if (blockWidth >= textWidth) continue;
                            blockWidth = textWidth;
                        }
                        Rectangle2D rect0Posn = outMetrics.getStringBounds(WatermarkingText[0], g2d);
                        int textHeight0Posn = (int)rect0Posn.getHeight();
                        int topYposition = vSpace - textHeight0Posn;
                        int middleYPosition = result.getHeight() / 2 - blockHeight / 2 - textHeight0Posn + outMetrics.getAscent();
                        int bottomYPosition = result.getHeight() - blockHeight - vSpace - textHeight0Posn + outMetrics.getAscent();
                        for (i = 0; i < WatermarkingText.length; ++i) {
                            Rectangle2D rect = outMetrics.getStringBounds(WatermarkingText[i], g2d);
                            int textHeight = (int)rect.getHeight();
                            int textWidth = (int)rect.getWidth();
                            if (positionSelect.equalsIgnoreCase("Top Left")) {
                                x = hSpace;
                                y = (topYposition += textHeight) + outMetrics.getAscent();
                            } else if (positionSelect.equalsIgnoreCase("Top Center")) {
                                x = result.getWidth() / 2 - textWidth / 2;
                                y = (topYposition += textHeight) + outMetrics.getAscent();
                            } else if (positionSelect.equalsIgnoreCase("Top Right")) {
                                x = result.getWidth() - blockWidth - hSpace;
                                y = (topYposition += textHeight) + outMetrics.getAscent();
                            } else if (positionSelect.equalsIgnoreCase("Middle Left")) {
                                x = hSpace;
                                y = middleYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Middle Center")) {
                                x = result.getWidth() / 2 - textWidth / 2;
                                y = middleYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Middle Right")) {
                                x = result.getWidth() - blockWidth - hSpace;
                                y = middleYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Bottom Left")) {
                                x = hSpace;
                                y = bottomYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Bottom Center")) {
                                x = result.getWidth() / 2 - textWidth / 2;
                                y = bottomYPosition += textHeight;
                            } else if (positionSelect.equalsIgnoreCase("Bottom Right")) {
                                x = result.getWidth() - blockWidth - hSpace;
                                y = bottomYPosition += textHeight;
                            }
                            g2d.drawString(WatermarkingText[i], x, y);
                        }
                        continue;
                    }
                    Integer.parseInt("s");
                }
            }
            finally {
                if (g2d != null) {
                    g2d.dispose();
                }
            }
            results.add(result);
            ++imgNo;
        }
        return results;
    }

    public void writePDF(ArrayList results, File inputImage) {
        File inputFolderParent = this.helper.getInputParentFolderPath();
        String inputParentFoldrName = "";
        String ExtendedFolderPath = "";
        String outputFolder = "";
        String tiffPageNo = "";
        String ext = ".pdf";
        if (inputFolderParent != null) {
            inputParentFoldrName = inputFolderParent.getPath();
            ExtendedFolderPath = inputImage.getPath().substring(inputParentFoldrName.length(), inputImage.getPath().lastIndexOf(".")) + tiffPageNo + ext;
            outputFolder = this.outPutFilePath + File.separator + inputFolderParent.getName() + ExtendedFolderPath;
        } else {
            ExtendedFolderPath = inputImage.getPath().substring(0, 1) + File.separator + inputImage.getPath().substring(3, inputImage.getPath().lastIndexOf(".")) + tiffPageNo + ext;
            outputFolder = this.outPutFilePath + File.separator + ExtendedFolderPath;
        }
        this.helper.MakeFolderStructure(outputFolder);
        String outputPath = outputFolder;
        WriteToPDF writer = new WriteToPDF();
        this.OutputFile = this.getOutputFile(outputPath, ".pdf");
        writer.writeToPDF(this.OutputFile.getPath(), results, this.getMaxDocSize(results), this.helper);
        this.helper.appendReport(this.i + 1 + "]\tComplete\t" + this.helper.getInputFiles().get(this.i) + "\n");
        this.helper.Info("\tComplete\t\t" + this.helper.getInputFiles().get(this.i) + "\n");
    }

    public float[] getMaxDocSize(ArrayList resulList) {
        int maxHeight = 0;
        int maxWidth = 0;
        float[] dimentions = new float[2];
        for (BufferedImage result : resulList) {
            if (maxHeight < result.getHeight()) {
                maxHeight = result.getHeight();
            }
            if (maxWidth >= result.getWidth()) continue;
            maxWidth = result.getWidth();
        }
        dimentions[0] = maxHeight;
        dimentions[1] = maxWidth;
        return dimentions;
    }

    public void weriteJPEG(ArrayList results, File inputImage) throws Exception {
        boolean imgNo = false;
        for (BufferedImage result : results) {
            File inputFolderParent = this.helper.getInputParentFolderPath();
            String inputParentFoldrName = "";
            String ExtendedFolderPath = "";
            String outputFolder = "";
            String tiffPageNo = "";
            String ext = ".jpg";
            if (inputFolderParent != null) {
                inputParentFoldrName = inputFolderParent.getPath();
                ExtendedFolderPath = inputImage.getPath().substring(inputParentFoldrName.length(), inputImage.getPath().lastIndexOf(".")) + tiffPageNo + ext;
                outputFolder = this.outPutFilePath + File.separator + inputFolderParent.getName() + ExtendedFolderPath;
            } else {
                ExtendedFolderPath = inputImage.getPath().substring(0, 1) + File.separator + inputImage.getPath().substring(3, inputImage.getPath().lastIndexOf(".")) + tiffPageNo + ext;
                outputFolder = this.outPutFilePath + File.separator + ExtendedFolderPath;
            }
            this.helper.MakeFolderStructure(outputFolder);
            String outputPath = outputFolder;
            this.writeJPEG(result, outputPath, this.imageQuality, this.helper, this.i);
            this.helper.appendReport(this.i + 1 + "]\tComplete\t" + this.helper.getInputFiles().get(this.i) + "\n");
            this.helper.Info("\tComplete\t\t" + this.helper.getInputFiles().get(this.i) + "\n");
        }
    }
}

