/*
 * Decompiled with CFR 0.152.
 */
package WatermarkHelper;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class JFontPreviewPanel
extends JPanel {
    private Font font;

    public JFontPreviewPanel(Font f) {
        this.setFont(f);
        this.setBorder(new TitledBorder(new EtchedBorder(1), "Preview"));
    }

    public void setFont(Font f) {
        this.font = f;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paintComponent(g);
        this.paintBorder(g);
    }

    public void paintComponent(Graphics g) {
        Image osi = this.createImage(this.getSize().width, this.getSize().height);
        Graphics osg = osi.getGraphics();
        osg.setFont(this.font);
        Rectangle2D bounds = this.font.getStringBounds(this.font.getFontName(), 0, this.font.getFontName().length(), new FontRenderContext(null, true, false));
        int width = new Double(bounds.getWidth()).intValue();
        int height = new Double(bounds.getHeight()).intValue();
        osg.drawString(this.font.getFontName(), 5, (this.getSize().height - height) / 2 + height);
        g.drawImage(osi, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, 75);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

