/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import jdomain.jdraw.gui.DrawBrowser;
import jdomain.jdraw.gui.DrawMenu;
import jdomain.jdraw.gui.FillTool;
import jdomain.jdraw.gui.MainFrame;
import jdomain.util.Log;
import jdomain.util.Util;

public final class Settings
implements Serializable {
    private static final int MAX_LAST_FILES = 10;
    private static final long serialVersionUID = 1L;
    public static final Settings INSTANCE = Settings.createSettings();
    private float jpegQuality = 1.0f;
    private ArrayList fileList = new ArrayList();
    private String openDir;
    private String saveDir = this.openDir = DrawBrowser.INSTANCE.getOpenDir();
    private int redTolerance = 0;
    private int greenTolerance = 0;
    private int blueTolerance = 0;
    private int alphaTolerance = 0;
    private Dimension frameDim = new Dimension(800, 720);
    private Point frameLoc = new Point(0, 0);

    private Settings() {
    }

    public Dimension getFrameDimension() {
        return this.frameDim;
    }

    public Point getFrameLocation() {
        return this.frameLoc;
    }

    public void saveWindowDimensions() {
        this.frameLoc = MainFrame.INSTANCE.getLocation();
        this.frameDim = MainFrame.INSTANCE.getSize();
    }

    public void setTolerance(FillTool.Tolerance tolerance) {
        this.redTolerance = tolerance.redDiff;
        this.greenTolerance = tolerance.greenDiff;
        this.blueTolerance = tolerance.blueDiff;
        this.alphaTolerance = tolerance.alphaDiff;
    }

    private static String getFilename() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(File.separator).append("jdraw.");
        stringBuffer.append("v1.1.5").append(".dat");
        return stringBuffer.toString();
    }

    public ArrayList getFileList() {
        return this.fileList;
    }

    public float getJPEGQuality() {
        return this.jpegQuality;
    }

    public String getOpenDir() {
        return this.openDir;
    }

    public String getSaveDir() {
        return this.saveDir;
    }

    public void addLastFile(String string) {
        this.openDir = DrawBrowser.INSTANCE.getOpenDir();
        this.saveDir = DrawBrowser.INSTANCE.getSaveDir();
        int n = this.fileList.indexOf(string);
        if (n == 0) {
            return;
        }
        if (n == -1) {
            this.fileList.add(0, string);
            if (this.fileList.size() > 10) {
                this.fileList.remove(9);
            }
        } else {
            this.fileList.remove(string);
            this.fileList.add(0, string);
        }
        ((DrawMenu)MainFrame.INSTANCE.getJMenuBar()).buildLastFilesMenu();
    }

    public void setJPEGQuality(float f) {
        this.jpegQuality = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Settings createSettings() {
        Object object;
        Log.debug("loading settings...");
        File file = new File(Settings.getFilename());
        if (file.exists()) {
            object = null;
            try {
                object = new ObjectInputStream(new FileInputStream(file));
                Settings settings = (Settings)((ObjectInputStream)object).readObject();
                settings.check();
                Settings settings2 = settings;
                return settings2;
            }
            catch (Exception exception) {
                Log.debug("error loading setting. creating new instance...");
            }
            finally {
                Util.close((InputStream)object);
            }
        }
        object = new Settings();
        ((Settings)object).check();
        return object;
    }

    private void check() {
        if (this.openDir == null) {
            this.openDir = System.getProperty("user.dir");
        }
        if (this.saveDir == null) {
            this.saveDir = System.getProperty("user.dir");
        }
        FillTool.INSTANCE.setTolerance(new FillTool.Tolerance(this.redTolerance, this.greenTolerance, this.blueTolerance, this.alphaTolerance));
        if (this.frameDim != null) {
            int n = this.frameDim.width;
            int n2 = this.frameDim.height;
            if (n == 0 || n2 == 0) {
                this.frameDim = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Log.debug("saving settings...");
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(Settings.getFilename()));
            objectOutputStream.writeObject(this);
            Util.close(objectOutputStream);
        }
        catch (Exception exception) {
            Log.error("saving settings failed");
        }
        finally {
            Util.close(objectOutputStream);
        }
    }
}

