/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import javax.swing.KeyStroke;
import jdomain.jdraw.Main;
import jdomain.jdraw.Settings;
import jdomain.jdraw.action.BlockingDrawAction;
import jdomain.jdraw.action.ContinuedAction;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gio.GIFReader;
import jdomain.jdraw.gio.IconReader;
import jdomain.jdraw.gio.ImageReader;
import jdomain.jdraw.gui.DrawBrowser;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.PixelTool;
import jdomain.jdraw.gui.ToolPanel;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.util.Log;
import jdomain.util.Util;
import jdomain.util.gui.GUIUtil;

public final class LoadAction
extends BlockingDrawAction
implements ContinuedAction {
    private static final long serialVersionUID = 1L;
    private Picture picture;
    private String newFileName;
    static /* synthetic */ Class class$jdomain$jdraw$action$LoadAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetPixelToolAction;

    protected LoadAction() {
        super("Open...", "open.png");
        this.setToolTipText("Opens an image file");
        this.setAccelerators(new KeyStroke[]{KeyStroke.getKeyStroke(new Character('O'), 2)});
    }

    public static boolean isJDraw(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n);
        return string2.equalsIgnoreCase(".jd");
    }

    public static boolean isICO(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n);
        return string2.equalsIgnoreCase(".ico");
    }

    public static boolean isGIF(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n);
        return string2.equalsIgnoreCase(".gif");
    }

    public static boolean isJPEG(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n);
        return string2.equalsIgnoreCase(".jpg") || string2.equalsIgnoreCase(".jpeg");
    }

    public static boolean isPNG(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n);
        return string2.equalsIgnoreCase(".png");
    }

    public boolean prepareAction() {
        this.picture = null;
        File file = DrawBrowser.INSTANCE.openImage();
        if (file != null) {
            this.newFileName = file.getAbsolutePath();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Picture readJDraw(String string) {
        Picture picture;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(string));
            picture = (Picture)objectInputStream.readObject();
        }
        catch (Exception exception) {
            Picture picture2;
            try {
                Log.exception(exception);
                picture2 = null;
            }
            catch (Throwable throwable) {
                Util.close(objectInputStream);
                throw throwable;
            }
            Util.close(objectInputStream);
            return picture2;
        }
        Util.close(objectInputStream);
        return picture;
    }

    public static Picture readImage(String string) {
        LoadAction loadAction = (LoadAction)DrawAction.getAction(class$jdomain$jdraw$action$LoadAction == null ? (class$jdomain$jdraw$action$LoadAction = LoadAction.class$("jdomain.jdraw.action.LoadAction")) : class$jdomain$jdraw$action$LoadAction);
        loadAction.newFileName = string;
        loadAction.startAction();
        return loadAction.picture;
    }

    public static void openImage(String string) {
        LoadAction loadAction = (LoadAction)DrawAction.getAction(class$jdomain$jdraw$action$LoadAction == null ? (class$jdomain$jdraw$action$LoadAction = LoadAction.class$("jdomain.jdraw.action.LoadAction")) : class$jdomain$jdraw$action$LoadAction);
        loadAction.newFileName = string;
        loadAction.startAction();
        loadAction.finishAction();
    }

    public void startAction() {
        if (LoadAction.isGIF(this.newFileName)) {
            boolean bl;
            this.picture = GIFReader.readGIF(this.newFileName);
            if (this.picture == null && (bl = GUIUtil.question(MainFrame.INSTANCE, "Retry?", "JDraw couldn't read this GIF image. Do you want to retry using Java's graphics library?", "Retry", "Cancel"))) {
                this.picture = ImageReader.readImage(this.newFileName);
            }
        } else {
            this.picture = LoadAction.isJDraw(this.newFileName) ? this.readJDraw(this.newFileName) : (LoadAction.isICO(this.newFileName) ? IconReader.readIcon(this.newFileName) : ImageReader.readImage(this.newFileName));
        }
    }

    public void finishAction() {
        if (this.picture != null) {
            Settings.INSTANCE.addLastFile(this.newFileName);
            Settings.INSTANCE.save();
            MainFrame.INSTANCE.setFileName(this.newFileName);
            Main.setPicture(this.picture);
            UndoManager.INSTANCE.reset();
            ToolPanel.INSTANCE.setCurrentTool(PixelTool.INSTANCE, DrawAction.getAction(class$jdomain$jdraw$action$SetPixelToolAction == null ? (class$jdomain$jdraw$action$SetPixelToolAction = LoadAction.class$("jdomain.jdraw.action.SetPixelToolAction")) : class$jdomain$jdraw$action$SetPixelToolAction));
            Log.info("Opened.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

