/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.jdraw.gui.MainFrame;
import jdomain.util.Util;
import jdomain.util.gui.UpperCaseField;

public final class ColourEditor
extends DrawDialog {
    private static final long serialVersionUID = 1L;
    public static final ColourEditor INSTANCE = new ColourEditor();
    private final JColorChooser chooser = new JColorChooser();
    private final PreviewPanel previewPanel = new PreviewPanel();

    private ColourEditor() {
        super("Colour Editor");
        this.setDisposeOnClose(false);
        this.setModal(true);
        this.chooser.setDragEnabled(true);
        this.chooser.addChooserPanel(new HexChooserPanel());
        this.chooser.addChooserPanel(new AlphaChooserPanel());
        this.chooser.getSelectionModel().addChangeListener(this.previewPanel);
        this.chooser.setPreviewPanel(this.previewPanel);
        this.main.add((Component)this.chooser, "Center");
        this.chooser.add((Component)this.previewPanel, "South");
        this.setDefaultBorder();
        this.addRightButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addButtonPanel();
    }

    public void setColour(Color color) {
        this.chooser.setColor(color);
        this.previewPanel.setColour(color);
    }

    public Color getColour() {
        return this.chooser.getColor();
    }

    private final class AlphaChooserPanel
    extends AbstractColorChooserPanel
    implements DocumentListener,
    ChangeListener {
        private static final long serialVersionUID = 1L;
        private final JTextField alphaField = new JTextField(3);
        private final JSlider alphaSlider = new JSlider(1, 0, 255, 0);

        public AlphaChooserPanel() {
            this.setLayout(new GridBagLayout());
            this.alphaSlider.addChangeListener(this);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            this.alphaSlider.setMajorTickSpacing(20);
            this.alphaSlider.setMinorTickSpacing(5);
            this.alphaSlider.setPaintTicks(true);
            hashtable.put(new Integer(0), this.createLabel("transparent", 0));
            for (int i = 50; i < 205; i += 50) {
                hashtable.put(new Integer(i), this.createLabel(null, i));
            }
            hashtable.put(new Integer(255), this.createLabel("opaque", 255));
            this.alphaSlider.setLabelTable(hashtable);
            this.alphaSlider.setPaintLabels(true);
            this.alphaField.getDocument().addDocumentListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            this.add((Component)new JLabel(this.getDisplayName()), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.alphaSlider, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this.alphaField, gridBagConstraints);
        }

        private JLabel createLabel(String string, int n) {
            JLabel jLabel = new JLabel();
            jLabel.setFont(MainFrame.DEFAULT_FONT);
            if (string == null) {
                jLabel.setText(String.valueOf(n));
            } else {
                jLabel.setText(string);
            }
            return jLabel;
        }

        protected void buildChooser() {
        }

        public String getDisplayName() {
            return "Alpha";
        }

        public Icon getLargeDisplayIcon() {
            return null;
        }

        public Icon getSmallDisplayIcon() {
            return null;
        }

        public void updateChooser() {
            if (INSTANCE == null) {
                return;
            }
            int n = INSTANCE.chooser.getColor().getAlpha();
            if (!this.alphaField.hasFocus()) {
                this.alphaField.setText(String.valueOf(n));
            }
            if (!this.alphaSlider.hasFocus()) {
                this.alphaSlider.setValue(n);
            }
        }

        public int getMnemonic() {
            return 65;
        }

        public int getDisplayedMnemonicIndex() {
            return 2;
        }

        private void update() {
            String string = this.alphaField.getText().trim();
            if (Util.isNumber(string, 0, 255)) {
                int n = Util.asInt(string);
                Color color = INSTANCE.chooser.getColor();
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
                INSTANCE.setColour(color);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Color color = INSTANCE.getColour();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alphaSlider.getValue());
            INSTANCE.setColour(color);
        }
    }

    private final class HexChooserPanel
    extends AbstractColorChooserPanel
    implements DocumentListener {
        private static final long serialVersionUID = 1L;
        private final JTextField hexField = new UpperCaseField(8);

        public HexChooserPanel() {
            this.setLayout(new FlowLayout(1, 2, 0));
            this.add(new JLabel(this.getDisplayName() + " [rgba]: #"));
            this.add(this.hexField);
            this.hexField.getDocument().addDocumentListener(this);
        }

        protected void buildChooser() {
        }

        public String getDisplayName() {
            return "Hex";
        }

        public Icon getLargeDisplayIcon() {
            return null;
        }

        public Icon getSmallDisplayIcon() {
            return null;
        }

        public void updateChooser() {
            if (INSTANCE == null) {
                return;
            }
            if (!this.hexField.hasFocus()) {
                Color color = INSTANCE.chooser.getColor();
                String string = Util.hexString(color.getRed(), 2) + Util.hexString(color.getGreen(), 2) + Util.hexString(color.getBlue(), 2) + Util.hexString(color.getAlpha(), 2);
                this.hexField.setText(string.toUpperCase());
            }
        }

        public int getMnemonic() {
            return 88;
        }

        public int getDisplayedMnemonicIndex() {
            return 2;
        }

        private void update() {
            String string = this.hexField.getText().trim();
            if (Util.isMinMax(string.length(), 6, 8)) {
                String string2 = string.substring(0, 2);
                String string3 = string.substring(2, 4);
                String string4 = string.substring(4, 6);
                String string5 = "";
                if (string.length() > 6 && (string5 = string.substring(6)).length() == 1) {
                    string5 = string5 + '0';
                }
                if (Util.isNumber(string2, 16, 0, 255) && Util.isNumber(string3, 16, 0, 255) && Util.isNumber(string4, 16, 0, 255) && Util.isNumber(string5, 16, 0, 255)) {
                    INSTANCE.chooser.setColor(new Color(Util.asInt(string2, 16), Util.asInt(string3, 16), Util.asInt(string4, 16), Util.asInt(string5, 16)));
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }
    }

    private final class PreviewPanel
    extends JPanel
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        private final JPanel colPanel = new JPanel();
        private final JLabel hexLabel = new JLabel(" ");
        private final JLabel decLabel = new JLabel(" ");

        public PreviewPanel() {
            super(new FlowLayout(0, 0, 0));
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.add(jPanel);
            jPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
            this.colPanel.setPreferredSize(new Dimension(50, 10));
            this.colPanel.setBorder(new EtchedBorder());
            this.hexLabel.setBorder(new EmptyBorder(8, 0, 0, 0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            jPanel.add((Component)this.colPanel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridheight = 1;
            jPanel.add((Component)this.decLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.hexLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }

        public void setColour(Color color) {
            this.colPanel.setBackground(color);
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            int n4 = color.getAlpha();
            this.hexLabel.setText("<html><b>hex</b>(" + Util.hexString(n, 2) + "," + Util.hexString(n2, 2) + "," + Util.hexString(n3, 2) + "," + Util.hexString(n4, 2) + ")</html>");
            this.hexLabel.setFont(MainFrame.DEFAULT_FONT);
            this.decLabel.setText("<html><b>rgba</b>(" + n + "," + n2 + "," + n3 + "," + n4 + ")</html>");
            this.decLabel.setFont(MainFrame.DEFAULT_FONT);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.setColour(ColourEditor.this.chooser.getColor());
        }
    }
}

