/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import jdomain.jdraw.data.ColourEntry;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Assert;
import jdomain.util.ResourceLoader;
import jdomain.util.gui.BackgroundPanel;

public class ColourPanel
extends BackgroundPanel {
    private static final long serialVersionUID = 1L;
    protected static final Dimension DIMENSION = new Dimension(24, 24);
    private static final String TOOLTIP = "<html> <b>Left-click:</b> select foreground-colour<br> <b>Right-click:</b> select background-colour<br> <b>Double-click:</b> edit colour<br> <b>Ctrl+Left-click:</b> toggle transparency<br><b>Ctrl+Right-click:</b> select picture background</html>";
    protected static final Border PLAIN_BORDER = new CompoundBorder(new LineBorder(Color.darkGray), new LineBorder(Color.black));
    private static final Border PICTURE_BACKGROUND_BORDER = new CompoundBorder(new LineBorder(Color.white), new LineBorder(Color.black));
    private boolean isForeground = false;
    private boolean isBackground = false;
    private boolean isTransparent = false;
    private boolean isPictureBackground = false;
    protected final int index;

    public ColourPanel(ColourEntry colourEntry) {
        this.setBorder(PLAIN_BORDER);
        this.index = colourEntry.getIndex();
        this.setBackgroundIcon(ResourceLoader.getImage("jdomain/jdraw/images/background.gif"));
        this.update();
    }

    public Dimension getPreferredSize() {
        return DIMENSION;
    }

    public void update() {
        Picture picture = Tool.getPicture();
        Color color = picture.getCurrentPalette().getColour(this.index).getColour();
        this.setForeground(color);
        this.isForeground = this.index == picture.getForeground();
        this.isBackground = this.index == picture.getBackground();
        this.isTransparent = this.index == picture.getTransparent();
        boolean bl = this.isPictureBackground = this.index == picture.getPictureBackground();
        if (this.isPictureBackground) {
            this.setBorder(PICTURE_BACKGROUND_BORDER);
        } else {
            this.setBorder(PLAIN_BORDER);
        }
        this.updateToolTipText();
        Assert.isTrue(color.getAlpha() != 0 || this.isTransparent, "Duplicate full transparent colour found: #" + this.index);
        this.repaint();
    }

    private void updateToolTipText() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        ColourEntry colourEntry = Tool.getCurrentPalette().getColour(this.index);
        int n = colourEntry.getColour().getAlpha();
        if (this.isTransparent) {
            stringBuffer.append("Transparent - ");
        }
        if (n != 255) {
            stringBuffer.append("Alpha:");
            stringBuffer.append(n);
            stringBuffer.append(" - ");
        }
        if (this.isPictureBackground) {
            stringBuffer.append("Picture background - ");
        }
        if (this.isForeground) {
            stringBuffer.append("Foreground - ");
        }
        if (this.isBackground) {
            stringBuffer.append("Background - ");
        }
        if ((string = stringBuffer.toString().trim()).length() > 0) {
            string = string.substring(0, string.length() - 2);
            this.setToolTipText(string);
        } else {
            this.setToolTipText(TOOLTIP);
        }
    }

    public void setBackground(boolean bl) {
        this.isBackground = bl;
        this.repaint();
    }

    public void setForeground(boolean bl) {
        this.isForeground = bl;
        this.repaint();
    }

    public void setTransparent(boolean bl) {
        this.isTransparent = bl;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paint(graphics2D);
        Border border = this.getBorder();
        Insets insets = border.getBorderInsets(this);
        Dimension dimension = this.getSize();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = dimension.width - n - (insets.right - 1) - (insets.left - 1);
        int n4 = dimension.height - n2 - (insets.bottom - 1) - (insets.top - 1);
        if (this.isTransparent) {
            graphics2D.setColor(Color.black);
        } else if (this.getForeground().getAlpha() == 255) {
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(n, n2, n3, n4);
        } else {
            Shape shape = graphics2D.getClip();
            Polygon polygon = new Polygon();
            polygon.addPoint(n3 + 2, n2);
            polygon.addPoint(n3 + 2, n4 + 2);
            polygon.addPoint(n, n4 + 2);
            graphics2D.setClip(polygon);
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setClip(shape);
            graphics2D.setColor(Color.white);
            graphics2D.drawLine(n3, n2, n, n4);
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(n3 + 1, n2, n, n4 + 1);
        }
        if (this.isForeground) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(1, 1, 6, 6);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(1, 1, 6, 6);
        }
        if (this.isBackground) {
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(ColourPanel.DIMENSION.width - 6 - 3, ColourPanel.DIMENSION.height - 6 - 3, 6, 6);
            graphics2D.setColor(Color.white);
            graphics2D.drawRect(ColourPanel.DIMENSION.width - 6 - 3, ColourPanel.DIMENSION.height - 6 - 3, 6, 6);
        }
    }
}

