/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jdomain.jdraw.Main;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.FrameSettings;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.dnd.DnDUtil;
import jdomain.jdraw.gui.dnd.FrameDragger;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.ResourceLoader;
import jdomain.util.Util;
import jdomain.util.gui.WidgetFactory;

public class FrameSettingsDialog
extends DrawDialog
implements DocumentListener,
ListSelectionListener,
ActionListener,
ListDataListener {
    private static final long serialVersionUID = 1L;
    private static final Border CELL_BORDER = new EmptyBorder(2, 6, 2, 6);
    private Picture picture;
    private FrameEntry copiedEntry = null;
    private static final String[] DISPOSAL_TYPES = new String[]{"Don't care", "Do not dispose", "Restore to background", "Restore previous image"};
    public static final ImageIcon FRAME_ICON = ResourceLoader.getImage("jdomain/jdraw/images/frame.png", 20);
    private final JButton applyButton = new JButton("Apply");
    private boolean hasChanges = false;
    private final JButton removeButton = new JButton("Remove Frame");
    private final JButton copyButton = new JButton("Copy Frame");
    private final JButton pasteButton = new JButton("Paste Frame");
    private int newFrameCount = 0;
    private final JPanel settingsPanel;
    private final JList frameList;
    private final JTextField delayField = new JTextField();
    private final JComboBox disposalBox = new JComboBox<String>(DISPOSAL_TYPES);
    private final JTextField iconWidthField = new JTextField();
    private final JTextField iconHeightField = new JTextField();
    private boolean updating = false;

    public FrameSettingsDialog() {
        super("Frame Settings");
        this.setModal(true);
        this.setUndecorated(false);
        this.setResizable(true);
        WidgetFactory.addFocusAdapter(this.delayField);
        this.frameList = new JList(this.createFrameList());
        this.frameList.getModel().addListDataListener(this);
        this.frameList.setVisibleRowCount(10);
        this.frameList.setCellRenderer(new FrameEntryRenderer());
        this.frameList.addListSelectionListener(this);
        this.frameList.setFixedCellHeight(24);
        this.frameList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.frameList);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width += 10;
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.main.add((Component)jScrollPane, "Center");
        this.delayField.getDocument().addDocumentListener(this);
        this.disposalBox.addActionListener(this);
        this.iconWidthField.getDocument().addDocumentListener(this);
        this.iconHeightField.getDocument().addDocumentListener(this);
        this.settingsPanel = this.createSettingsPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.settingsPanel, "North");
        this.main.add((Component)jPanel, "East");
        this.addLeftButton(this.copyButton);
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameSettingsDialog.this.copyFrame();
            }
        });
        this.copyButton.setMnemonic('f');
        this.addLeftButton(this.pasteButton);
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameSettingsDialog.this.pasteFrame();
            }
        });
        this.pasteButton.setMnemonic('p');
        this.addLeftButton(this.removeButton);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameSettingsDialog.this.removeFrame();
            }
        });
        this.removeButton.setMnemonic('r');
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.applyButton);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameSettingsDialog.this.apply();
            }
        });
        this.applyButton.setMnemonic('a');
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
        this.setDefaultBorder();
        new FrameDragger(this.frameList);
        this.frameList.setSelectedIndex(Tool.getPicture().getCurrentFrameIndex());
        this.hasChanges = false;
        this.checkInput();
    }

    protected final void approve() {
        this.apply();
        super.approve();
    }

    private final void apply() {
        Picture picture = Tool.getPicture();
        this.picture = new Picture(picture.getWidth(), picture.getHeight());
        this.picture.setPalette(picture.getPalette());
        ListModel listModel = this.frameList.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            FrameEntry frameEntry = (FrameEntry)listModel.getElementAt(i);
            this.picture.addFrame(frameEntry.produceFrame());
        }
        this.picture.setCurrentFrame(0);
        if (picture.getCurrentFrameIndex() < this.picture.getFrameCount()) {
            this.picture.setCurrentFrame(picture.getCurrentFrameIndex());
        }
        this.picture.setTransparent(picture.getTransparent());
        Main.setPicture(this.picture);
        this.hasChanges = false;
        this.checkInput();
    }

    private final void removeFrame() {
        this.updating = true;
        int n = this.frameList.getSelectedIndex();
        ((DefaultListModel)this.frameList.getModel()).remove(n);
        this.frameList.clearSelection();
        this.hasChanges = true;
        this.updating = false;
        this.checkInput();
    }

    private JPanel createSettingsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 4, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel("Delay in 1/100 seconds:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.delayField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Disposal method:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.disposalBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Icon width: (1-" + Tool.getPictureWidth() + ")");
        jLabel.setBorder(new EmptyBorder(15, 0, 0, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.iconWidthField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Icon height: (1-" + Tool.getPictureHeight() + ")");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.iconHeightField, gridBagConstraints);
        jPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        return jPanel;
    }

    private void checkInput() {
        this.picture = null;
        int n = this.frameList.getSelectedIndex();
        boolean bl = n != -1;
        this.removeButton.setEnabled(bl && this.frameList.getModel().getSize() > 1);
        this.copyButton.setEnabled(bl);
        this.pasteButton.setEnabled(this.copiedEntry != null);
        this.delayField.setEnabled(bl);
        this.disposalBox.setEnabled(bl);
        this.iconWidthField.setEnabled(bl);
        this.iconHeightField.setEnabled(bl);
        boolean bl2 = !bl || Util.isNumber(this.delayField.getText(), 0, Integer.MAX_VALUE) && Util.isIn(this.getIconWidth(), 1, Tool.getPictureWidth()) && Util.isIn(this.getIconHeight(), 1, Tool.getPictureHeight());
        this.applyButton.setEnabled(this.hasChanges && bl2);
        this.getApproveButton().setEnabled(this.hasChanges && bl2);
    }

    private final int getIconWidth() {
        String string = this.iconWidthField.getText().trim();
        return Util.asInt(string);
    }

    private final int getIconHeight() {
        String string = this.iconHeightField.getText().trim();
        return Util.asInt(string);
    }

    private ListModel createFrameList() {
        Picture picture = Tool.getPicture();
        int n = picture.getFrameCount();
        DefaultListModel<FrameEntry> defaultListModel = new DefaultListModel<FrameEntry>();
        for (int i = 0; i < n; ++i) {
            defaultListModel.addElement(new FrameEntry(picture.getFrame(i)));
        }
        return defaultListModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.disposalBox.isEnabled()) {
            FrameEntry frameEntry = (FrameEntry)this.frameList.getSelectedValue();
            if (frameEntry != null) {
                frameEntry.disposalMethod = this.disposalBox.getSelectedIndex();
            }
            this.hasChanges = true;
            this.checkInput();
        }
    }

    private void documentUpdate(Document document) {
        if (this.updating) {
            return;
        }
        FrameEntry frameEntry = (FrameEntry)this.frameList.getSelectedValue();
        if (document == this.delayField.getDocument()) {
            frameEntry.delay = this.delayField.getText().trim();
        } else if (document == this.iconWidthField.getDocument()) {
            frameEntry.iconWidth = this.iconWidthField.getText().trim();
        } else if (document == this.iconHeightField.getDocument()) {
            frameEntry.iconHeight = this.iconHeightField.getText().trim();
        }
        this.hasChanges = true;
        this.checkInput();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentUpdate(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentUpdate(documentEvent.getDocument());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentUpdate(documentEvent.getDocument());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.frameList.getSelectedIndex();
        if (n == -1) {
            this.delayField.setText("");
            this.iconWidthField.setText("");
            this.iconHeightField.setText("");
            this.disposalBox.setSelectedIndex(0);
        } else {
            FrameEntry frameEntry = (FrameEntry)this.frameList.getSelectedValue();
            this.delayField.setText(frameEntry.delay);
            this.iconWidthField.setText(frameEntry.iconWidth);
            this.iconHeightField.setText(frameEntry.iconHeight);
            this.disposalBox.setSelectedIndex(frameEntry.disposalMethod);
        }
        this.checkInput();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.hasChanges = true;
        this.checkInput();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.hasChanges = true;
        this.frameList.setSelectedIndex(listDataEvent.getIndex0());
        this.checkInput();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.hasChanges = true;
        this.frameList.setSelectedIndex(0);
        this.checkInput();
    }

    private void copyFrame() {
        int n = this.frameList.getSelectedIndex();
        if (n != -1) {
            this.copiedEntry = ((FrameEntry)this.frameList.getSelectedValue()).createCopy();
            Log.info("Frame copied.");
            this.checkInput();
        }
    }

    private void pasteFrame() {
        if (this.copiedEntry != null) {
            int n = this.frameList.getSelectedIndex();
            if (n == -1) {
                n = this.frameList.getModel().getSize();
            }
            if (++n >= this.frameList.getModel().getSize()) {
                ((DefaultListModel)this.frameList.getModel()).addElement(this.copiedEntry);
            } else {
                ((DefaultListModel)this.frameList.getModel()).insertElementAt(this.copiedEntry, n);
            }
            Log.info("Frame pasted.");
        }
    }

    public final boolean handleKey(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            if (keyEvent.getModifiers() == 2) {
                if (keyEvent.getKeyChar() == '\u0003') {
                    this.copyFrame();
                } else if (keyEvent.getKeyChar() == '\u0016') {
                    this.pasteFrame();
                }
            }
            if (keyEvent.getKeyChar() == '\u001b' && keyEvent.getModifiers() == 0) {
                this.cancel();
                return true;
            }
        }
        return false;
    }

    private final class FrameEntryRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private FrameEntryRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setIcon(FRAME_ICON);
            jLabel.setBorder(CELL_BORDER);
            return jLabel;
        }
    }

    public final class FrameEntry
    implements Transferable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private Frame frame;
        public String delay = "";
        public int disposalMethod = 0;
        private Frame copiedFrame = null;
        private String iconWidth = "";
        private String iconHeight = "";

        private FrameEntry() {
        }

        public FrameEntry(Frame frame) {
            this.frame = frame;
            if (this.frame == null) {
                FrameSettingsDialog.this.newFrameCount++;
                this.name = "New Frame #" + FrameSettingsDialog.this.newFrameCount;
            } else {
                this.name = "Frame #" + (Tool.getPicture().indexOf(this.frame) + 1);
                FrameSettings frameSettings = this.frame.getSettings();
                this.delay = String.valueOf(frameSettings.getDelay());
                this.disposalMethod = frameSettings.getDisposalMethod();
                this.iconWidth = String.valueOf(frameSettings.getIconWidth());
                this.iconHeight = String.valueOf(frameSettings.getIconHeight());
            }
        }

        public Frame produceFrame() {
            Frame frame = this.frame != null ? this.frame : this.copiedFrame.copy(FrameSettingsDialog.this.picture);
            FrameSettings frameSettings = frame.getSettings();
            frameSettings.setDelay(Integer.parseInt(this.delay));
            frameSettings.setDisposalMethod(this.disposalMethod);
            frameSettings.setIconWidth(Integer.parseInt(this.iconWidth));
            frameSettings.setIconHeight(Integer.parseInt(this.iconHeight));
            return frame;
        }

        public FrameEntry createCopy() {
            Frame frame = this.frame;
            if (frame == null) {
                frame = this.copiedFrame;
            }
            Assert.notNull(frame, "gui: internal error. frameEntry without frame");
            FrameEntry frameEntry = new FrameEntry();
            frameEntry.copiedFrame = frame;
            frameEntry.name = "Copy of " + this.name;
            frameEntry.delay = this.delay;
            frameEntry.disposalMethod = this.disposalMethod;
            frameEntry.iconWidth = this.iconWidth;
            frameEntry.iconHeight = this.iconHeight;
            return frameEntry;
        }

        public FrameEntry createIdenticalCopy() {
            FrameEntry frameEntry = new FrameEntry();
            frameEntry.name = this.name;
            frameEntry.copiedFrame = this.copiedFrame;
            frameEntry.frame = this.frame;
            frameEntry.delay = this.delay;
            frameEntry.disposalMethod = this.disposalMethod;
            frameEntry.iconWidth = this.iconWidth;
            frameEntry.iconHeight = this.iconHeight;
            return frameEntry;
        }

        public String toString() {
            return this.name;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return DnDUtil.FRAME_FLAVORS;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == DnDUtil.FRAME_FLAVORS[0];
        }
    }
}

