/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import jdomain.jdraw.gui.MainFrame;
import jdomain.util.Log;
import jdomain.util.LogListener;
import jdomain.util.Util;
import jdomain.util.gui.AntialiasPanel;
import jdomain.util.gui.GUIUtil;

public final class StatusPanel
extends AntialiasPanel
implements LogListener {
    private static final long serialVersionUID = 1L;
    public static final StatusPanel INSTANCE = new StatusPanel();
    private final JLabel text = new JLabel(" ");
    private final JLabel draw = new JLabel();

    private StatusPanel() {
        super(new BorderLayout(0, 0));
        this.add((Component)this.text, "Center");
        Log.addLogListener(this);
        this.setBorder(new EmptyBorder(2, 8, 2, 8));
        this.text.setFont(MainFrame.SMALL_FONT);
        this.draw.setFont(MainFrame.SMALL_FONT);
        this.draw.setHorizontalAlignment(4);
        this.add((Component)this.draw, "East");
    }

    public void drawInfo(String string) {
        this.draw.setText(string);
    }

    public void debug(String string) {
    }

    public void info(String string) {
        this.print(string);
    }

    public void warning(String string) {
        GUIUtil.warning(MainFrame.INSTANCE, string);
        this.print(Color.blue, string);
    }

    public void warning(String string, Object object) {
        this.print(Color.blue, string + " [" + object.toString() + "]");
    }

    public void error(String string) {
        GUIUtil.error(MainFrame.INSTANCE, string);
        this.print(Color.red, string);
    }

    public void exception(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null || string.trim().length() == 0) {
            string = "An error occurred! Giving up...\nExceptionType: " + Util.shortClassName(throwable.getClass());
        }
        GUIUtil.error(MainFrame.INSTANCE, string);
        this.print(Color.red, throwable.getMessage());
    }

    public void close() {
    }

    private void print(Color color, String string) {
        if (string == null || string.equals("")) {
            string = " ";
        }
        this.text.setForeground(color);
        this.text.setText(string);
    }

    private void print(String string) {
        this.print(Color.black, string);
    }
}

