/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui.undo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import jdomain.jdraw.data.Clip;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Pixel;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawPixel;
import jdomain.util.Log;

public abstract class Undoable {
    protected final Clip frame;

    public abstract void redo();

    public abstract void undo();

    public Undoable() {
        this(Tool.getCurrentFrame());
    }

    public Undoable(Clip clip) {
        this.frame = clip;
    }

    public final Clip getFrame() {
        return this.frame;
    }

    protected final void prepareGraphics(Graphics graphics) {
        if (Tool.isAntialiasOn()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    public boolean isValid() {
        return true;
    }

    public static final DrawPixel calculateDifference(Clip clip, Image image, int n, int n2, int n3, int n4) {
        int n5;
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, true);
        try {
            if (!pixelGrabber.grabPixels()) {
                if (Log.DEBUG) {
                    Log.debug("undo: grabbing pixels failed");
                }
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            Log.exception(interruptedException);
            return null;
        }
        ArrayList<Pixel> arrayList = new ArrayList<Pixel>();
        int[] nArray = (int[])pixelGrabber.getPixels();
        int n6 = 0;
        for (n5 = n2; n5 < n2 + n4; ++n5) {
            for (int i = n; i < n + n3; ++i) {
                int n7;
                int n8 = clip.getPixel(i, n5);
                if (n8 != (n7 = Undoable.indexOfPixelColour(nArray[n6]))) {
                    arrayList.add(new Pixel(i, n5, n8, n7));
                }
                ++n6;
            }
        }
        Log.info("Palette now has " + Tool.getCurrentPalette().size() + " colours");
        n5 = arrayList.size();
        if (n5 == 0) {
            Log.debug("undo: no pixels changed");
            return null;
        }
        Pixel[] pixelArray = new Pixel[n5];
        arrayList.toArray(pixelArray);
        return new DrawPixel(clip, pixelArray);
    }

    private static final int indexOfPixelColour(int n) {
        Color color;
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        Color color2 = new Color(n2, n3, n4);
        Palette palette = Tool.getCurrentPalette();
        int n5 = Tool.getPicture().getTransparent();
        if (n5 != -1 && color2.equals(color = palette.getColour(n5).getColour())) {
            return n5;
        }
        int n6 = palette.findColour(color2);
        if (n6 == -1) {
            n6 = palette.size();
            palette.addColour(color2);
        }
        return n6;
    }
}

