/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class BackgroundPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private ImageIcon icon;
    private ImageObserver imageObserver = new JPanel();
    private Image image = null;
    private boolean showBackground = false;

    public BackgroundPanel(LayoutManager layoutManager) {
        this(true, layoutManager);
    }

    private BackgroundPanel(boolean bl, LayoutManager layoutManager) {
        if (layoutManager != null) {
            this.setLayout(layoutManager);
        }
    }

    public BackgroundPanel(boolean bl) {
        this(bl, null);
    }

    public BackgroundPanel() {
        this(true);
    }

    public void setBackgroundIcon(ImageIcon imageIcon) {
        int n = 0;
        int n2 = 0;
        if (imageIcon != null) {
            n = imageIcon.getIconWidth();
            n2 = imageIcon.getIconHeight();
        }
        this.setBackgroundIcon(imageIcon, n, n2);
    }

    public void setBackgroundIcon(ImageIcon imageIcon, int n, int n2) {
        this.icon = imageIcon;
        this.showBackground = this.icon != null;
        this.repaint();
    }

    public void showBackgroundIcon(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.icon != null && bl;
        if (bl2 != this.showBackground) {
            this.showBackground = bl2;
            this.repaint();
        }
    }

    public boolean showingBackgroundIcon() {
        return this.icon != null && this.showBackground;
    }

    private Image getBufferedImage() {
        if (this.image == null) {
            Dimension dimension = this.getSize();
            this.image = this.createImage(dimension.width, dimension.height);
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            Graphics graphics = this.image.getGraphics();
            for (int i = 0; i < dimension.height; i += n2) {
                for (int j = 0; j < dimension.width; j += n) {
                    graphics.drawImage(this.icon.getImage(), j, i, n, n2, this.imageObserver);
                }
            }
        }
        return this.image;
    }

    public void setSize(Dimension dimension) {
        this.image = null;
        super.setSize(dimension);
    }

    public void setSize(int n, int n2) {
        this.image = null;
        super.setSize(n, n2);
    }

    public void setPreferredSize(Dimension dimension) {
        this.image = null;
        super.setPreferredSize(dimension);
    }

    public void paint(Graphics graphics) {
        if (this.showingBackgroundIcon()) {
            Dimension dimension = this.getSize();
            graphics.drawImage(this.getBufferedImage(), 0, 0, dimension.width, dimension.height, this.imageObserver);
            super.paintChildren(graphics);
            super.paintBorder(graphics);
        } else {
            super.paint(graphics);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Rectangle rectangle2 = this.getBounds();
        if (!rectangle2.equals(rectangle = new Rectangle(n, n2, n3, n4))) {
            this.image = null;
            super.setBounds(n, n2, n3, n4);
        }
    }

    public void setBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getBounds();
        if (!rectangle2.equals(rectangle)) {
            this.image = null;
            super.setBounds(rectangle);
        }
    }
}

