/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jdomain.util.Log;
import jdomain.util.ResourceLoader;
import jdomain.util.gui.BrowserFilter;
import jdomain.util.gui.FileBrowser;
import jdomain.util.gui.GUIUtil;
import jdomain.util.gui.ImageHandler;
import jdomain.util.gui.ScrollablePanel;
import jdomain.util.gui.StandardScrollPane;

public final class IconViewer
extends StandardScrollPane
implements ListDataListener {
    private static final long serialVersionUID = 1L;
    private static final int LENGTH = 50;
    private static final HashMap ICON_MAP = new HashMap();
    private static final Border UNSELECTED_BORDER = new LineBorder(Color.lightGray);
    private static final Border SELECTED_BORDER = new LineBorder(Color.blue);
    private static final String[] JDK_SUPPORTED_IMAGE_EXTENSIONS = new String[]{".bmp", ".gif", ".jpg", ".jpeg", ".png", ".pnm", ".tif"};
    private static final ArrayList IMAGE_HANDLER = new ArrayList();
    private static final BrowserFilter ALL_IMAGES_FILTER = BrowserFilter.createFilter("<hidden>", JDK_SUPPORTED_IMAGE_EXTENSIONS);
    private GridBagConstraints gc = new GridBagConstraints();
    private JPanel iconPanel = new ScrollablePanel(new GridBagLayout(), 50, 5);
    private PropertyChangeEvent lastChangeEvent;
    private final ListModel model;
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                IconLabel iconLabel = (IconLabel)mouseEvent.getSource();
                File file = new File(iconLabel.fileName);
                FileBrowser fileBrowser = (FileBrowser)GUIUtil.findParentComponentOfClass(iconLabel, class$jdomain$util$gui$FileBrowser == null ? (class$jdomain$util$gui$FileBrowser = IconViewer.class$("jdomain.util.gui.FileBrowser")) : class$jdomain$util$gui$FileBrowser);
                if (fileBrowser != null) {
                    fileBrowser.setSelectedFile(file);
                }
            }
        }
    };
    static /* synthetic */ Class class$jdomain$util$gui$FileBrowser;

    public static final boolean isImage(File file) {
        if (file.isDirectory()) {
            return false;
        }
        Iterator iterator = IMAGE_HANDLER.iterator();
        String string = file.toString();
        while (iterator.hasNext()) {
            if (!((ImageHandler)iterator.next()).canHandleImage(string)) continue;
            return true;
        }
        return ALL_IMAGES_FILTER.accept(file);
    }

    public static final boolean isImage(String string) {
        return IconViewer.isImage(new File(string));
    }

    public IconViewer(ListModel listModel) {
        this.model = listModel;
        this.iconPanel.setBackground(Color.white);
        this.setEnsuredHeight(54);
        this.setPreferredSize(new Dimension(10, 54));
        this.setViewportView(this.iconPanel);
        this.getViewport().setBackground(Color.white);
        this.setBorder(new CompoundBorder(new EmptyBorder(10, 0, 0, 0), this.getBorder()));
        this.gc.fill = 3;
        this.gc.insets = new Insets(1, 1, 1, 1);
        this.gc.anchor = 10;
        this.gc.ipadx = 10;
        this.model.addListDataListener(this);
    }

    public static void addImageHandler(ImageHandler imageHandler) {
        IMAGE_HANDLER.add(imageHandler);
    }

    private void addImage(IconLabel iconLabel) {
        this.iconPanel.add((Component)iconLabel, this.gc);
        ++this.gc.gridx;
    }

    private ImageHandler getHandler(String string) {
        Iterator iterator = IMAGE_HANDLER.iterator();
        while (iterator.hasNext()) {
            ImageHandler imageHandler = (ImageHandler)iterator.next();
            if (!imageHandler.canHandleImage(string)) continue;
            return imageHandler;
        }
        return null;
    }

    private void addImage(String string) {
        ImageIcon imageIcon = null;
        ImageHandler imageHandler = this.getHandler(string);
        try {
            imageIcon = imageHandler != null ? imageHandler.createIconLabel(string) : new ImageIcon(string);
        }
        catch (Throwable throwable) {
            Log.warning("error opening " + string + ". (skipped)");
            Log.exception(throwable);
        }
        if (imageIcon != null) {
            int n = imageIcon.getIconWidth();
            int n2 = imageIcon.getIconHeight();
            imageIcon = ResourceLoader.scaleImage(imageIcon, 50);
            IconLabel iconLabel = new IconLabel(imageIcon, string, n, n2);
            iconLabel.setBorder(UNSELECTED_BORDER);
            this.addImage(iconLabel);
            ICON_MAP.put(string, iconLabel);
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.rebuild();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.rebuild();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.rebuild();
    }

    protected void rebuild() {
        this.iconPanel.setVisible(false);
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.iconPanel.removeAll();
        ICON_MAP.clear();
        for (int i = 0; i < this.model.getSize(); ++i) {
            File file = new File(this.model.getElementAt(i).toString());
            if (!IconViewer.isImage(file)) continue;
            this.addImage(file.toString());
        }
        this.iconPanel.invalidate();
        this.iconPanel.revalidate();
        this.iconPanel.setVisible(true);
    }

    protected void updateSelection() {
        if (this.lastChangeEvent != null) {
            this.selectionChanged(this.lastChangeEvent);
        }
    }

    protected void selectionChanged(PropertyChangeEvent propertyChangeEvent) {
        this.lastChangeEvent = propertyChangeEvent;
        if (this.getParent() != null) {
            this.changeSelection((File)propertyChangeEvent.getOldValue(), false);
            this.changeSelection((File)propertyChangeEvent.getNewValue(), true);
        }
    }

    private void changeSelection(File file, boolean bl) {
        if (file == null) {
            return;
        }
        String string = file.toString();
        IconLabel iconLabel = (IconLabel)ICON_MAP.get(string);
        if (iconLabel != null) {
            iconLabel.setBorder(bl ? SELECTED_BORDER : UNSELECTED_BORDER);
            if (bl && !this.isVisible(iconLabel)) {
                int n = this.iconPanel.getWidth() - this.getViewport().getExtentSize().width;
                if (n <= 0) {
                    n = 1;
                }
                int n2 = Math.min(n, iconLabel.getLocation().x) - 1;
                this.getViewport().setViewPosition(new Point(n2, 0));
            }
        }
    }

    private boolean isVisible(IconLabel iconLabel) {
        int n = iconLabel.getLocation().x - 1;
        int n2 = iconLabel.getWidth() + 1;
        Rectangle rectangle = this.getViewport().getViewRect();
        return n >= rectangle.x && n + n2 <= rectangle.x + rectangle.width;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class IconLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        public final String fileName;

        public IconLabel(Icon icon, String string, int n, int n2) {
            super(icon);
            this.setOpaque(false);
            this.setToolTipText("" + n + "x" + n2);
            this.fileName = string;
            this.addMouseListener(IconViewer.this.mouseListener);
        }
    }
}

