/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.Locale;

class ScanFile {
    BufferedInputStream bf;
    Dimension reduce = new Dimension(5, 5);
    BlkWht bw;
    PcxFile pcx;
    ScanGui sg;
    ScanParam sp;
    ScanParameters sps;
    char savchr = (char)32;
    boolean char_saved = false;
    int magic;
    boolean raw;
    int w;
    int h;
    int maxclr = 0;
    int ired = 0;
    int igrn = 0;
    int iblu = 0;
    int[] pix;
    String scanFileName = "tmp.pnm";
    String pcx_file;
    String pcx_base;
    boolean pcx_save;

    boolean scanImage() {
        Object object;
        String string = this.sg.device.trim();
        File file = new File(string + ".conf");
        if (!file.exists()) {
            this.sg.setStatusText("File " + file + " does not exist");
            System.out.println("File " + file + " does not exist");
            return false;
        }
        String string2 = " -d " + string;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(1);
        String string3 = this.tr(this.sp.origmm.width, numberFormat, 215.8);
        String string4 = this.tr(this.sp.origmm.height, numberFormat, 355.5);
        String string5 = this.tr(this.sp.sizemm.width, numberFormat, 215.8);
        String string6 = this.tr(this.sp.sizemm.height, numberFormat, 355.5);
        int n = this.tr(this.sp.resolution.width, 20, 300);
        String string7 = " -l " + string3 + " -t " + string4 + " -x " + string5 + " -y " + string6 + " --resolution " + n;
        DiscreteOption discreteOption = this.sps.mode;
        string7 = string7 + " --" + discreteOption.command + " " + ((ScanOption)discreteOption).getValue();
        String string8 = "";
        Object object2 = this.sps.getOptions();
        while (object2.hasMoreElements()) {
            object = (ScanOption)object2.nextElement();
            string8 = string8 + " --" + ((ScanOption)object).command + " " + ((ScanOption)object).getValue();
        }
        String string9 = "scanimage";
        object2 = new File(string9 + ".exe");
        if (!((File)object2).exists()) {
            this.sg.setStatusText("The executable file, " + string9 + " is missing");
            System.out.println("The executable file, " + string9 + " is missing");
            return false;
        }
        string9 = "cmd /c " + string9 + string2 + string7 + string8 + " > " + this.scanFileName;
        System.out.println(string9);
        try {
            object = Runtime.getRuntime();
            Process process = ((Runtime)object).exec(string9);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream());
            int n2 = 128;
            char[] cArray = new char[n2];
            int n3 = inputStreamReader.read(cArray, 0, n2);
            process.waitFor();
            inputStreamReader.close();
            if (n3 >= 0) {
                this.sg.setStatusText(new String(cArray, 0, n3 - 2));
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return true;
    }

    void readScannedImage() {
        if (this.pcx_save) {
            ((TextComponent)this.sg.tf_status).setText("Creating image and saving file");
        } else {
            ((TextComponent)this.sg.tf_status).setText("Creating image");
        }
        File file = new File(this.scanFileName);
        if (!file.exists()) {
            ((TextComponent)this.sg.tf_status).setText("File " + this.scanFileName + " does not exist");
            return;
        }
        try {
            this.bf = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + fileNotFoundException.getMessage());
        }
        char c = this.getChr();
        if (c != 'P') {
            System.out.println("Bad magic number in image file: " + this.scanFileName);
            System.out.println("Magic number = " + c);
            System.exit(1);
        }
        c = this.getChr();
        this.magic = c - 48;
        if (this.magic > 3) {
            this.magic -= 3;
            this.raw = true;
        } else {
            this.raw = false;
        }
        this.w = this.getNmbr();
        this.h = this.getNmbr();
        this.maxclr = this.magic > 1 ? this.getNmbr() : 1;
        if (this.pcx_save) {
            this.pcx = new PcxFile(this.pcx_file, this.magic, this.w, this.h, this.maxclr, 300, 300);
        }
        this.reduce.width = this.w / this.sp.scrn_pix2.width + 1;
        this.reduce.height = this.h / this.sp.scrn_pix2.height + 1;
        if (this.reduce.width > this.reduce.height) {
            this.reduce.height = this.reduce.width;
        } else {
            this.reduce.width = this.reduce.height;
        }
        int n = this.w / this.reduce.width;
        int n2 = this.h / this.reduce.height;
        this.pix = new int[n * n2];
        int n3 = 0;
        try {
            if (this.raw) {
                if (this.magic == 1) {
                    ScanFile scanFile = this;
                    if (scanFile == null) {
                        throw null;
                    }
                    this.bw = scanFile.new BlkWht();
                }
                int n4 = 1;
                while (n4 <= this.h) {
                    if (this.magic == 1) {
                        this.bw.reset();
                    }
                    boolean bl = n4 % this.reduce.height == 0;
                    int n5 = 1;
                    while (n5 <= this.w) {
                        if (this.magic == 1) {
                            this.ired = this.bw.getBit();
                        } else {
                            this.ired = this.bf.read();
                            if (this.pcx_save) {
                                this.pcx.store(this.ired);
                            }
                            if (this.magic == 3) {
                                this.igrn = this.bf.read();
                                this.iblu = this.bf.read();
                                if (this.pcx_save) {
                                    this.pcx.store(1, this.igrn);
                                    this.pcx.store(2, this.iblu);
                                }
                            }
                        }
                        if (bl && n5 % this.reduce.width == 0) {
                            this.ired = 255 * this.ired / this.maxclr;
                            if (this.magic < 3) {
                                this.iblu = this.ired;
                                this.igrn = this.ired;
                            } else {
                                this.iblu = 255 * this.iblu / this.maxclr;
                                this.igrn = 255 * this.igrn / this.maxclr;
                            }
                            this.pix[n3++] = 0xFF000000 | this.ired << 16 | this.igrn << 8 | this.iblu;
                        }
                        ++n5;
                    }
                    if (this.pcx_save) {
                        this.pcx.writeLine();
                    }
                    ++n4;
                }
                if (this.pcx_save) {
                    this.pcx.finish();
                }
                this.h = n2;
                this.w = n;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    String tr(double d, NumberFormat numberFormat, double d2) {
        if (d > d2) {
            d = d2;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return numberFormat.format(d);
    }

    int tr(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    int tr(int n, int n2) {
        n = n2 * n / 100;
        return this.tr(n, -n2, n2);
    }

    public MemoryImageSource getImage() {
        return new MemoryImageSource(this.w, this.h, this.pix, 0, this.w);
    }

    private int getNmbr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getChr());
        while (this.chrNxt()) {
            stringBuffer.append(this.getChr());
        }
        return Integer.parseInt(stringBuffer.toString());
    }

    private char getChr() {
        char c;
        if (this.char_saved) {
            this.char_saved = false;
            return this.savchr;
        }
        try {
            do {
                c = (char)this.bf.read();
            } while (this.whitespace(c = this.skipComment(c)));
        }
        catch (IOException iOException) {
            c = ' ';
            System.out.println(iOException.getMessage());
        }
        return c;
    }

    private boolean chrNxt() {
        if (this.char_saved) {
            return true;
        }
        try {
            char c = (char)this.bf.read();
            c = this.skipComment(c);
            if (!this.whitespace(c)) {
                this.char_saved = true;
                this.savchr = c;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return false;
        }
    }

    private boolean whitespace(char c) {
        return c == ' ' | c == '\t' | c == '\n' | c == '\r';
    }

    private char skipComment(char c) throws IOException {
        if (c == '#') {
            boolean bl = false;
            while ((c = (char)this.bf.read()) != '\n') {
            }
        }
        return c;
    }

    public ScanFile(ScanParam scanParam, ScanParameters scanParameters, ScanGui scanGui) {
        this.pcx_save = scanParam.pcx_save;
        this.pcx_file = scanParam.pcx_file;
        this.sg = scanGui;
        this.sp = scanParam;
        this.sps = scanParameters;
    }

    class BlkWht {
        int bits_remain = 0;
        int byt;
        int result;

        public int getBit() throws IOException {
            if (this.bits_remain == 0) {
                this.reset();
            }
            --this.bits_remain;
            this.result = this.byt >> this.bits_remain & 1;
            return this.result == 0 ? 1 : 0;
        }

        public void reset() throws IOException {
            this.byt = ScanFile.this.bf.read();
            this.bits_remain = 8;
            if (ScanFile.this.pcx_save) {
                ScanFile.this.pcx.store(~this.byt);
            }
        }

        BlkWht() {
        }
    }
}

