/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.jka;

import fi.iki.jka.JPhoto;
import fi.iki.jka.JPhotoAlbumLink;
import fi.iki.jka.JPhotoCollection;
import fi.iki.jka.JPhotoFrame;
import fi.iki.jka.JPhotoList;
import fi.iki.jka.Utils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class JPhotoTransferHandler
extends TransferHandler {
    JPhotoList list = null;

    public JPhotoTransferHandler(JPhotoList list) {
        this.list = list;
    }

    public int getSourceActions(JComponent c) {
        int res = super.getSourceActions(c);
        res = 3;
        return res;
    }

    public Transferable createTransferable(JComponent comp) {
        JPhotoCollection selected = new JPhotoCollection();
        selected.setPhotos(new ArrayList<Object>(Arrays.asList(this.list.getSelectedValues())));
        JPhotoCollection transferable = selected;
        System.out.println("createTransferable result " + transferable);
        return transferable;
    }

    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        System.out.println("exportAsDrag:" + comp.getClass() + ", " + action);
        this.list.setDragBegin(this.list.getSelectedIndex());
        super.exportAsDrag(comp, e, action);
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        try {
            this.list.setDragBegin(-1);
            if (data == null) {
                System.out.println("exportDone: No transferable");
                return;
            }
            JPhotoCollection photos = (JPhotoCollection)data.getTransferData(JPhotoCollection.PHOTOCOLLECTION_FLAVOR);
            boolean index = false;
            if (action == 2) {
                Iterator i = photos.iterator();
                while (i.hasNext()) {
                    JPhoto photo = (JPhoto)i.next();
                    if (!this.list.getPhotoModel().remove(photo)) continue;
                    System.out.println("exportDone: removed photo " + photo);
                }
            }
        }
        catch (Exception e) {
            System.out.println("exportDone error:" + e);
        }
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        boolean res = true;
        return res;
    }

    public boolean importData(JComponent comp, Transferable t) {
        try {
            JPhoto photo = null;
            int index = this.list.getSelectedIndex();
            int begin = this.list.getDragBegin();
            if (index < 0) {
                index = 0;
            }
            System.out.println("importData: index=" + index + " begin=" + begin);
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                ++index;
                List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                Collections.sort(fileList);
                Iterator iterator = fileList.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    String name = file.getName().toLowerCase();
                    if (Utils.isImageName(name)) {
                        photo = new JPhoto(this.list.getPhotoModel(), file);
                        this.list.getPhotoModel().add(index, photo);
                        ++index;
                        continue;
                    }
                    if (!name.endsWith(JPhotoFrame.FILE_EXT)) continue;
                    photo = new JPhotoAlbumLink(this.list.getPhotoModel(), file.getAbsolutePath());
                    this.list.getPhotoModel().add(index, photo);
                    ++index;
                }
            } else {
                JPhotoCollection photos = (JPhotoCollection)t.getTransferData(JPhotoCollection.PHOTOCOLLECTION_FLAVOR);
                if (begin >= 0 && begin < index) {
                    ++index;
                }
                Iterator i = photos.iterator();
                while (i.hasNext()) {
                    photo = (JPhoto)i.next();
                    this.list.getPhotoModel().add(index, photo);
                    ++index;
                }
            }
            this.list.recalculateVisibleRows();
            return true;
        }
        catch (Exception e) {
            System.out.println("importData error:" + e);
            e.printStackTrace();
            return false;
        }
    }

    public Icon getVisualRepresentation(Transferable t) {
        try {
            JPhoto photo = (JPhoto)t.getTransferData(JPhoto.PHOTO_FLAVOR);
            System.out.println("getVisualRepresentation for " + photo);
            return new ImageIcon(photo.getThumbImage());
        }
        catch (Exception e) {
            System.out.println("getVisualRepresentation error:" + e);
            return null;
        }
    }
}

