/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import java.util.Hashtable;
import org.exolab.castor.builder.binding.Binding;
import org.exolab.castor.builder.binding.ComponentBindingType;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Structure;

public class ExtendedBinding
extends Binding {
    protected static final String PATH_SEPARATOR = "/";
    protected static final String ATTRIBUTE_PREFIX = "@";
    protected static final String COMPLEXTYPE_ID = "complexType:";
    protected static final String GROUP_ID = "group:";
    private static final short ATTRIBUTE = 10;
    private static final short ELEMENT = 11;
    private static final short COMPLEXTYPE = 12;
    private static final short GROUP = 13;
    private Hashtable _componentBindings = new Hashtable(10);
    private boolean _bindingProcessed = false;

    public ComponentBindingType getComponentBindingType(Annotated annotated) {
        String string;
        ComponentBindingType componentBindingType;
        if (annotated == null) {
            return null;
        }
        if (annotated.getStructureType() == 10) {
            return null;
        }
        if (!this._bindingProcessed) {
            this.processBindingComponents();
        }
        if ((componentBindingType = this.lookupComponentBindingType(string = this.getSchemaLocation(annotated))) == null) {
            switch (annotated.getStructureType()) {
                case 8: {
                    if (componentBindingType != null) break;
                    ElementDecl elementDecl = (ElementDecl)annotated;
                    if (elementDecl.isReference()) {
                        string = this.getSchemaLocation(elementDecl.getReference());
                        componentBindingType = this.lookupComponentBindingType(string);
                    }
                    elementDecl = null;
                    break;
                }
                case 3: {
                    if (componentBindingType != null) break;
                    AttributeDecl attributeDecl = (AttributeDecl)annotated;
                    if (attributeDecl.isReference()) {
                        string = this.getSchemaLocation(attributeDecl.getReference());
                        componentBindingType = this.lookupComponentBindingType(string);
                    }
                    attributeDecl = null;
                    break;
                }
            }
        }
        return componentBindingType;
    }

    private ComponentBindingType lookupComponentBindingType(String string) {
        if (string == null) {
            return null;
        }
        return (ComponentBindingType)this._componentBindings.get(string);
    }

    private void processBindingComponents() {
        ComponentBindingType componentBindingType;
        ComponentBindingType[] componentBindingTypeArray = this.getAttributeBinding();
        int n = 0;
        while (n < componentBindingTypeArray.length) {
            componentBindingType = componentBindingTypeArray[n];
            this.handleComponent(componentBindingType, null, 10);
            ++n;
        }
        componentBindingTypeArray = this.getComplexTypeBinding();
        int n2 = 0;
        while (n2 < componentBindingTypeArray.length) {
            componentBindingType = componentBindingTypeArray[n2];
            this.handleComponent(componentBindingType, null, 12);
            ++n2;
        }
        componentBindingTypeArray = this.getElementBinding();
        int n3 = 0;
        while (n3 < componentBindingTypeArray.length) {
            componentBindingType = componentBindingTypeArray[n3];
            this.handleComponent(componentBindingType, null, 11);
            ++n3;
        }
        componentBindingTypeArray = this.getGroupBinding();
        int n4 = 0;
        while (n4 < componentBindingTypeArray.length) {
            componentBindingType = componentBindingTypeArray[n4];
            this.handleComponent(componentBindingType, null, 13);
            ++n4;
        }
        componentBindingType = null;
        componentBindingTypeArray = null;
        this._bindingProcessed = true;
    }

    private void handleComponent(ComponentBindingType componentBindingType, StringBuffer stringBuffer, int n) {
        ComponentBindingType componentBindingType2;
        String string;
        if (componentBindingType == null) {
            return;
        }
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(20);
        }
        boolean bl = (string = componentBindingType.getName()).indexOf(PATH_SEPARATOR) != -1;
        switch (n) {
            case 10: {
                if (!bl) {
                    stringBuffer.append(PATH_SEPARATOR);
                    stringBuffer.append(ATTRIBUTE_PREFIX);
                }
                stringBuffer.append(string);
                this._componentBindings.put(stringBuffer.toString(), componentBindingType);
                break;
            }
            case 12: {
                if (!bl) {
                    stringBuffer.append(COMPLEXTYPE_ID);
                }
                stringBuffer.append(string);
                this._componentBindings.put(stringBuffer.toString(), componentBindingType);
                break;
            }
            case 11: {
                if (!bl) {
                    stringBuffer.append(PATH_SEPARATOR);
                }
                stringBuffer.append(string);
                this._componentBindings.put(stringBuffer.toString(), componentBindingType);
                break;
            }
            case 13: {
                if (!bl) {
                    stringBuffer.append(GROUP_ID);
                }
                stringBuffer.append(string);
                this._componentBindings.put(stringBuffer.toString(), componentBindingType);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid ComponentBindingType: the type (attribute, element, complextype or group) is unknown");
            }
        }
        ComponentBindingType[] componentBindingTypeArray = componentBindingType.getAttributeBinding();
        int n2 = 0;
        while (n2 < componentBindingTypeArray.length) {
            componentBindingType2 = componentBindingTypeArray[n2];
            this.handleComponent(componentBindingType2, stringBuffer, 10);
            ++n2;
        }
        componentBindingTypeArray = componentBindingType.getComplexTypeBinding();
        int n3 = 0;
        while (n3 < componentBindingTypeArray.length) {
            componentBindingType2 = componentBindingTypeArray[n3];
            this.handleComponent(componentBindingType2, stringBuffer, 12);
            ++n3;
        }
        componentBindingTypeArray = componentBindingType.getElementBinding();
        int n4 = 0;
        while (n4 < componentBindingTypeArray.length) {
            componentBindingType2 = componentBindingTypeArray[n4];
            this.handleComponent(componentBindingType2, stringBuffer, 11);
            ++n4;
        }
        componentBindingTypeArray = componentBindingType.getGroupBinding();
        int n5 = 0;
        while (n5 < componentBindingTypeArray.length) {
            componentBindingType2 = componentBindingTypeArray[n5];
            this.handleComponent(componentBindingType2, stringBuffer, 13);
            ++n5;
        }
        componentBindingType2 = null;
        componentBindingTypeArray = null;
    }

    private String getSchemaLocation(Structure structure) {
        if (structure == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        this.getSchemaLocation(structure, stringBuffer);
        return stringBuffer.toString();
    }

    private void getSchemaLocation(Structure structure, StringBuffer stringBuffer) {
        if (structure == null) {
            throw new IllegalArgumentException("Structure cannot be null");
        }
        if (stringBuffer == null) {
            throw new IllegalArgumentException("location cannot be null");
        }
        Structure structure2 = null;
        switch (structure.getStructureType()) {
            case 8: {
                structure2 = ((ElementDecl)structure).getParent();
                if (structure2.getStructureType() != 19) {
                    this.getSchemaLocation(structure2, stringBuffer);
                }
                stringBuffer.append(PATH_SEPARATOR);
                stringBuffer.append(((ElementDecl)structure).getName());
                break;
            }
            case 6: {
                ComplexType complexType = (ComplexType)structure;
                structure2 = complexType.getParent();
                if (structure2.getStructureType() != 19) {
                    this.getSchemaLocation(structure2, stringBuffer);
                }
                if (complexType.getName() == null) break;
                stringBuffer.append(COMPLEXTYPE_ID);
                stringBuffer.append(((ComplexType)structure).getName());
                break;
            }
            case 16: {
                ModelGroup modelGroup = (ModelGroup)structure;
                structure2 = modelGroup.getParent();
                if (structure2.getStructureType() != 19) {
                    this.getSchemaLocation(structure2, stringBuffer);
                }
                if (modelGroup.getName() == null) break;
                stringBuffer.append(GROUP_ID);
                stringBuffer.append(modelGroup.getName());
                break;
            }
            case 3: {
                structure2 = ((AttributeDecl)structure).getParent();
                if (structure2.getStructureType() != 19) {
                    this.getSchemaLocation(structure2, stringBuffer);
                }
                stringBuffer.append(PATH_SEPARATOR);
                stringBuffer.append(ATTRIBUTE_PREFIX);
                stringBuffer.append(((AttributeDecl)structure).getName());
                break;
            }
            case 10: {
                this.getSchemaLocation(((Group)structure).getParent(), stringBuffer);
                break;
            }
        }
    }
}

