/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import java.io.Serializable;
import org.exolab.castor.builder.BindingComponent;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.binding.ClassType;
import org.exolab.castor.builder.binding.ComponentBindingType;
import org.exolab.castor.builder.binding.ComponentBindingTypeChoice;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.FieldType;
import org.exolab.castor.builder.binding.Interface;
import org.exolab.castor.builder.binding.NamingXMLType;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.javasource.JClass;

public class XMLBindingComponent
implements BindingComponent {
    private ExtendedBinding _binding;
    private ComponentBindingType _compBinding;
    private Annotated _annotated;
    private String _prefix;
    private String _suffix;
    private short _type = (short)-1;
    private int _hashCode = -1;
    private String _javaClassName = null;
    private String _javaMemberName = null;
    private String _javaPackage = null;
    private FieldType _member = null;
    private ClassType _class = null;
    private Interface _interface = null;
    private Schema _schema = null;
    private static GroupNaming _groupNaming = null;

    public ExtendedBinding getBinding() {
        return this._binding;
    }

    public void setBinding(ExtendedBinding extendedBinding) {
        this._binding = extendedBinding;
    }

    public void setView(Annotated annotated) {
        Serializable serializable;
        if (annotated == null) {
            throw new IllegalArgumentException("The XML Schema annotated structure is null.");
        }
        this._annotated = annotated;
        int n = -1;
        this._javaClassName = null;
        this._javaMemberName = null;
        this._javaPackage = null;
        this._schema = null;
        this._member = null;
        this._class = null;
        this._interface = null;
        this._type = (short)-1;
        this._prefix = null;
        this._suffix = null;
        if (this._binding != null) {
            this._compBinding = this._binding.getComponentBindingType(annotated);
            serializable = this._binding.getNamingXML();
            if (serializable != null) {
                switch (annotated.getStructureType()) {
                    case 6: {
                        if (((NamingXMLType)serializable).getComplexTypeName() == null) break;
                        this._prefix = ((NamingXMLType)serializable).getComplexTypeName().getPrefix();
                        this._suffix = ((NamingXMLType)serializable).getComplexTypeName().getSuffix();
                        break;
                    }
                    case 8: {
                        if (((NamingXMLType)serializable).getElementName() == null) break;
                        this._prefix = ((NamingXMLType)serializable).getElementName().getPrefix();
                        this._suffix = ((NamingXMLType)serializable).getElementName().getSuffix();
                        break;
                    }
                    case 16: {
                        if (((NamingXMLType)serializable).getModelGroupName() == null) break;
                        this._prefix = ((NamingXMLType)serializable).getModelGroupName().getPrefix();
                        this._suffix = ((NamingXMLType)serializable).getModelGroupName().getSuffix();
                        break;
                    }
                }
            }
        }
        if (this._compBinding != null) {
            serializable = this._compBinding.getComponentBindingTypeChoice();
            if (((ComponentBindingTypeChoice)serializable).getInterface() != null) {
                this._type = 0;
                this._interface = ((ComponentBindingTypeChoice)serializable).getInterface();
            } else if (((ComponentBindingTypeChoice)serializable).getJavaClass() != null) {
                this._type = 1;
                this._class = ((ComponentBindingTypeChoice)serializable).getJavaClass();
            } else if (((ComponentBindingTypeChoice)serializable).getMember() != null) {
                this._type = (short)2;
                this._member = ((ComponentBindingTypeChoice)serializable).getMember();
            } else {
                String string = "Illegal Binding component:";
                string = string + "it does not define a class, an interface or a member binding.";
                throw new IllegalStateException(string);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        boolean bl = false;
        if (object instanceof XMLBindingComponent) {
            XMLBindingComponent xMLBindingComponent = (XMLBindingComponent)object;
            bl = this._annotated.equals(xMLBindingComponent.getAnnotated());
            if (this._compBinding != null) {
                bl = xMLBindingComponent.getComponentBinding() != null ? bl && this._compBinding.equals(xMLBindingComponent.getComponentBinding()) : false;
            } else if (xMLBindingComponent.getComponentBinding() != null) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            int n = 0;
            if (this._compBinding != null) {
                n = this._compBinding.getName().hashCode();
            }
            this._hashCode = 37 * this._annotated.hashCode() + n;
        }
        return this._hashCode;
    }

    protected ComponentBindingType getComponentBinding() {
        return this._compBinding;
    }

    public Annotated getAnnotated() {
        return this._annotated;
    }

    public boolean createGroupItem() {
        int n = 0;
        boolean bl = false;
        switch (this._annotated.getStructureType()) {
            case 8: {
                XMLType xMLType = ((ElementDecl)this._annotated).getType();
                if (!xMLType.isComplexType() || (n = ((ComplexType)xMLType).getMaxOccurs()) <= 1 && n >= 0 || xMLType.getName() != null) break;
                bl = true;
                break;
            }
            case 6: {
                n = ((ComplexType)this._annotated).getMaxOccurs();
                if (n <= 1 && n >= 0) break;
                bl = true;
                break;
            }
            case 10: 
            case 16: {
                Group group = (Group)this._annotated;
                n = group.getMaxOccurs();
                if (n <= 1 && n >= 0) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String getSchemaLocation() {
        String string = null;
        Schema schema = this.getSchema();
        if (schema != null) {
            string = schema.getSchemaLocation();
        }
        return string;
    }

    public String getTargetNamespace() {
        String string = null;
        Schema schema = null;
        Form form = null;
        switch (this._annotated.getStructureType()) {
            case 3: {
                AttributeDecl attributeDecl = (AttributeDecl)this._annotated;
                if (attributeDecl.isReference()) {
                    attributeDecl = attributeDecl.getReference();
                }
                schema = attributeDecl.getSchema();
                if (attributeDecl.getParent() == schema) break;
                form = attributeDecl.getForm();
                if (form == null) {
                    form = schema.getAttributeFormDefault();
                }
                if (form != null && !form.isUnqualified()) break;
                return null;
            }
            case 8: {
                ElementDecl elementDecl = (ElementDecl)this._annotated;
                if (elementDecl.isReference()) {
                    elementDecl = elementDecl.getReference();
                }
                schema = elementDecl.getSchema();
                if (elementDecl.getParent() == schema) break;
                form = elementDecl.getForm();
                if (form == null) {
                    form = schema.getElementFormDefault();
                }
                if (form != null && !form.isUnqualified()) break;
                return null;
            }
        }
        if (schema == null) {
            schema = this.getSchema();
        }
        if (schema != null) {
            string = schema.getTargetNamespace();
        }
        return string;
    }

    public Schema getSchema() {
        if (this._schema == null) {
            switch (this._annotated.getStructureType()) {
                case 3: {
                    AttributeDecl attributeDecl = (AttributeDecl)this._annotated;
                    if (attributeDecl.isReference()) {
                        attributeDecl = attributeDecl.getReference();
                    }
                    this._schema = attributeDecl.getSchema();
                    attributeDecl = null;
                    break;
                }
                case 8: {
                    ElementDecl elementDecl = (ElementDecl)this._annotated;
                    if (elementDecl.isReference()) {
                        elementDecl = elementDecl.getReference();
                    }
                    this._schema = elementDecl.getSchema();
                    elementDecl = null;
                    break;
                }
                case 6: {
                    this._schema = ((ComplexType)this._annotated).getSchema();
                    break;
                }
                case 16: {
                    ModelGroup modelGroup = (ModelGroup)this._annotated;
                    if (modelGroup.isReference()) {
                        modelGroup = modelGroup.getReference();
                    }
                    this._schema = modelGroup.getSchema();
                    modelGroup = null;
                    break;
                }
                case 10: {
                    Structure structure = ((Group)this._annotated).getParent();
                    short s = structure.getStructureType();
                    while (s == 10) {
                        structure = ((Group)structure).getParent();
                        s = structure.getStructureType();
                    }
                    if (s == 6) {
                        this._schema = ((ComplexType)structure).getSchema();
                        break;
                    }
                    if (s != 16) break;
                    this._schema = ((ModelGroup)structure).getSchema();
                    break;
                }
                case 21: 
                case 22: {
                    this._schema = ((SimpleType)this._annotated).getSchema();
                    break;
                }
            }
        }
        return this._schema;
    }

    public XMLType getXMLType() {
        XMLType xMLType = null;
        switch (this._annotated.getStructureType()) {
            case 8: {
                xMLType = ((ElementDecl)this._annotated).getType();
                break;
            }
            case 6: {
                xMLType = (ComplexType)this._annotated;
                break;
            }
            case 3: {
                xMLType = ((AttributeDecl)this._annotated).getSimpleType();
                break;
            }
        }
        return xMLType;
    }

    public String getXMLName() {
        String string = null;
        switch (this._annotated.getStructureType()) {
            case 8: {
                string = ((ElementDecl)this._annotated).getName();
                break;
            }
            case 6: {
                string = ((ComplexType)this._annotated).getName();
                break;
            }
            case 3: {
                string = ((AttributeDecl)this._annotated).getName();
                break;
            }
            case 10: 
            case 16: {
                string = ((Group)this._annotated).getName();
                break;
            }
        }
        return string;
    }

    public String getValue() {
        String string = null;
        switch (this._annotated.getStructureType()) {
            case 8: {
                string = ((ElementDecl)this._annotated).getDefaultValue();
                if (string != null) break;
                string = ((ElementDecl)this._annotated).getFixedValue();
                break;
            }
            case 3: {
                string = ((AttributeDecl)this._annotated).getDefaultValue();
                if (string != null) break;
                string = ((AttributeDecl)this._annotated).getFixedValue();
                break;
            }
        }
        return string;
    }

    public String getJavaClassName() {
        if (this._javaClassName == null) {
            String string = null;
            if (this._compBinding != null) {
                switch (this.getType()) {
                    case 1: {
                        string = this._class.getName();
                        break;
                    }
                    case 0: {
                        string = this._interface.getName();
                        break;
                    }
                }
            }
            if (string == null || string.length() <= 0) {
                Object object;
                if (this._annotated.getStructureType() == 8) {
                    object = (ElementDecl)this._annotated;
                    if (((ElementDecl)object).isReference()) {
                        Annotated annotated = this._annotated;
                        this.setView(((ElementDecl)object).getReference());
                        string = this.getJavaClassName();
                        this.setView(annotated);
                        annotated = null;
                    }
                    object = null;
                }
                if (!(string != null && string.length() > 0 || (string = this.getXMLName()) != null || this._annotated.getStructureType() != 10 && this._annotated.getStructureType() != 16 || (string = _groupNaming.createClassName((Group)this._annotated)) != null)) {
                    object = "Unable to create name for group.";
                    throw new IllegalStateException((String)object);
                }
            }
            if (this._prefix != null) {
                string = this._prefix + string;
            }
            if (this._suffix != null) {
                string = string + this._suffix;
            }
            this._javaClassName = JavaNaming.toJavaClassName(string);
        }
        return this._javaClassName;
    }

    public String getJavaMemberName() {
        if (this._javaMemberName == null) {
            String string = null;
            if (this._compBinding != null) {
                switch (this.getType()) {
                    case 1: {
                        string = this._class.getName();
                        break;
                    }
                    case 0: {
                        string = this._interface.getName();
                        break;
                    }
                    case 2: {
                        string = this._member.getName();
                        break;
                    }
                }
            }
            if (string == null || string.length() <= 0) {
                Object object;
                Annotated annotated = null;
                if (this._annotated.getStructureType() == 3) {
                    object = (AttributeDecl)this._annotated;
                    if (((AttributeDecl)object).isReference()) {
                        annotated = this._annotated;
                        this.setView(((AttributeDecl)object).getReference());
                        string = this.getJavaMemberName();
                        this.setView(annotated);
                    }
                    object = null;
                } else if (this._annotated.getStructureType() == 8) {
                    object = (ElementDecl)this._annotated;
                    if (((ElementDecl)object).isReference()) {
                        annotated = this._annotated;
                        this.setView(((ElementDecl)object).getReference());
                        string = this.getJavaMemberName();
                        this.setView(annotated);
                    }
                    object = null;
                }
                annotated = null;
                if (!(string != null && string.length() > 0 || (string = this.getXMLName()) != null || this._annotated.getStructureType() != 10 && this._annotated.getStructureType() != 16 || (string = _groupNaming.createClassName((Group)this._annotated)) != null)) {
                    object = "Unable to create name for group.";
                    throw new IllegalStateException((String)object);
                }
            }
            if (this._prefix != null) {
                string = this._prefix + string;
            }
            if (this._suffix != null) {
                string = string + this._suffix;
            }
            this._javaMemberName = JavaNaming.toJavaMemberName(string);
        }
        return this._javaMemberName;
    }

    public String getQualifiedName() {
        String string = this.getJavaClassName();
        String string2 = this.getJavaPackage();
        if (string2 != null && string2.length() > 0) {
            string2 = string2 + '.';
            string = string2 + string;
        }
        return string;
    }

    public String getJavaPackage() {
        if (this._javaPackage == null) {
            String string = null;
            String string2 = this.getSchemaLocation();
            String string3 = this.getTargetNamespace();
            if (this._compBinding != null) {
                switch (this.getType()) {
                    case 1: {
                        string = this._class.getPackage();
                        break;
                    }
                }
            }
            if (string == null || string.length() == 0) {
                if (string2 != null) {
                    string = SourceGenerator.lookupPackageLocation(string2);
                }
                if (string3 != null && (string == null || string.length() == 0)) {
                    string = SourceGenerator.lookupPackageNamespace(string3);
                }
            }
            this._javaPackage = string;
        }
        return this._javaPackage;
    }

    public int getUpperBound() {
        switch (this._annotated.getStructureType()) {
            case 8: {
                return ((ElementDecl)this._annotated).getMaxOccurs();
            }
            case 6: {
                return ((ComplexType)this._annotated).getMaxOccurs();
            }
            case 10: 
            case 16: {
                return ((Group)this._annotated).getMaxOccurs();
            }
        }
        return 1;
    }

    public int getLowerBound() {
        switch (this._annotated.getStructureType()) {
            case 8: {
                return ((ElementDecl)this._annotated).getMinOccurs();
            }
            case 6: {
                return ((ComplexType)this._annotated).getMinOccurs();
            }
            case 10: 
            case 16: {
                return ((Group)this._annotated).getMinOccurs();
            }
            case 3: {
                if (!((AttributeDecl)this._annotated).isRequired()) break;
                return 1;
            }
        }
        return 0;
    }

    public String getExtends() {
        if (this.getType() == 1) {
            return this._class.getExtends();
        }
        return SourceGenerator.getProperty("org.exolab.castor.builder.superclass", null);
    }

    public String[] getImplements() {
        if (this.getType() == 1) {
            return this._class.getImplements();
        }
        return null;
    }

    public boolean hasBoundProperties() {
        if (this.getType() == 1 && this._class.hasBound()) {
            return this._class.getBound();
        }
        return SourceGenerator.boundPropertiesEnabled();
    }

    public boolean hasEquals() {
        if (this.getType() == 1 && this._class.hasEquals()) {
            return this._class.getEquals();
        }
        return SourceGenerator.equalsMethod();
    }

    public boolean isAbstract() {
        boolean bl = false;
        if (this.getType() == 1 && this._class.hasAbstract()) {
            bl = this._class.getAbstract();
        }
        if (!bl) {
            bl = this._annotated.getStructureType() == 6;
            bl = bl && SourceGenerator.mappingSchemaElement2Java();
        }
        return bl;
    }

    public boolean isFinal() {
        if (this.getType() == 1) {
            return this._class.getFinal();
        }
        return false;
    }

    public boolean isFixed() {
        switch (this._annotated.getStructureType()) {
            case 8: {
                String string = ((ElementDecl)this._annotated).getFixedValue();
                return string != null;
            }
            case 3: {
                return ((AttributeDecl)this._annotated).isFixed();
            }
        }
        return false;
    }

    public boolean useWrapper() {
        boolean bl = false;
        if (this._type == 2) {
            if (this._member.hasWrapper()) {
                bl = this._member.getWrapper();
            }
        } else {
            bl = SourceGenerator.usePrimitiveWrapper();
        }
        return bl;
    }

    public XSType getJavaType() {
        String string;
        XSType xSType = null;
        boolean bl = this.useWrapper();
        XMLType xMLType = this.getXMLType();
        if (xMLType.isComplexType()) {
            xSType = new XSClass(new JClass(this.getJavaClassName()));
        } else if (this._type == 2 && (string = this._member.getJavaType()) != null && string.length() > 0) {
            xSType = TypeConversion.convertType(string);
        }
        if (xSType == null && xMLType.isSimpleType()) {
            string = null;
            if (((SimpleType)xMLType).getSchema() != this.getSchema()) {
                XMLBindingComponent xMLBindingComponent = new XMLBindingComponent();
                xMLBindingComponent.setBinding(this._binding);
                xMLBindingComponent.setView(xMLType);
                string = xMLBindingComponent.getJavaPackage();
            } else {
                string = this.getJavaPackage();
            }
            xSType = TypeConversion.convertType((SimpleType)xMLType, bl, string);
        }
        return xSType;
    }

    public String getCollectionType() {
        String string = null;
        if (this._type == 2) {
            string = this._member.getCollection().toString();
        }
        return string;
    }

    public String getValidator() {
        if (this._type == 2) {
            return this._member.getValidator();
        }
        return null;
    }

    public String getXMLFieldHandler() {
        if (this._type == 2) {
            return this._member.getHandler();
        }
        return null;
    }

    public short getType() {
        return this._type;
    }

    static {
        _groupNaming = new GroupNaming();
    }
}

