/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.HashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.XAResourceSource;

public final class XAResourceImpl
implements XAResource {
    private final LockEngine _engine;
    private final XAResourceSource _xaSource;

    public XAResourceImpl(LockEngine lockEngine, XAResourceSource xAResourceSource) {
        if (lockEngine == null || xAResourceSource == null) {
            throw new IllegalArgumentException("Argument 'engine' or xaSource' is null");
        }
        this._xaSource = xAResourceSource;
        this._engine = lockEngine;
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        switch (n) {
            case 0: {
                TransactionContext transactionContext;
                HashMap hashMap = this._engine.getXATransactions();
                synchronized (hashMap) {
                    transactionContext = (TransactionContext)this._engine.getXATransactions().get(xid);
                    if (transactionContext == null) {
                        transactionContext = this._xaSource.createTransactionContext(xid);
                        this._engine.getXATransactions().put(xid, transactionContext);
                    }
                }
                this._xaSource.setTransactionContext(transactionContext);
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                TransactionContext transactionContext = (TransactionContext)this._engine.getXATransactions().get(xid);
                if (transactionContext == null || !transactionContext.isOpen()) {
                    throw new XAException(-4);
                }
                this._xaSource.setTransactionContext(transactionContext);
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionContext transactionContext = (TransactionContext)this._engine.getXATransactions().get(xid);
        if (transactionContext == null) {
            throw new XAException(-4);
        }
        if (this._xaSource.getTransactionContext() == null) {
            throw new XAException(-5);
        }
        switch (n) {
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                this._xaSource.xaFailed();
                this._xaSource.setTransactionContext(null);
                if (!transactionContext.isOpen()) break;
                try {
                    transactionContext.rollback();
                }
                catch (Exception exception) {}
                break;
            }
            case 0x2000000: {
                this._xaSource.setTransactionContext(null);
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    public synchronized void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        HashMap hashMap = this._engine.getXATransactions();
        synchronized (hashMap) {
            TransactionContext transactionContext = (TransactionContext)this._engine.getXATransactions().remove(xid);
            if (transactionContext == null) {
                throw new XAException(-4);
            }
            if (this._xaSource.getTransactionContext() == transactionContext) {
                this._xaSource.setTransactionContext(null);
            }
            if (transactionContext.isOpen()) {
                try {
                    transactionContext.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new XAException(-6);
            }
        }
    }

    public synchronized int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionContext transactionContext = (TransactionContext)this._engine.getXATransactions().get(xid);
        if (transactionContext == null) {
            throw new XAException(-4);
        }
        switch (transactionContext.getStatus()) {
            case 0: 
            case 2: {
                try {
                    if (transactionContext.prepare()) {
                        return 0;
                    }
                    return 3;
                }
                catch (TransactionAbortedException transactionAbortedException) {
                    throw new XAException(100);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new XAException(-6);
                }
            }
            case 1: {
                throw new XAException(100);
            }
        }
        throw new XAException(-6);
    }

    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionContext transactionContext = (TransactionContext)this._engine.getXATransactions().get(xid);
        if (transactionContext == null) {
            throw new XAException(-4);
        }
        switch (transactionContext.getStatus()) {
            case 3: {
                return;
            }
            case 4: {
                throw new XAException(6);
            }
            case 2: {
                try {
                    transactionContext.commit();
                    break;
                }
                catch (TransactionAbortedException transactionAbortedException) {
                    throw new XAException(6);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new XAException(-6);
                }
            }
        }
        throw new XAException(-6);
    }

    public synchronized void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionContext transactionContext = (TransactionContext)this._engine.getXATransactions().get(xid);
        if (transactionContext == null) {
            throw new XAException(-4);
        }
        switch (transactionContext.getStatus()) {
            case 3: {
                throw new XAException(7);
            }
            case 4: {
                return;
            }
            case 0: 
            case 1: {
                try {
                    transactionContext.rollback();
                }
                catch (IllegalStateException illegalStateException) {
                    throw new XAException(-6);
                }
                return;
            }
        }
        throw new XAException(-6);
    }

    public Xid[] recover(int n) throws XAException {
        return null;
    }

    public synchronized boolean isSameRM(XAResource xAResource) throws XAException {
        if (xAResource == null || !(xAResource instanceof XAResourceImpl)) {
            return false;
        }
        return this._engine == ((XAResourceImpl)xAResource)._engine;
    }

    public boolean setTransactionTimeout(int n) {
        TransactionContext transactionContext = this._xaSource.getTransactionContext();
        if (transactionContext != null && transactionContext.isOpen()) {
            transactionContext.setTransactionTimeout(n);
            return true;
        }
        return false;
    }

    public int getTransactionTimeout() {
        TransactionContext transactionContext = this._xaSource.getTransactionContext();
        if (transactionContext != null && transactionContext.isOpen()) {
            return transactionContext.getTransactionTimeout();
        }
        return 0;
    }
}

