/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Structure;

public class Wildcard
extends Particle {
    private Vector _namespaces;
    private boolean _attribute = false;
    private ComplexType _complexType;
    private Group _group;
    private AttributeGroup _attGroup;
    private String _processContents;
    private String _id = null;

    public Wildcard(ComplexType complexType) {
        this._complexType = complexType;
        this.init();
    }

    public Wildcard(Group group) {
        this._group = group;
        this.init();
    }

    public Wildcard(AttributeGroup attributeGroup) {
        this._attGroup = attributeGroup;
        this.init();
    }

    private void init() {
        this._namespaces = new Vector(1);
        this.setMaxOccurs(1);
        this.setMinOccurs(1);
        try {
            this.setProcessContents("strict");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    public void addNamespace(String string) {
        this._namespaces.addElement(string);
    }

    public boolean removeNamespace(String string) {
        if (string == null) {
            return false;
        }
        int n = this._namespaces.indexOf(string);
        if (n >= 0) {
            this._namespaces.removeElementAt(n);
            return true;
        }
        return false;
    }

    public ComplexType getComplexType() {
        return this._complexType;
    }

    public Group getModelGroup() {
        return this._group;
    }

    public AttributeGroup getAttributeGroup() {
        return this._attGroup;
    }

    public Schema getSchema() {
        if (this._complexType != null) {
            return this._complexType.getSchema();
        }
        if (this._attGroup != null) {
            if (this._attGroup instanceof AttributeGroupDecl) {
                return ((AttributeGroupDecl)this._attGroup).getSchema();
            }
            if (this._attGroup instanceof AttributeGroupReference) {
                AttributeGroup attributeGroup = ((AttributeGroupReference)this._attGroup).resolveReference();
                if (attributeGroup instanceof AttributeGroupDecl) {
                    return ((AttributeGroupDecl)attributeGroup).getSchema();
                }
                attributeGroup = null;
                return null;
            }
        } else if (this._group != null) {
            Structure structure = this._group.getParent();
            Schema schema = null;
            if (structure != null) {
                while (schema == null) {
                    switch (structure.getStructureType()) {
                        case 6: {
                            schema = ((ComplexType)structure).getSchema();
                            break;
                        }
                        case 16: {
                            schema = ((ModelGroup)structure).getSchema();
                            break;
                        }
                        case 10: {
                            structure = ((Group)structure).getParent();
                            break;
                        }
                        default: {
                            String string = "A group can only be child of a complexType";
                            string = string + " or a ModelGroup or a group.";
                            throw new IllegalStateException(string);
                        }
                    }
                }
            }
            return schema;
        }
        return null;
    }

    public Enumeration getNamespaces() {
        return this._namespaces.elements();
    }

    public String getProcessContent() {
        return this._processContents;
    }

    public boolean isAttributeWildcard() {
        return this._attribute;
    }

    public void setAttributeWildcard() {
        this._attribute = true;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setProcessContents(String string) throws SchemaException {
        if (!SchemaNames.isProcessName(string)) {
            throw new SchemaException("processContents attribute not valid:" + string);
        }
        this._processContents = string;
    }

    public void validate() throws ValidationException {
    }

    public short getStructureType() {
        return 24;
    }
}

