/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;

public class FacetUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller = null;
    private int depth = 0;
    private Facet _facet = null;
    private String _elementName = null;

    public FacetUnmarshaller(String string, AttributeSet attributeSet) throws XMLException {
        this._elementName = string;
        if (!FacetUnmarshaller.isFacet(string)) {
            String string2 = "'" + string + "' is not a valid or supported facet.";
            throw new IllegalArgumentException(string2);
        }
        Object var3_4 = null;
        this._facet = new Facet(string, attributeSet.getValue("value"));
    }

    public String elementName() {
        return this._elementName;
    }

    public Facet getFacet() {
        return this._facet;
    }

    public Object getObject() {
        return this.getFacet();
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else {
            this.illegalElement(string);
        }
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        if (this.unmarshaller == null) {
            throw new SchemaException("missing start element: " + string);
        }
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._facet.addAnnotation(annotation);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    protected static boolean isFacet(String string) {
        if ("enumeration".equals(string)) {
            return true;
        }
        if ("length".equals(string)) {
            return true;
        }
        if ("pattern".equals(string)) {
            return true;
        }
        if ("maxExclusive".equals(string)) {
            return true;
        }
        if ("minExclusive".equals(string)) {
            return true;
        }
        if ("maxInclusive".equals(string)) {
            return true;
        }
        if ("minInclusive".equals(string)) {
            return true;
        }
        if ("maxLength".equals(string)) {
            return true;
        }
        if ("minLength".equals(string)) {
            return true;
        }
        if ("whiteSpace".equals(string)) {
            return true;
        }
        if ("totalDigits".equals(string)) {
            return true;
        }
        return "fractionDigits".equals(string);
    }
}

