/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.SimpleTypeDefinition;
import org.exolab.castor.xml.schema.reader.SimpleTypeListUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeRestrictionUnmarshaller;
import org.exolab.castor.xml.schema.reader.UnionUnmarshaller;

public class SimpleTypeUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private SimpleTypeDefinition _simpleTypeDef = null;
    private SimpleType _simpleType = null;
    private boolean foundAnnotation = false;
    private boolean foundList = false;
    private boolean foundRestriction = false;
    private boolean foundUnion = false;

    public SimpleTypeUnmarshaller(Schema schema, AttributeSet attributeSet) throws XMLException {
        String string;
        String string2;
        int n;
        String string3 = attributeSet.getValue("name");
        if (string3 != null && (n = string3.indexOf(58)) >= 0 && (string2 = schema.getNamespace(string = string3.substring(0, n))) != null && string2.equals(schema.getTargetNamespace())) {
            string3 = string3.substring(n + 1);
        }
        String string4 = attributeSet.getValue("id");
        this._simpleTypeDef = new SimpleTypeDefinition(schema, string3, string4);
        this._simpleTypeDef.setFinal(attributeSet.getValue("final"));
    }

    public String elementName() {
        return "simpleType";
    }

    public SimpleType getSimpleType() {
        if (this._simpleType == null) {
            this._simpleType = this._simpleTypeDef.createSimpleType();
        }
        return this._simpleType;
    }

    public Object getObject() {
        return this.getSimpleType();
    }

    public void finish() throws XMLException {
        if (!(this.foundList || this.foundUnion || this.foundRestriction)) {
            this.error("Invalid 'simpleType'; missing 'restriction' | 'union' | 'list'.");
        }
    }

    public void startElement(String string, String string2, AttributeSet attributeSet, Namespaces namespaces) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, string2, attributeSet, namespaces);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'simpleType'.");
            }
            if (this.foundList || this.foundUnion || this.foundRestriction) {
                this.error("An annotation may only appear as the first child of 'simpleType'.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeSet);
        } else if ("restriction".equals(string)) {
            if (this.foundList) {
                this.error("A 'simpleType' cannot have both a 'list' and a 'restriction' in the same definition.");
            }
            if (this.foundUnion) {
                this.error("A 'simpleType' cannot have both a 'union' and a 'restriction' in the same definition.");
            }
            this.foundRestriction = true;
            this.unmarshaller = new SimpleTypeRestrictionUnmarshaller(this._simpleTypeDef, attributeSet);
        } else if ("list".equals(string)) {
            this.foundList = true;
            Schema schema = this._simpleTypeDef.getSchema();
            this.unmarshaller = new SimpleTypeListUnmarshaller(schema, attributeSet);
        } else if ("union".equals(string)) {
            this.foundUnion = true;
            Schema schema = this._simpleTypeDef.getSchema();
            this.unmarshaller = new UnionUnmarshaller(schema, attributeSet);
        } else {
            this.illegalElement(string);
        }
    }

    public void endElement(String string, String string2) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string, string2);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._simpleTypeDef.setAnnotation(annotation);
        } else if ("list".equals(string)) {
            this._simpleType = (SimpleType)this.unmarshaller.getObject();
            this._simpleTypeDef.copyInto(this._simpleType);
        } else if ("union".equals(string)) {
            this._simpleType = (SimpleType)this.unmarshaller.getObject();
            this._simpleTypeDef.copyInto(this._simpleType);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

