/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class LongValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private long min = 0L;
    private long max = 0L;
    private long fixed = 0L;

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public void setFixed(long l) {
        this.useFixed = true;
        this.fixed = l;
    }

    public void setMinExclusive(long l) {
        this.useMin = true;
        this.min = l + 1L;
    }

    public void setMinInclusive(long l) {
        this.useMin = true;
        this.min = l;
    }

    public void setMaxExclusive(long l) {
        this.useMax = true;
        this.max = l - 1L;
    }

    public void setMaxInclusive(long l) {
        this.useMax = true;
        this.max = l;
    }

    public void validate(long l, ValidationContext validationContext) throws ValidationException {
        if (this.useFixed) {
            if (l != this.fixed) {
                String string = l + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(string);
            }
            return;
        }
        if (this.useMin && l < this.min) {
            String string = l + " is less than the minimum allowable ";
            string = string + "value of " + this.min;
            throw new ValidationException(string);
        }
        if (this.useMax && l > this.max) {
            String string = l + " is greater than the maximum allowable ";
            string = string + "value of " + this.max;
            throw new ValidationException(string);
        }
        if (this.hasPattern()) {
            super.validate(Long.toString(l), validationContext);
        }
    }

    public void validate(Object object, ValidationContext validationContext) throws ValidationException {
        if (object == null) {
            String string = "LongValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        long l = 0L;
        try {
            l = (Long)object;
        }
        catch (Exception exception) {
            String string = "Expecting a Long, received instead: ";
            string = string + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(l, validationContext);
    }
}

