/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JInterface;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

abstract class JStructure
extends JType {
    static final String DEFAULT_HEADER = "$Id$";
    static final String version = "$Revision$ $Date$";
    private JComment header = null;
    private Vector imports = null;
    private Vector interfaces = null;
    private JDocComment jdc = null;
    private Vector methods = null;
    private JModifiers modifiers = null;
    private String packageName = null;

    protected JStructure(String string) throws IllegalArgumentException {
        super(string);
        if (!JStructure.isValidClassName(string)) {
            String string2 = this.getLocalName();
            String string3 = "'" + string2 + "' is ";
            string3 = JNaming.isKeyword(string2) ? string3 + "a reserved word and may not be used as  a class name." : string3 + "not a valid Java identifier.";
            throw new IllegalArgumentException(string3);
        }
        this.packageName = JStructure.getPackageFromClassName(string);
        this.imports = new Vector();
        this.interfaces = new Vector();
        this.jdc = new JDocComment();
        this.methods = new Vector();
        this.modifiers = new JModifiers();
        this.jdc.addDescriptor(JDocDescriptor.createVersionDesc(version));
    }

    public abstract void addField(JField var1) throws IllegalArgumentException;

    public abstract void addMember(JMember var1) throws IllegalArgumentException;

    public void addImport(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        String string2 = JStructure.getPackageFromClassName(string);
        if (string2 != null) {
            if (string2.equals(this.packageName)) {
                return;
            }
            if (string2.equals("java.lang")) {
                return;
            }
            int n = 0;
            while (n < this.imports.size()) {
                String string3 = (String)this.imports.elementAt(n);
                if (string3.equals(string)) {
                    return;
                }
                if (string3.compareTo(string) > 0) {
                    this.imports.insertElementAt(string, n);
                    return;
                }
                ++n;
            }
            this.imports.addElement(string);
        }
    }

    public void addInterface(String string) {
        if (!this.interfaces.contains(string)) {
            this.interfaces.addElement(string);
        }
    }

    public void addInterface(JInterface jInterface) {
        if (jInterface == null) {
            return;
        }
        String string = jInterface.getName();
        if (!this.interfaces.contains(string)) {
            this.interfaces.addElement(string);
        }
    }

    public abstract JField getField(String var1);

    public abstract JField[] getFields();

    public String getFilename(String string) {
        File file;
        String string2 = this.getLocalName() + ".java";
        String string3 = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            string3 = this.packageName.replace('.', File.separatorChar);
        }
        if (!(file = string == null ? new File(string3) : new File(string, string3)).exists()) {
            file.mkdirs();
        }
        if (file.toString().length() > 0) {
            string2 = file.toString() + File.separator + string2;
        }
        return string2;
    }

    public JComment getHeader() {
        return this.header;
    }

    public Enumeration getImports() {
        return this.imports.elements();
    }

    public Enumeration getInterfaces() {
        return this.interfaces.elements();
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName(boolean bl) {
        int n;
        String string = super.getName();
        if (bl && (n = string.lastIndexOf(".")) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public boolean hasImport(String string) {
        return this.imports.contains(string);
    }

    public boolean removeImport(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        if (string.length() == 0) {
            return bl;
        }
        bl = this.imports.removeElement(string);
        return bl;
    }

    public static boolean isValidClassName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return JNaming.isValidJavaIdentifier(string);
    }

    public void print() {
        this.print(null, null);
    }

    public void print(String string, String string2) {
        String string3 = this.getLocalName();
        String string4 = this.getFilename(string);
        File file = new File(string4);
        JSourceWriter jSourceWriter = null;
        try {
            jSourceWriter = new JSourceWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            System.out.println("unable to create class file: " + string4);
            return;
        }
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        jSourceWriter.setLineSeparator(string2);
        this.print(jSourceWriter);
        jSourceWriter.close();
    }

    public abstract void print(JSourceWriter var1);

    public void printHeader(JSourceWriter jSourceWriter) {
        if (jSourceWriter == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        JComment jComment = this.getHeader();
        if (jComment != null) {
            jComment.print(jSourceWriter);
        } else {
            jSourceWriter.writeln("/*");
            jSourceWriter.writeln(" * $Id$");
            jSourceWriter.writeln(" */");
        }
        jSourceWriter.writeln();
        jSourceWriter.flush();
    }

    public void printImportDeclarations(JSourceWriter jSourceWriter) {
        if (jSourceWriter == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        if (this.imports.size() > 0) {
            jSourceWriter.writeln("  //---------------------------------/");
            jSourceWriter.writeln(" //- Imported classes and packages -/");
            jSourceWriter.writeln("//---------------------------------/");
            jSourceWriter.writeln();
            Enumeration enumeration = this.imports.elements();
            while (enumeration.hasMoreElements()) {
                jSourceWriter.write("import ");
                jSourceWriter.write(enumeration.nextElement());
                jSourceWriter.writeln(';');
            }
            jSourceWriter.writeln();
            jSourceWriter.flush();
        }
    }

    public void printPackageDeclaration(JSourceWriter jSourceWriter) {
        if (jSourceWriter == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        if (this.packageName != null && this.packageName.length() > 0) {
            jSourceWriter.write("package ");
            jSourceWriter.write(this.packageName);
            jSourceWriter.writeln(';');
            jSourceWriter.writeln();
        }
        jSourceWriter.flush();
    }

    public void setHeader(JComment jComment) {
        this.header = jComment;
    }

    public void setPackageName(String string) {
        this.packageName = string;
        this.changePackage(string);
    }

    protected int getInterfaceCount() {
        return this.interfaces.size();
    }

    protected static void printlnWithPrefix(String string, String string2, JSourceWriter jSourceWriter) {
        jSourceWriter.write(string);
        if (string2 == null) {
            return;
        }
        char[] cArray = string2.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c == '\n') {
                jSourceWriter.write(cArray, n, n2 - n + 1);
                n = n2 + 1;
                if (n2 < cArray.length) {
                    jSourceWriter.write(string);
                }
            }
            ++n2;
        }
        if (n < cArray.length) {
            jSourceWriter.write(cArray, n, cArray.length - n);
        }
        jSourceWriter.writeln();
    }

    protected static String getPackageFromClassName(String string) {
        int n = -1;
        n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }
}

