/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import net.jalbum.filters.BlurFilterPlugin;
import net.jalbum.filters.FilterControl;
import net.jalbum.filters.components.ExtendedSlider;
import se.datadosen.jalbum.Msg;

public class BlurControl
extends FilterControl {
    private static final long serialVersionUID = -7969686269619548580L;
    protected BlurFilterPlugin blurFilterPlugin;
    protected ExtendedSlider strengthSlider;
    protected JLabel textStrength;

    public BlurControl() {
    }

    public BlurControl(BlurFilterPlugin blurFilterPlugin) {
        this.init(blurFilterPlugin);
        this.addBlurControls();
    }

    protected void addBlurControls() {
        this.textStrength = new JLabel(Msg.getString((Object)this, (String)"filters.blur.strength"));
        this.strengthSlider = new ExtendedSlider(0, 0, 100, this.blurFilterPlugin.getStrength());
        this.strengthSlider.getSlider().setMajorTickSpacing(25);
        this.strengthSlider.getSlider().setMinorTickSpacing(5);
        this.strengthSlider.getSlider().setSnapToTicks(false);
        this.strengthSlider.getSlider().setPaintLabels(false);
        this.strengthSlider.setSliderWidth(132);
        this.strengthSlider.removeResetButton();
        this.strengthSlider.addActionListener(this);
        this.add(this.textStrength);
        this.add("br", this.strengthSlider);
    }

    protected void init(BlurFilterPlugin blurFilterPlugin) {
        this.blurFilterPlugin = blurFilterPlugin;
        super.init(blurFilterPlugin);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.strengthSlider && this.strengthSlider.getValue() != this.blurFilterPlugin.getStrength()) {
            this.blurFilterPlugin.adjustStrength(this.strengthSlider.getValue());
        }
    }
}

