/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;
import net.jalbum.filters.MultipleResizableObjectControl;
import net.jalbum.filters.ResizableObject;
import net.jalbum.filters.ResizableObjectPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleResizableObjectPanel
extends ResizableObjectPanel {
    private static final long serialVersionUID = -7820278572564980535L;
    protected MultipleResizableObjectControl multipleResizableObjectControl;
    protected String namePrefix = "Resizable Object ";
    protected int counter = 0;
    protected boolean outlineSelected = true;
    protected boolean paintOnlySelected = false;
    protected boolean applyFilter = false;
    protected boolean emptyClickCreatesNewObject = false;
    protected Vector<ResizableObject> objectVector;
    protected ResizableObject hoveredOverObject;

    public MultipleResizableObjectPanel() {
        this.name = "MultipleResizableObjectPanel";
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = "This is just for inheriting for other filters. This is not applieable.";
        this.prescale = false;
        this.postscale = false;
        this.multipleResizableObjectControl = new MultipleResizableObjectControl(this);
        this.objectVector = new Vector();
        this.resizableObject.setName(this.namePrefix + this.counter);
        ++this.counter;
        this.hoveredOverObject = this.resizableObject;
        this.applyFilter = true;
    }

    @Override
    public JPanel getControls() {
        return this.multipleResizableObjectControl;
    }

    public void addObject() {
        if (!this.resizableObject.isInitial()) {
            this.resizableObject.setState(10);
            this.resizableObject = new ResizableObject(this.width, this.height);
            this.resizableObject.setParentPanel(this);
            this.objectVector.add(0, this.resizableObject);
            this.resizableObject.setName(this.namePrefix + this.counter);
            this.multipleResizableObjectControl.adjustResizableObject(this.resizableObject);
            ++this.counter;
        }
    }

    public boolean selectObject(String name) {
        for (int i = 0; i < this.objectVector.size(); ++i) {
            if (!this.objectVector.get(i).getName().equals(name)) continue;
            this.resizableObject.setState(10);
            this.resizableObject = this.objectVector.get(i);
            this.multipleResizableObjectControl.adjustResizableObject(this.resizableObject);
            return true;
        }
        return false;
    }

    public boolean selectObject(int index) {
        if (index < 0 || index >= this.objectVector.size()) {
            return false;
        }
        this.resizableObject.setState(10);
        this.resizableObject = this.objectVector.get(index);
        this.multipleResizableObjectControl.adjustResizableObject(this.resizableObject);
        return true;
    }

    public boolean removeObject() {
        if (this.objectVector.size() > 1) {
            this.objectVector.remove(this.resizableObject);
            this.resizableObject = this.objectVector.get(0);
            this.multipleResizableObjectControl.adjustResizableObject(this.resizableObject);
            this.renderPreview();
            return true;
        }
        return false;
    }

    public boolean removeObject(int index) {
        if (index < 0 || index >= this.objectVector.size() || this.objectVector.size() > 1) {
            return false;
        }
        ResizableObject removedObject = this.objectVector.get(index);
        this.objectVector.remove(index);
        if (removedObject == this.resizableObject) {
            this.resizableObject = this.objectVector.get(0);
            this.multipleResizableObjectControl.adjustResizableObject(this.resizableObject);
        }
        this.renderPreview();
        return true;
    }

    public boolean removeObject(String name) {
        if (this.objectVector.size() > 1) {
            for (int i = 0; i < this.objectVector.size(); ++i) {
                if (!this.objectVector.get(i).getName().equals(name)) continue;
                ResizableObject removedObject = this.objectVector.get(i);
                this.objectVector.remove(i);
                if (removedObject == this.resizableObject) {
                    this.resizableObject = this.objectVector.get(0);
                    this.multipleResizableObjectControl.adjustResizableObject(this.resizableObject);
                }
                this.renderPreview();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.showOutline) {
            if (this.paintOnlySelected) {
                this.resizableObject.paint(g);
            } else {
                for (int i = 0; i < this.objectVector.size(); ++i) {
                    this.objectVector.get(i).paint(g);
                }
                if (this.outlineSelected && !this.resizableObject.isInitial()) {
                    this.paintOutline(g);
                }
            }
        }
    }

    protected void paintOutline(Graphics g) {
        g.setColor(Color.YELLOW);
        g.drawRect((int)(this.resizableObject.getOutX1() * (double)(this.width - 1)), (int)(this.resizableObject.getOutY1() * (double)(this.height - 1)), (int)(this.resizableObject.getObjectWidth() * (double)(this.width - 1)), (int)(this.resizableObject.getObjectHeight() * (double)(this.height - 1)));
    }

    public BufferedImage renderPreview(BufferedImage bi) {
        BufferedImage out = bi;
        if (this.applyFilter) {
            out = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
            out.setData(bi.getData());
            for (int i = 0; i < this.objectVector.size(); ++i) {
                out = this.renderObject(this.objectVector.get(i), out);
            }
        }
        return out;
    }

    protected BufferedImage renderObject(ResizableObject object, BufferedImage bi) {
        return bi;
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 155) {
            this.addObject();
            this.multipleResizableObjectControl.checkButtons();
            this.renderPreview();
        } else if (arg0.getKeyCode() == 127) {
            this.removeObject();
            this.multipleResizableObjectControl.checkButtons();
            this.renderPreview();
        } else if (arg0.getKeyCode() == 34) {
            this.previousObject();
        } else if (arg0.getKeyCode() == 33) {
            this.nextObject();
        } else if (arg0.getKeyCode() == 18 || arg0.getKeyCode() == 17) {
            for (int i = 0; i < this.objectVector.size(); ++i) {
                this.objectVector.get(i).keyPressed(arg0);
            }
        } else if (this.resizableObject != null) {
            this.resizableObject.keyPressed(arg0);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() == 18 || arg0.getKeyCode() == 17) {
            for (int i = 0; i < this.objectVector.size(); ++i) {
                this.objectVector.get(i).keyReleased(arg0);
            }
        } else if (this.resizableObject != null) {
            this.resizableObject.keyReleased(arg0);
        }
    }

    public void previousObject() {
        this.selectObject((this.objectVector.indexOf(this.resizableObject) + 1) % this.objectVector.size());
        this.renderPreview();
    }

    public void nextObject() {
        this.selectObject((this.objectVector.indexOf(this.resizableObject) + this.objectVector.size() - 1) % this.objectVector.size());
        this.renderPreview();
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        if (this.resizableObject != null) {
            if (this.resizableObject.isInitial() || (double)x >= this.resizableObject.getOutX1() * (double)(this.width - 1) - 5.0 && (double)x <= this.resizableObject.getOutX2() * (double)(this.width - 1) + 5.0 && (double)y >= this.resizableObject.getOutY1() * (double)(this.height - 1) - 5.0 && (double)y <= this.resizableObject.getOutY2() * (double)(this.height - 1) + 5.0) {
                this.hoveredOverObject.setState(10);
                this.hoveredOverObject = this.resizableObject;
                this.resizableObject.mouseMoved(event);
            } else {
                for (int i = 0; i < this.objectVector.size(); ++i) {
                    if (!((double)x >= this.objectVector.get(i).getOutX1() * (double)(this.width - 1) - 5.0) || !((double)x <= this.objectVector.get(i).getOutX2() * (double)(this.width - 1) + 5.0) || !((double)y >= this.objectVector.get(i).getOutY1() * (double)(this.height - 1) - 5.0) || !((double)y <= this.objectVector.get(i).getOutY2() * (double)(this.height - 1) + 5.0)) continue;
                    this.hoveredOverObject.setState(10);
                    this.hoveredOverObject = this.objectVector.get(i);
                    this.hoveredOverObject.mouseMoved(event);
                    return;
                }
                this.hoveredOverObject.setState(10);
                this.hoveredOverObject = this.resizableObject;
                this.resizableObject.mouseMoved(event);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        if (this.resizableObject != null) {
            if (this.resizableObject.isInitial() || (double)x >= this.resizableObject.getOutX1() * (double)(this.width - 1) - 5.0 && (double)x <= this.resizableObject.getOutX2() * (double)(this.width - 1) + 5.0 && (double)y >= this.resizableObject.getOutY1() * (double)(this.height - 1) - 5.0 && (double)y <= this.resizableObject.getOutY2() * (double)(this.height - 1) + 5.0) {
                this.resizableObject.mousePressed(event);
            } else {
                for (int i = 0; i < this.objectVector.size(); ++i) {
                    if (!((double)x >= this.objectVector.get(i).getOutX1() * (double)(this.width - 1) - 5.0) || !((double)x <= this.objectVector.get(i).getOutX2() * (double)(this.width - 1) + 5.0) || !((double)y >= this.objectVector.get(i).getOutY1() * (double)(this.height - 1) - 5.0) || !((double)y <= this.objectVector.get(i).getOutY2() * (double)(this.height - 1) + 5.0)) continue;
                    this.selectObject(i);
                    this.resizableObject.mousePressed(event);
                    return;
                }
                if (this.emptyClickCreatesNewObject) {
                    this.addObject();
                    this.mousePressed(event);
                    this.multipleResizableObjectControl.checkButtons();
                    this.renderPreview();
                } else {
                    this.resizableObject.mousePressed(event);
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.resizableObject = null;
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.setCursor(new Cursor(0));
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public boolean isOutlineSelected() {
        return this.outlineSelected;
    }

    public void setOutlineSelected(boolean outlineSelected) {
        this.outlineSelected = outlineSelected;
    }

    public boolean isPaintOnlySelected() {
        return this.paintOnlySelected;
    }

    public void setPaintOnlySelected(boolean paintOnlySelected) {
        this.paintOnlySelected = paintOnlySelected;
    }

    public boolean isApplyFilter() {
        return this.applyFilter;
    }

    public void setApplyFilter(boolean applyFilter) {
        this.applyFilter = applyFilter;
    }

    public Vector<ResizableObject> getObjectVector() {
        return this.objectVector;
    }

    public void setObjectVector(Vector<ResizableObject> objectVector) {
        this.objectVector = objectVector;
    }

    public ResizableObject getHoveredOverObject() {
        return this.hoveredOverObject;
    }

    public void setHoveredOverObject(ResizableObject hoveredOverObject) {
        this.hoveredOverObject = hoveredOverObject;
    }
}

