/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import net.jalbum.filters.ResizableObjectPanel;

public class ResizableObject
implements MouseMotionListener,
MouseListener,
KeyListener,
Serializable {
    private static final long serialVersionUID = 5798630994588019554L;
    protected double X1;
    protected double Y1;
    protected double X2;
    protected double Y2;
    protected double OutX1;
    protected double OutX2;
    protected double OutY1;
    protected double OutY2;
    protected double OffsetX;
    protected double OffsetY;
    protected int width;
    protected int height;
    protected int state;
    protected int position;
    protected boolean initial = true;
    protected boolean repaintOnCursorChange = true;
    protected String name = "Resizable Object";
    public static final int MAKE = 0;
    public static final int MOVE = 1;
    public static final int RESIZE_NW = 2;
    public static final int RESIZE_NE = 3;
    public static final int RESIZE_SE = 4;
    public static final int RESIZE_SW = 5;
    public static final int RESIZE_N = 6;
    public static final int RESIZE_E = 7;
    public static final int RESIZE_S = 8;
    public static final int RESIZE_W = 9;
    public static final int NOTHING = 10;
    protected Color color = new Color(255, 255, 255, 127);
    protected ResizableObjectPanel parentPanel;
    protected int handlesize = 6;

    public ResizableObject() {
        this(100, 100);
    }

    public ResizableObject(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public ResizableObject(int width, int height, ResizableObjectPanel parentPanel) {
        this(width, height);
        this.parentPanel = parentPanel;
    }

    public void setParentPanel(ResizableObjectPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    public void paint(Graphics g) {
        if (!this.initial) {
            this.checkDimensions(false);
            g.setColor(this.color);
            g.drawRect((int)this.OutX1 * (this.width - 1), (int)this.OutY1 * (this.height - 1), (int)(this.OutX2 - this.OutX1) * (this.width - 1), (int)(this.OutY2 - this.OutY1) * (this.width - 1));
            this.paintHandles(g);
        }
    }

    protected void paintHandles(Graphics g) {
        if (this.position == 1 || this.position == 2 || this.position == 3 || this.position == 4 || this.position == 5 || this.position == 6 || this.position == 7 || this.position == 8 || this.position == 9) {
            int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
            int intX2 = (int)(this.OutX2 * (double)(this.width - 1));
            int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
            int intY2 = (int)(this.OutY2 * (double)(this.height - 1));
            g.setColor(Color.WHITE);
            g.fillRect(intX1 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX1 - this.handlesize / 2, intY2 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX2 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX2 - this.handlesize / 2, intY2 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.setColor(Color.BLACK);
            g.drawRect(intX1 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX1 - this.handlesize / 2, intY2 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX2 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX2 - this.handlesize / 2, intY2 - this.handlesize / 2, this.handlesize, this.handlesize);
        }
    }

    protected int checkState(int x, int y) {
        int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
        int intX2 = (int)(this.OutX2 * (double)(this.width - 1));
        int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
        int intY2 = (int)(this.OutY2 * (double)(this.height - 1));
        if (x > intX1 - 5 && x < intX1 + 5 && y > intY1 - 5 && y < intY1 + 5) {
            return 2;
        }
        if (x > intX2 - 5 && x < intX2 + 5 && y > intY1 - 5 && y < intY1 + 5) {
            return 3;
        }
        if (x > intX2 - 5 && x < intX2 + 5 && y > intY2 - 5 && y < intY2 + 5) {
            return 4;
        }
        if (x > intX1 - 5 && x < intX1 + 5 && y > intY2 - 5 && y < intY2 + 5) {
            return 5;
        }
        if (x > intX1 && x < intX2 && y > intY1 - 5 && y < intY1 + 5) {
            return 6;
        }
        if (x > intX2 - 5 && x < intX2 + 5 && y > intY1 && y < intY2) {
            return 7;
        }
        if (x > intX1 && x < intX2 && y > intY2 - 5 && y < intY2 + 5) {
            return 8;
        }
        if (x > intX1 - 5 && x < intX1 + 5 && y > intY1 && y < intY2) {
            return 9;
        }
        if (x > intX1 && x < intX2 && y > intY1 && y < intY2) {
            if (this.initial) {
                return 0;
            }
            return 1;
        }
        if (x <= this.width - 1 && y >= 0 && y <= this.height - 1) {
            return 0;
        }
        return 10;
    }

    protected void checkDimensions(boolean changeOriginal) {
        if (this.X1 > this.X2) {
            this.OutX2 = this.X1;
            this.OutX1 = this.X2;
        } else {
            this.OutX1 = this.X1;
            this.OutX2 = this.X2;
        }
        if (this.Y1 > this.Y2) {
            this.OutY2 = this.Y1;
            this.OutY1 = this.Y2;
        } else {
            this.OutY1 = this.Y1;
            this.OutY2 = this.Y2;
        }
        if (this.OutX1 < 0.0) {
            this.OutX1 = 0.0;
        }
        if (this.OutX1 > 1.0) {
            this.OutX1 = 1.0;
        }
        if (this.OutX2 < 0.0) {
            this.OutX2 = 0.0;
        }
        if (this.OutX2 > 1.0) {
            this.OutX2 = 1.0;
        }
        if (this.OutY1 < 0.0) {
            this.OutY1 = 0.0;
        }
        if (this.OutY2 < 0.0) {
            this.OutY2 = 0.0;
        }
        if (this.OutY1 > 1.0) {
            this.OutY1 = 1.0;
        }
        if (this.OutY2 > 1.0) {
            this.OutY2 = 1.0;
        }
        if (changeOriginal) {
            this.X1 = this.OutX1;
            this.X2 = this.OutX2;
            this.Y1 = this.OutY1;
            this.Y2 = this.OutY2;
        }
    }

    protected void changeMousePosition(MouseEvent arg0) {
        int inputX = arg0.getX();
        int inputY = arg0.getY();
        if (this.state == 1) {
            this.X1 = this.X1 - this.OffsetX + (double)inputX / (double)(this.width - 1);
            this.X2 = this.X2 - this.OffsetX + (double)inputX / (double)(this.width - 1);
            this.OffsetX = (double)inputX / (double)(this.width - 1);
            this.Y1 = this.Y1 - this.OffsetY + (double)inputY / (double)(this.height - 1);
            this.Y2 = this.Y2 - this.OffsetY + (double)inputY / (double)(this.height - 1);
            this.OffsetY = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 0) {
            this.X2 = (double)inputX / (double)(this.width - 1);
            this.Y2 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 2) {
            this.X1 = (double)inputX / (double)(this.width - 1);
            this.Y1 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 3) {
            this.X2 = (double)inputX / (double)(this.width - 1);
            this.Y1 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 4) {
            this.X2 = (double)inputX / (double)(this.width - 1);
            this.Y2 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 5) {
            this.X1 = (double)inputX / (double)(this.width - 1);
            this.Y2 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 6) {
            this.Y1 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 7) {
            this.X2 = (double)inputX / (double)(this.width - 1);
        } else if (this.state == 8) {
            this.Y2 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 9) {
            this.X1 = (double)inputX / (double)(this.width - 1);
        }
    }

    protected void setMouseCursor(MouseEvent arg0) {
        this.position = this.checkState(arg0.getX(), arg0.getY());
        Cursor old = this.parentPanel.getCursor();
        if (this.position == 0) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(1));
        } else if (this.position == 1) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(13));
        } else if (this.position == 2) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(6));
        } else if (this.position == 3) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(7));
        } else if (this.position == 4) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(5));
        } else if (this.position == 5) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(4));
        } else if (this.position == 6) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.position == 7) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.position == 8) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.position == 9) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(10));
        } else {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (old != this.parentPanel.getCursor()) {
            this.parentPanel.renderPreview();
        }
    }

    public void updateParent() {
        this.parentPanel.updateController(this.OutX1, this.OutY1, this.OutX2, this.OutY2);
    }

    public void update(double x1, double y1, double x2, double y2) {
        this.X1 = x1;
        this.Y1 = y1;
        this.X2 = x2;
        this.Y2 = y2;
        this.checkDimensions(true);
    }

    public void mousePressed(MouseEvent arg0) {
        int inputX = arg0.getX();
        int inputY = arg0.getY();
        this.state = this.checkState(inputX, inputY);
        if (this.state == 1) {
            this.OffsetX = (double)inputX / (double)(this.width - 1);
            this.OffsetY = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 0) {
            this.X1 = (double)inputX / (double)(this.width - 1);
            this.Y1 = (double)inputY / (double)(this.height - 1);
            this.X2 = (double)inputX / (double)(this.width - 1);
            this.Y2 = (double)inputY / (double)(this.height - 1);
        }
        this.initial = false;
        this.changeMousePosition(arg0);
        this.checkDimensions(true);
        this.updateParent();
    }

    public void mouseDragged(MouseEvent arg0) {
        this.changeMousePosition(arg0);
        this.checkDimensions(false);
        this.updateParent();
    }

    public void mouseReleased(MouseEvent arg0) {
        this.changeMousePosition(arg0);
        this.checkDimensions(true);
        this.state = 10;
        this.updateParent();
    }

    public void mouseMoved(MouseEvent arg0) {
        this.setMouseCursor(arg0);
    }

    public void mouseEntered(MouseEvent arg0) {
        this.setMouseCursor(arg0);
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
        this.parentPanel.setCursor(Cursor.getPredefinedCursor(0));
    }

    public double getObjectWidth() {
        return this.OutX2 - this.OutX1;
    }

    public double getObjectHeight() {
        return this.OutY2 - this.OutY1;
    }

    public void keyPressed(KeyEvent arg0) {
        if ((arg0.getKeyCode() == 226 || arg0.getKeyCode() == 37) && this.X1 > 0.0) {
            this.X1 -= 1.0 / (double)(this.width - 1);
            this.X2 -= 1.0 / (double)(this.width - 1);
        }
        if ((arg0.getKeyCode() == 224 || arg0.getKeyCode() == 38) && this.Y1 > 0.0) {
            this.Y1 -= 1.0 / (double)(this.height - 1);
            this.Y2 -= 1.0 / (double)(this.height - 1);
        }
        if ((arg0.getKeyCode() == 227 || arg0.getKeyCode() == 39) && this.X2 < 1.0) {
            this.X1 += 1.0 / (double)(this.width - 1);
            this.X2 += 1.0 / (double)(this.width - 1);
        }
        if ((arg0.getKeyCode() == 225 || arg0.getKeyCode() == 40) && this.Y2 < 1.0) {
            this.Y1 += 1.0 / (double)(this.height - 1);
            this.Y2 += 1.0 / (double)(this.height - 1);
        }
        this.checkDimensions(true);
        this.updateParent();
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public double getX1() {
        return this.X1;
    }

    public void setX1(double x1) {
        this.X1 = x1;
    }

    public double getY1() {
        return this.Y1;
    }

    public void setY1(double y1) {
        this.Y1 = y1;
    }

    public double getX2() {
        return this.X2;
    }

    public void setX2(double x2) {
        this.X2 = x2;
    }

    public double getY2() {
        return this.Y2;
    }

    public void setY2(double y2) {
        this.Y2 = y2;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getOutX1() {
        return this.OutX1;
    }

    public double getOutX2() {
        return this.OutX2;
    }

    public double getOutY1() {
        return this.OutY1;
    }

    public double getOutY2() {
        return this.OutY2;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        this.position = state;
    }

    public double getOffsetX() {
        return this.OffsetX;
    }

    public void setOffsetX(double offsetX) {
        this.OffsetX = offsetX;
    }

    public double getOffsetY() {
        return this.OffsetY;
    }

    public void setOffsetY(double offsetY) {
        this.OffsetY = offsetY;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isRepaintOnCursorChange() {
        return this.repaintOnCursorChange;
    }

    public void setRepaintOnCursorChange(boolean repaintOnCursorChange) {
        this.repaintOnCursorChange = repaintOnCursorChange;
    }

    public int getHandlesize() {
        return this.handlesize;
    }

    public void setHandlesize(int handlesize) {
        this.handlesize = handlesize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResizableObjectPanel getParentPanel() {
        return this.parentPanel;
    }

    public void setOutX1(double outX1) {
        this.OutX1 = outX1;
    }

    public void setOutX2(double outX2) {
        this.OutX2 = outX2;
    }

    public void setOutY1(double outY1) {
        this.OutY1 = outY1;
    }

    public void setOutY2(double outY2) {
        this.OutY2 = outY2;
    }
}

