/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.datadosen.component.RiverLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedSlider
extends JPanel
implements ActionListener,
ChangeListener,
FocusListener {
    private static final long serialVersionUID = -5260376230055299702L;
    protected JSlider slider;
    protected JTextField textfield;
    protected JButton reset;
    protected int max;
    protected int min;
    protected int value;
    protected int initialValue;
    protected int orientation = 0;
    protected String textReset = "Reset";
    protected boolean showReset = true;
    protected Vector<ActionListener> actionListeners;

    public ExtendedSlider() {
    }

    public ExtendedSlider(int orientation) {
        this(0, 0, 100, 0);
    }

    public ExtendedSlider(int min, int max) {
        this(0, min, max, (min + max) / 2);
    }

    public ExtendedSlider(int min, int max, int value) {
        this(0, min, max, value);
    }

    public ExtendedSlider(int orientation, int min, int max, int value) {
        this.min = min;
        this.max = max;
        this.value = value;
        this.initialValue = value;
        this.actionListeners = new Vector();
        this.slider = new JSlider(min, max, value);
        if (orientation == 1) {
            this.orientation = 1;
            this.slider.setOrientation(orientation);
        } else {
            this.orientation = 0;
            this.slider.setOrientation(orientation);
        }
        this.textfield = new JTextField(3);
        this.textfield.setText(Integer.toString(this.slider.getValue()));
        this.reset = new JButton(this.textReset);
        this.slider.addChangeListener(this);
        this.textfield.addActionListener(this);
        this.textfield.addFocusListener(this);
        this.reset.addActionListener(this);
        this.slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing((max - min) / 4);
        this.slider.setMinorTickSpacing((max - min) / 8);
        this.slider.setPaintLabels(true);
        this.setLayout((LayoutManager)new RiverLayout(0, 0));
        this.add(this.slider);
        if (orientation == 1) {
            this.add("br", this.textfield);
            if (this.showReset) {
                this.add("br", this.reset);
            }
        } else {
            this.add("", this.textfield);
            if (this.showReset) {
                this.add(this.reset);
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (Component c : this.getComponents()) {
            c.setEnabled(b);
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.actionListeners.toArray();
    }

    public void postActionEvent() {
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            this.actionListeners.get(i).actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public JTextField getTextField() {
        return this.textfield;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setResetText(String resetText) {
        this.textReset = resetText;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.textfield) {
            this.readTextfieldValue();
        } else if (e.getSource() == this.reset) {
            this.reset();
            this.postActionEvent();
        }
    }

    private void readTextfieldValue() {
        try {
            int value = Integer.parseInt(this.textfield.getText());
            if (value < this.min) {
                value = this.min;
            } else if (value > this.max) {
                value = this.max;
            }
            this.value = value;
            this.textfield.setText(Integer.toString(this.value));
            this.slider.setValue(this.value);
        }
        catch (Exception ex) {
            this.textfield.setText(Integer.toString(this.slider.getValue()));
        }
    }

    public void reset() {
        this.textfield.setText(Integer.toString(this.initialValue));
        this.slider.setValue(this.initialValue);
    }

    public void removeResetButton() {
        this.remove(this.reset);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource() == this.slider) {
            this.value = this.slider.getValue();
            this.textfield.setText(Integer.toString(this.value));
            this.postActionEvent();
        }
    }

    public void setShowReset(boolean showReset) {
        this.showReset = showReset;
    }

    public JTextField getTextfield() {
        return this.textfield;
    }

    public void setTextfield(JTextField textfield) {
        this.textfield = textfield;
    }

    public JButton getReset() {
        return this.reset;
    }

    public void setReset(JButton reset) {
        this.reset = reset;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public String getTextReset() {
        return this.textReset;
    }

    public void setTextReset(String textReset) {
        this.textReset = textReset;
    }

    public boolean isShowReset() {
        return this.showReset;
    }

    public void setSlider(JSlider slider) {
        this.slider = slider;
    }

    public void setActionListeners(Vector<ActionListener> actionListeners) {
        this.actionListeners = actionListeners;
    }

    public void setSliderWidth(int width) {
        this.slider.setPreferredSize(new Dimension(width, this.slider.getPreferredSize().height));
    }

    public void setSliderHeight(int height) {
        this.slider.setPreferredSize(new Dimension(this.slider.getPreferredSize().width, height));
    }

    public int getSliderWidth() {
        return this.slider.getPreferredSize().width;
    }

    public int getSliderHeight() {
        return this.slider.getPreferredSize().height;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.textfield) {
            this.readTextfieldValue();
        }
    }
}

