/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import se.datadosen.component.WordList;

public class Autocompleter
implements DocumentListener {
    private final JTextComponent comp;
    private WordList wordList;
    private static final String COMMIT_ACTION = "commit";
    private Mode mode = Mode.INSERT;
    private Action defaultCommit;
    private Action newCommitAction = new CommitAction();
    private String postfix = ", ";
    private int threshold = 1;
    private String separatorChars = ",;+";

    public Autocompleter(JTextComponent comp, WordList wordList) {
        if (comp == null) {
            throw new IllegalArgumentException("comp is null");
        }
        if (wordList == null) {
            throw new IllegalArgumentException("wordList is null");
        }
        this.comp = comp;
        this.wordList = wordList;
        this.init();
    }

    private void init() {
        this.comp.getDocument().addDocumentListener(this);
        InputMap im = this.comp.getInputMap();
        ActionMap am = this.comp.getActionMap();
        Object acceptKey = im.get(KeyStroke.getKeyStroke("ENTER"));
        this.defaultCommit = am.get(acceptKey);
        im.put(KeyStroke.getKeyStroke("ENTER"), COMMIT_ACTION);
        am.put(COMMIT_ACTION, this.defaultCommit);
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public String getSeparatorChars() {
        return this.separatorChars;
    }

    public void setSeparatorChars(String separatorChars) {
        this.separatorChars = separatorChars;
    }

    public WordList getWordList() {
        return this.wordList;
    }

    public void setWordList(WordList wordList) {
        this.wordList = wordList;
    }

    public void changedUpdate(DocumentEvent ev) {
    }

    public void removeUpdate(DocumentEvent ev) {
    }

    public void insertUpdate(DocumentEvent ev) {
        char c;
        int w;
        if (ev.getLength() != 1) {
            return;
        }
        int pos = ev.getOffset();
        String content = null;
        try {
            content = this.comp.getText(0, pos + 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        for (w = pos; w >= 0 && this.separatorChars.indexOf(c = content.charAt(w)) == -1; --w) {
        }
        ++w;
        while (w < pos && Character.isWhitespace(c = content.charAt(w))) {
            ++w;
        }
        if (pos - --w < this.threshold) {
            return;
        }
        String prefix = content.substring(w + 1).toLowerCase();
        List<String> words = this.wordList.getList();
        int n = Collections.binarySearch(words, prefix);
        if (n < 0 && -n <= words.size()) {
            String match = words.get(-n - 1);
            if (match.startsWith(prefix)) {
                String completion = this.wordList.get(match).substring(pos - w);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1));
            }
        } else {
            this.mode = Mode.INSERT;
        }
    }

    private class CommitAction
    extends AbstractAction {
        private CommitAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            if (Autocompleter.this.mode == Mode.COMPLETION) {
                try {
                    int pos = Autocompleter.this.comp.getSelectionEnd();
                    Autocompleter.this.comp.getDocument().insertString(pos, Autocompleter.this.postfix, null);
                    Autocompleter.this.comp.setCaretPosition(pos + Autocompleter.this.postfix.length());
                    Autocompleter.this.mode = Mode.INSERT;
                    Autocompleter.this.comp.getActionMap().put(Autocompleter.COMMIT_ACTION, Autocompleter.this.defaultCommit);
                }
                catch (BadLocationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private class CompletionTask
    implements Runnable {
        String completion;
        int position;

        CompletionTask(String completion, int position) {
            this.completion = completion;
            this.position = position;
        }

        public void run() {
            try {
                Autocompleter.this.comp.getDocument().insertString(this.position, this.completion, null);
                Autocompleter.this.comp.setCaretPosition(this.position + this.completion.length());
                Autocompleter.this.comp.moveCaretPosition(this.position);
                Autocompleter.this.mode = Mode.COMPLETION;
                Autocompleter.this.comp.getActionMap().put(Autocompleter.COMMIT_ACTION, Autocompleter.this.newCommitAction);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        INSERT,
        COMPLETION;

    }
}

