/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JBackgroundPanel
extends JPanel {
    protected Image bg;
    protected Border imageBorder;
    private int ix;
    private int iy;

    public int getImageTopCornerXCoordinate() {
        return this.ix;
    }

    public int getImageTopCornerYCoordinate() {
        return this.iy;
    }

    public void setBackgroundImage(Image bg) {
        this.bg = bg;
        this.repaint();
    }

    public Image getBackgroundImage() {
        return this.bg;
    }

    public Dimension getDisplayableImageSize() {
        Dimension size = (Dimension)this.getSize().clone();
        return size;
    }

    public void setImageBorder(Border border) {
        this.imageBorder = border;
    }

    protected void paintComponent(Graphics g2d) {
        super.paintComponent(g2d);
        Graphics2D g = (Graphics2D)g2d;
        if (this.bg != null) {
            int iw = this.bg.getWidth(null);
            int ih = this.bg.getHeight(null);
            int cw = this.getWidth();
            int ch = this.getHeight();
            Insets in = this.getInsets();
            Insets in2 = new Insets(0, 0, 0, 0);
            if (this.imageBorder != null) {
                in2 = this.imageBorder.getBorderInsets(this);
            }
            int boundingWidth = cw - in.left - in2.left - in.right - in2.right;
            int boundingHeight = ch - in.top - in2.top - in.bottom - in2.bottom;
            Dimension scaledDim = JBackgroundPanel.calcDimension(iw, ih, new Dimension(boundingWidth, boundingHeight));
            iw = scaledDim.width;
            ih = scaledDim.height;
            this.ix = (cw - iw) / 2;
            this.iy = (ch - ih) / 2;
            g.drawImage(this.bg, this.ix, this.iy, iw, ih, null);
            if (this.imageBorder != null) {
                this.imageBorder.paintBorder(this, g, this.ix - in2.left, this.iy - in2.top, iw + in2.left + in2.right, ih + in2.top + in2.bottom);
            }
        }
    }

    private static Dimension calcDimension(int width, int height, Dimension boundingBox) {
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return new Dimension(width, height);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)width / maxScale + 0.5), (int)((double)height / maxScale + 0.5));
    }
}

