/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import se.datadosen.component.DropDownIcon;
import se.datadosen.component.MarginIcon;

public class JPopupButton
extends JButton {
    private JPopupMenu popup;
    private Icon dropDownIcon;
    private boolean popupVisible;
    private boolean arrowPressed;
    private Action defaultAction;
    private PropertyChangeListener listener;
    private static Color faintColor = new Color(SystemColor.textInactiveText.getRed(), SystemColor.textInactiveText.getGreen(), SystemColor.textInactiveText.getBlue());

    public JPopupButton() {
        this.initialize();
    }

    public JPopupButton(Icon icon) {
        super(icon);
        this.initialize();
    }

    public JPopupButton(String text) {
        super(text);
        this.initialize();
    }

    public JPopupButton(Action a) {
        super((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        this.setAction(a);
        this.initialize();
    }

    public JPopupButton(String text, Icon icon) {
        super(text, icon);
        this.initialize();
    }

    public void setAction(Action a) {
        if (this.defaultAction != null) {
            this.defaultAction.removePropertyChangeListener(this.listener);
        }
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("enabled")) {
                    boolean enabled = (Boolean)evt.getNewValue();
                    JPopupButton.this.setEnabled(enabled);
                } else if (evt.getPropertyName().equals("Name")) {
                    JPopupButton.this.setText((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("Icon")) {
                    JPopupButton.this.setIcon((Icon)evt.getNewValue());
                } else if (evt.getPropertyName().equals("ShortDescription")) {
                    JPopupButton.this.setToolTipText((String)evt.getNewValue());
                }
            }
        };
        this.defaultAction = a;
        this.defaultAction.addPropertyChangeListener(this.listener);
        this.setEnabled(this.defaultAction.isEnabled());
        if (a.getValue("Name") != null) {
            this.setText((String)a.getValue("Name"));
        }
        if (a.getValue("SmallIcon") != null) {
            this.setIcon((Icon)a.getValue("SmallIcon"));
        }
        if (a.getValue("ShortDescription") != null) {
            this.setToolTipText((String)a.getValue("ShortDescription"));
        }
    }

    public Action getAction() {
        return this.defaultAction;
    }

    public void setIcon(Icon i) {
        super.setIcon(i);
        this.validate();
    }

    private void initialize() {
        this.popup = new JPopupMenu();
        this.popupVisible = false;
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JPopupButton.this.setPopupVisible(true);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JPopupButton.this.setPopupVisible(false);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                JPopupButton.this.setPopupVisible(false);
            }
        });
        this.addMouseListener(new MouseHandler());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPopupButton.this.isArrowPressed() || JPopupButton.this.defaultAction == null) {
                    JPopupButton.this.togglePopupVisible();
                } else {
                    JPopupButton.this.defaultAction.actionPerformed(e);
                    JPopupButton.this.setSelected(false);
                }
            }
        });
    }

    public boolean isPopupVisible() {
        return this.popupVisible;
    }

    public void setPopupVisible(boolean popupVisible) {
        this.popupVisible = popupVisible;
        this.setSelected(popupVisible);
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public void setPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public Icon getDropDownIcon() {
        if (this.dropDownIcon == null) {
            this.setDropDownIcon(new MarginIcon(new Insets(4, 6, 4, 9), new DropDownIcon()));
        }
        return this.dropDownIcon;
    }

    public void setDropDownIcon(Icon dropDownIcon) {
        this.dropDownIcon = dropDownIcon;
    }

    public boolean isArrowPressed() {
        return this.arrowPressed;
    }

    public void setArrowPressed(boolean arrowPressed) {
        this.arrowPressed = arrowPressed;
    }

    public Component add(Component c) {
        return this.popup.add(c);
    }

    public JMenuItem add(Action a) {
        return this.popup.add(a);
    }

    public void togglePopupVisible() {
        if (this.popup.isShowing()) {
            this.popup.setVisible(false);
        } else {
            this.popup.show(this, this.getWidth() - this.dropDownIcon.getIconWidth(), this.getHeight());
        }
    }

    public void setMargin(Insets m) {
        Icon ico = this.getDropDownIcon();
        m = new Insets(m.top, m.left, m.bottom, m.right + ico.getIconWidth());
        super.setMargin(m);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Icon ico = this.getDropDownIcon();
        ico.paintIcon(this, g, width - ico.getIconWidth(), height / 2 - ico.getIconHeight() / 2);
        g.setColor(faintColor);
        int x = width - ico.getIconWidth() - 1;
        g.drawLine(x, (height - ico.getIconHeight()) / 2, x, (height + ico.getIconHeight()) / 2);
    }

    public boolean isAboveArrow(Point p) {
        return this.getWidth() - this.getDropDownIcon().getIconWidth() < p.x;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            JPopupButton.this.setArrowPressed(JPopupButton.this.isAboveArrow(e.getPoint()));
        }
    }
}

