/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapClip
implements Transferable {
    public static DataFlavor mapFlavor = new DataFlavor(MapClip.class, "Map flavor");
    private Vector<Map.Entry> clip;
    private static final DataFlavor[] flavors = new DataFlavor[]{mapFlavor, DataFlavor.stringFlavor};

    public MapClip(Vector<Map.Entry> clip) {
        this.clip = clip;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor df : flavors) {
            if (!flavor.equals(df)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(mapFlavor)) {
            return this.clip;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry e : this.clip) {
                sb.append(e.getKey().toString());
                sb.append('=');
                sb.append(e.getValue().toString());
                sb.append('\n');
            }
            return sb.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

