/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Cursor;
import java.awt.Window;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WaitCursor {
    private Window parent;
    private long delay = 200L;
    private int nWorkers = 0;
    private ScheduledExecutorService delayedService = Executors.newScheduledThreadPool(1);
    private ScheduledFuture pendingWaitCursor;

    public WaitCursor(Window parent) {
        this.parent = parent;
    }

    public WaitCursor(Window parent, long delay) {
        this.parent = parent;
        this.delay = delay;
    }

    public void workStarted() {
        ++this.nWorkers;
        if (this.pendingWaitCursor == null || this.pendingWaitCursor.isDone() || this.pendingWaitCursor.isCancelled()) {
            this.pendingWaitCursor = this.delayedService.schedule(new Runnable(){

                public void run() {
                    WaitCursor.this.parent.setCursor(Cursor.getPredefinedCursor(3));
                }
            }, this.delay, TimeUnit.MILLISECONDS);
        }
    }

    public void workDone() {
        --this.nWorkers;
        if (this.nWorkers < 0) {
            this.nWorkers = 0;
        }
        if (this.nWorkers == 0) {
            if (this.pendingWaitCursor != null) {
                this.pendingWaitCursor.cancel(false);
            }
            this.parent.setCursor(Cursor.getDefaultCursor());
        }
    }
}

