/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterRenderer;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.GenericRotationSupport;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.util.FileFilters;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.Scope;

public class AlbumImage {
    static final Dimension OUTER_BOUNDS = new Dimension(4000, 2000);
    final BufferedImage im;
    final File file;
    final int stage;
    final AlbumBean engine;

    public AlbumImage(BufferedImage image, AlbumBean engine) {
        this.file = null;
        this.im = image;
        this.engine = engine;
        this.stage = 1;
    }

    public AlbumImage(AlbumObject ao) throws IOException {
        this.file = ao.getRepresentingImageFile();
        if (this.file == null || !this.file.exists()) {
            throw new IOException("AlbumObject " + ao + " can't be represented as an image");
        }
        int scale = FileFilters.calculateSubsamplingByScale(this.file, OUTER_BOUNDS);
        BufferedImage bi = FileFilters.loadImage(this.file, scale);
        this.engine = ((AlbumObjectImpl)ao).factory.engine;
        this.stage = 1;
        this.im = bi = GenericRotationSupport.adjustOrientation(bi, ao);
    }

    public AlbumImage(File imageFile, AlbumBean engine) throws IOException {
        this.file = imageFile;
        BufferedImage bi = FileFilters.loadImage(imageFile, engine);
        this.engine = engine;
        this.stage = 1;
        this.im = RotationSupport.adjustOrientation(bi, imageFile);
    }

    protected AlbumImage(File file, BufferedImage im, int stage, AlbumBean engine) {
        this.file = file;
        this.im = im;
        this.stage = stage;
        this.engine = engine;
    }

    protected static BufferedImage cloneImage(BufferedImage im) {
        BufferedImage bi = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)im, 0, 0, null);
        g.dispose();
        return bi;
    }

    AlbumImage scaleToFit(Dimension dim, float sharpenAmount) {
        return new AlbumImage(this.file, this.engine.scaleToFit(this.im, dim, this.engine.getScalingMethod(), sharpenAmount), this.stage, this.engine);
    }

    public AlbumImage scaleToFit(Dimension dim) {
        return new AlbumImage(this.file, this.engine.scaleToFit(this.im, dim, this.engine.getScalingMethod()), this.stage, this.engine);
    }

    protected AlbumImage scaleToFit(Dimension dim, int stage) {
        String scaleMethod = stage == 2 && this.engine.highQualityThumbs ? "ScaleSmooth" : this.engine.getScalingMethod();
        return new AlbumImage(this.file, this.engine.scaleToFit(this.im, dim, scaleMethod), stage, this.engine);
    }

    public AlbumImage scaleToThumbnail() {
        return this.scaleToFit(this.engine.thumbDim, 4);
    }

    public AlbumImage scaleToCloseup() {
        return this.scaleToFit(this.engine.imageDim, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlbumImage applyFilter(JAFilter filter, Map vars) {
        JAFilter jAFilter = filter;
        synchronized (jAFilter) {
            return new AlbumImage(this.file, filter.filter(AlbumImage.cloneImage(this.im), vars), this.stage, this.engine);
        }
    }

    public AlbumImage applyFilter(JAFilter filter) {
        HashMap vars;
        Map map = vars = this.file != null && Config.getConfig().isCompatibilityMode() ? (Map)this.engine.fileVariables.get(this.file) : null;
        if (vars == null) {
            vars = new HashMap();
        }
        return this.applyFilter(filter, vars);
    }

    public AlbumImage applyFilters(int stage) {
        AlbumObject ao;
        FilterList stack;
        Scope vars;
        Scope scope = vars = this.file != null && Config.getConfig().isCompatibilityMode() ? this.engine.fileVariables.get(this.file) : null;
        if (vars == null) {
            vars = new Scope();
        }
        FilterRenderer filterRenderer = null;
        if (this.file != null && (stack = (FilterList)(ao = this.engine.getFactory().createInstance(this.file)).getProperties().get("filterList")) != null) {
            filterRenderer = new FilterRenderer();
            filterRenderer.setFilterList(stack);
        }
        return new AlbumImage(this.file, this.engine.processFilters(filterRenderer, this.im, vars, stage), stage, this.engine);
    }

    public AlbumImage applyFilters() {
        return this.applyFilters(this.stage);
    }

    public Image getImage() {
        return this.im;
    }

    public BufferedImage getBufferedImage() {
        return this.im;
    }

    public AlbumImage saveJPEG(File output, int qualityPercent) throws IOException {
        return this.saveImage(output, qualityPercent);
    }

    public AlbumImage saveImage(File output, int qualityPercent) throws IOException {
        if (output.isDirectory()) {
            output = new File(output, this.file.getName());
        }
        FileFilters.saveJPEG(this.im, output, this.engine, null, (float)qualityPercent / 100.0f);
        return this;
    }

    public AlbumImage saveJPEG(File output) throws IOException {
        return this.saveImage(output);
    }

    public AlbumImage saveImage(File output) throws IOException {
        return this.saveJPEG(output, this.engine.getQualityPercent());
    }
}

