/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.xmp.XMPException;
import com.apple.eio.FileManager;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterRenderer;
import org.jdesktop.jdic.fileutil.FileUtil;
import org.netbeans.editor.WeakPropertyChangeSupport;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.io.RenamedFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.AlbumObjectOrderer;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.FileNamerContext;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.GenericRotationSupport;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.VideoProcessor;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.FileFilters;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.IO;
import se.datadosen.util.Orientation;
import se.datadosen.util.Platform;
import se.datadosen.util.Scope;
import se.datadosen.util.StringCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumObjectImpl
implements AlbumObject,
Serializable {
    public static final String COMMENTS_FILE_NAME = "comments.properties";
    public static final String META_FILE_NAME = "meta.properties";
    public static final String ALBUMFILES_FILE_NAME = "albumfiles.txt";
    public static final String JALBUM_FOLDER_NAME = ".jalbum";
    public static final Dimension THUMBNAIL_DIMENSION = new Dimension(160, 160);
    public static final String CACHE_FOLDER = "cache";
    private static ImageIcon folderIcon = new ImageIcon(JAlbumObject.class.getResource("images/folder_closed.png"));
    private static ImageIcon playIcon = new ImageIcon(JAlbumObject.class.getResource("images/play.png"));
    private static ImageIcon faintFolderIcon = new ImageIcon(JAlbumObject.class.getResource("images/folder_closed_faint.png"));
    private static ImageIcon brokenLinkIcon = new ImageIcon(JAlbumObject.class.getResource("images/broken_link.png"));
    private static ImageIcon brokenImageIcon = new ImageIcon(JAlbumObject.class.getResource("images/broken_image.png"));
    private static DataFlavor[] flavors = new DataFlavor[]{AlbumObject.albumObjectFlavor, DataFlavor.javaFileListFlavor};
    transient AlbumObjectFactory factory;
    private transient AlbumObject parent;
    File file;
    private Boolean isFolder;
    long whenAdded;
    String webSafeName;
    transient Category category;
    private transient Orientation orientation;
    String comment;
    private transient SoftReference<List<AlbumObject>> children;
    Map<String, AlbumObject> nameMap;
    private long lastRefreshed;
    boolean included = true;
    boolean doCache = true;
    private transient SoftReference<AlbumObjectMetadata> albumObjectMetadata;
    transient SoftReference<AlbumObjectProperties> properties;
    transient SoftReference<XmpManager> xmpProperties;
    private AlbumObject representingAlbumObject;
    private WeakPropertyChangeSupport changeSupport;
    transient AlbumObjectOrderer orderer;
    private transient ThumbnailCache thumbnailCache = new ThumbnailCache();
    private transient Scope vars;
    private transient FileFilters.BasicImageInfo imageInfo;
    private PropertyChangeListener propertyChangeListener;

    private BufferedImage cloneBufferedImage(BufferedImage old, int newType) {
        int iw = old.getWidth();
        int ih = old.getHeight();
        BufferedImage bi = new BufferedImage(iw, ih, newType);
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)old, 0, 0, null);
        g.dispose();
        old.flush();
        return bi;
    }

    private BufferedImage ensureMinimumSize(BufferedImage old, Dimension minSize) {
        if (old.getWidth() >= minSize.width && old.getHeight() >= minSize.height) {
            return old;
        }
        BufferedImage im = new BufferedImage(Math.max(minSize.width, old.getWidth()), Math.max(minSize.height, old.getHeight()), 2);
        Graphics2D g = im.createGraphics();
        g.drawImage((Image)old, (im.getWidth() - old.getWidth()) / 2, (im.getHeight() - old.getHeight()) / 2, null);
        g.dispose();
        return im;
    }

    AlbumObjectImpl(File file, AlbumObject parent, AlbumObjectFactory factory) {
        this.parent = parent;
        this.factory = factory;
        this.setFile(file);
        if (this.isFolder()) {
            this.orderer = new AlbumObjectOrderer(this);
        }
    }

    private void setFile(File f) {
        String safe;
        this.file = f;
        this.isFolder = f.isDirectory();
        if (!this.factory.isMakingAlbum() && f instanceof CachedFile) {
            ((CachedFile)f).setCacheing(false);
        }
        this.webSafeName = !(safe = IO.webSafe(this.file.getName())).equals(this.file.getName()) ? safe : null;
    }

    private static boolean exists(String s) {
        return s != null && s.trim().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AlbumObject> getNameMap() {
        if (this.nameMap == null && this.isFolder()) {
            AlbumObjectImpl albumObjectImpl = this;
            synchronized (albumObjectImpl) {
                if (this.nameMap == null) {
                    HashMap<String, AlbumObject> nameMap = new HashMap<String, AlbumObject>();
                    for (AlbumObject ao : this.getChildren()) {
                        nameMap.put(ao.getName().toLowerCase(), ao);
                    }
                    this.nameMap = nameMap;
                }
            }
        }
        return this.nameMap;
    }

    public FileFilters.BasicImageInfo getImageInfo() throws IOException {
        if (this.imageInfo == null) {
            this.imageInfo = FileFilters.getBasicImageInfo(this.file);
        }
        return this.imageInfo;
    }

    private static AlbumObject doGetRepresentingAlbumObject(AlbumObject ao, boolean useThumbForFolderIcon, Set<File> alreadyVisited) {
        try {
            Map props = AlbumBean.getFolderProperties(ao.getFile());
            String folderIconPath = (String)props.get("folderIcon");
            if (AlbumObjectImpl.exists(folderIconPath)) {
                AlbumObject child = ao.getChild(folderIconPath);
                if (child == null) {
                    return null;
                }
                if (child.isFolder()) {
                    return AlbumObjectImpl.getRepresentingAlbumObject(child, useThumbForFolderIcon, alreadyVisited);
                }
                return child;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public AlbumObject getRepresentingAlbumObject() {
        if (this.representingAlbumObject == null) {
            if (this.isFolder()) {
                AlbumObject rep2;
                this.representingAlbumObject = AlbumObjectImpl.getRepresentingAlbumObject(this, this.factory.engine.isUseThumbForFolderIcon());
                if (this.representingAlbumObject != null && !this.representingAlbumObject.isDisplayableImage() && (rep2 = this.representingAlbumObject.getRepresentingAlbumObject()) != null) {
                    this.representingAlbumObject = rep2;
                }
            } else {
                File thumbFile = IO.thumbFile(this.file);
                if (!this.file.equals(thumbFile) && thumbFile.exists()) {
                    this.representingAlbumObject = this.factory.createInstance(thumbFile);
                }
            }
        }
        return this.representingAlbumObject;
    }

    @Override
    public AlbumObject getRepresentingAlbumObject(boolean force) {
        AlbumObject rep2;
        AlbumObject rep = AlbumObjectImpl.getRepresentingAlbumObject(this, force);
        if (rep != null && !rep.isDisplayableImage() && (rep2 = rep.getRepresentingAlbumObject()) != null) {
            rep = rep2;
        }
        return rep;
    }

    private static AlbumObject getRepresentingAlbumObject(AlbumObject ao, boolean useThumbForFolderIcon) {
        return AlbumObjectImpl.getRepresentingAlbumObject(ao, useThumbForFolderIcon, new HashSet<File>());
    }

    private static AlbumObject getRepresentingAlbumObject(AlbumObject ao, boolean useThumbForFolderIcon, Set<File> alreadyVisited) {
        if (alreadyVisited.contains(ao.getFile())) {
            System.err.println("Circular folder link detected when entering " + ao.getFile());
            return null;
        }
        alreadyVisited.add(ao.getFile());
        AlbumObject rep = AlbumObjectImpl.doGetRepresentingAlbumObject(ao, useThumbForFolderIcon, alreadyVisited);
        if (rep == null && useThumbForFolderIcon) {
            try {
                List<AlbumObject> children = ao.getChildren();
                for (AlbumObject child : children) {
                    if (!child.isIncluded() || child.isFolder() || !child.hasDisplayableImage()) continue;
                    return child;
                }
                for (AlbumObject child : children) {
                    if (!child.isFolder() || (rep = AlbumObjectImpl.getRepresentingAlbumObject(child, useThumbForFolderIcon, alreadyVisited)) == null) continue;
                    return rep;
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return rep;
    }

    @Override
    public AlbumObject getParent() {
        return this.parent;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getLastModified() {
        long last = this.file.lastModified();
        File propFile = AlbumObjectProperties.getPropertyFile(this.file);
        last = Math.max(propFile.lastModified(), last);
        if (this.isFolder()) {
            File metaFile = new File(this.file, META_FILE_NAME);
            last = Math.max(metaFile.lastModified(), last);
            File albumFilesFile = new File(this.file, ALBUMFILES_FILE_NAME);
            last = Math.max(albumFilesFile.lastModified(), last);
        }
        return last;
    }

    @Override
    public long getWhenAdded() {
        if (this.whenAdded == 0L) {
            this.whenAdded = new Date().getTime();
        }
        return this.whenAdded;
    }

    public long getLastRefreshed() {
        return this.lastRefreshed;
    }

    @Override
    public Image loadImage() throws IOException {
        return this.loadImage(false, null);
    }

    @Override
    public Image loadImage(boolean useFastLoading, Dimension imageDim) throws IOException {
        BufferedImage im;
        if (!this.isDisplayableImage()) {
            return null;
        }
        if (useFastLoading) {
            int scale = FileFilters.calculateSubsamplingByScale(this.file, imageDim);
            im = FileFilters.loadImage(this.file, scale);
        } else {
            im = FileFilters.loadImage(this.file);
        }
        this.getMetadata();
        return GenericRotationSupport.adjustOrientation(im, (AlbumObject)this);
    }

    @Override
    public AlbumObjectFactory getFactory() {
        return this.factory;
    }

    @Override
    public void rotateLeft() {
        this.setOrientation(this.getOrientation().next());
    }

    @Override
    public void rotateRight() {
        this.setOrientation(this.getOrientation().previous());
    }

    @Override
    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.orientation = GenericRotationSupport.getOrientation(this);
        }
        return this.orientation;
    }

    @Override
    public void setOrientation(Orientation o) {
        this.thumbnailCache.clear();
        Orientation old = this.getOrientation();
        GenericRotationSupport.setOrientation(o, this);
        this.orientation = o;
        this.firePropertyChange("orientation", (Object)o, (Object)old);
        this.albumObjectMetadata = null;
        this.getMetadata();
    }

    @Override
    public boolean isIncludeOriginal() {
        return this.getProperties().get("includeOriginal", Boolean.FALSE);
    }

    @Override
    public void setIncludeOriginal(boolean includeOriginal) {
        AlbumObjectProperties props = this.getProperties();
        props.put("includeOriginal", includeOriginal);
        props.save();
    }

    private void deleteFromParent() throws IOException {
        AlbumObjectImpl pao = (AlbumObjectImpl)this.parent;
        if (pao != null) {
            List<AlbumObject> parentChildren = pao.getChildren();
            parentChildren.remove(this);
            pao.setChildren(parentChildren);
        }
    }

    @Override
    public void delete() throws IOException, PermissionException {
        File cachedThumbnailFile;
        if (this.parent != null && !this.isFolder()) {
            this.setClassicComment("");
        }
        if (!this.isLink()) {
            try {
                File thumbFile = IO.thumbFile(this.file);
                if (Platform.isMac()) {
                    if (!FileManager.moveToTrash((File)this.file)) {
                        throw new IOException("Unable to recycle");
                    }
                    if (thumbFile.exists()) {
                        thumbFile.delete();
                    }
                } else {
                    FileUtil fu = new FileUtil();
                    fu.recycle(this.file);
                    if (thumbFile.exists()) {
                        thumbFile.delete();
                    }
                }
            }
            catch (Throwable t) {
                if (this.isFolder()) {
                    List<AlbumObject> children = this.getChildren();
                    if (children.size() > 0) {
                        throw new PermissionException(Msg.get("edit.folderNotEmptyError", this.getName()));
                    }
                    this.deleteFolderSafely(this.file);
                }
                this.file.delete();
                IO.thumbFile(this.file).delete();
            }
        }
        File aop = AlbumObjectProperties.getPropertyFile(this.file);
        if (aop.exists()) {
            aop.delete();
        }
        if ((cachedThumbnailFile = this.getCachedThumbnailFile(this.file)).exists()) {
            cachedThumbnailFile.delete();
        }
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        albumSynchronizer.delete(this);
        this.deleteFromParent();
    }

    private boolean deleteFolderSafely(File folder) throws IOException {
        File f = new File(folder, COMMENTS_FILE_NAME);
        f.delete();
        f = new File(folder, META_FILE_NAME);
        f.delete();
        f = new File(folder, ALBUMFILES_FILE_NAME);
        f.delete();
        File jalbumFolder = new File(folder, JALBUM_FOLDER_NAME);
        if (jalbumFolder.exists()) {
            AlbumObjectImpl.deleteDirRecursively(jalbumFolder);
        }
        File dsStore = new File(folder, ".DS_Store");
        dsStore.delete();
        File thumbsDb = new File(folder, "THUMBS.DB");
        thumbsDb.delete();
        return folder.delete();
    }

    private static void deleteDirRecursively(File dir) {
        for (CachedFile f : CachedFile.listFiles(dir)) {
            if (((File)f).isDirectory()) {
                AlbumObjectImpl.deleteDirRecursively(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    private String uniqueName(String suggestedName) {
        String base = IO.baseName(suggestedName);
        String ext = IO.extensionOf(suggestedName);
        if (ext.length() > 0) {
            ext = "." + ext;
        }
        String name = suggestedName;
        int i = 1;
        while (this.containsName(name)) {
            name = base + "-" + i + ext;
            ++i;
        }
        return name;
    }

    @Override
    public AlbumObject createFolder(String suggestedName) throws IOException {
        List<AlbumObject> chldrn = this.getChildren();
        File folderFile = new File(this.file, this.uniqueName(suggestedName));
        folderFile.mkdir();
        AlbumObject ao = this.factory.createInstance(folderFile, this);
        chldrn.add(ao);
        this.setChildren(chldrn);
        return ao;
    }

    @Override
    public AlbumObject createPage(String suggestedName) throws IOException {
        File progDir = Config.getConfig().progDir;
        return this.createPage(suggestedName, new File(progDir, "system/empty-page.htt"));
    }

    @Override
    public AlbumObject createPage(String suggestedName, File original) throws IOException {
        List<AlbumObject> chldrn = this.getChildren();
        File pageFile = new File(this.file, this.uniqueName(suggestedName));
        IO.copyFile(original, pageFile);
        AlbumObject ao = this.factory.createInstance(pageFile, this);
        chldrn.add(ao);
        this.setChildren(chldrn);
        AlbumObjectProperties props = ao.getProperties();
        props.put("originalPath", original.getAbsolutePath());
        props.save();
        return ao;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getWebName() {
        return this.webSafeName != null ? this.webSafeName : this.getName();
    }

    @Override
    public boolean setName(String newName) {
        newName = newName.trim();
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        String oldName = this.file.getName();
        File renamedFile = new File(this.file.getParentFile(), newName);
        if (!this.isFolder() && !IO.extensionOf(newName).equalsIgnoreCase(IO.extensionOf(this.file))) {
            newName = IO.baseName(renamedFile) + "." + IO.extensionOf(this.file);
            renamedFile = new File(renamedFile.getParentFile(), newName);
        }
        if (this.getParent() != null && !oldName.equalsIgnoreCase(newName) && this.getParent().containsName(newName) || newName.length() == 0) {
            return false;
        }
        if (this.isLink()) {
            LinkFile lf = (LinkFile)this.file;
            renamedFile = new LinkFile(lf.getLink().getParentFile(), renamedFile.getName(), lf.getTarget());
        }
        if (this.file.renameTo(renamedFile)) {
            if (this.parent != null) {
                AlbumObjectImpl.setComment(this.getComment(), renamedFile, this.file);
            } else {
                this.factory.engine.setDirectory(renamedFile.getAbsolutePath());
            }
            File propFile = AlbumObjectProperties.getPropertyFile(this.file);
            File renamedPropFile = AlbumObjectProperties.getPropertyFile(renamedFile);
            if (propFile.exists()) {
                propFile.renameTo(renamedPropFile);
            }
            File thumbFile = this.getCachedThumbnailFile(this.file);
            File renamedThumbFile = this.getCachedThumbnailFile(renamedFile);
            if (thumbFile.exists()) {
                thumbFile.renameTo(renamedThumbFile);
            }
            File fromTranslated = albumSynchronizer.translate(this);
            this.setFile(renamedFile);
            File toTranslated = albumSynchronizer.translate(this);
            albumSynchronizer.moveTo(this, fromTranslated, toTranslated);
            try {
                if (this.parent != null) {
                    ((AlbumObjectImpl)this.parent).lastRefreshed = System.currentTimeMillis();
                    this.parent.setChildren(this.parent.getChildren());
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.invalidate();
            this.category = null;
            this.firePropertyChange("name", oldName, newName);
            if (newName.equals(this.factory.engine.getResourceDirectory())) {
                this.setHidden(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getComment() {
        String comment;
        XmpManager mgr;
        if (this.comment != null) {
            return this.comment;
        }
        if (this.isFolder()) {
            try {
                Map props = this.getFolderProperties();
                this.comment = (String)props.get("descript");
                return this.comment != null ? this.comment : "";
            }
            catch (IOException ex) {
                return "";
            }
        }
        if (this.factory.engine.isReadXmp() && (mgr = this.getXmpManager()) != null && (comment = mgr.getDescription()) != null) {
            return comment;
        }
        AlbumObjectMetadata meta = this.getMetadata();
        this.comment = this.factory.engine.readComment(this.file, this.parent != null ? this.parent.getFile() : this.file.getParentFile(), meta.metadata);
        return this.comment;
    }

    private void setClassicComment(String newComment) throws IOException {
        if (this.isFolder()) {
            Map props = this.getFolderProperties();
            props.put("descript", newComment);
            this.setFolderProperties(props);
        } else {
            AlbumObjectImpl.setComment(newComment, this.file, this.file);
        }
        this.comment = newComment;
    }

    private void setXmpComment(String newComment) {
        XmpManager xmpProps;
        if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
            try {
                xmpProps.setDescription(newComment);
                xmpProps.save();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void setComment(String newComment) throws IOException {
        String oldComment = this.comment;
        if (newComment.equals(oldComment)) {
            return;
        }
        this.setClassicComment(newComment);
        this.setXmpComment(newComment);
        this.firePropertyChange("comment", oldComment, newComment);
    }

    @Override
    public String getTitle() {
        AlbumObjectMetadata aoMeta;
        Metadata md;
        String title;
        XmpManager xmpProps;
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null && (title = xmpProps.getTitle()) != null) {
            return title;
        }
        AlbumObjectProperties aop = this.getProperties();
        title = (String)aop.get("title");
        if (title == null && (md = (aoMeta = this.getMetadata()).getMetadata()) != null && md.containsDirectory(IptcDirectory.class)) {
            IptcDirectory iptc = (IptcDirectory)md.getDirectory(IptcDirectory.class);
            switch (this.factory.engine.getTitleSource()) {
                case IPTCObjectName: {
                    if (!iptc.containsTag(517)) break;
                    title = iptc.getString(517);
                    break;
                }
                case IPTCHeadline: {
                    if (!iptc.containsTag(617)) break;
                    title = iptc.getString(617);
                }
            }
        }
        return title != null ? title : "";
    }

    @Override
    public boolean setTitle(String newTitle) {
        String oldTitle = this.getTitle();
        if (!newTitle.equals(oldTitle)) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setTitle(newTitle);
                    xmpProps.save();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            aop.put("title", newTitle);
            boolean res = aop.save(false);
            this.firePropertyChange("title", oldTitle, newTitle);
            return res;
        }
        return true;
    }

    @Override
    public int getRating() {
        Integer rating;
        XmpManager xmpProps;
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null && (rating = xmpProps.getRating()) != null) {
            return rating;
        }
        AlbumObjectProperties aop = this.getProperties();
        Integer r = (Integer)aop.get("rating");
        if (r == null) {
            r = new Integer(0);
        }
        return r;
    }

    @Override
    public void setRating(int rating) {
        int oldRating = this.getRating();
        if (rating != oldRating) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setRating(rating);
                    xmpProps.save();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            aop.put("rating", rating);
            aop.save(false);
        }
    }

    @Override
    public Flag getFlag() {
        AlbumObjectProperties aop;
        Flag flag;
        XmpManager xmpProps;
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null) {
            try {
                return xmpProps.getFlag();
            }
            catch (XMPException ex) {
                // empty catch block
            }
        }
        return (flag = (Flag)((Object)(aop = this.getProperties()).get("flag"))) != null ? flag : Flag.NoFlag;
    }

    @Override
    public void setKeywords(String keywords) {
        String oldKeywords = this.getKeywords();
        if (!keywords.equals(oldKeywords)) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setKeywords(keywords);
                    xmpProps.save();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            if ("".equals(keywords)) {
                aop.remove("keywords");
            } else {
                aop.put("keywords", keywords);
            }
            aop.save(false);
            this.firePropertyChange("keywords", oldKeywords, keywords);
        }
    }

    @Override
    public String getKeywords() {
        XmpManager xmpProps;
        String keywords = null;
        if (this.factory.engine.isReadXmp() && (xmpProps = this.getXmpManager()) != null) {
            try {
                keywords = xmpProps.getKeywords();
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        if (keywords == null) {
            AlbumObjectProperties aop = this.getProperties();
            keywords = aop.get("keywords", "");
        }
        return keywords != null ? keywords : "";
    }

    @Override
    public void setFlag(Flag flag) {
        Flag oldFlag = this.getFlag();
        if (flag != oldFlag) {
            XmpManager xmpProps;
            if (Config.getConfig().isWriteXmp() && (xmpProps = this.getXmpManager()) != null) {
                try {
                    xmpProps.setFlag(flag);
                    xmpProps.save();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            AlbumObjectProperties aop = this.getProperties();
            if (flag == Flag.NoFlag) {
                aop.remove("flag");
            } else {
                aop.put("flag", (Object)flag);
            }
            aop.save(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFileMetadataToXmp() throws XMPException, IOException {
        boolean readXmp;
        block6: {
            readXmp = this.factory.engine.isReadXmp();
            this.factory.engine.setReadXmp(false);
            try {
                Integer rating;
                AlbumObjectProperties aop;
                String title;
                XmpManager xmpProps = this.getXmpManager();
                int modCount = 0;
                if (xmpProps == null) break block6;
                if (this.getComment().length() > 0) {
                    xmpProps.setDescription(this.getComment());
                    ++modCount;
                }
                if ((title = (String)(aop = this.getProperties()).get("title")) != null) {
                    xmpProps.setTitle(title);
                    ++modCount;
                }
                if ((rating = (Integer)aop.get("rating")) != null) {
                    xmpProps.setRating(rating);
                    ++modCount;
                }
                if (modCount <= 0) break block6;
                xmpProps.save();
                boolean bl = true;
                Object var9_9 = null;
                this.factory.engine.setReadXmp(readXmp);
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.factory.engine.setReadXmp(readXmp);
                throw throwable;
            }
        }
        boolean bl = false;
        Object var9_10 = null;
        this.factory.engine.setReadXmp(readXmp);
        return bl;
    }

    @Override
    public String getPathFromRoot() {
        if (this.parent == null) {
            return "";
        }
        if (this.parent.getParent() == null) {
            return this.getName();
        }
        return this.parent.getPathFromRoot() + '/' + this.getName();
    }

    @Override
    public AlbumObjectMetadata getMetadata() {
        AlbumObjectMetadata md;
        AlbumObjectMetadata albumObjectMetadata = md = this.albumObjectMetadata != null ? this.albumObjectMetadata.get() : null;
        if (md == null) {
            try {
                md = AlbumObjectMetadata.getInstance(this.file);
                this.albumObjectMetadata = new SoftReference<AlbumObjectMetadata>(md);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return md;
    }

    @Override
    public AlbumObjectProperties getProperties() {
        AlbumObjectProperties aop;
        AlbumObjectProperties albumObjectProperties = aop = this.properties != null ? this.properties.get() : null;
        if (aop == null) {
            aop = AlbumObjectProperties.getInstance(this);
            this.propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    AlbumObjectImpl.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            };
            aop.removePropertyChangeListener(this.propertyChangeListener);
            aop.addPropertyChangeListener(this.propertyChangeListener);
            this.properties = new SoftReference<AlbumObjectProperties>(aop);
        }
        return aop;
    }

    @Override
    public XmpManager getXmpManager() {
        XmpManager xmpProps;
        XmpManager xmpManager = xmpProps = this.xmpProperties != null ? this.xmpProperties.get() : null;
        if (xmpProps == null && !this.isFolder() && this.isJPEGImage()) {
            try {
                xmpProps = new XmpManager(this);
                this.xmpProperties = new SoftReference<XmpManager>(xmpProps);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return xmpProps;
    }

    private boolean isJPEGImage() {
        String name = this.getFile().getName().toLowerCase();
        return name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    @Override
    public boolean isDisplayableImage() {
        return this.file.exists() && !FileFilters.hasIcon(this.file);
    }

    @Override
    public boolean hasDisplayableImage() {
        return this.isDisplayableImage() || this.getCachedThumbnailFile(this.file).exists() || this.factory.engine.getVideoProcessor().isFormatSupported(this.file);
    }

    @Override
    public boolean isLink() {
        return this.file instanceof LinkFile;
    }

    @Override
    public boolean isFolder() {
        if (this.isFolder == null) {
            this.isFolder = this.file.isDirectory();
        }
        return this.isFolder;
    }

    @Override
    public Category getCategory() {
        if (this.category == null) {
            if (this.isFolder()) {
                this.category = Category.folder;
            } else if (FileFilters.isFileSupported(this.file)) {
                this.category = Category.image;
            } else if ("Audio file".equals(FileFilters.getFileCategory(this.file))) {
                this.category = Category.audio;
            } else if (VideoProcessor.createInstance().isFormatSupported(this.file)) {
                this.category = Category.video;
            } else {
                this.category = Category.other;
                FileFilters.FileType ft = FileFilters.getFileType(this.file);
                if (ft != null && "Web page template".equals(ft.name)) {
                    this.category = Category.webPage;
                }
            }
        }
        return this.category;
    }

    @Override
    public boolean isIncluded() {
        return this.included;
    }

    @Override
    public void setIncluded(boolean included) {
        boolean oldIncluded = this.included;
        this.included = included;
        this.firePropertyChange("included", oldIncluded, included);
    }

    @Override
    public boolean isHidden() {
        AlbumObjectProperties aop = this.getProperties();
        Boolean hidden = (Boolean)aop.get("hidden");
        return hidden != null ? hidden : false;
    }

    @Override
    public void setHidden(boolean hidden) {
        boolean oldHidden = this.isHidden();
        AlbumObjectProperties aop = this.getProperties();
        aop.put("hidden", hidden);
        aop.save(false);
        this.thumbnailCache.clear();
        this.firePropertyChange("hidden", oldHidden, hidden);
    }

    @Override
    public boolean isWithin(AlbumObject parent) {
        for (AlbumObject ao = this; ao != null; ao = ao.getParent()) {
            if (ao != parent) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlbumObject> getChildren() {
        List<AlbumObject> children = this.children != null ? this.children.get() : null;
        long lastModified = this.getLastModified();
        if (this.isFolder() && (children == null || lastModified > this.getLastRefreshed())) {
            AlbumObjectImpl albumObjectImpl = this;
            synchronized (albumObjectImpl) {
                List<AlbumObject> list = children = this.children != null ? this.children.get() : null;
                if (children == null || lastModified > this.getLastRefreshed()) {
                    children = new ArrayList<AlbumObject>();
                    FileCollection fc = new FileCollection(this.factory.engine, this.file);
                    Collection<FileCollection.FileEntry> entries = fc.listEntries(this.factory.getFilter(), this.factory.isIncludeExcluded(), this.factory.isIncludeMissing());
                    this.lastRefreshed = System.currentTimeMillis();
                    FileNamerContext context = new FileNamerContext(this);
                    if (entries != null) {
                        boolean newFilesFound = false;
                        long now = new Date().getTime();
                        AlbumObject[] chldrn = new AlbumObject[entries.size()];
                        Iterator<FileCollection.FileEntry> it = entries.iterator();
                        for (int i = 0; i < chldrn.length; ++i) {
                            FileCollection.FileEntry fe = it.next();
                            AlbumObject ao = this.factory.createInstance(fe.file, context);
                            if (fe.excluded) {
                                ao.setIncluded(false);
                            }
                            if (ao.getName().equals(this.factory.engine.getResourceDirectory())) {
                                ao.setHidden(true);
                            }
                            if (fe.whenAdded == null) {
                                fe.whenAdded = now;
                                newFilesFound = true;
                            }
                            ((AlbumObjectImpl)ao).whenAdded = fe.whenAdded;
                            chldrn[i] = ao;
                        }
                        AlbumObjectOrderer orderer = new AlbumObjectOrderer(this);
                        Collections.addAll(children, orderer.sort(chldrn));
                        this.children = new SoftReference<List<AlbumObject>>(children);
                        this.representingAlbumObject = null;
                        if (newFilesFound) {
                            try {
                                this.setChildren(children);
                            }
                            catch (IOException ex) {
                                System.err.println("Can't write to " + new File(this.file, ALBUMFILES_FILE_NAME));
                            }
                        }
                    }
                }
            }
        }
        return children;
    }

    @Override
    public AlbumObject getChild(String path) {
        int slashIndex = (path = path.toLowerCase()).indexOf(47);
        if (slashIndex >= 0) {
            AlbumObject child = this.getChild(path.substring(0, slashIndex));
            if (child != null) {
                return child.getChild(path.substring(slashIndex + 1));
            }
        } else {
            Map<String, AlbumObject> nm = this.getNameMap();
            return nm != null ? nm.get(path) : null;
        }
        return null;
    }

    @Override
    public void setChildren(List<AlbumObject> children) throws IOException {
        this.children = new SoftReference<List<AlbumObject>>(children);
        this.nameMap = null;
        this.lastRefreshed = System.currentTimeMillis();
        this.representingAlbumObject = null;
        StringBuilder content = new StringBuilder();
        content.append("# This file is created by JAlbum. It sets custom file filtering and ordering for this image directory.\r\n# Files not listed here are added to the end of the album\r\n# Rows beginning with \"-\" indicate excluded files.\r\n# Rows can have up to 3 tab separated columns according to this scheme:\r\n# File name | Target path (for links) | When added (seconds since epoch)\r\n# Note: The target path can reference files and directories in other locations and thereby\r\n# allows you to compile albums consisting of files from several different locations.\r\n\r\n");
        for (AlbumObjectImpl albumObjectImpl : children) {
            if (!albumObjectImpl.isIncluded()) {
                content.append('-');
            }
            if (albumObjectImpl.file instanceof RenamedFile) {
                content.append(((RenamedFile)albumObjectImpl.file).getTargetName());
            } else {
                content.append(albumObjectImpl.file.getName());
            }
            content.append('\t');
            if (albumObjectImpl.file instanceof LinkFile && !(albumObjectImpl.file instanceof RenamedFile)) {
                content.append(((LinkFile)albumObjectImpl.file).getTarget());
            }
            content.append('\t');
            content.append(albumObjectImpl.getWhenAdded() / 1000L);
            content.append("\r\n");
        }
        File file = new File(this.file, ALBUMFILES_FILE_NAME);
        String textEncoding = this.factory.engine.isWriteUTF8() ? "UTF-8" : this.factory.engine.getTextEncoding();
        String s = content.toString();
        if (!textEncoding.equals("UTF-8") && !StringCodec.isEncodable(s, textEncoding)) {
            textEncoding = "UTF-8";
        }
        IO.writeTextFile(s, file, textEncoding);
        this.firePropertyChange("children", null, children);
    }

    @Override
    public boolean containsName(String name) {
        return this.getNameMap().containsKey(name.toLowerCase());
    }

    @Override
    public void moveTo(AlbumObject newParent) throws IOException {
        this.moveTo(newParent, -1);
    }

    @Override
    public boolean repairLink(File newTarget) throws IOException {
        if (!this.isLink() || this.file.exists() || !newTarget.exists()) {
            return false;
        }
        this.setFile(new LinkFile(((LinkFile)this.file).getLink().getParentFile(), this.file.getName(), newTarget));
        this.invalidate();
        this.parent.setChildren(this.parent.getChildren());
        return true;
    }

    @Override
    public void moveTo(AlbumObject newParent, int position) throws IOException {
        File newFile;
        if (!newParent.isFolder()) {
            throw new IllegalArgumentException("Argument must be a folder");
        }
        if (newParent.containsName(this.getName())) {
            throw new IOException(Msg.get("edit.objectAlreadyExists", this.getName()));
        }
        List<AlbumObject> chldrn = newParent.getChildren();
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        File fromTranslated = albumSynchronizer.translate(this);
        if (this.isLink()) {
            newFile = new LinkFile(newParent.getFile(), this.getName(), this.file.getAbsoluteFile());
        } else {
            newFile = new File(newParent.getFile(), this.getName());
            if (!this.file.renameTo(newFile)) {
                throw new IOException(Msg.get("edit.moveError", this.file, newFile));
            }
            IO.thumbFile(this.file).renameTo(IO.thumbFile(newFile));
        }
        if (this.parent != null) {
            AlbumObjectImpl.setComment(this.getComment(), newFile, this.file);
        }
        File propFile = AlbumObjectProperties.getPropertyFile(this.file);
        File renamedPropFile = AlbumObjectProperties.getPropertyFile(newFile);
        if (propFile.exists()) {
            renamedPropFile.getParentFile().mkdir();
            propFile.renameTo(renamedPropFile);
        }
        File thumbFile = this.getCachedThumbnailFile(this.file);
        File renamedThumbFile = this.getCachedThumbnailFile(newFile);
        if (thumbFile.exists()) {
            renamedThumbFile.getParentFile().mkdirs();
            thumbFile.renameTo(renamedThumbFile);
        }
        this.invalidate();
        this.deleteFromParent();
        this.setFile(newFile);
        this.parent = (AlbumObjectImpl)newParent;
        if (position != -1) {
            chldrn.add(position, this);
        } else {
            chldrn.add(this);
        }
        newParent.setChildren(chldrn);
        File toTranslated = albumSynchronizer.translate(this);
        albumSynchronizer.moveTo(this, fromTranslated, toTranslated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(List<File> files) throws IOException {
        List<AlbumObject> children = this.getChildren();
        try {
            for (File f : files) {
                if (this.containsName(f.getName())) {
                    throw new IOException(Msg.get("edit.objectAlreadyExists", f.getName()));
                }
                AlbumObject ao = this.factory.createInstance((File)new LinkFile(this.file, f.getName(), f), this);
                children.add(ao);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setChildren(children);
            throw throwable;
        }
        this.setChildren(children);
    }

    @Override
    public void add(Set<AlbumObject> objects) throws IOException {
        this.add(this.getChildren().size(), objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Set<AlbumObject> objects) throws IOException {
        List<AlbumObject> children = this.getChildren();
        try {
            for (AlbumObject ao : objects) {
                ((AlbumObjectImpl)ao).parent = this;
            }
            if (index < children.size()) {
                int indexAfterRemoval = index;
                Iterator<AlbumObject> it = children.iterator();
                for (int i = 0; i < index && it.hasNext(); ++i) {
                    AlbumObject ao = it.next();
                    if (!objects.contains(ao)) continue;
                    this.getNameMap().remove(ao.getName().toLowerCase());
                    it.remove();
                    --indexAfterRemoval;
                }
                children.removeAll(objects);
                children.addAll(indexAfterRemoval, objects);
            } else {
                children.removeAll(objects);
                children.addAll(objects);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.setChildren(children);
            throw throwable;
        }
        this.setChildren(children);
    }

    @Override
    public AlbumObject.Ordering getOrdering() {
        return this.orderer.getOrdering();
    }

    @Override
    public void setOrdering(AlbumObject.Ordering ordering) throws IOException {
        if (this.orderer != null) {
            this.orderer.setOrdering(ordering);
        }
    }

    @Override
    public AlbumObject.Ordering getFolderOrdering() {
        return this.orderer.getFolderOrdering();
    }

    @Override
    public void setFolderOrdering(AlbumObject.Ordering folderOrdering) throws IOException {
        this.orderer.setFolderOrdering(folderOrdering);
    }

    @Override
    public boolean isFoldersFirst() {
        return this.orderer.isFoldersFirst();
    }

    @Override
    public void setFoldersFirst(boolean foldersFirst) throws IOException {
        this.orderer.setFoldersFirst(foldersFirst);
    }

    @Override
    public boolean isReverseOrdering() {
        return this.orderer.isReverseOrdering();
    }

    @Override
    public void setReverseOrdering(boolean reverseOrdering) throws IOException {
        this.orderer.setReverseOrdering(reverseOrdering);
    }

    @Override
    public boolean isReverseFolderOrdering() {
        return this.orderer.isReverseFolderOrdering();
    }

    @Override
    public void setReverseFolderOrdering(boolean reverseFolderOrdering) throws IOException {
        this.orderer.setReverseFolderOrdering(reverseFolderOrdering);
    }

    @Override
    public void invalidate() {
        this.children = null;
        this.nameMap = null;
        this.representingAlbumObject = null;
    }

    private static BufferedImage cropToShape(BufferedImage bi, Dimension dDim) {
        Dimension sDim = new Dimension(bi.getWidth(), bi.getHeight());
        double sAspekt = (double)sDim.width / (double)sDim.height;
        double dAspekt = (double)dDim.width / (double)dDim.height;
        if (sAspekt > dAspekt) {
            int newWidth = (int)(dAspekt * (double)sDim.height);
            return bi.getSubimage((sDim.width - newWidth) / 2, 0, newWidth, sDim.height);
        }
        if (sAspekt < dAspekt) {
            int newHeight = (int)((double)sDim.width / dAspekt);
            return bi.getSubimage(0, (sDim.height - newHeight) / 6, sDim.width, newHeight);
        }
        return bi;
    }

    @Override
    public ImageIcon getRepresentingIcon(Dimension bounds, boolean enlarge) throws IOException {
        return this.getRepresentingIcon(bounds, false, enlarge);
    }

    @Override
    public ImageIcon getRepresentingIcon(Dimension bounds, boolean fixedShape, boolean enlarge) throws IOException {
        BufferedImage bi;
        Graphics2D g;
        ImageIcon ii = this.thumbnailCache.getIcon(bounds, fixedShape);
        if (ii != null) {
            return ii;
        }
        if (this.getRepresentingAlbumObject() != null) {
            ii = this.representingAlbumObject.getRepresentingIcon(bounds, fixedShape, enlarge);
            if (this.isFolder()) {
                BufferedImage ri = AlbumObjectImpl.ensureBuffered(ii);
                ri = this.ensureMinimumSize(ri, new Dimension(96, 96));
                ri = GraphicsUtilities.duplicate(ri);
                g = (Graphics2D)ri.getGraphics();
                Image fi = faintFolderIcon.getImage();
                int fw = fi.getWidth(null);
                int fh = fi.getHeight(null);
                if (ri.getWidth() < 100 || ri.getHeight() < 100) {
                    fw = 3 * fw / 5;
                    fh = 3 * fh / 5;
                }
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.drawImage(fi, (ri.getWidth(null) - fw) / 2, (ri.getHeight(null) - fh) / 2, fw, fh, null);
                g.dispose();
                ii = new ImageIcon(ri);
            }
            bi = AlbumObjectImpl.ensureBuffered(ii);
            bi = GenericRotationSupport.adjustOrientation(bi, (AlbumObject)this);
            ii = new ImageIcon(bi);
        } else {
            Object o = this.doGetRepresentingIcon(bounds, fixedShape, enlarge);
            if (o instanceof ImageIcon) {
                ii = AlbumObjectImpl.scaleToFit((ImageIcon)o, bounds, enlarge);
            } else {
                BufferedImage bi2 = (BufferedImage)o;
                if (fixedShape) {
                    bi2 = AlbumObjectImpl.cropToShape(bi2, bounds);
                }
                bi2 = GenericRotationSupport.adjustOrientation(bi2, (AlbumObject)this);
                FilterRenderer filterRenderer = new FilterRenderer();
                AlbumObjectProperties props = this.getProperties();
                FilterList fl = (FilterList)props.get("filterList");
                if (fl != null) {
                    try {
                        filterRenderer.setFilterList(fl);
                        bi2 = this.cloneBufferedImage(bi2, 2);
                        bi2 = filterRenderer.applyPrescaleFilters(bi2);
                        bi2 = this.factory.engine.scaleToFit(bi2, new Dimension(600, 600), "ScaleFast");
                        bi2 = filterRenderer.applyPostscaleFilters(bi2);
                    }
                    catch (Throwable t) {
                        System.err.println("Error applying image tools to " + this.getName() + ": " + t);
                    }
                    ii = AlbumObjectImpl.scaleToFit(new ImageIcon(bi2), bounds, true);
                } else {
                    ii = AlbumObjectImpl.scaleToFit(new ImageIcon(bi2), bounds, enlarge);
                }
            }
        }
        if (this.getCategory() == Category.video && ii.getIconWidth() > 50) {
            bi = AlbumObjectImpl.ensureBuffered(ii);
            Image pi = playIcon.getImage();
            int pw = pi.getWidth(null);
            int ph = pi.getHeight(null);
            if (bi.getWidth() <= 100 && bi.getHeight() <= 100) {
                pw /= 2;
                ph /= 2;
            } else if (bi.getWidth() <= 160 && bi.getHeight() <= 160) {
                pw = 2 * pw / 3;
                ph = 2 * ph / 3;
            }
            Graphics2D g2 = (Graphics2D)bi.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(pi, (bi.getWidth(null) - pw) / 2, (bi.getHeight(null) - ph) / 2, pw, ph, null);
            g2.dispose();
            ii = new ImageIcon(bi);
        }
        if (this.isHidden()) {
            BufferedImage im = new BufferedImage(ii.getIconWidth(), ii.getIconHeight(), 6);
            g = im.createGraphics();
            AlphaComposite composite = AlphaComposite.getInstance(3, 0.3f);
            g.setComposite(composite);
            g.drawImage(ii.getImage(), 0, 0, null);
            ii = new ImageIcon(im);
        }
        this.thumbnailCache.update(ii, bounds, fixedShape);
        return ii;
    }

    private Object doGetRepresentingIcon(Dimension bounds, boolean fixedShape, boolean enlarge) throws IOException {
        if (!this.hasDisplayableImage()) {
            ImageIcon repIcon = null;
            repIcon = !this.file.exists() ? brokenLinkIcon : (this.isFolder() ? folderIcon : new ImageIcon(FileFilters.getIconFor(this.file, this.factory.engine).toURL()));
            return repIcon;
        }
        try {
            this.getRepresentingImageFile();
            File thumbnailFile = IO.thumbFile(this.file);
            if (!thumbnailFile.equals(this.file)) {
                thumbnailFile = this.getCachedThumbnailFile(this.file);
            }
            if (thumbnailFile.exists()) {
                if (thumbnailFile.lastModified() < this.file.lastModified()) {
                    this.thumbnailCache.clear();
                }
                return FileFilters.loadImage(thumbnailFile);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            BufferedImage thumb = this.readEmbeddedThumbnail();
            FileFilters.BasicImageInfo info = this.getImageInfo();
            if (AlbumObjectImpl.isPortrait(thumb.getWidth(), thumb.getHeight()) != AlbumObjectImpl.isPortrait(info.width, info.height)) {
                throw new IOException("Discarding thumbnail that has different aspect than main image");
            }
            return thumb;
        }
        catch (IOException ex) {
            try {
                int scale = FileFilters.calculateSubsamplingByScale(this.file, THUMBNAIL_DIMENSION);
                BufferedImage bi = FileFilters.loadImage(this.file, scale);
                bi = this.factory.engine.scaleToFit(bi, THUMBNAIL_DIMENSION, "ScaleMedium");
                try {
                    this.setRepresentingIcon(bi, false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bi;
            }
            catch (Exception e) {
                return brokenImageIcon;
            }
        }
    }

    private static boolean isPortrait(int width, int height) {
        return height > width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage readEmbeddedThumbnail() throws IOException {
        try {
            AlbumObjectMetadata meta = this.getMetadata();
            if (meta.metadata != null && meta.metadata.containsDirectory(ExifDirectory.class)) {
                Directory dir = meta.metadata.getDirectory(ExifDirectory.class);
                byte[] rawImage = (byte[])dir.getObject(61441);
                ImageIcon ii = new ImageIcon(rawImage);
                return AlbumObjectImpl.ensureBuffered(ii);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(IO.extensionOf(this.file));
        while (true) {
            Object var7_10;
            ImageInputStream iis;
            block11: {
                BufferedImage bufferedImage;
                if (!it.hasNext()) {
                    throw new IOException("No image readers found for " + this.getName());
                }
                ImageReader ir = it.next();
                iis = null;
                try {
                    try {
                        iis = ImageIO.createImageInputStream(this.file);
                        ir.setInput(iis);
                        int minIndex = ir.getMinIndex();
                        if (!ir.hasThumbnails(minIndex)) break block11;
                        bufferedImage = ir.readThumbnail(minIndex, minIndex);
                        var7_10 = null;
                        if (iis == null) return bufferedImage;
                    }
                    catch (RuntimeException ex) {
                        System.err.println("Caught " + ex + " for " + this.file + ":");
                        ex.printStackTrace(System.err);
                        var7_10 = null;
                        if (iis == null) continue;
                        iis.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_10 = null;
                    if (iis == null) throw throwable;
                    iis.close();
                    throw throwable;
                }
                iis.close();
                return bufferedImage;
            }
            var7_10 = null;
            if (iis == null) continue;
            iis.close();
        }
    }

    @Override
    public File getRepresentingImageFile() {
        File thumb;
        VideoProcessor vp;
        if (this.file.exists() && FileFilters.isFileSupported(this.file)) {
            return this.file;
        }
        File cacheFile = this.getCachedThumbnailFile(this.file);
        if (!cacheFile.exists() && (vp = this.factory.engine.getVideoProcessor()).isFormatSupported(this.file)) {
            cacheFile.getParentFile().mkdirs();
            try {
                VideoProcessor.VideoInfo vi = vp.createThumbnailFile(this.file, cacheFile, (TimeCode)this.getProperties().get("videoPosition"));
                Orientation o = vi.orientation;
                if (cacheFile.exists()) {
                    AlbumObjectProperties props = this.getProperties();
                    if (!props.containsKey("orientation")) {
                        props.put("orientation", (Object)o);
                    }
                    if (vi.duration != null) {
                        props.put("videoDuration", vi.duration);
                    }
                    if (vi.fps != null) {
                        props.put("videoFPS", vi.fps);
                    }
                    if (vi.dim != null) {
                        props.put("videoWidth", vi.dim.width);
                        props.put("videoHeight", vi.dim.height);
                    }
                    props.save();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                cacheFile.delete();
            }
            catch (OperationAbortedException operationAbortedException) {
                // empty catch block
            }
        }
        if ((thumb = IO.thumbFile(this.file)).exists()) {
            return thumb;
        }
        if (this.getRepresentingAlbumObject() != null) {
            return this.representingAlbumObject.getRepresentingImageFile();
        }
        if (this.isFolder()) {
            return null;
        }
        if (cacheFile.exists()) {
            return cacheFile;
        }
        return null;
    }

    @Override
    public void setRepresentingAlbumObject(AlbumObject rep) {
        try {
            AlbumObject oldRep = this.getRepresentingAlbumObject();
            Map props = this.getFolderProperties();
            this.representingAlbumObject = null;
            if (rep == null) {
                props.remove("folderIcon");
            } else {
                String path = IO.relativePath(rep.getPathFromRoot(), this.getPathFromRoot());
                props.put("folderIcon", path);
            }
            this.setFolderProperties(props);
            this.representingAlbumObject = this.getRepresentingAlbumObject();
            this.updateRepresentingIcon();
            this.firePropertyChange("representingAlbumObject", oldRep, this.representingAlbumObject);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public String getThumbnailPath() {
        AlbumObject rep = AlbumObjectImpl.getRepresentingAlbumObject(this, true);
        if (rep != null) {
            String name;
            String pathFromRoot = rep.getPathFromRoot();
            String path = "";
            int slashIndex = pathFromRoot.lastIndexOf(47);
            if (slashIndex == -1) {
                name = pathFromRoot;
            } else {
                path = pathFromRoot.substring(0, slashIndex);
                name = pathFromRoot.substring(slashIndex + 1);
            }
            path = IO.combinePaths(path, this.factory.engine.getThumbnailDirectory());
            path = IO.combinePaths(path, this.factory.engine.getThumbnailPrefix() + this.factory.engine.getTargetName(name));
            return path;
        }
        return null;
    }

    public static ImageIcon scaleToFit(ImageIcon ii, Dimension boundingBox, boolean enlarge) {
        int width = ii.getIconWidth();
        int height = ii.getIconHeight();
        if (!enlarge && width <= boundingBox.width && height <= boundingBox.height) {
            return ii;
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        BufferedImage scaled = AlbumObjectImpl.ensureBuffered(ii.getImage(), width, height);
        scaled = GraphicsUtilities.getFasterScaledInstance(scaled, newWidth, newHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
        return new ImageIcon(scaled);
    }

    private static BufferedImage ensureBuffered(ImageIcon ii) {
        return AlbumObjectImpl.ensureBuffered(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
    }

    private static BufferedImage ensureBuffered(Image img, int iw, int ih) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(iw, ih, 6);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AlbumObject)) {
            return false;
        }
        AlbumObjectImpl otherAO = (AlbumObjectImpl)o;
        return this.getName().equals(otherAO.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(this, propertyName, oldValue, newValue);
    }

    static void setComment(String comment, File file, File oldFile) {
        boolean done = false;
        try {
            Map<String, String> map;
            File oldMapFile = new File(AlbumObjectImpl.getAlbumParentFile(oldFile), COMMENTS_FILE_NAME);
            File newMapFile = new File(AlbumObjectImpl.getAlbumParentFile(file), COMMENTS_FILE_NAME);
            if (oldMapFile.exists()) {
                map = IO.readMapFile(oldMapFile);
                if (oldFile != null) {
                    map.remove(oldFile.getName());
                }
                if (newMapFile.equals(oldMapFile)) {
                    if (comment.length() > 0) {
                        map.put(file.getName(), comment);
                    } else {
                        map.remove(file.getName());
                    }
                    done = true;
                }
                IO.writeMapFile(map, oldMapFile);
                if (done) {
                    return;
                }
            }
            map = new HashMap();
            if (newMapFile.exists()) {
                map = IO.readMapFile(newMapFile);
            }
            if (comment.length() > 0) {
                map.put(file.getName(), comment);
            } else {
                map.remove(file.getName());
            }
            IO.writeMapFile(map, newMapFile);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private Map getFolderProperties() throws IOException {
        return AlbumBean.getFolderProperties(this.file);
    }

    private void setFolderProperties(Map properties) throws IOException {
        this.getChildren();
        IO.writeMapFile(properties, new File(this.file, META_FILE_NAME));
        this.lastRefreshed = System.currentTimeMillis();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor element : flavors) {
            if (!flavor.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(flavors[0])) {
            return this;
        }
        if (flavor.equals(flavors[1])) {
            return new File[]{this.file};
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void setRepresentingIcon(BufferedImage thumbnail, boolean changed) throws IOException {
        if (this.factory.isCacheThumbnails()) {
            File thumbnailFile = this.getCachedThumbnailFile(this.file);
            thumbnailFile.getParentFile().mkdirs();
            FileFilters.saveJPEG(thumbnail, thumbnailFile, this.factory.engine);
            this.thumbnailCache.clear();
        }
        if (changed) {
            this.firePropertyChange("imageUpdated", null, null);
        }
    }

    @Override
    public void updateRepresentingIcon() {
        this.thumbnailCache.clear();
        this.firePropertyChange("imageUpdated", null, null);
    }

    static File getCacheFolder(File f) {
        return new File(AlbumObjectImpl.getJAlbumFolder(f), CACHE_FOLDER);
    }

    private File getCachedThumbnailFile(File f) {
        return new File(AlbumObjectImpl.getCacheFolder(f), this.factory.engine.getTargetName(f.getName()));
    }

    static File getAlbumParentFile(File f) {
        return f instanceof LinkFile ? ((LinkFile)f).getLink().getParentFile() : f.getParentFile();
    }

    static File getJAlbumFolder(File f) {
        return new File(AlbumObjectImpl.getAlbumParentFile(f), JALBUM_FOLDER_NAME);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        System.out.println("Read object called");
        ois.defaultReadObject();
        this.factory = JAlbumContext.getInstance().getAlbumObjectfactory();
        this.orderer = new AlbumObjectOrderer(this);
        this.thumbnailCache = new ThumbnailCache();
    }

    @Override
    public Scope getVars() {
        if (this.vars == null && this.getParent() != null) {
            this.vars = new Scope(this.factory.engine.globalVariables);
            this.factory.engine.fileVariables.put(this.file, this.vars);
            try {
                this.factory.engine.registerVariables(this, new File(this.factory.engine.getInterpretedOutputDirectory(), this.getParent().getPathFromRoot()), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot register variables for " + this.getName(), ex);
            }
        }
        return this.vars;
    }

    @Override
    public void setVars(Scope vars) {
        this.vars = vars;
    }

    private static class ThumbnailCache {
        ImageIcon icon;
        Dimension bounds;
        boolean cropToBounds;

        private ThumbnailCache() {
        }

        void update(ImageIcon icon, Dimension bounds, boolean cropToBounds) {
            this.icon = icon;
            this.bounds = bounds;
            this.cropToBounds = cropToBounds;
        }

        ImageIcon getIcon(Dimension bounds, boolean cropToBounds) {
            if (this.icon != null && this.bounds.equals(bounds) && this.cropToBounds == cropToBounds) {
                return this.icon;
            }
            return null;
        }

        private void clear() {
            this.icon = null;
        }
    }
}

