/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileCollection
implements Serializable {
    public static final String META_FILE_NAME = "meta.properties";
    AlbumBean engine;
    File baseDir;
    File albumfilesFile;
    Set<String> excluded = new HashSet<String>();
    private final Pattern tabDelim = Pattern.compile("\t");

    public FileCollection(AlbumBean engine, File baseDir) {
        this.engine = engine;
        this.baseDir = baseDir;
        this.albumfilesFile = new File(baseDir, "albumfiles.txt");
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    private File getFile(String line, Map<String, File> existing) {
        StringTokenizer tokens = new StringTokenizer(line, "\t");
        String fileName = tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            String targetPath = tokens.nextToken();
            if (fileName.startsWith("-")) {
                targetPath = "-" + targetPath;
            }
            if (Platform.isWindows() && targetPath.indexOf(47) != -1) {
                targetPath = targetPath.replace('/', File.separatorChar);
            } else if (targetPath.indexOf(92) != -1) {
                targetPath = targetPath.replace('\\', File.separatorChar);
            }
            File found = existing.get(fileName.toLowerCase());
            if (found != null) {
                return found;
            }
            return new LinkFile(this.baseDir, fileName, new CachedFile(targetPath));
        }
        File f = new CachedFile(fileName);
        if (!f.isAbsolute()) {
            f = new CachedFile(this.baseDir, fileName);
            File found = existing.get(fileName.toLowerCase());
            if (found != null) {
                f = found;
            }
            return f;
        }
        return new LinkFile(this.baseDir, f.getName(), f);
    }

    private File getFile(String[] cols, Map<String, File> existing) {
        String fileName = cols[0];
        if (cols.length > 1 && cols[1].length() > 0) {
            String targetPath = cols[1];
            if (fileName.startsWith("-")) {
                targetPath = "-" + targetPath;
            }
            if (Platform.isWindows() && targetPath.indexOf(47) != -1) {
                targetPath = targetPath.replace('/', File.separatorChar);
            } else if (targetPath.indexOf(92) != -1) {
                targetPath = targetPath.replace('\\', File.separatorChar);
            }
            File found = existing.get(fileName.toLowerCase());
            if (found != null) {
                return found;
            }
            return new LinkFile(this.baseDir, fileName, new CachedFile(targetPath));
        }
        File f = new CachedFile(fileName);
        if (!f.isAbsolute()) {
            f = new CachedFile(this.baseDir, fileName);
            File found = existing.get(fileName.toLowerCase());
            if (found != null) {
                f = found;
            }
            return f;
        }
        return new LinkFile(this.baseDir, f.getName(), f);
    }

    public File[] listFiles(FileFilter ff) {
        return this.listFiles(ff, false);
    }

    public File[] listFiles(FileFilter ff, boolean includeExcluded) {
        return this.listFiles(ff, includeExcluded, false);
    }

    public File[] listFiles(FileFilter ff, boolean includeExcluded, boolean includeMissing) {
        File[] content = CachedFile.listFiles(this.baseDir, ff);
        if (!this.albumfilesFile.exists()) {
            return content;
        }
        HashMap<String, File> existing = this.mapFiles(content);
        try {
            String line;
            this.excluded = new HashSet<String>();
            LinkedHashMap<String, File> list = new LinkedHashMap<String, File>();
            String text = IO.readTextFile(this.albumfilesFile);
            BufferedReader reader = new BufferedReader(new StringReader(text));
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#' || line.equals("and the path to the right is the target path.")) continue;
                File f = this.getFile(line, existing);
                if ("true".equals(System.getProperty("blockLinks", "false")) && f instanceof LinkFile) continue;
                if (line.startsWith("-") && !f.exists()) {
                    f = this.getFile(line.substring(1), existing);
                    this.excluded.add(f.getName());
                    if (!includeExcluded || (!includeMissing || !(f instanceof LinkFile)) && !f.exists() || !ff.accept(f)) continue;
                    list.put(f.getName(), f);
                    continue;
                }
                if ((!includeMissing || !(f instanceof LinkFile)) && !f.exists() || !ff.accept(f)) continue;
                list.put(f.getName(), f);
            }
            for (File f : content) {
                if (!list.containsKey(f.getName()) && this.engine.isExcludeByDefault()) {
                    this.excluded.add(f.getName());
                }
                if (!includeExcluded && this.excluded.contains(f.getName())) continue;
                list.put(f.getName(), f);
            }
            File[] files = list.values().toArray(new File[list.size()]);
            return files;
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            throw new RuntimeException(ex.toString());
        }
    }

    public Collection<FileEntry> listEntries(FileFilter ff, boolean includeExcluded, boolean includeMissing) {
        try {
            this.excluded = new HashSet<String>();
            File[] content = CachedFile.listFiles(this.baseDir, ff);
            LinkedHashMap<String, FileEntry> list = new LinkedHashMap<String, FileEntry>();
            if (this.albumfilesFile.exists()) {
                String line;
                HashMap<String, File> existing = this.mapFiles(content);
                String text = IO.readTextFile(this.albumfilesFile);
                BufferedReader reader = new BufferedReader(new StringReader(text));
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0 || line.charAt(0) == '#' || line.equals("and the path to the right is the target path.")) continue;
                    String[] cols = this.tabDelim.split(line);
                    File f = this.getFile(cols, existing);
                    FileEntry fe = new FileEntry(f);
                    if (cols.length >= 3) {
                        try {
                            fe.whenAdded = this.ensureMillis(Long.parseLong(cols[2]));
                        }
                        catch (NumberFormatException ex) {
                            fe.whenAdded = f.lastModified();
                        }
                    } else {
                        fe.whenAdded = f.lastModified();
                    }
                    if ("true".equals(System.getProperty("blockLinks", "false")) && f instanceof LinkFile) continue;
                    if (line.startsWith("-") && !f.exists()) {
                        cols = this.tabDelim.split(line.substring(1));
                        fe.file = f = this.getFile(cols, existing);
                        this.excluded.add(f.getName());
                        fe.excluded = true;
                        if (!includeExcluded || (!includeMissing || !(f instanceof LinkFile)) && !f.exists() || !ff.accept(f)) continue;
                        list.put(f.getName(), fe);
                        continue;
                    }
                    if ((!includeMissing || !(f instanceof LinkFile)) && !f.exists() || !ff.accept(f)) continue;
                    list.put(f.getName(), fe);
                }
            }
            for (File f : content) {
                FileEntry fe = (FileEntry)list.get(f.getName());
                if (fe == null && this.engine.isExcludeByDefault()) {
                    this.excluded.add(f.getName());
                    fe = new FileEntry(f);
                    fe.excluded = true;
                }
                if (!includeExcluded && this.excluded.contains(f.getName())) continue;
                if (fe == null) {
                    fe = new FileEntry(f);
                }
                list.put(f.getName(), fe);
            }
            return list.values();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            throw new RuntimeException(ex.toString());
        }
    }

    public boolean isExcluded(File f) {
        return this.excluded.contains(f.getName());
    }

    private Long ensureMillis(long whenAdded) {
        if (whenAdded > 100000000000L) {
            return whenAdded;
        }
        return whenAdded * 1000L;
    }

    private HashMap<String, File> mapFiles(File[] content) {
        HashMap<String, File> map = new HashMap<String, File>();
        for (File f : content) {
            map.put(f.getName().toLowerCase(), f);
        }
        return map;
    }

    static class FileEntry {
        File file;
        Long whenAdded;
        boolean excluded;

        public FileEntry(File file) {
            this.file = file;
        }

        public FileEntry(File file, Long whenAdded, boolean excluded) {
            this.file = file;
            this.whenAdded = whenAdded;
            this.excluded = excluded;
        }
    }
}

