/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingworker.SwingWorker;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.Debug;
import se.datadosen.util.Multilingual;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JAccountStatusPanel
extends JComponent {
    private static final Font panelFont = new Font("SansSerif", 0, 11);
    final JAlbumContext context;
    private AccountManager.AccountStatus accountStatus;
    @Text(value="ui.jAlbumStorage", postfix=":  ")
    private JLabel jAlbumStorageLabel = new JLabel();
    @Text(value="ui.upgrade")
    @ToolTipText(value="ui.upgradeStorage")
    private JLinkLabel upgradeStorageLink = new JLinkLabel("", "");
    private JProgressSpinner updateSpinner = new JProgressSpinner(16);
    @ToolTipText(value="ui.gotojAlbumPage")
    private JAccountStatusMeter meter;
    @Text(value="ui.upgradeStorage")
    Action upgradeStorageAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            try {
                SignInManager mgr = SignInManager.getInstance();
                String userName = mgr.getUserName();
                if (userName == null) {
                    return;
                }
                String upgradeURL = JAlbumSite.getInstance().getMyJAlbumUpgradeUrl() + "/?utm_source=client&utm_medium=upgradeStorageAction&utm_campaign=accountStatusPanel&referrer=jalbumStatusBar&cid=" + AccountManager.getCid(userName, mgr.getPassword());
                BrowserLauncher.openURL(upgradeURL);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
        }
    };
    Action gotoSiteAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            try {
                SignInManager mgr = SignInManager.getInstance();
                String userName = mgr.getUserName();
                if (userName == null) {
                    return;
                }
                String siteURL = JAlbumSite.getInstance().getHomeUrl() + "/users/" + userName + "/?utm_source=client&utm_medium=gotoSiteAction&utm_campaign=accountStatusPanel&referrer=jalbumStatusBar&cid=" + AccountManager.getCid(userName, mgr.getPassword());
                BrowserLauncher.openURL(siteURL);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.out);
            }
        }
    };
    @Text(value="edit.update")
    Action updateAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            JAccountStatusPanel.this.updateSpinner.setVisible(true);
            new SwingWorker<AccountManager.AccountStatus, Object>(){

                protected AccountManager.AccountStatus doInBackground() throws Exception {
                    SignInManager mgr = SignInManager.getInstance();
                    if (!mgr.isSignedIn()) {
                        throw new RuntimeException("Not signed in");
                    }
                    return AccountManager.getJalbumAccountQuota(mgr.getUserName(), mgr.getPassword());
                }

                protected void done() {
                    try {
                        AccountManager.AccountStatus status = (AccountManager.AccountStatus)this.get();
                        JAccountStatusPanel.this.setStatus(status);
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (ExecutionException ex) {
                        Debug.showErrorDialog(JAccountStatusPanel.this, ex.getCause());
                    }
                    JAccountStatusPanel.this.updateAction.setEnabled(true);
                    JAccountStatusPanel.this.updateSpinner.setVisible(false);
                }
            }.execute();
        }
    };

    public void setStatus(AccountManager.AccountStatus accountStatus) {
        this.accountStatus = accountStatus;
        String usage = (String)accountStatus.get("usage");
        String quota = (String)accountStatus.get("quota");
        if (usage != null && quota != null) {
            this.setValues(new Long(usage), new Long(quota));
        } else {
            this.setValues(null, null);
        }
    }

    public AccountManager.AccountStatus getStatus() {
        return this.accountStatus;
    }

    private void setValues(Long used, Long quota) {
        this.meter.used = used;
        this.meter.quota = quota;
        this.meter.setTexts();
        this.repaint();
    }

    public JAccountStatusPanel(JAlbumContext context) {
        this.context = context;
        this.meter = new JAccountStatusMeter();
        Msg.maintainTranslated(this);
        this.setLayout(new BoxLayout(this, 0));
        this.jAlbumStorageLabel.setFont(panelFont);
        this.upgradeStorageLink.setFont(panelFont);
        this.upgradeStorageLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JAccountStatusPanel.this.upgradeStorageAction.actionPerformed(e);
            }
        });
        this.updateSpinner.setVisible(false);
        this.add(this.updateSpinner);
        this.add(this.jAlbumStorageLabel);
        this.add(this.meter);
        this.add(Box.createHorizontalStrut(6));
        this.add(this.upgradeStorageLink);
        this.add(Box.createHorizontalStrut(6));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.meter.setVisible(visible);
    }

    private static Color rainbow(float ratio) {
        Color green = new Color(0, 180, 0, 100);
        Color yellow = JAccountStatusPanel.dilute(Color.yellow, 0.3f);
        Color red = JAccountStatusPanel.dilute(Color.red, 0.8f);
        float threshold = 0.5f;
        if (ratio < threshold) {
            return green;
        }
        if ((double)(ratio = (ratio - threshold) / (1.0f - threshold)) < 0.5) {
            return JAccountStatusPanel.mix(green, yellow, ratio * 2.0f);
        }
        return JAccountStatusPanel.mix(yellow, red, (ratio - 0.5f) * 2.0f);
    }

    private static Color mix(Color c1, Color c2, float balance) {
        float invBal = 1.0f - balance;
        return new Color((int)((float)c1.getRed() * invBal + (float)c2.getRed() * balance), (int)((float)c1.getGreen() * invBal + (float)c2.getGreen() * balance), (int)((float)c1.getBlue() * invBal + (float)c2.getBlue() * balance), (int)((float)c1.getAlpha() * invBal + (float)c2.getAlpha() * balance));
    }

    private static Color dilute(Color c, float amount) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)((float)c.getAlpha() * (1.0f - amount)));
    }

    private static Color darker(Color c) {
        float FACTOR = 0.6f;
        return new Color((int)((float)c.getRed() * FACTOR), (int)((float)c.getGreen() * FACTOR), (int)((float)c.getBlue() * FACTOR), 150);
    }

    private class JAccountStatusMeter
    extends JComponent
    implements Multilingual {
        private JLabel accountStatusLabel = new JLabel();
        private Long used = null;
        private Long quota = null;
        private DecimalFormat formatter = new DecimalFormat("0.0");
        private float alpha = 1.0f;

        public JAccountStatusMeter() {
            this.init();
        }

        private void init() {
            Msg.maintainTranslated(this);
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    AccountProfile account;
                    String userName = SignInManager.getInstance().getUserName();
                    if (userName != null && (account = AccountManager.getInstance().findJAlbumAccountByUserName(userName)) != null) {
                        JAccountStatusPanel.this.gotoSiteAction.setEnabled(true);
                        JAccountStatusPanel.this.gotoSiteAction.putValue("Name", Msg.get("share.gotoURL") + " " + account.getFtpServer());
                        return;
                    }
                    JAccountStatusPanel.this.gotoSiteAction.setEnabled(false);
                    JAccountStatusPanel.this.gotoSiteAction.putValue("Name", "No account activated");
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            popupMenu.add(JAccountStatusPanel.this.gotoSiteAction);
            popupMenu.add(JAccountStatusPanel.this.upgradeStorageAction);
            popupMenu.addSeparator();
            popupMenu.add(JAccountStatusPanel.this.updateAction);
            this.setComponentPopupMenu(popupMenu);
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        JAccountStatusPanel.this.gotoSiteAction.actionPerformed(null);
                    }
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                    JAccountStatusMeter.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                public void mouseExited(MouseEvent e) {
                    JAccountStatusMeter.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            this.accountStatusLabel.setFont(panelFont);
            this.setTexts();
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            JAccountStatusPanel.this.updateSpinner.setVisible(false);
            this.add((Component)JAccountStatusPanel.this.jAlbumStorageLabel, "West");
            this.add((Component)this.accountStatusLabel, "Center");
        }

        private void setTexts() {
            this.accountStatusLabel.setText(Msg.get("publish.quotaInfo", this.formatUsed(), this.formatQuota()));
        }

        private String formatUsed() {
            if (this.used == null) {
                return "--";
            }
            return this.formatter.format(this.used.floatValue() / 1024.0f);
        }

        private String formatQuota() {
            if (this.quota == null) {
                return "--";
            }
            return "" + this.quota / 1024L;
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.alpha = 0.0f;
            }
            super.setVisible(visible);
            if (visible) {
                new Thread("animator"){

                    public void run() {
                        try {
                            JAccountStatusMeter.this.alpha = 0.0f;
                            while (JAccountStatusMeter.this.alpha <= 1.0f) {
                                3.sleep(30L);
                                JAccountStatusMeter.this.repaint();
                                JAccountStatusMeter.this.alpha += 0.08f;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }

        protected void paintComponent(Graphics g2) {
            Graphics2D g = (Graphics2D)g2;
            if (this.alpha < 0.0f) {
                this.alpha = 0.0f;
            } else if (this.alpha > 1.0f) {
                this.alpha = 1.0f;
            }
            AlphaComposite composite = AlphaComposite.getInstance(3, this.alpha);
            g.setComposite(composite);
            g.setPaint(new GradientPaint(new Point(0, 0), Color.white, new Point(0, 8), Color.white.darker(), true));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.used != null && this.quota != null) {
                try {
                    float ratio = this.used.floatValue() / this.quota.floatValue();
                    if (ratio > 1.0f) {
                        ratio = 1.0f;
                    }
                    Color c = JAccountStatusPanel.rainbow(ratio);
                    g.setPaint(new GradientPaint(new Point(0, 0), c, new Point(0, 8), JAccountStatusPanel.darker(c), true));
                    g.fillRect(0, 0, (int)((float)this.getWidth() * ratio), this.getHeight());
                }
                catch (ArithmeticException ex) {
                    // empty catch block
                }
            }
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            super.paintComponent(g);
        }

        public void languageUpdated() {
            this.setTexts();
        }
    }
}

