/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.incors.plaf.alloy.AlloyLookAndFeel;
import edu.stanford.ejalbert.BrowserLauncher;
import java.beans.Beans;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.jdic.init.JdicManager;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumConsole;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.SplashScreen;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.Timer;
import se.datadosen.util.WinRegistry;

public class JAlbum {
    public static Logger logger = Logger.getLogger("jalbum");
    public static JAlbumFrame mainFrame = null;
    public static final Object initializedOkMonitor = new Object();
    static boolean initialized = false;
    private static Map globals = new HashMap();
    private static PrintStream err = System.err;
    private JAlbumAdapter dummyAdapter;
    private Timer dummyTimer;

    public static void dumpThreads() {
        try {
            File logFile = new File(MiniConfig.getMiniConfig().configDir, "thread-dump.txt");
            PrintWriter log = new PrintWriter(new BufferedWriter(new FileWriter(logFile)));
            Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> threadEntry : threads.entrySet()) {
                log.println(threadEntry.getKey());
                for (StackTraceElement el : threadEntry.getValue()) {
                    log.println(el);
                }
                log.println("");
            }
            log.close();
            JOptionPane.showMessageDialog(JAlbumContext.getInstance().getFrame(), "Full thread dump saved to thread-dump.txt");
            BrowserLauncher.showInFileSystem(logFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAlbum(String[] args) {
        SplashScreen splash = new SplashScreen();
        splash.setVisible(true);
        splash.toFront();
        Object object = initializedOkMonitor;
        synchronized (object) {
            File projectFile = null;
            if (args.length > 0) {
                projectFile = new File(args[0]);
            }
            PluginManager.loadPlugins();
            mainFrame = new JAlbumFrame(projectFile);
            PluginManager.initPlugins();
            File onStart = new File(Config.getConfig().progDir, "system/onstart.bsh");
            splash.setVisible(false);
            mainFrame.setResizable(true);
            mainFrame.packThis();
            mainFrame.validate();
            mainFrame.setVisible(true);
            mainFrame.toFront();
            initialized = true;
            if (onStart.exists()) {
                mainFrame.executeScript(onStart);
            }
            this.launchOnStartCode();
        }
    }

    public static Object getGlobal(Object key) {
        return globals.get(key);
    }

    public static Object setGlobal(Object key, Object value) {
        return globals.put(key, value);
    }

    public static long getGUID() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(JAlbum.class);
            return Long.valueOf(prefs.get("guid", "0"));
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public static boolean isUsingAlloyLAF() {
        return UIManager.getLookAndFeel().getClass().getName().indexOf("Alloy") >= 0;
    }

    public static boolean isUsingSystemLAF() {
        return UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName());
    }

    public static void main(String[] args) {
        block35: {
            File defaultProjectFile = Config.getConfigFile("defaults.jap", ".jalbum-defaults.jap");
            try {
                boolean explicitLookAndFeel = false;
                try {
                    Preferences prefs = Preferences.userNodeForPackage(JAlbum.class);
                    String guid = prefs.get("guid", null);
                    if (guid == null) {
                        guid = String.valueOf(System.currentTimeMillis());
                        prefs.put("guid", guid);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    JdicManager jm = JdicManager.getManager();
                    jm.initShareNative();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                System.setProperty("jalbum.file.encoding", System.getProperty("file.encoding"));
                if ("MacRoman".equals(System.getProperty("jalbum.file.encoding"))) {
                    System.setProperty("jalbum.file.encoding", "ISO-8859-1");
                }
                Config config = Config.getConfig();
                if (defaultProjectFile.exists()) {
                    Properties props = IO.readPropertyFile(defaultProjectFile);
                    try {
                        BeanBinder.setProperties((Object)config, props);
                    }
                    catch (BeanBinderException ex) {
                        ex.printStackTrace(System.err);
                    }
                    if (props.containsKey("lookAndFeel")) {
                        explicitLookAndFeel = true;
                    }
                    if (!props.containsKey("showPreviewInfoBar")) {
                        config.setShowInfoBarInPreview(false);
                    }
                }
                if (Platform.isMac() || Platform.isLinux()) {
                    File desktopDir;
                    File userHomeDir = new File(System.getProperty("user.home"));
                    File myPicturesDir = new File(userHomeDir, "Pictures");
                    if (myPicturesDir.exists()) {
                        System.setProperty("my.pictures.path", myPicturesDir.getAbsolutePath());
                    }
                    if ((desktopDir = new File(userHomeDir, "Desktop")).exists()) {
                        System.setProperty("desktop.path", desktopDir.getAbsolutePath());
                    }
                }
                if (Platform.isMac()) {
                    try {
                        Beans.instantiate(JAlbum.class.getClassLoader(), "se.datadosen.jalbum.SpecialMacHandler");
                    }
                    catch (ClassNotFoundException e) {
                        err.println("Error: Failed to load extended Mac support...");
                        e.printStackTrace(err);
                    }
                } else if (Platform.isWindows()) {
                    try {
                        JAlbum.setShellFolderAsSystemProperty("My Pictures", "my.pictures.path");
                        JAlbum.setShellFolderAsSystemProperty("Desktop", "desktop.path");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(err);
                    }
                } else if (Platform.isLinux()) {
                    // empty if block
                }
                if (config.getLookAndFeel().equals("com.incors.plaf.alloy.AlloyLookAndFeel")) {
                    ImageIcon expandedIcon = new ImageIcon(JAlbumExplorer.class.getResource("images/tree_expanded.png"));
                    ImageIcon collapsedIcon = new ImageIcon(JAlbumExplorer.class.getResource("images/tree_collapsed.png"));
                    UIManager.getDefaults().put("Tree.expandedIcon", expandedIcon);
                    UIManager.getDefaults().put("Tree.collapsedIcon", collapsedIcon);
                }
                Properties commandLineProperties = BeanBinder.parseArgsOptions(args);
                BeanBinder.setProperties((Object)Config.getConfig(), commandLineProperties);
                SmartResourceBundle.getBundle(config.progDir, "texts/texts");
                if (commandLineProperties.size() > 0 && !commandLineProperties.containsKey("ui")) {
                    Stopwatch timer = new Stopwatch();
                    timer.start();
                    new JAlbumConsole(commandLineProperties);
                    System.out.println("Elapsed time: " + timer);
                    System.exit(0);
                    break block35;
                }
                AlloyLookAndFeel.setProperty((String)"alloy.licenseCode", (String)"x#David_Ekholm#y9qpca#do9gyo");
                try {
                    UIManager.setLookAndFeel(config.getLookAndFeel());
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace(err);
                }
                catch (UnsupportedLookAndFeelException ex) {
                    // empty catch block
                }
                if (args.length > 0 && args[0].endsWith(".jaskin")) {
                    SkinManager sm = new SkinManager();
                    sm.installSkin(new File(args[0]));
                } else if (args.length > 0 && args[0].endsWith(".jaext")) {
                    PluginManager.installPlugin(new File(args[0]));
                } else {
                    new JAlbum(args);
                }
            }
            catch (MissingResourceException ex) {
                ex.printStackTrace(System.out);
                err.println("JAlbum: Cannot locate resources. Either set -programDirectory to JAlbum install directory or run JAlbum from its install directory.");
            }
            catch (Throwable e) {
                e.printStackTrace(err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secondaryMain(final String[] args) {
        JAlbum.ensureGuiStarted();
        Object object = initializedOkMonitor;
        synchronized (object) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    mainFrame.setExtendedState(0);
                    mainFrame.toFront();
                    if (args[0].length() > 0) {
                        if (args[0].endsWith(".jaskin")) {
                            new SkinManager().installSkin(new File(args[0]));
                        } else if (args[0].endsWith(".jaext")) {
                            PluginManager.installPlugin(new File(args[0]));
                        } else {
                            ArrayList<File> files = new ArrayList<File>();
                            for (String s : args) {
                                files.add(new File(s));
                            }
                            JAlbumContext.getInstance().getFrame().addFiles(files);
                        }
                    }
                }
            });
        }
    }

    private static void ensureGuiStarted() {
        while (!initialized) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void launchOnStartCode() {
        final String onStartCodeUrl = JAlbumSite.getInstance().getOnStartCodeUrl();
        final String onStartCodeClass = JAlbumSite.getInstance().getOnStartCodeClassName();
        if (onStartCodeUrl != null && onStartCodeClass != null) {
            new Thread("onStartCodeThread"){

                public void run() {
                    block2: {
                        try {
                            URLClassLoader cl = new URLClassLoader(new URL[]{new URL(onStartCodeUrl)}, this.getClass().getClassLoader());
                            Class<?> clazz = cl.loadClass(onStartCodeClass);
                            JAlbumPlugin onStartPlugin = (JAlbumPlugin)clazz.newInstance();
                            onStartPlugin.init(JAlbumContext.getInstance().getPluginContext());
                            PluginManager.registerPlugin(onStartPlugin);
                        }
                        catch (Exception ex) {
                            if (!Config.getConfig().isDebugMode()) break block2;
                            ex.printStackTrace(err);
                        }
                    }
                }
            }.start();
        }
    }

    private static void setShellFolderAsSystemProperty(String registryKey, String systemProperty) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String path;
        if (System.getProperty(systemProperty) == null && (path = WinRegistry.readString(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", registryKey)) != null) {
            System.setProperty(systemProperty, path);
        }
    }
}

