/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingworker.SwingWorker;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JSiteButton;
import se.datadosen.component.RoundedLineBorder;
import se.datadosen.dnd.TransferableNode;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileNameDocument;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumInfo;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.RecentProjectFiles;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.util.AliasAction;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Multilingual;
import se.datadosen.util.SlowAction;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JAlbumManager
extends JPanel
implements RecentProjectFiles.Listener,
Multilingual {
    private static final Dimension iconSize = new Dimension(28, 28);
    private static final ImageIcon newAlbumProjectIcon = Icons.getIcon("big.newAlbumProject");
    private final JTree tree;
    private final JAlbumContext context;
    private List<AlbumProject> projects = new ArrayList<AlbumProject>();
    private AlbumProject activeProject;
    public static final AlbumProject emptyProject = new AlbumProject(JAlbumFrame.defaultProjectFile, (AlbumObject)null);
    private final AlbumRootComponent albumRootComponent;
    private final ContentPanel contentPanel;
    private final JPopupMenu albumPopup = new JPopupMenu();
    private final MouseListener openSettingsMouseListener;
    @Text(value="album.info")
    @ToolTipText(value="album.info")
    public Action infoAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.getIcon("small.info"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        }

        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("album info presented");
            JAlbumInfo infoFrame = new JAlbumInfo(JAlbumContext.getInstance(), JAlbumManager.this.activeProject);
            Rectangle b = JAlbumManager.this.albumRootComponent.getBounds();
            Point p = JAlbumManager.this.albumRootComponent.getLocationOnScreen();
            infoFrame.setLocation(p.x + b.width + 20, p.y);
            infoFrame.setVisible(true);
        }
    };
    @Text(value="edit.renameFile", postfix="...")
    public Action renameAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JAlbumManager.this.albumRootComponent.setEditing(true);
        }
    };
    @ToolTipText(value="ui.more")
    private Action moreAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.getIcon("small.more"));
        }

        public void actionPerformed(ActionEvent e) {
            JComponent source = (JComponent)e.getSource();
            JAlbumManager.this.albumPopup.show((JComponent)e.getSource(), 0, source.getHeight());
        }
    };
    @Text(value="album.removeFromList")
    public Action removeFromListAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            AlbumProject oldProject = JAlbumManager.this.activeProject;
            JAlbumFrame window = JAlbumManager.this.context.getFrame();
            if (window.askProjectSave(Msg.get("ui.newProjectMenu"))) {
                if (!oldProject.equals(emptyProject)) {
                    JAlbumManager.this.projects.remove(oldProject);
                }
                RecentProjectFiles.getInstance().removeFile(oldProject.getProjectFile());
                window.markAsClean();
                window.markSkinAsClean();
                window.closeProject();
            }
        }
    };
    @Text(value="album.deletePublishedAlbum", postfix="...")
    public SlowAction deletePublishedAlbumAction = new SlowAction(){

        public void actionPerformed(final ActionEvent e) {
            int selected;
            if (e != null && (selected = JOptionPane.showConfirmDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deletePublishedAlbumInfo"), Msg.get("album.deletePublishedAlbum"), 0, 2)) != 0) {
                return;
            }
            final PropertyChangeListener stateListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() == SwingWorker.StateValue.STARTED) {
                        ((JAlbumManager)JAlbumManager.this).context.getFrame().progressSpinner.workStarted();
                    }
                }
            };
            final AlbumBean engineClone = JAlbumManager.this.context.getEngine().clone();
            new SwingWorker<Object, String>(){
                {
                    this.addPropertyChangeListener(stateListener);
                    if (this.getStateListener() != null) {
                        this.addPropertyChangeListener(this.getStateListener());
                    }
                }

                protected void process(List<String> chunks) {
                    ((JAlbumManager)JAlbumManager.this).context.getFrame().statusBar.setText(chunks.get(chunks.size() - 1));
                }

                protected void done() {
                    block3: {
                        ((JAlbumManager)JAlbumManager.this).context.getFrame().progressSpinner.workDone();
                        try {
                            this.get();
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace(System.err);
                        }
                        catch (ExecutionException ex) {
                            ((JAlbumManager)JAlbumManager.this).context.getFrame().statusBar.setText("");
                            Throwable cause = ex.getCause();
                            if (e == null) break block3;
                            int messageType = cause instanceof InformationException ? 1 : 0;
                            JOptionPane.showMessageDialog(JAlbumManager.this.context.getFrame(), cause.getMessage(), Msg.get("album.deletePublishedAlbum"), messageType);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object doInBackground() throws Exception {
                    AccountProfile account;
                    String accountProfileName = (String)JAlbumManager.this.activeProject.getRootFolder().getProperties().get("accountProfileName");
                    if (accountProfileName == null) {
                        accountProfileName = engineClone.getAccountProfileName();
                    }
                    if ((account = AccountManager.getInstance().findAccountByName(accountProfileName)) == null) {
                        account = AccountManager.getInstance().getFirstMyjalbumAccount();
                    }
                    if (account == null) {
                        throw new InformationException(Msg.get("ui.notPublished"));
                    }
                    UploadBean uploadBean = new UploadBean();
                    this.publish(new String[]{Msg.get("ui.connectingToServer") + " " + account.getFtpServer() + "..."});
                    try {
                        uploadBean.setAccountProperties(account);
                        uploadBean.connect();
                        this.publish(new String[]{Msg.get("ui.locatingPublishedAlbum") + "..."});
                        UploadBean.PathFinder pathFinder = uploadBean.getPathFinder(JAlbumManager.this.activeProject.getRootFolder(), engineClone);
                        if (!pathFinder.albumExists() || pathFinder.getResolvedRemoteDirectory().equals(pathFinder.resolvedWebRootDirectory)) {
                            throw new InformationException(Msg.get("ui.notPublishedTo", pathFinder.getResolvedAlbumURL()));
                        }
                        this.publish(new String[]{Msg.get("ui.deletingPublishedAlbum") + "..."});
                        uploadBean.deleteAlbum(JAlbumManager.this.activeProject.getRootFolder(), pathFinder.getResolvedRemoteDirectory());
                        try {
                            Notifier notifier = new Notifier(JAlbumManager.this.context);
                            if (notifier.allowedToNotify(account)) {
                                this.publish(new String[]{Msg.get("publish.updatingProfilePage") + "..."});
                                notifier.albumDeleted(account, pathFinder.getResolvedAlbumURL());
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        this.publish(new String[]{Msg.get("edit.doneInfo")});
                        Object var5_5 = null;
                        Object var7_7 = null;
                        uploadBean.disconnect();
                        return var5_5;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        uploadBean.disconnect();
                        throw throwable;
                    }
                }
            }.execute();
        }
    };
    @Text(value="album.deleteLocalAlbum", postfix="...")
    public SlowAction deleteLocalAlbumAction = new SlowAction(){

        public void actionPerformed(ActionEvent e) {
            int selected;
            File projectDir = JAlbumManager.this.activeProject.getProjectFile().getParentFile();
            final File outputDir = JAlbumManager.this.context.getEngine().getInterpretedOutputDirectory();
            if (e != null && !IO.isSubdirectoryOf(outputDir, projectDir)) {
                int selected2 = JOptionPane.showOptionDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deleteLocalAlbumSafetyInfo"), Msg.get("album.deleteLocalAlbum"), 0, 1, null, new Object[]{Msg.get("close"), Msg.get("ui.openFolder")}, Msg.get("ui.openFolder"));
                if (selected2 == 1) {
                    try {
                        BrowserLauncher.openLocal(outputDir);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
            if (e != null && (selected = JOptionPane.showConfirmDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deleteLocalAlbumInfo", outputDir), Msg.get("album.deleteLocalAlbum"), 0, 2)) != 0) {
                return;
            }
            ((JAlbumManager)JAlbumManager.this).context.getFrame().progressSpinner.workStarted();
            new SwingWorker<Object, String>(){
                {
                    if (this.getStateListener() != null) {
                        this.addPropertyChangeListener(this.getStateListener());
                    }
                }

                protected Object doInBackground() throws Exception {
                    this.publish(new String[]{Msg.get("ui.deleting", outputDir) + "..."});
                    IO.deleteDir(outputDir);
                    return null;
                }

                protected void process(List<String> chunks) {
                    ((JAlbumManager)JAlbumManager.this).context.getFrame().statusBar.setText(chunks.get(0));
                }

                protected void done() {
                    ((JAlbumManager)JAlbumManager.this).context.getFrame().statusBar.setText(Msg.get("edit.doneInfo"));
                    ((JAlbumManager)JAlbumManager.this).context.getFrame().progressSpinner.workDone();
                    JAlbumManager.this.context.getFrame().fixUIdisabling();
                }
            }.execute();
        }
    };
    @Text(value="album.deleteEntireProject", postfix="...")
    public Action deleteEntireProjectAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.getIcon("small.delete"));
        }

        public void actionPerformed(ActionEvent e) {
            final File projectDir = JAlbumManager.this.activeProject.getProjectFile().getParentFile();
            File myalbumsDir = new File(Config.getConfig().getMyAlbumsLocation());
            if (e != null && !IO.isSubdirectoryOf(projectDir, myalbumsDir)) {
                int selected = JOptionPane.showOptionDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deleteEntireProjectSafetyInfo"), Msg.get("album.deleteEntireProject"), 0, 1, null, new Object[]{Msg.get("close"), Msg.get("ui.openFolder")}, Msg.get("ui.openFolder"));
                if (selected == 1) {
                    try {
                        BrowserLauncher.openLocal(projectDir);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
            int selected = JOptionPane.showConfirmDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deleteEntireProjectInfo", projectDir), Msg.get("album.deleteEntireProject"), 0, 2);
            if (selected != 0) {
                return;
            }
            JAlbumManager.this.deletePublishedAlbumAction.actionPerformed(null);
            JAlbumManager.this.context.getFrame().markAsClean();
            JAlbumManager.this.context.getFrame().markSkinAsClean();
            ((JAlbumManager)JAlbumManager.this).context.getFrame().progressSpinner.workStarted();
            new SwingWorker<Object, String>(){

                protected Object doInBackground() throws Exception {
                    this.publish(new String[]{Msg.get("ui.deleting", projectDir) + "..."});
                    IO.deleteDir(projectDir);
                    return null;
                }

                protected void process(List<String> chunks) {
                    ((JAlbumManager)JAlbumManager.this).context.getFrame().statusBar.setText(chunks.get(0));
                }

                protected void done() {
                    ((JAlbumManager)JAlbumManager.this).context.getFrame().statusBar.setText(Msg.get("edit.doneInfo"));
                    ((JAlbumManager)JAlbumManager.this).context.getFrame().progressSpinner.workDone();
                    JAlbumManager.this.removeFromListAction.actionPerformed(null);
                }
            }.execute();
        }
    };
    @Text(value="ui.publishToolTip")
    Action publishAction;
    @ToolTipText(value="ui.settings")
    Action settingsAction;
    private JSiteButton previewButton;
    private JSiteButton infoButton;
    private JSiteButton settingsButton;
    private JSiteButton skinSettingsButton;
    @Text(value="edit.delete")
    private JMenu deleteMenu;
    private JButton moreButton;

    public JAlbumManager(JAlbumContext ctx, JTree tree) {
        this.publishAction = new AliasAction(JAlbumContext.getInstance().getFrame().actions.publishAction);
        this.settingsAction = new AliasAction(JAlbumContext.getInstance().getFrame().actions.settingsAction);
        this.deleteMenu = new JMenu();
        this.moreButton = new JPlainButton(this.moreAction);
        Msg.maintainTranslated(this);
        this.context = ctx;
        this.tree = tree;
        this.projects.add(emptyProject);
        this.previewButton = new JSiteButton(this.context.getFrame().actions.viewAlbumAction, false);
        this.infoButton = new JSiteButton(this.infoAction, false);
        this.settingsButton = new JSiteButton(this.settingsAction, false);
        this.skinSettingsButton = new JSiteButton(this.context.getFrame().actions.skinSettingsAction, false);
        Color c = JAlbumColor.albumButtonsBackground;
        this.previewButton.setBackground(c);
        this.infoButton.setBackground(c);
        this.settingsButton.setBackground(c);
        this.skinSettingsButton.setBackground(c);
        this.previewButton.setIcon(Icons.getIcon("small.preview"));
        this.openSettingsMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ((JAlbumManager)JAlbumManager.this).context.getFrame().actions.settingsAction.actionPerformed(null);
                }
                if (e.getSource() instanceof JComponent) {
                    ((JComponent)e.getSource()).requestFocusInWindow();
                }
            }
        };
        this.albumRootComponent = new AlbumRootComponent();
        this.contentPanel = new ContentPanel();
        this.setBackground(SystemColor.text);
        this.setLayout((LayoutManager)new MigLayout("insets 1, gap 0, fillx, wrap 1"));
        this.albumPopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AccountManager mgr = AccountManager.getInstance();
                AccountProfile account = mgr.findCurrentAccount(JAlbumManager.this.context.getEngine());
                if (account != null) {
                    JAlbumManager.this.publishAction.putValue("Name", Msg.get("album.publishTo", account.getFtpServer()) + "...");
                } else {
                    JAlbumManager.this.publishAction.putValue("Name", Msg.get("ui.publish") + "...");
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.albumPopup.add(this.context.getFrame().actions.settingsAction);
        this.albumPopup.add(this.context.getFrame().actions.skinSettingsAction);
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.context.getFrame().actions.makeAction);
        this.albumPopup.add(new AliasAction(this.context.getFrame().actions.viewAlbumAction, (Icon)Icons.getIcon("small.preview")));
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.publishAction);
        this.albumPopup.add(this.context.getFrame().actions.showPublishWindowAction);
        this.albumPopup.add(this.context.getFrame().actions.embedAlbumAction);
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.context.getFrame().actions.closeProjectAction);
        this.albumPopup.addSeparator();
        this.deleteMenu.setIcon(Icons.getIcon("small.delete"));
        this.deleteMenu.add(this.deleteLocalAlbumAction);
        this.deleteMenu.add(this.deletePublishedAlbumAction);
        this.deleteMenu.add(this.deleteEntireProjectAction);
        this.albumPopup.add(this.deleteMenu);
        this.albumPopup.add(this.removeFromListAction);
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.renameAction);
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.infoAction);
        RecentProjectFiles.getInstance().addListener(this);
    }

    public void setActiveAlbumProject(AlbumProject ap) {
        this.addAlbumProject(ap);
        this.activeProject = ap;
        this.albumRootComponent.setAlbumProject(ap);
        this.refresh();
    }

    public void addAlbumProject(AlbumProject album) {
        if (album == null) {
            throw new IllegalArgumentException("Can't add null album");
        }
        if (!this.projects.contains(album)) {
            this.projects.add(this.projects.size() - 1, album);
        }
    }

    public void orderBy(Config.ProjectOrdering ordering) {
        this.projects.remove(emptyProject);
        switch (ordering) {
            case projectsByUse: {
                Collections.sort(this.projects, new Comparator<AlbumProject>(){

                    @Override
                    public int compare(AlbumProject o1, AlbumProject o2) {
                        return o1.getAddedCount() - o2.getAddedCount();
                    }
                });
                break;
            }
            case projectsByName: {
                Collections.sort(this.projects, new Comparator<AlbumProject>(){

                    @Override
                    public int compare(AlbumProject o1, AlbumProject o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                break;
            }
            case projectsByReverseName: {
                Collections.sort(this.projects, new Comparator<AlbumProject>(){

                    @Override
                    public int compare(AlbumProject o1, AlbumProject o2) {
                        return o2.getName().compareToIgnoreCase(o1.getName());
                    }
                });
            }
        }
        this.projects.add(emptyProject);
        this.refresh();
    }

    public AlbumRootComponent getAlbumRootComponent() {
        return this.albumRootComponent;
    }

    public void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JAlbumManager.this.removeAll();
                JAlbumManager.this.contentPanel.refresh();
                String constraint = "grow";
                for (AlbumProject ap : JAlbumManager.this.projects) {
                    if (ap.equals(JAlbumManager.this.activeProject)) {
                        JAlbumManager.this.add((Component)JAlbumManager.this.contentPanel, constraint);
                        continue;
                    }
                    JAlbumManager.this.add((Component)new JAlbumButton(ap), constraint);
                }
                JAlbumManager.this.validate();
                if (!emptyProject.equals(JAlbumManager.this.activeProject)) {
                    JAlbumManager.this.scrollRectToVisible(JAlbumManager.this.contentPanel.getBounds());
                }
                JAlbumManager.this.repaint();
            }
        });
    }

    public void projectFileRenamed(RecentProjectFiles list, File oldName, File newName) {
        for (AlbumProject project : this.projects) {
            if (!project.getProjectFile().equals(oldName)) continue;
            project.setProjectFile(newName);
            project.setRootFolder(this.albumRootComponent.ap.getRootFolder());
            break;
        }
        if (this.activeProject.getProjectFile().equals(oldName)) {
            this.activeProject.setProjectFile(newName);
            this.activeProject.setRootFolder(this.albumRootComponent.ap.getRootFolder());
        }
    }

    public void structureChanged(RecentProjectFiles list) {
    }

    public void languageUpdated() {
        this.refresh();
    }

    class InformationException
    extends Exception {
        public InformationException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JAlbumButton
    extends JSiteButton
    implements ActionListener,
    DropTargetListener {
        AlbumProject album;

        public JAlbumButton(final AlbumProject ap) {
            super(ap.getRootFolder() != null ? ap.getName() : Msg.get("ui.emptyProject"));
            this.album = ap;
            this.setBorderPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
            this.setContentAreaFilled(false);
            this.setHorizontalAlignment(2);
            this.setBackground(JAlbumColor.albumHover);
            this.addActionListener(this);
            if (ap.getRootFolder() != null) {
                new DropTarget(this, 2, this);
            }
            this.setIcon(ap.icon != null ? ap.icon : newAlbumProjectIcon);
            if (ap.icon == null) {
                new SwingWorker<Icon, Object>(){

                    protected Icon doInBackground() throws Exception {
                        AlbumObject ao = ap.getRootFolder();
                        if (ao != null) {
                            JAlbumButton.this.setToolTipText(ap.getLongName());
                            AlbumObject rep = ao.getRepresentingAlbumObject(true);
                            if (rep != null) {
                                return rep.getRepresentingIcon(iconSize, true, false);
                            }
                        }
                        return null;
                    }

                    protected void done() {
                        try {
                            Icon icon = (Icon)this.get();
                            if (icon != null) {
                                ap.icon = icon;
                                JAlbumButton.this.setIcon(icon);
                                JAlbumButton.this.repaint();
                            } else {
                                JAlbumButton.this.setForeground(SystemColor.textInactiveText);
                                JAlbumButton.this.setToolTipText(null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.execute();
            } else {
                this.setToolTipText(ap.getLongName());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.album.equals(emptyProject)) {
                JAlbumManager.this.context.getFrame().loadProject(this.album.getProjectFile());
            } else {
                JAlbumManager.this.context.getFrame().closeProject();
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (this.isValidDragDrop(dtde.getCurrentDataFlavors())) {
                dtde.acceptDrag(2);
                this.setFont(this.getFont().deriveFont(1));
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            dtde.acceptDrag(2);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.setFont(this.getFont().deriveFont(0));
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (!this.isValidDragDrop(dtde.getCurrentDataFlavors())) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(2);
            this.setFont(this.getFont().deriveFont(1));
            Transferable t = dtde.getTransferable();
            ArrayList<AlbumObject> dragged = new ArrayList<AlbumObject>();
            try {
                if (t.isDataFlavorSupported(AlbumObject.albumObjectFlavor)) {
                    for (JAlbumObject jao : ((JAlbumManager)JAlbumManager.this).context.getExplorer().explorer.getDraggedObjects()) {
                        dragged.add(jao.ao);
                    }
                } else if (t.isDataFlavorSupported(TransferableNode.NODE_FLAVOR)) {
                    JAlbumExplorer.FolderTreeNode node = (JAlbumExplorer.FolderTreeNode)t.getTransferData(TransferableNode.NODE_FLAVOR);
                    dragged.add(node.getAlbumObject());
                    JAlbumManager.this.tree.setSelectionPath(new TreePath(node.getParent()));
                }
                this.album.getRootFolder().invalidate();
                this.moveTo(dragged, this.album.getRootFolder());
                ((JAlbumManager)JAlbumManager.this).context.getExplorer().refreshAction.actionPerformed(null);
                dtde.dropComplete(true);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JAlbumManager.this, ex);
                dtde.dropComplete(false);
            }
            catch (UnsupportedFlavorException ex) {
                Debug.showErrorDialog(JAlbumManager.this, ex);
                dtde.dropComplete(false);
            }
        }

        private void moveTo(List<AlbumObject> objects, AlbumObject target) throws IOException {
            for (AlbumObject ao : objects) {
                ao.moveTo(target);
            }
        }

        private boolean isValidDragDrop(DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor dropFlavor = flavors[i];
                if (!dropFlavor.equals(JAlbumObject.jAlbumObjectFlavor) && !dropFlavor.equals(TransferableNode.NODE_FLAVOR)) continue;
                return true;
            }
            return false;
        }
    }

    private class ContentPanel
    extends JPanel {
        public ContentPanel() {
            super(new BorderLayout());
            this.setBackground(JAlbumColor.albumHighlight);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), new RoundedLineBorder(Color.lightGray)));
            JAlbumManager.this.tree.setBackground(JAlbumColor.albumHighlight);
            JAlbumManager.this.tree.setRootVisible(false);
            JAlbumManager.this.tree.setShowsRootHandles(true);
            JAlbumManager.this.tree.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger() && JAlbumManager.this.tree.getPathForLocation(e.getX(), e.getY()) == null) {
                        JAlbumManager.this.albumPopup.show(JAlbumManager.this.tree, e.getX(), e.getY());
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger() && JAlbumManager.this.tree.getPathForLocation(e.getX(), e.getY()) == null) {
                        JAlbumManager.this.albumPopup.show(JAlbumManager.this.tree, e.getX(), e.getY());
                    }
                }
            });
            this.addMouseListener(JAlbumManager.this.openSettingsMouseListener);
        }

        private void refresh() {
            this.removeAll();
            if (emptyProject.equals(JAlbumManager.this.activeProject)) {
                JLabel newAlbumLabel = new JLabel(Msg.get("ui.emptyProject"), newAlbumProjectIcon, 10);
                newAlbumLabel.setForeground(SystemColor.textInactiveText);
                this.add((Component)newAlbumLabel, "North");
            } else {
                this.add((Component)JAlbumManager.this.albumRootComponent, "North");
                this.add((Component)JAlbumManager.this.tree, "Center");
                JPanel buttons = new JPanel(new FlowLayout(3, 0, 0));
                buttons.setComponentPopupMenu(JAlbumManager.this.albumPopup);
                buttons.addMouseListener(JAlbumManager.this.openSettingsMouseListener);
                buttons.setBorder(BorderFactory.createEmptyBorder(8, 1, 1, 1));
                buttons.setOpaque(false);
                buttons.add(JAlbumManager.this.previewButton);
                buttons.add(Box.createRigidArea(new Dimension(4, 1)));
                buttons.add(JAlbumManager.this.infoButton);
                buttons.add(Box.createRigidArea(new Dimension(4, 1)));
                buttons.add(JAlbumManager.this.settingsButton);
                this.add((Component)buttons, "South");
            }
        }
    }

    public class AlbumRootComponent
    extends JPanel {
        AlbumProject ap;
        private AlbumRootLabel label;
        private JTextField nameField;
        private JLabel iconLabel;
        private boolean editing;
        private final PropertyChangeListener thumbnailListener;

        public AlbumRootComponent() {
            super((LayoutManager)new MigLayout("fillx, aligny 100%"));
            this.nameField = new JTextField();
            this.iconLabel = new JLabel();
            this.editing = false;
            this.thumbnailListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    AlbumRootComponent.this.renderThumbnail();
                }
            };
            this.setInheritsPopupMenu(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
            this.nameField.setDocument(new FileNameDocument());
            this.setOpaque(false);
            this.label = new AlbumRootLabel(JAlbumManager.this.tree);
            this.label.setInheritsPopupMenu(true);
            this.add((Component)this.label, "dock west");
            this.add((Component)JAlbumManager.this.moreButton, "dock east");
            this.setComponentPopupMenu(JAlbumManager.this.albumPopup);
            this.label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1 && AlbumRootComponent.this.label.isSelected() && e.getButton() == 1 && e.getPoint().x > AlbumRootComponent.this.label.getIcon().getIconWidth() + AlbumRootComponent.this.label.getIconTextGap()) {
                        AlbumRootComponent.this.setEditing(true);
                    }
                    if (e.getClickCount() == 2) {
                        ((JAlbumManager)JAlbumManager.this).context.getFrame().actions.settingsAction.actionPerformed(null);
                    } else {
                        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)JAlbumManager.this.tree.getModel().getRoot();
                        if (rootNode != null) {
                            JAlbumManager.this.tree.setSelectionPath(new TreePath(rootNode.getPath()));
                            JAlbumManager.this.context.getExplorer().setExplorerView();
                        }
                    }
                }
            });
            this.addMouseListener(JAlbumManager.this.openSettingsMouseListener);
            JAlbumManager.this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    boolean rootSelected = e.getPath().getPathCount() == 1;
                    AlbumRootComponent.this.label.setSelected(rootSelected);
                }
            });
            this.nameField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        AlbumRootComponent.this.nameField.setText(AlbumRootComponent.this.ap.getName());
                        AlbumRootComponent.this.setEditing(false);
                    }
                }
            });
            this.nameField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    AlbumRootComponent.this.setEditing(false);
                }
            });
            this.nameField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    AlbumRootComponent.this.setEditing(false);
                }
            });
        }

        boolean isEditing() {
            return this.editing;
        }

        void setEditing(boolean editing) {
            if (this.editing == editing) {
                return;
            }
            if (editing) {
                this.remove(this.label);
                this.iconLabel.setIcon(this.label.getIcon());
                this.nameField.setText(this.ap.getName());
                this.add((Component)this.iconLabel, "dock west");
                this.add((Component)this.nameField, "dock west");
                this.validate();
                this.repaint();
                this.editing = editing;
                this.nameField.requestFocusInWindow();
            } else {
                this.remove(this.iconLabel);
                this.remove(this.nameField);
                this.add((Component)this.label, "dock west");
                this.validate();
                this.repaint();
                this.editing = editing;
                String newName = this.nameField.getText();
                if (!newName.equals(this.ap.getName())) {
                    try {
                        if (JAlbumManager.this.context.getFrame().renameProjectDirectory(newName)) {
                            this.label.setText(newName);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        void setAlbumProject(AlbumProject ap) {
            AlbumObject ao;
            AlbumObject albumObject = ao = this.ap != null ? this.ap.getRootFolder() : null;
            if (ao != null) {
                ao.removePropertyChangeListener(this.thumbnailListener);
            }
            this.ap = ap;
            ao = ap.getRootFolder();
            if (ao != null) {
                ao.addPropertyChangeListener("representingAlbumObject", this.thumbnailListener);
                ao.addPropertyChangeListener("children", this.thumbnailListener);
                this.label.setText(ap.getName());
                this.label.setToolTipText(ap.getLongName());
            }
            this.renderThumbnail();
        }

        private void renderThumbnail() {
            AlbumObject rep;
            if (this.ap.getRootFolder() != null && this.ap.getRootFolder().getName().length() > 0 && (rep = this.ap.getRootFolder().getRepresentingAlbumObject(true)) != null) {
                try {
                    ImageIcon icon = rep.getRepresentingIcon(iconSize, true, false);
                    this.label.setIcon(icon);
                    for (AlbumProject ap : JAlbumManager.this.projects) {
                        if (!ap.equals(JAlbumManager.this.activeProject)) continue;
                        ap.icon = icon;
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            this.label.setIcon(newAlbumProjectIcon);
        }
    }

    private static class AlbumRootLabel
    extends JLabel {
        private boolean selected = false;

        public AlbumRootLabel(JTree tree) {
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            Font f = g.getFont();
            if (this.selected) {
                g.setFont(f.deriveFont(1));
            }
            super.paintComponent(g);
        }

        public Dimension getPreferredSize() {
            Font f = this.getFont();
            this.setFont(f.deriveFont(1));
            Dimension retDimension = super.getPreferredSize();
            this.setFont(f);
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }
    }
}

