/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Multilingual;

class JLabelTypeIndicator
extends JComponent
implements Multilingual {
    private JLabel label = new JLabel();
    private JPopupMenu popup = new JPopupMenu();

    public JLabelTypeIndicator() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.label.setFont(new Font("SansSerif", 0, 11));
        this.setToolTipText(Msg.get("ui.labelType"));
        this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 1, JAlbumColor.border), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        Config.getConfig().addPropertyChangeListener("labelType", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JLabelTypeIndicator.this.updateStatus();
            }
        });
        Config.getConfig().addPropertyChangeListener("language", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JLabelTypeIndicator.this.languageUpdated();
            }
        });
        this.add((Component)this.label, "Center");
        for (JMenuItem item : JAlbumContext.getInstance().getFrame().albumExplorer.createLabelTypeItems()) {
            this.popup.add(item);
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                JLabelTypeIndicator.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.updateStatus();
    }

    private void updateStatus() {
        Config.LabelType lt = Config.getConfig().getLabelType();
        this.label.setText(lt.toString());
        this.label.setForeground(JAlbumColor.getColorFor(lt));
    }

    public void languageUpdated() {
        this.setToolTipText(Msg.get("ui.labelType"));
        this.updateStatus();
    }
}

