/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.table.TableColumnModel;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JMapTable;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JWarningPanel;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.VideoProcessor;
import se.datadosen.jalbum.VideoResolution;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.annotations.Text;

public class JVideoSettingsPanel
extends ControlPanel
implements PropertyChangeListener {
    JAlbumContext context;
    @Text(value="ui.videoSupportDisabledWarning")
    JLabel videoSupportDisabledWarningLabel = new JLabel();
    JWarningPanel warningPanel = new JWarningPanel(this.videoSupportDisabledWarningLabel);
    @Text(value="ui.quality")
    JLabel videoQulityLabel = new JLabel();
    JSlider videoQuality = new JSlider(0, 100, 75);
    @Text(value="ui.resolution")
    JLabel videoResolutionLabel = new JLabel();
    JComboBox videoResolution = new JComboBox<VideoResolution>(VideoResolution.values());
    @Text(value="ui.low")
    JLabel lowQuality = new JLabel();
    @Text(value="ui.high")
    JLabel highQuality = new JLabel();
    @Text(value="ui.customSettings")
    JCheckBox useCustomVideoSettings = new JCheckBox();
    @Text(value="ui.advancedPanel")
    JCollapsiblePanel advancedPanel = new JCollapsiblePanel(new BorderLayout());
    JMapTable videoParametersTable = new JMapTable();
    JLinkLabel ffmpegDocumentationLink = new JLinkLabel("http://ffmpeg.org/ffmpeg.html#Options", Msg.get("ui.ffmpegDocumentation"));

    public JVideoSettingsPanel(JAlbumContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        Msg.maintainTranslated(this);
        this.videoQuality.setMajorTickSpacing(25);
        this.videoQuality.setMinorTickSpacing(5);
        this.videoQuality.setPaintTicks(true);
        this.videoQuality.setSnapToTicks(true);
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        ((Dictionary)table).put(0, this.lowQuality);
        ((Dictionary)table).put(100, this.highQuality);
        this.videoQuality.setLabelTable(table);
        this.videoQuality.setPaintLabels(true);
        this.videoParametersTable.setHeaderNames(Msg.get("ui.userVariablesNameColumn"), Msg.get("ui.userVariablesValueColumn"));
        TableColumnModel cm = this.videoParametersTable.getColumnModel();
        cm.getColumn(0).setMinWidth(60);
        cm.getColumn(0).setPreferredWidth(100);
        cm.getColumn(0).setMaxWidth(100);
        this.videoParametersTable.setSortKeys(false);
        new StateMonitor(){

            public void onChange() {
                1.enable(!JVideoSettingsPanel.this.useCustomVideoSettings.isSelected(), (JComponent)JVideoSettingsPanel.this.videoQulityLabel, (JComponent)JVideoSettingsPanel.this.videoQuality, (JComponent)JVideoSettingsPanel.this.videoResolutionLabel, (JComponent)JVideoSettingsPanel.this.videoResolution);
                1.enable(JVideoSettingsPanel.this.useCustomVideoSettings.isSelected(), (JComponent)JVideoSettingsPanel.this.videoParametersTable);
                JVideoSettingsPanel.this.advancedPanel.setExpanded(JVideoSettingsPanel.this.useCustomVideoSettings.isSelected());
            }
        }.add(this.useCustomVideoSettings).done();
        new StateMonitor(){

            public void onChange() {
                if (!BeanBinder.isSynchingUI()) {
                    VideoProcessor processor = JVideoSettingsPanel.this.context.getEngine().getVideoProcessor();
                    processor.setVideoResolution((VideoResolution)((Object)JVideoSettingsPanel.this.videoResolution.getSelectedItem()));
                    if (!JVideoSettingsPanel.this.useCustomVideoSettings.isSelected()) {
                        processor.setVideoParameters(null);
                    }
                    JVideoSettingsPanel.this.videoParametersTable.clear();
                    JVideoSettingsPanel.this.videoParametersTable.putAll(processor.getVideoParameters());
                }
            }
        }.add(this.videoResolution).add(this.useCustomVideoSettings);
        this.add("br hfill", this.warningPanel);
        this.add("br", this.videoQulityLabel);
        this.add("tab", this.videoQuality);
        this.add("br", this.videoResolutionLabel);
        this.add("tab", this.videoResolution);
        this.add("p", this.useCustomVideoSettings);
        this.advancedPanel.add(new JScrollPane(this.videoParametersTable));
        this.advancedPanel.add((Component)this.ffmpegDocumentationLink, "South");
        this.add("br hfill vfill", this.advancedPanel);
        Config.getConfig().addPropertyChangeListener(this);
        this.propertyChange(null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        boolean videoSupportActive = Config.getConfig().isVideoSupported();
        this.warningPanel.setVisible(!videoSupportActive);
        this.videoQulityLabel.setVisible(videoSupportActive);
        this.videoQuality.setVisible(videoSupportActive);
        this.videoResolutionLabel.setVisible(videoSupportActive);
        this.videoResolution.setVisible(videoSupportActive);
        this.useCustomVideoSettings.setVisible(videoSupportActive);
        this.advancedPanel.setVisible(videoSupportActive);
        this.validate();
    }
}

