/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;

public class Elements {
    public static String stripComments(String doc) {
        int cEnd;
        int cStart = doc.indexOf("<!--");
        if (cStart == -1) {
            return doc;
        }
        StringBuilder buf = new StringBuilder();
        do {
            buf.append(doc.substring(0, cStart));
            doc = doc.substring(cStart);
            cEnd = doc.indexOf("-->");
            if (cEnd != -1) continue;
            return buf.toString();
        } while ((cStart = (doc = doc.substring(cEnd + 3)).indexOf("<!--")) != -1);
        buf.append(doc);
        return buf.toString();
    }

    public static Element getNextElement(String[] names, String doc, boolean startsWith) throws ElementException {
        return Elements.getNextElement(names, doc, 0, startsWith);
    }

    static final int indexOfIntroducer(String s, int start) {
        int boff = s.indexOf(60, start);
        int doff = s.indexOf(36, start);
        if (boff == -1 && doff == -1) {
            return -1;
        }
        if (boff == -1) {
            boff = Integer.MAX_VALUE;
        }
        if (doff == -1) {
            doff = Integer.MAX_VALUE;
        }
        return boff < doff ? boff : doff;
    }

    public static Element getNextElement(String[] names, String doc, int start, boolean startsWith) throws ElementException {
        int offset = start;
        while ((offset = Elements.indexOfIntroducer(doc, offset)) != -1) {
            char c;
            int i;
            if (doc.charAt(offset) == '$') {
                if (offset + 1 < doc.length() && doc.charAt(offset + 1) == '{') {
                    return Elements.getExpressionLanguage(doc);
                }
                ++offset;
                continue;
            }
            for (i = 0; i < names.length && (!doc.startsWith(names[i], offset + 1) || !startsWith && (c = doc.charAt(offset + 1 + names[i].length())) != '=' && Character.isJavaIdentifierPart(c)); ++i) {
            }
            if (i == names.length) {
                ++offset;
                continue;
            }
            if (names[i].equals("%")) {
                return Elements.getScriptlet(doc);
            }
            Element e = new Element();
            e.preElement = doc.substring(0, offset);
            AttributeTokenizer at = new AttributeTokenizer(doc, offset + 1);
            String name = e.name = at.nextName();
            while (at.hasMoreTokens()) {
                e.attributes.put(at.nextName(), at.nextValue());
            }
            offset = at.getPosition();
            char c2 = doc.charAt(offset);
            if (c2 == '/') {
                e.content = "";
                e.postElement = doc.substring(offset + 2);
                e.postIndex = offset + 2;
                return e;
            }
            if (c2 != '>') {
                throw new ElementException("Begin tag not closed");
            }
            int contentStart = offset + 1;
            while ((offset = doc.indexOf(60, offset)) != -1) {
                if (doc.startsWith(name, offset + 1)) {
                    Element subElem = Elements.getNextElement(new String[]{name}, doc, offset, startsWith);
                    offset = subElem.getPostIndex() - 1;
                } else if (doc.startsWith("/" + name, offset + 1)) {
                    e.content = doc.substring(contentStart, offset);
                    if ((offset = doc.indexOf(62, offset)) == -1) {
                        throw new ElementException("Element " + e.name + " has malformad ending tag");
                    }
                    e.postElement = doc.substring(offset + 1);
                    e.postIndex = offset + 1;
                    return e;
                }
                ++offset;
            }
            throw new ElementException("Element " + e.name + " has no matching ending tag");
        }
        return null;
    }

    public static Element getElementByName(String name, String doc, boolean startsWith) throws ElementException {
        return Elements.getNextElement(new String[]{name}, doc, startsWith);
    }

    public static String contentOfElement(String name, String doc) throws ElementException {
        Element el = Elements.getElementByName(name, doc, false);
        return el != null ? el.getContent() : null;
    }

    public static Element getScriptlet(String doc) throws ElementException {
        int offset = 0;
        while ((offset = doc.indexOf(60, offset)) != -1) {
            if (doc.charAt(offset + 1) != '%') {
                ++offset;
                continue;
            }
            Element e = new Element();
            e.name = "%";
            e.preElement = doc.substring(0, offset);
            int contentStart = offset + 2;
            switch (doc.charAt(contentStart)) {
                case '=': {
                    e.evalScriptlet = true;
                    ++contentStart;
                    break;
                }
                case '!': {
                    e.definitionScriptlet = true;
                    ++contentStart;
                }
            }
            offset = contentStart;
            while ((offset = doc.indexOf(37, offset)) != -1) {
                if (doc.charAt(offset + 1) != '>') {
                    ++offset;
                    continue;
                }
                e.content = doc.substring(contentStart, offset);
                e.postElement = doc.substring(offset + 2);
                return e;
            }
            throw new ElementException("Scriptlet has no ending");
        }
        return null;
    }

    public static Element getExpressionLanguage(String doc) throws ElementException {
        int offset = 0;
        while ((offset = doc.indexOf(36, offset)) != -1) {
            int contentStart;
            if (doc.charAt(offset + 1) != '{') {
                ++offset;
                continue;
            }
            Element e = new Element();
            e.name = "$";
            e.preElement = doc.substring(0, offset);
            offset = contentStart = offset + 2;
            if ((offset = doc.indexOf(125, offset)) == -1) {
                throw new ElementException("Expression has no ending brace");
            }
            e.content = doc.substring(contentStart, offset);
            e.postElement = doc.substring(offset + 1);
            return e;
        }
        return null;
    }
}

