/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import se.datadosen.util.PrintSafeHashMap;

public class Scope
implements Map,
Serializable {
    protected Scope outer;
    protected Map map;
    private boolean flattening;

    public Scope() {
        this.map = new PrintSafeHashMap();
    }

    public Scope(Scope outer) {
        this();
        this.outer = outer;
    }

    public Scope(Map map) {
        this.map = map;
    }

    public Scope(Map map, Scope outer) {
        this.map = map;
        this.outer = outer;
    }

    public Object get(Object key) {
        Object res = this.map.get(key);
        if (res == null && this.outer != null) {
            res = this.outer.get(key);
        }
        return res;
    }

    public Object put(Object key, Object value) {
        this.verify(key);
        return this.map.put(key, value);
    }

    public void putAll(Map more) {
        this.verify(null);
        if (more != null) {
            this.map.putAll(more);
        }
    }

    public Object remove(Object key) {
        this.verify(key);
        return this.map.remove(key);
    }

    public Scope getOuter() {
        return this.outer;
    }

    public void setOuter(Scope outer) {
        this.outer = outer;
    }

    public Map getMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map flatten2() {
        if (this.outer == null) {
            return new PrintSafeHashMap(this.map);
        }
        Map flatMap = this.outer.flatten2();
        try {
            this.flattening = true;
            flatMap.putAll(this.map);
        }
        finally {
            this.flattening = false;
        }
        return flatMap;
    }

    public Map flatten() {
        if (this.outer == null) {
            return this.map;
        }
        return this.flatten2();
    }

    private void verify(Object key) {
        if (this.flattening) {
            throw new IllegalStateException("Calling illegal method during flattening. Key is " + key);
        }
    }

    public Scope push(Map map) {
        if (map == null) {
            return this;
        }
        return new Scope(map, this);
    }

    public Scope remove(Map map) {
        if (this == map) {
            return this.outer;
        }
        Scope scope = this;
        while (scope != null) {
            if (scope.outer == map) {
                scope.outer = scope.outer.outer;
                return scope;
            }
            scope = this.outer;
        }
        return this;
    }

    public int size() {
        return this.outer != null ? this.outer.size() + this.map.size() : this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        boolean contains = this.map.containsKey(key);
        if (!contains && this.outer != null) {
            return this.outer.containsKey(key);
        }
        return contains;
    }

    public boolean containsValue(Object value) {
        boolean contains = this.map.containsValue(value);
        if (!contains && this.outer != null) {
            return this.outer.containsValue(value);
        }
        return contains;
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.flatten().keySet();
    }

    public Collection values() {
        return this.flatten().values();
    }

    public Set entrySet() {
        return this.flatten().entrySet();
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return this.flatten().toString();
    }
}

