/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import se.datadosen.imaging.exif.ImageInfoFormatter;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CategoryCounters;
import se.datadosen.jalbum.CompiledBase;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.Widget;
import se.datadosen.util.FileFilters;
import se.datadosen.util.FormattedDate;
import se.datadosen.util.IO;
import se.datadosen.util.Scope;

public class Util
extends CompiledBase {
    private Map skinVars;
    private DateFormat dateFormat;
    private boolean showMetaLabel;
    private String photoDataTemplate;
    private String photoDataSep;
    private String thumbCaptionTemplate;
    private String imgCaptionTemplate;
    private SkinProperties sp;
    private boolean shopValid;
    private boolean isFixedShapeThumbs;
    public String pageExt;
    public String indexPageName;
    public String indexName;
    public String thumbsDir;
    public String slidesDir;
    public boolean isUrlEncode;
    public String basePath;
    public boolean linkOriginals;
    public boolean copyOriginals;
    public boolean makeSlides;
    public String skinVersion;
    public String skinName;
    public String skinLink;
    public String styleName;
    public String uniqueID;
    public String fotomotoAid;
    public boolean hasWidgets;
    public String lang;
    public String locale;
    public int imagesPerPage;
    private static NumberFormat twoDec = new DecimalFormat("0.00");
    public String translationsFile;
    public String folderThumbFileName;
    public String folderThumbSize;
    private String defPathSep;
    private int[] xSalt;
    private String wmk;
    public String license;
    public boolean excludeCredits;
    private int searchPageCount;
    private int searchTotalCount;
    private Writer searchStream;
    private String searchSep;
    private String regionsPrefixPicasa;
    private String regionsPrefixMS;

    public Util(AlbumBean engine) {
        super(engine);
        this.skinVars = this.engine.getSkinVariables();
        this.dateFormat = new SimpleDateFormat(this.engine.getDateFormat());
        this.showMetaLabel = Boolean.TRUE.equals(this.skinVars.get("showPhotoDataLabel"));
        this.photoDataTemplate = (String)this.skinVars.get("photoDataTemplate");
        this.photoDataSep = " &nbsp; &middot; &nbsp; ";
        this.thumbCaptionTemplate = (String)this.skinVars.get("thumbCaptionTemplate");
        this.imgCaptionTemplate = (String)this.skinVars.get("imgCaptionTemplate");
        this.sp = this.engine.getSkinProperties();
        this.shopValid = !this.isEmpty(this.skinVars.get("shopId")) && !this.isEmpty(this.skinVars.get("shopCurrency"));
        this.isFixedShapeThumbs = Boolean.TRUE.equals(this.skinVars.get("fixedShapeThumbs"));
        this.pageExt = this.engine.getPageExtension();
        this.indexPageName = this.engine.getIndexPageName();
        this.indexName = this.indexPageName + this.pageExt;
        this.thumbsDir = this.engine.getThumbnailDirectory();
        this.slidesDir = this.engine.getSlideDirectory();
        this.isUrlEncode = this.engine.isUrlEncode();
        this.basePath = this.getBasePath();
        this.linkOriginals = this.engine.getImageLinking().equals("LinkOriginals");
        this.copyOriginals = this.engine.isCopyOriginals();
        this.makeSlides = this.engine.isSlides();
        this.skinVersion = this.sp.getProperty("version", "0.0");
        this.skinName = this.sp.getProperty("title", "");
        this.skinLink = this.sp.getProperty("homePage", "http://jalbum.net/skins/skin/" + this.skinName);
        this.styleName = this.style.substring(0, this.style.indexOf("."));
        this.uniqueID = String.valueOf((int)Math.floor(Math.random() * 1000.0));
        this.fotomotoAid = "&aid=25b6e51331930731";
        this.hasWidgets = this.hasWidgets();
        this.lang = Config.getConfig().getInterpretedLanguage();
        this.locale = this.isEmpty(this.lang) ? "en_US" : this.getLoc(this.lang);
        this.imagesPerPage = this.rows == 0 ? Integer.MAX_VALUE : this.cols * this.rows;
        this.translationsFile = "texts.js";
        this.folderThumbFileName = "folderthumb.jpg";
        this.folderThumbSize = "300x300";
        this.defPathSep = "";
        this.xSalt = new int[]{147, 163, 87, 254, 153, 4, 198, 23};
        this.wmk = this.chSer().trim();
        this.license = this.getLicense();
        this.excludeCredits = this.engine.isExcludeBacklinks() || this.wmk.length() > 0;
        this.searchPageCount = 0;
        this.searchTotalCount = 0;
        this.searchSep = "-!-";
        this.regionsPrefixPicasa = "mwg-rs:Regions/mwg-rs:RegionList";
        this.regionsPrefixMS = "MP:RegionInfo/MPRI:Regions";
    }

    private boolean hasWidgets() {
        if (!(this.window instanceof JAlbumFrame)) {
            return false;
        }
        AlbumObjectProperties props = this.rootFolder.getProperties();
        try {
            if (SignInManager.getInstance().isSignedIn() && this.engine.isWidgetInjection() && props.containsKey("widgets")) {
                List widgets = (List)props.get("widgets");
                for (Widget widget : widgets) {
                    if (!Boolean.TRUE.equals(widget.getActive())) continue;
                    return true;
                }
            }
        }
        catch (ExceptionInInitializerError e) {
            System.out.println("Exception in initializer error: " + e);
        }
        return false;
    }

    private String getBasePath() {
        String s = (String)this.skinVars.get("uploadPath");
        if (this.isEmpty(s)) {
            s = IO.urlEncode((String)((String)this.rootFolder.getProperties().get("albumURL", (Object)"")));
        } else if (!s.endsWith("/")) {
            s = s + "/" + IO.urlEncode((String)this.rootFolder.getName()) + "/";
        }
        return s;
    }

    public void log(String s, Throwable e) {
        if (s != null) {
            System.out.println(s);
        }
        if (e != null) {
            e.printStackTrace(System.out);
        }
    }

    public void debug(AlbumObject ao) {
        String v = this.skinVars.get("debugVars").toString();
        if (v != null) {
            this.debug(ao, v);
        }
    }

    public void debug(AlbumObject ao, String names) {
        if (this.isEmpty(names)) {
            return;
        }
        String[] ns = names.split(",");
        if (ns.length > 0) {
            System.out.println("\n------------------------------------------------------------------------------------ debug: " + this.getString(ao, "fileName"));
            for (String n : ns) {
                String s;
                System.out.println(n + " = " + ((s = this.getString(ao, n)) != null ? s : "null"));
            }
        }
    }

    public boolean isEmpty(Object o) {
        return o == null || o.toString().trim().equals("");
    }

    public boolean isTrue(Object o) {
        return o != null && Boolean.TRUE.equals(o);
    }

    public String urlEncodeFix(String s) {
        return this.isUrlEncode ? s : IO.urlEncode((String)s);
    }

    public String urlEncode(String s) {
        return s == null ? null : (this.isUrlEncode ? IO.urlEncode((String)s) : s);
    }

    public String urlEncodeSafe(String s) {
        return s == null ? null : (this.isUrlEncode ? IO.urlEncode((String)s) : s.replaceAll("\\'", "\\\\'"));
    }

    public String fixExtension(String s) {
        return s.replaceAll(".gif", ".png").replaceAll(".(tif|bmp|mov|avi|mp4)", ".jpg");
    }

    public String replaceExt(String s) {
        int i = s.lastIndexOf(".");
        return i > 0 ? s.substring(0, i) + this.pageExt : s + "." + this.pageExt;
    }

    public String replaceExt(String s, String nx) {
        int i = s.lastIndexOf(".");
        return i > 0 ? s.substring(0, i) + nx : s + "." + nx;
    }

    public String getExt(String s) {
        int i = s.lastIndexOf(".");
        return i > 0 ? s.substring(i + 1) : null;
    }

    public Object getObject(AlbumObject ao, String name) {
        if (this.isEmpty(name)) {
            return null;
        }
        Scope vars = ao.getVars();
        Object o = vars.get((Object)name);
        if (o == null && (o = this.skinVars.get(name)) == null) {
            return null;
        }
        return o;
    }

    public String getUserVar(String name) {
        return (String)this.skinVars.get(name);
    }

    public String getString(AlbumObject ao, String name) {
        return (String)this.getObject(ao, name);
    }

    private String getString(Object o) {
        return o == null ? null : o.toString();
    }

    public Integer getInteger(AlbumObject ao, String name) {
        Object o = this.getObject(ao, name);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        String v = String.valueOf(o);
        if (v != null && !this.isEmpty(v)) {
            try {
                return Integer.valueOf(v);
            }
            catch (NumberFormatException e) {
                this.log("Number error in \"" + name + "\"", e);
            }
        }
        return null;
    }

    public int getInt(String s) {
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.log("Number error", e);
            }
        }
        return 0;
    }

    public int getInt(Integer i) {
        return i == null ? -1 : i;
    }

    public int getInt(Float f) {
        return f == null ? -1 : Math.round(f.floatValue());
    }

    public Long getLong(AlbumObject ao, String name) {
        Object o = this.getObject(ao, name);
        if (o instanceof Long) {
            return (Long)o;
        }
        String s = String.valueOf(o);
        if (s != null && !this.isEmpty(s)) {
            try {
                return Long.valueOf(s);
            }
            catch (NumberFormatException e) {
                this.log("Number error in \"" + name + "\"", e);
            }
        }
        return null;
    }

    public Float getFloat(AlbumObject ao, String name) {
        Object o = this.getObject(ao, name);
        if (o instanceof Float) {
            return (Float)o;
        }
        String s = String.valueOf(this.getObject(ao, name));
        if (s != null && !this.isEmpty(s)) {
            try {
                return Float.valueOf(s);
            }
            catch (Exception e) {
                this.log("Number error", e);
            }
        }
        return Float.valueOf(0.0f);
    }

    public Float getFloat(Object o) {
        if (o instanceof Float) {
            return (Float)o;
        }
        try {
            return Float.valueOf(String.valueOf(o));
        }
        catch (Exception e) {
            this.log("Number error", e);
            return Float.valueOf(0.0f);
        }
    }

    public float getFloatNum(String s) {
        if (s != null) {
            try {
                return Float.parseFloat(s);
            }
            catch (Exception e) {
                this.log("Number error", e);
            }
        }
        return 0.0f;
    }

    public float getFloatNum(Float d) {
        return d == null ? 0.0f : d.floatValue();
    }

    public int getAttrAsInt(String code, String attr) {
        return this.getAttrAsInt(code, attr, 0);
    }

    public int getAttrAsInt(String code, String attr, int def) {
        int i = code.indexOf(attr);
        int l = code.length();
        int n = 0;
        if (i >= 0) {
            i += attr.length() + 1;
            while (i < l && !Character.isDigit(code.charAt(i))) {
                ++i;
            }
            while (i < l && Character.isDigit(code.charAt(i))) {
                n = n * 10 + Character.getNumericValue(code.charAt(i));
                ++i;
            }
            return n;
        }
        return def;
    }

    public String getSizeAsString(Map vars) {
        return this.getSizeAsString((Long)vars.get("fileSize"));
    }

    public String getSizeAsString(long s) {
        String p;
        double n;
        if (s >= 0x40000000L) {
            n = (double)s / 1.073741824E9;
            p = "GB";
        } else if (s >= 0x100000L) {
            n = (double)s / 1048576.0;
            p = "MB";
        } else if (s >= 1024L) {
            n = (double)s / 1024.0;
            p = "kB";
        } else {
            n = s;
            p = "B";
        }
        return twoDec.format(n) + " " + p;
    }

    public String filterJunk(int s) {
        return Integer.toString(s);
    }

    public String filterJunk(String s) {
        if (s == null) {
            return s;
        }
        if ((s = s.trim()).length() == 0 || s.equals("x") || s.startsWith("ACD Systems Digital Imaging") || s.startsWith("LEAD Technologies") || s.startsWith("AppleMark") || s.startsWith("Intel(R) JPEG Library") || s.startsWith("Created with The GIMP") || s.startsWith("ASCII") || s.startsWith("OLYMPUS DIGITAL CAMERA") || s.startsWith("File written by Adobe Photoshop")) {
            return "";
        }
        if (s.startsWith("Flash did not fire")) {
            return this.texts.getString("noFlash");
        }
        return s;
    }

    public String shorten(String s) {
        return this.shorten(s, 160);
    }

    public String shorten(String s, int max) {
        if (s == null) {
            return "";
        }
        if (s.length() > max) {
            int i;
            if (s.indexOf("<") >= 0) {
                s = this.stripHTML(s);
            }
            if ((i = s.lastIndexOf(32, max)) < max / 2) {
                i = max;
            }
            return s.substring(0, i) + "&hellip;";
        }
        return s;
    }

    public String getMeta(Scope vars, String key) {
        if (key == null || vars == null) {
            return null;
        }
        Map m = (Map)vars.get((Object)"meta");
        if (m == null) {
            return null;
        }
        Object o = m.get(key);
        if (o == null && (o = m.get("Xmp." + key)) == null && (o = m.get("Iptc." + key)) == null && (o = m.get("Windows XP " + key)) == null) {
            return null;
        }
        String v = o.toString();
        if ("F-Number".equals(key) || "FNumber".equals(key) || key.toLowerCase().startsWith("aperture")) {
            if (v.charAt(0) == 'F') {
                v = v.substring(1);
            }
            return "f/" + v;
        }
        return this.filterJunk(v);
    }

    public String getVar(AlbumObject ao, String name) {
        if (this.isEmpty(name)) {
            return null;
        }
        return this.getVar(ao.getVars(), name);
    }

    public String getVar(Scope vars, String name) {
        String s;
        if (this.isEmpty(name)) {
            return "";
        }
        if (vars.containsKey((Object)"folder")) {
            Object o;
            s = name.equals("description") ? ((o = vars.getMap().get("description")) == null ? "" : String.valueOf(o)) : ((o = vars.get((Object)name)) != null ? String.valueOf(o) : "");
        } else if (name.equals("fileLabel")) {
            s = (String)vars.get((Object)"fileTitle");
            if (s == null && (s = (String)vars.get((Object)"label")) != null) {
                s = s.replaceAll("_", " ");
            }
        } else if (name.equals("fileSize")) {
            s = this.getSizeAsString((Long)vars.get((Object)"fileSize"));
        } else {
            Object o = vars.get((Object)name);
            if (o != null) {
                s = this.filterJunk(String.valueOf(o));
            } else {
                s = this.getMeta(vars, name);
                if (s == null) {
                    s = "";
                }
            }
        }
        return s;
    }

    public Dimension getDim(BufferedImage bi) {
        return bi == null ? null : new Dimension(bi.getWidth(), bi.getHeight());
    }

    public Dimension getDim(int i) {
        return new Dimension(i, 0);
    }

    public Dimension getDim(String s) {
        int y;
        int x;
        if (s == null) {
            return new Dimension(0, 0);
        }
        if ((s = s.replaceAll("\\s", "")).length() == 0) {
            return new Dimension(0, 0);
        }
        int i = s.toLowerCase().indexOf("x");
        if (i > 0) {
            x = Integer.parseInt(s.substring(0, i));
            y = i + 1 < s.length() ? Integer.parseInt(s.substring(i + 1)) : 0;
        } else if (i == 0) {
            x = 0;
            y = s.length() > 1 ? Integer.parseInt(s.substring(1)) : 0;
        } else {
            x = Integer.parseInt(s);
            y = 0;
        }
        return new Dimension(x, y);
    }

    public String cleanup(int s) {
        return String.valueOf(s);
    }

    public String cleanup(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("&", "&#38;").replaceAll("'", "&#39;").replaceAll("\"", "&#34;").replaceAll("(\n|\r)", "<br/>");
    }

    public String stripHTML(int s) {
        return String.valueOf(s);
    }

    public String stripHTML(String s) {
        if (s == null) {
            return "";
        }
        return this.cleanup(s.replaceAll("\\<[^>]*>", " ").replaceAll("(\n|\r)", " ")).trim();
    }

    public String stripEmptyHTML(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("\\<([A-Za-z0-9]+)[^>]*></\\1>", "").trim();
    }

    public String stripQuot(int s) {
        return String.valueOf(s);
    }

    public String stripQuot(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("'", "&#39;").replaceAll("\"", "&#34;").replaceAll("(\n|\r)", "<br/>");
    }

    public String escQuot(int s) {
        return String.valueOf(s);
    }

    public String escQuot(String s) {
        return s == null ? null : s.replaceAll("\\'", "\\\\'").replaceAll("(\n|\r)", " ");
    }

    public String stripQuotes(int s) {
        return String.valueOf(s);
    }

    public String stripQuotes(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("'", "&apos;").replaceAll("(\n|\r)", "");
    }

    public String stripLinebreak(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("(\n|\r)", "<br/>");
    }

    public String cleanPath(String p) {
        if (p.equals(".")) {
            return "";
        }
        if ((p = p.replaceAll("%2F", "/")).endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    public String cleanItem(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("\\<[^>]*>", " ").replaceAll("(\n|\r)", " ").replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"").trim();
    }

    public String formatPlainText(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("\\*([\\w\\s]+)\\*", "<strong>$1</strong>").replaceAll("\\+([\\w\\s]+)\\+", "<em>$1</em>").replaceAll("\\_([\\w\\s]+)\\_", "<u>$1</u>").replaceAll("(\n|\r)", "<br>").replaceAll("\\!(http\\:[\\w\\./\\-]+[png|gif|jpg])\\!", "<img src=\"$1\">").replaceAll("\\[((?:http|https|ftp){1}\\:[\\w\\./\\-]+)\\]", "<a href=\"$1\">$1</a>").replaceAll("\\[([^\\|]+)\\|((?:http|https|ftp){1}\\:[\\w\\./\\-]+)\\]", "<a href=\"$2\">$1</a>");
    }

    public String getProcessed(String s) {
        String s1 = "";
        if (!this.isEmpty(s)) {
            try {
                s1 = this.engine.processTemplate(s);
            }
            catch (Exception e) {
                this.log("Error processing string: " + s, e);
                return s;
            }
        }
        return s1;
    }

    private String getIndexName(int from, int to) {
        return from / this.imagesPerPage == to / this.imagesPerPage ? "" : this.indexPageName + (to >= this.imagesPerPage ? Integer.valueOf(to / this.imagesPerPage + 1) : "") + this.pageExt;
    }

    public void addImageLinks(AlbumObject folder, boolean loop) {
        Map vars;
        int fi = Integer.MAX_VALUE;
        int pi = 0;
        int ci = 0;
        Map fvars = null;
        Map pvars = null;
        for (AlbumObject ao : folder.getChildren()) {
            if (!ao.isIncluded() || ao.isHidden()) continue;
            Category cat = ao.getCategory();
            if (cat != Category.folder && cat != Category.webPage) {
                vars = ao.getVars().getMap();
                if (fvars == null) {
                    fvars = vars;
                    fi = ci;
                }
                if (pvars != null) {
                    vars.put("previousImageLink", this.getIndexName(ci, pi) + "#" + this.urlEncode(pvars.get("fileName").toString()));
                    pvars.put("nextImageLink", this.getIndexName(pi, ci) + "#" + this.urlEncode(vars.get("fileName").toString()));
                }
                pvars = vars;
                pi = ci;
            }
            ++ci;
        }
        if (fvars != null && pvars != null && ci > fi) {
            if (loop) {
                pvars.put("nextImageLink", this.getIndexName(pi, fi) + "#" + this.urlEncode(fvars.get("fileName").toString()));
                fvars.put("previousImageLink", this.getIndexName(fi, pi) + "#" + this.urlEncode(pvars.get("fileName").toString()));
            }
            vars = folder.getVars().getMap();
            vars.put("firstImageLink", this.getIndexName(-1, fi) + "#" + this.urlEncode(fvars.get("fileName").toString()));
            vars.put("lastImageLink", this.getIndexName(-1, pi) + "#" + this.urlEncode(pvars.get("fileName").toString()));
        }
    }

    public String wrap(String t, String s) {
        if (this.isEmpty(s) || this.isEmpty(t)) {
            return "";
        }
        return "<" + t + ">" + s + "</" + t.split(" ")[0] + ">";
    }

    public String attr(String a, Object o) {
        if (this.isEmpty(o) || this.isEmpty(a)) {
            return "";
        }
        return " " + a + "=\"" + o + "\"";
    }

    public String attrIf(String a, Boolean b) {
        return b != false ? this.attr(a, String.valueOf(b)) : "";
    }

    public String data(String n, Object o) {
        if (this.isEmpty(n) || this.isEmpty(o)) {
            return "";
        }
        return this.attr("data-" + n, "" + o);
    }

    public String dataIf(String n, Boolean b) {
        return this.attrIf("data-" + n, b);
    }

    public String getCssColor(String c) {
        if (c.length() < 8) {
            return c;
        }
        if (c.startsWith("#FF") || c.startsWith("#ff")) {
            return "#" + c.substring(3);
        }
        if (c.startsWith("#00")) {
            return "transparent";
        }
        return "rgba(" + Integer.parseInt(c.substring(3, 5), 16) + "," + Integer.parseInt(c.substring(5, 7), 16) + "," + Integer.parseInt(c.substring(7, 9), 16) + "," + (double)Integer.parseInt(c.substring(1, 3), 16) / 255.0 + ")";
    }

    public Double getLuminosity(String c) {
        if (c.charAt(0) == '#') {
            c = c.substring(1);
        }
        if (c.length() > 6) {
            c = c.substring(2);
        }
        return c.length() > 5 ? 0.0011725490196078 * (double)Integer.parseInt(c.substring(0, 2), 16) + 0.0023019607843137 * (double)Integer.parseInt(c.substring(2, 4), 16) + 4.470588235294118E-4 * (double)Integer.parseInt(c.substring(4, 6), 16) : 0.0;
    }

    public boolean isLightColor(String c) {
        return this.isLightColor(c, "#FFFFFF");
    }

    public boolean isLightColor(String c, Double treshold) {
        return this.isLightColor(c, "#FFFFFF", treshold);
    }

    public boolean isLightColor(String c, String bc) {
        return this.isLightColor(c, bc, 0.6);
    }

    public boolean isLightColor(String c, String bc, Double treshold) {
        if (c.charAt(0) == '#') {
            c = c.substring(1);
        }
        Double l = this.getLuminosity(c);
        if (c.length() > 6) {
            Double o = (double)Integer.parseInt(c.substring(0, 2), 16) / 255.0;
            l = o * l + (1.0 - o) * this.getLuminosity(bc);
        }
        return l > treshold;
    }

    public String getBgColor(String c) {
        String bc = "background-color:";
        if (c.charAt(0) == '#' && c.length() > 7) {
            if (c.startsWith("#FF") || c.startsWith("#ff")) {
                return bc + "#" + c.substring(3) + ";";
            }
            if (c.startsWith("#00")) {
                return bc + "transparent;";
            }
            return bc + "#" + c.substring(3) + "; " + bc + "rgba(" + Integer.parseInt(c.substring(3, 5), 16) + "," + Integer.parseInt(c.substring(5, 7), 16) + "," + Integer.parseInt(c.substring(7, 9), 16) + "," + (double)Integer.parseInt(c.substring(1, 3), 16) / 255.0 + ")" + ";";
        }
        return bc + c + ";";
    }

    public String getTextColor(String bg) {
        return "color:" + (this.isLightColor(bg) ? "#222222" : "#dddddd");
    }

    private long deepLastTaken(AlbumObject folder) throws IOException {
        long lastTaken = 0L;
        for (AlbumObject ao : folder.getChildren()) {
            Date d;
            String ds;
            Map met;
            Scope vars;
            Category cat = ao.getCategory();
            if (!ao.isIncluded() || cat == Category.webPage) continue;
            long lt = cat == Category.folder ? this.deepLastTaken(ao) : ((vars = ao.getVars()) != null ? ((met = (Map)vars.get((Object)"meta")) != null && (ds = (String)met.get("Date/Time Original")) != null && (d = ImageInfoFormatter.parseExifDate((String)ds)) != null ? d.getTime() : 0L) : ao.getLastModified());
            if (lt <= lastTaken) continue;
            lastTaken = lt;
        }
        return lastTaken;
    }

    public int folderDateTakenDays(AlbumObject folder) {
        long lt;
        try {
            lt = this.deepLastTaken(folder);
        }
        catch (IOException e) {
            this.log("IO Error:", e);
            return 0;
        }
        return (int)(lt / 86400000L);
    }

    public long fileDateTakenDays(AlbumObject ao) {
        Date d;
        String s;
        Map met = (Map)ao.getVars().get((Object)"meta");
        long m = met != null && (s = (String)met.get("Date/Time Original")) != null ? ((d = ImageInfoFormatter.parseExifDate((String)s)) == null ? 0L : d.getTime()) : ao.getLastModified();
        return (int)(m / 86400000L);
    }

    public long deepLastModifiedObject(AlbumObject folder) throws IOException {
        long lastModified = 0L;
        for (AlbumObject ao : folder.getChildren()) {
            long lm;
            Category cat = ao.getCategory();
            if (!ao.isIncluded() || cat == Category.webPage || (lm = cat == Category.folder ? this.deepLastModifiedObject(ao) : ao.getLastModified()) <= lastModified) continue;
            lastModified = lm;
        }
        return lastModified;
    }

    public long folderModified(AlbumObject folder) {
        long lm;
        try {
            lm = this.deepLastModifiedObject(folder);
        }
        catch (IOException e) {
            this.log("IO Error:", e);
            return 0L;
        }
        return lm;
    }

    public String folderModifiedString(AlbumObject folder) {
        FormattedDate lastMod = new FormattedDate(this.folderModified(folder), this.dateFormat);
        return lastMod.toString();
    }

    public long folderModifiedDays(AlbumObject folder) {
        return (int)(this.folderModified(folder) / 86400000L);
    }

    public long fileModifiedDays(AlbumObject ao) {
        return (int)(ao.getLastModified() / 86400000L);
    }

    public String getText(String name) {
        String s;
        try {
            s = this.texts.getString(name);
        }
        catch (MissingResourceException e) {
            System.out.println("Missing key: \"" + name + "\"");
            return name;
        }
        return s;
    }

    public String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length());
        s = s.replaceAll("\\p{Punct}+", " ");
        for (String w : s.split(" ")) {
            if (w.isEmpty()) continue;
            sb.append(w.substring(0, 1).toUpperCase());
            sb.append(w.substring(1));
        }
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    public String getExifLabel(String name) {
        String s;
        String n = name;
        try {
            s = this.texts.getString(n);
        }
        catch (MissingResourceException e) {
            n = this.toCamelCase(n);
            try {
                s = this.texts.getString(n);
            }
            catch (MissingResourceException e1) {
                s = name;
                System.out.println("Missing key: " + n + "=" + name);
            }
        }
        return s;
    }

    public AlbumObject getFirstImage(AlbumObject folder) {
        if (folder != null) {
            for (AlbumObject ao : folder.getChildren()) {
                if (ao.isFolder() || !ao.isIncluded() || ao.isHidden() || ao.getCategory() == Category.webPage) continue;
                return ao;
            }
        }
        return null;
    }

    public AlbumObject getPreviousFolder(AlbumObject folder) {
        if (folder != null) {
            AlbumObject prev = null;
            AlbumObject parent = folder.getParent();
            String fn = folder.getName();
            if (parent != null) {
                for (AlbumObject ao : parent.getChildren()) {
                    if (!ao.isFolder() || !ao.isIncluded() || ao.isHidden()) continue;
                    String n = ao.getName();
                    if (fn.equals(n)) {
                        return prev;
                    }
                    prev = ao;
                }
            }
        }
        return null;
    }

    public AlbumObject getNextFolder(AlbumObject folder) {
        if (folder != null) {
            AlbumObject parent = folder.getParent();
            String fn = folder.getName();
            boolean found = false;
            if (parent != null) {
                for (AlbumObject ao : parent.getChildren()) {
                    if (!ao.isFolder() || !ao.isIncluded() || ao.isHidden()) continue;
                    if (found) {
                        return ao;
                    }
                    if (!fn.equals(ao.getName())) continue;
                    found = true;
                }
            }
        }
        return null;
    }

    public String getTexts(String[] names) {
        StringBuilder sb = new StringBuilder(1024);
        if (names.length == 0) {
            return "";
        }
        for (String n : names) {
            String s = this.cleanup(this.getText(n));
            if (this.isEmpty(s)) continue;
            sb.append(n.replace('.', '_')).append(":'").append(s).append("',");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String getTexts(String[] names, String prefix) {
        StringBuilder sb = new StringBuilder(1024);
        if (names.length == 0) {
            return "";
        }
        for (String n : names) {
            String s = this.getText(prefix + "." + n);
            if (this.isEmpty(s)) continue;
            sb.append("'").append(this.stripQuotes(s)).append("',");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String writeTranslations(String[] keys) {
        String s = this.getTexts(keys);
        if (s.length() > 0) {
            try {
                File f = new File(this.resDirectory, this.translationsFile);
                BufferedWriter strm = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8"));
                strm.write("Texts={" + s + "};");
                strm.close();
                return this.translationsFile;
            }
            catch (IOException e) {
                this.log("Error writing file:", e);
            }
        }
        return "";
    }

    public String getCounts(AlbumObject ao) {
        return this.getCounts(ao, false);
    }

    public String getCounts(AlbumObject ao, boolean recursive) {
        CategoryCounters count;
        StringBuilder sb = new StringBuilder(256);
        try {
            count = JAlbumUtilities.countCategories((AlbumObject)ao, (boolean)recursive);
        }
        catch (Exception e) {
            this.log("Circular folder reference error:", e);
            return "";
        }
        sb.append("<ul>");
        int i = count.getCount(Category.image);
        if (i > 0) {
            sb.append("<li>").append(i).append(this.getText(i > 1 ? "images" : "image")).append("</li>");
        }
        if ((i = count.getCount(Category.audio)) > 0) {
            sb.append("<li>").append(i).append(this.getText(i > 1 ? "audios" : "audio")).append("</li>");
        }
        if ((i = count.getCount(Category.video)) > 0) {
            sb.append("<li>").append(i).append(this.getText(i > 1 ? "videos" : "video")).append("</li>");
        }
        if ((i = count.getCount(Category.other)) > 0) {
            sb.append("<li>").append(i).append(this.getText(i > 1 ? "others" : "other")).append("</li>");
        }
        sb.append("</ul>");
        return sb.length() > 9 ? sb.toString() : "";
    }

    private String getIndexPageName(int i) {
        if (i < 2) {
            return this.indexName;
        }
        return this.indexPageName + i + this.pageExt;
    }

    public String getIndexPagination(int curr, int max) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("<ul class=\"pagination\">");
        if (curr == 1) {
            sb.append("<li class=\"disabled\"><a href=\"#\">&laquo;</a></li>");
        } else {
            sb.append("<li><a href=\"").append(this.getIndexPageName(curr - 1)).append("\">&laquo;</a></li>");
        }
        for (int i = 1; i <= max; ++i) {
            if (i == curr) {
                sb.append("<li class=\"active\"><a href=\"#\">").append(i).append("</a></li>");
                continue;
            }
            sb.append("<li><a href=\"").append(this.getIndexPageName(i)).append("\">").append(i).append("</a></li>");
        }
        if (curr == max) {
            sb.append("<li class=\"disabled\"><a href=\"#\">&raquo;</a></li>");
        } else {
            sb.append("<li><a href=\"").append(this.getIndexPageName(curr + 1)).append("\">&raquo;</a></li>");
        }
        return sb.toString();
    }

    private String formatGps(String coord) {
        double degrees;
        if (coord == null) {
            return null;
        }
        String[] s = coord.split("[\u00b0'\" ]", 4);
        if (s == null || s.length < 1) {
            return null;
        }
        float minutes = 0.0f;
        float seconds = 0.0f;
        try {
            degrees = Double.parseDouble(s[0]);
            if (s.length > 1) {
                minutes = Float.parseFloat(s[1]);
            }
            if (s.length > 2) {
                seconds = Float.parseFloat(s[2]);
            }
        }
        catch (NumberFormatException e) {
            this.log("Number format error \"" + coord + "\"", e);
            return null;
        }
        DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
        df.setDecimalSeparatorAlwaysShown(false);
        df.setMaximumFractionDigits(5);
        return df.format(degrees + (double)((minutes * 60.0f + seconds) / 3600.0f)).replace(',', '.');
    }

    public String getLocation(AlbumObject ao) {
        String lon;
        String lat;
        Scope vars = ao.getVars();
        if (vars == null) {
            return "";
        }
        String loc = (String)vars.get((Object)"location");
        if (!this.isEmpty(loc) && loc.matches("([-\\d.]+),\\s*([-\\d.]+)")) {
            return loc;
        }
        loc = (String)vars.get((Object)"gpsLocation");
        if (loc != null && !this.isEmpty(loc)) {
            return loc;
        }
        Map met = (Map)vars.get((Object)"meta");
        if (met != null && (lat = this.formatGps((String)met.get("GPS.GPS Latitude"))) != null && (lon = this.formatGps((String)met.get("GPS.GPS Longitude"))) != null) {
            String latr = (String)met.get("GPS.GPS Latitude Ref");
            String lonr = (String)met.get("GPS.GPS Longitude Ref");
            if (latr != null && latr.equals("S")) {
                lat = ("-" + lat).replaceAll("--", "");
            }
            if (lonr != null && lonr.equals("W")) {
                lon = ("-" + lon).replaceAll("--", "");
            }
            return lat + "," + lon;
        }
        return "";
    }

    public Boolean checkLocation(AlbumObject ao) {
        Scope vars = ao.getVars();
        if (vars == null) {
            return false;
        }
        String loc = (String)vars.get((Object)"location");
        if (!this.isEmpty(loc) && loc.matches("([-\\d.]+),\\s*([-\\d.]+)")) {
            return true;
        }
        if (vars.get((Object)"gpsLatitude") != null) {
            return true;
        }
        Map met = (Map)vars.get((Object)"meta");
        if (met != null && met.get("GPS.GPS Latitude") != null) {
            return true;
        }
        return false;
    }

    public String getPhotoData(AlbumObject ao) {
        return this.isEmpty(this.photoDataTemplate) ? "" : this.getPhotoData(ao, this.photoDataTemplate);
    }

    public String getPhotoData(AlbumObject ao, String templ) {
        StringBuilder sb = new StringBuilder(1024);
        Scope vars = ao.getVars();
        block0: for (String keys : templ.split("[,;]")) {
            for (String key : keys.split("\\|")) {
                String val;
                Object o;
                if ((key = key.trim()).length() == 0 || key.charAt(0) == '#' || ((o = vars.get((Object)key)) == null || this.isEmpty(val = this.getString(o))) && ((val = this.getMeta(vars, key)) == null || val.length() <= 0) || key.equals("resolution") && val.equals(" x ")) continue;
                if (val.equals("Flash did not fire, auto")) {
                    val = "No";
                }
                if (this.showMetaLabel) {
                    String lbl = this.getExifLabel(key);
                    sb.append("<b>").append(this.isEmpty(lbl) ? key : lbl).append("</b> ").append(val);
                } else {
                    sb.append(val);
                }
                sb.append(this.photoDataSep);
                continue block0;
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - this.photoDataSep.length());
        }
        return sb.toString();
    }

    public String processTemplate(AlbumObject ao, String templ, boolean shorten) {
        if (ao.isFolder()) {
            return this.processTemplate(ao, templ, 0, shorten);
        }
        Integer n = this.getInteger(ao, "imageNum");
        return this.processTemplate(ao, templ, n == null ? 0 : n, shorten);
    }

    public String processTemplate(AlbumObject ao, String templ, int num) {
        return this.processTemplate(ao, templ, num, false);
    }

    public String processTemplate(AlbumObject ao, String templ) {
        if (ao.isFolder()) {
            return this.processTemplate(ao, templ, 0, false);
        }
        Integer n = this.getInteger(ao, "imageNum");
        return this.processTemplate(ao, templ, n == null ? 0 : n, false);
    }

    public String processTemplate(AlbumObject ao, String templ, int num, boolean shorten) {
        int i;
        if (this.isEmpty(templ)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(1024);
        int len = templ.length();
        int to = 0;
        do {
            if ((i = templ.indexOf(36, to)) < 0) {
                sb.append(templ.substring(to));
                continue;
            }
            sb.append(templ.substring(to, i));
            int from = i + 1;
            if (from < len) {
                String v;
                String k;
                if (templ.charAt(from) == '{') {
                    to = templ.indexOf(125, from);
                    if (to == -1) {
                        to = len;
                    }
                    k = templ.substring(from + 1, to);
                    ++to;
                } else {
                    char c;
                    for (to = from; to < len && (Character.isLetterOrDigit(c = templ.charAt(to)) || c == '.' || c == '-' || c == '_'); ++to) {
                    }
                    k = templ.substring(from, to);
                }
                if (k.equals("imageNum")) {
                    v = String.valueOf(num);
                } else {
                    v = this.getVar(ao, k);
                    if (shorten && (k.equals("comment") || k.equals("description")) && v.length() > 160) {
                        v = this.shorten(this.stripHTML(v));
                    }
                }
                sb.append(v);
                continue;
            }
            to = from;
        } while (i >= 0 && to < len);
        return this.stripEmptyHTML(sb.toString()).trim();
    }

    public String getThumbCaption(AlbumObject ao) {
        if (this.isEmpty(this.thumbCaptionTemplate)) {
            Scope vars = ao.getVars();
            return (String)vars.get((Object)"comment");
        }
        return this.processTemplate(ao, this.thumbCaptionTemplate);
    }

    public String getCaption(AlbumObject ao) {
        if (this.isEmpty(this.thumbCaptionTemplate)) {
            Scope vars = ao.getVars();
            return (String)vars.get((Object)"comment");
        }
        return this.processTemplate(ao, this.imgCaptionTemplate);
    }

    public String getShop(AlbumObject ao) {
        if (!this.shopValid) {
            return "";
        }
        Scope vars = ao.getVars();
        String so = (String)vars.get((Object)"shopOptions");
        if (this.isEmpty(so) || so.equals("-")) {
            return "";
        }
        return this.cleanup(so.replaceAll("\\n", "::"));
    }

    public String getMostphotosId(AlbumObject ao) {
        Object id = ao.getProperties().get("mostphotosImageId");
        return id == null ? "" : id.toString();
    }

    public String getRelPath(AlbumObject folder) {
        String relPath = "";
        if ((Integer)this.get("level") > 0) {
            File outDir = (File)this.get("outputDirectory");
            relPath = IO.relativePath((File)outDir, (File)this.rootOutputDirectory);
            relPath = relPath == null || relPath.equals("./") ? "" : relPath + "/";
        }
        return relPath;
    }

    public String getRootPath() {
        String rp = (String)this.get("rootPath");
        rp = rp.equals(".") ? "" : rp + "/";
        return rp;
    }

    public String getFolderPath(AlbumObject folder) {
        return this.urlEncode(this.basePath + this.getRelPath(folder));
    }

    public boolean copyFolderImages(AlbumObject folder, String folderImageFileName, String folderImageSize, String folderThumbFileName, String folderThumbSize) {
        return this.copyFolderImages(folder, folderImageFileName, folderImageSize, folderThumbFileName, folderThumbSize, false);
    }

    public boolean copyFolderImages(AlbumObject folder, String folderImageFileName, String folderImageSize, String folderThumbFileName, String folderThumbSize, boolean blur) {
        Boolean b;
        String s;
        Dimension dt;
        Dimension di;
        AlbumObject rep = folder.getRepresentingAlbumObject(true);
        if (rep == null || this.isEmpty(folderImageSize) || this.isEmpty(folderThumbSize) || this.isEmpty(folderImageFileName) || this.isEmpty(folderThumbFileName) || (di = this.getDim(folderImageSize)) == null || (dt = this.getDim(folderThumbSize)) == null || di.width == 0 || di.height == 0 || dt.width == 0 || dt.height == 0) {
            return false;
        }
        File outDir = (File)this.get("outputDirectory");
        File src = null;
        File dsti = new File(outDir, folderImageFileName);
        File dstt = new File(outDir, folderThumbFileName);
        AlbumObjectProperties props = folder.getProperties();
        AlbumImage ai = null;
        String folderImagePath = rep.getPathFromRoot();
        if (!(dsti.exists() && dstt.exists() && rep.getLastModified() <= dsti.lastModified() && (s = (String)props.get("lastFolderImagePath")) != null && s.equals(folderImagePath) && (s = (String)props.get("lastFolderImageSize")) != null && s.equals(folderImageSize) && (s = (String)props.get("lastFolderThumbSize")) != null && s.equals(folderThumbSize) && (b = (Boolean)props.get("lastFolderImageBlur")) != null && blur == b)) {
            try {
                ai = new AlbumImage(rep);
            }
            catch (IOException e) {
                Category cat = rep.getCategory();
                if (cat == Category.audio) {
                    src = new File(this.skinDirectory, "res/audio.poster.jpg");
                } else if (cat == Category.video) {
                    src = new File(this.skinDirectory, "res/video.poster.jpg");
                }
                if (src == null) {
                    src = FileFilters.getIconFor((File)rep.getFile());
                }
                if (src == null) {
                    return false;
                }
                try {
                    ai = new AlbumImage(src, this.engine);
                }
                catch (IOException ex) {
                    this.log("Fail to create folder image", ex);
                }
            }
            if (ai == null) {
                return false;
            }
            Dimension d1 = this.getDim((BufferedImage)ai.getImage());
            AlbumImage a = ai.applyFilters(1);
            a = (float)d1.width / (float)d1.height > (float)di.width / (float)di.height ? a.scaleToFit(new Dimension(Integer.MAX_VALUE, di.height)) : a.scaleToFit(new Dimension(di.width, Integer.MAX_VALUE));
            CropFilter cf = new CropFilter();
            cf.setBounds(di);
            cf.setYWeight(0.382f);
            a = a.applyFilter((JAFilter)cf);
            if (blur) {
                BlurFilter bf = new BlurFilter();
                bf.setRadius(80);
                a = a.applyFilter((JAFilter)bf);
            }
            a = a.applyFilters(2);
            try {
                a.saveImage(dsti);
            }
            catch (IOException e) {
                this.log("Can't save folder image file", e);
            }
            a = ai.applyFilters(1);
            a = (float)d1.width / (float)d1.height > (float)dt.width / (float)dt.height ? a.scaleToFit(new Dimension(Integer.MAX_VALUE, dt.height)) : a.scaleToFit(new Dimension(dt.width, Integer.MAX_VALUE));
            a = a.applyFilters(2);
            try {
                a.saveImage(dstt);
            }
            catch (IOException e) {
                this.log("Can't save folder thumb file", e);
            }
            props.put("lastFolderImagePath", (Object)folderImagePath);
            props.put("lastFolderImageSize", (Object)folderImageSize);
            props.put("lastFolderThumbSize", (Object)folderThumbSize);
            props.put("lastFolderImageBlur", (Object)blur);
            props.save(true);
        }
        return true;
    }

    public String getBreadcrumbPath(AlbumObject folder, String prefix, String pathSep) {
        StringBuilder sb = new StringBuilder();
        if (folder == null) {
            return "";
        }
        sb.append(this.getBreadcrumbPath(folder.getParent(), prefix + "../", pathSep));
        String title = folder.getTitle();
        if ("".equals(title)) {
            title = folder.getName();
        }
        if (pathSep.length() > 0 && sb.length() > 0) {
            sb.append(pathSep);
        }
        sb.append("<a href=\"").append(prefix).append(this.indexName).append("\">").append(title).append("</a>");
        return sb.toString();
    }

    public String getBreadcrumbPath(AlbumObject folder) {
        return (Integer)this.get("level") > 0 ? this.getBreadcrumbPath(folder.getParent(), "../", this.defPathSep) : "";
    }

    public String getIndexBreadcrumb(AlbumObject folder) {
        return (Integer)this.get("level") > 0 ? this.getBreadcrumbPath(folder.getParent(), "../", this.defPathSep) : "";
    }

    public String getSlideBreadcrumb(AlbumObject folder) {
        return folder == null ? "" : this.getBreadcrumbPath(folder, "../", this.defPathSep);
    }

    public String getPageBreadcrumb(AlbumObject folder) {
        return folder == null ? "" : this.getBreadcrumbPath(folder, "", this.defPathSep);
    }

    public String copyBackgroundAudio() {
        String pl = (String)this.skinVars.get("playlist");
        if (this.isEmpty(pl)) {
            return "";
        }
        return this.copyBackgroundAudio(pl);
    }

    public String copyBackgroundAudio(String pl) {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty(pl)) {
            for (String f : pl.split("\t")) {
                File src = new File(f);
                if (!src.exists() || !this.resDirectory.exists()) continue;
                try {
                    IO.copyFile((File)src, (File)this.resDirectory);
                    sb.append(sb.length() > 0 ? "::" : "").append(this.urlEncode(src.getName()));
                }
                catch (IOException e) {
                    this.log("Error copying background audio file(s):", e);
                }
            }
        }
        return sb.toString();
    }

    public String copyImage(String name) {
        File src;
        if (!this.isEmpty(name) && (src = new File(name)).exists() && this.resDirectory.exists()) {
            try {
                IO.copyFile((File)src, (File)this.resDirectory);
                return this.urlEncode(src.getName());
            }
            catch (IOException e) {
                this.log("Error copying image:", e);
            }
        }
        return "";
    }

    public void copyResource(String path, String srcName, String dstName) {
        if (!this.isEmpty(srcName)) {
            File src;
            File file = src = this.isEmpty(path) ? this.skinDirectory : new File(this.skinDirectory, path);
            if (src.exists()) {
                src = new File(src, srcName);
                File dst = new File(this.resDirectory, this.isEmpty(dstName) ? srcName : dstName);
                if (src.exists()) {
                    try {
                        IO.copyFile((File)src, (File)dst);
                    }
                    catch (IOException e) {
                        this.log("Error copying image:", e);
                    }
                }
            }
        }
    }

    public void copyDirectory(File src, File dst) {
        if (src.exists() && dst.exists()) {
            try {
                IO.copyDirectoryContent((File)src, (File)dst, (boolean)true);
            }
            catch (IOException e) {
                this.log("Error copying directory:", e);
            }
        }
    }

    public String xEncrypt(String s) {
        int i;
        int sl = s.length() + 4;
        int cl = (sl * 8 + 4) / 5;
        int[] src = new int[sl];
        String c = "";
        int v = 0;
        s = s + " ";
        for (i = 0; i < sl - 4; ++i) {
            char c2 = s.charAt(i);
            src[i + 4] = c2;
            v += c2;
        }
        src[0] = sl & 0xFF;
        src[1] = sl >> 8 & 0xFF;
        src[2] = v & 0xFF;
        src[3] = v >> 8 & 0xFF;
        for (i = 0; i < sl; ++i) {
            int n = i;
            src[n] = src[n] ^ this.xSalt[i % 8];
        }
        i = 0;
        int j = 0;
        while (i < cl) {
            int k = j / 8;
            v = src[k] << 8;
            if (k < sl - 1) {
                v += src[k + 1];
            }
            v = v >> 11 - j % 8 & 0x1F;
            c = c + (char)(v + (v > 9 ? 55 : 48));
            ++i;
            j += 5;
        }
        return c;
    }

    private String chSer() {
        int v;
        int i;
        int codeLength = 32;
        int sLength = 20;
        int[] x = new int[]{18, 69, 35, 160, 117, 99, 239, 66};
        int[] src = new int[sLength];
        String r = "";
        int j = 0;
        String s = this.getUserVar("chameleonSerial");
        if (this.isEmpty(s)) {
            s = this.getUserVar("turtleSerial");
        }
        if (this.isEmpty(s) || s.length() < codeLength) {
            return "";
        }
        for (i = 0; i < codeLength; ++i) {
            v = s.charAt(i) - 48;
            if (v > 9) {
                v -= 8;
            }
            v <<= 11 - j % 8;
            int k = j / 8;
            if (k < sLength) {
                int n = k++;
                src[n] = src[n] | v >> 8;
                if (k < sLength) {
                    int n2 = k;
                    src[n2] = src[n2] | v & 0xFF;
                }
            }
            j += 5;
        }
        for (i = 0; i < sLength; ++i) {
            int n = i;
            src[n] = src[n] ^ x[i % 8];
        }
        v = 0;
        for (i = 0; i < sLength - 2; ++i) {
            r = r + (char)src[i];
            v += src[i];
        }
        if (v == src[sLength - 2] % 256 + src[sLength - 1] * 256) {
            return r.substring(0, 14);
        }
        return "";
    }

    private String getLicense() {
        String s;
        if (this.licenseManager == null || (s = this.licenseManager.getLicenseCode()) == null) {
            s = this.wmk;
        }
        return s;
    }

    public Writer startSearch(File f) {
        return this.startSearch(f, false);
    }

    public Writer startSearch(File f, boolean saveCreated) {
        Long time = new Date().getTime();
        if (f == null) {
            return null;
        }
        try {
            this.searchStream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8"));
            this.searchStream.write("Search={");
            this.searchStream.write("\r\n\tmakeSlides:" + this.makeSlides + ",");
            this.searchStream.write("\r\n\tfolderThumb:'" + this.folderThumbFileName + "',");
            this.searchStream.write("\r\n\tindexName:'" + this.indexName + "',");
            this.searchStream.write("\r\n\tthumbs:'" + this.thumbsDir + "',");
            this.searchStream.write("\r\n\tslides:'" + this.slidesDir + "',");
            this.searchStream.write("\r\n\text:'" + this.pageExt.substring(1) + "',");
            this.searchStream.write("\r\n\turlEncode:" + (this.isUrlEncode ? "true" : "false") + ",");
            if (saveCreated) {
                this.searchStream.write("\r\n\tcreated:" + (int)(time / 86400000L) + ",");
            }
            this.searchStream.write("\r\n\tsep:'" + this.searchSep + "'");
            this.searchStream.write("\r\n};");
            this.searchStream.write("\r\nSearch.data=[");
        }
        catch (IOException e) {
            this.log("Error writing file:", e);
            return null;
        }
        return this.searchStream;
    }

    public void stopSearch() {
        if (this.searchStream == null) {
            return;
        }
        try {
            this.searchStream.write("\r\n];");
            this.searchStream.close();
        }
        catch (IOException e) {
            this.log("Error writing file:", e);
        }
    }

    public void startPageSearch(String path) {
        if (this.searchStream == null) {
            return;
        }
        try {
            this.searchStream.write((this.searchPageCount > 0 ? "," : "") + "\r\n\t[ '" + this.cleanPath(path).replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"") + "', [ ");
            this.searchTotalCount = 0;
        }
        catch (IOException e) {
            this.log("Error writing file:", e);
        }
    }

    public void stopPageSearch() {
        if (this.searchStream == null) {
            return;
        }
        try {
            this.searchStream.write(" ] ]");
            ++this.searchPageCount;
        }
        catch (IOException e) {
            this.log("Error writing file:", e);
        }
    }

    public void addSearchItem(String fn, String[] keys) {
        if (this.searchStream == null) {
            return;
        }
        try {
            this.searchStream.write((this.searchTotalCount > 0 ? "," : "") + "'" + fn.replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\""));
            for (String k : keys) {
                this.searchStream.write(this.searchSep + this.cleanItem(k));
            }
            this.searchStream.write("'");
            ++this.searchTotalCount;
        }
        catch (IOException e) {
            this.log("Error writing file:", e);
        }
    }

    public String getRootNavigation(AlbumObject co) {
        return this.getRootNavigation(co, true, " | ");
    }

    public String getRootNavigation(AlbumObject co, String sep) {
        return this.getRootNavigation(co, true, sep);
    }

    public String getRootNavigation(AlbumObject co, boolean home) {
        return this.getRootNavigation(co, home, " | ");
    }

    public String getRootNavigation(AlbumObject co, boolean home, String sep) {
        StringBuilder sb = new StringBuilder(1024);
        String root = this.getRootPath();
        if (home && !this.isEmpty(root)) {
            sb.append("<a href=\"").append(root).append(this.indexName).append("\" class=\"home\">").append(this.getText("home")).append("</a>");
        }
        for (AlbumObject ao : this.rootFolder.getChildren()) {
            Category cat;
            if (!ao.isIncluded() || ao.isHidden() || (cat = ao.getCategory()) != Category.folder && cat != Category.webPage) continue;
            Scope vars = ao.getVars();
            String t = (String)vars.get((Object)"title");
            if (cat == Category.webPage && t.equals("NewPhotos")) {
                t = this.getText("newPhotos");
            }
            sb.append(sb.length() > 0 ? sep : "").append("<a href=\"").append(root).append(vars.get((Object)"closeupPath")).append("\"").append(co.isWithin(ao) ? " class=\"actual\"" : "").append(">").append(t).append("</a>");
        }
        return sb.toString();
    }

    public String getNavigation(AlbumObject co) {
        return this.getNavigation(this.rootFolder, co, "", 3, true, false);
    }

    public String getNavigation(AlbumObject co, boolean home) {
        return this.getNavigation(this.rootFolder, co, "", 3, home, false);
    }

    public String getNavigation(AlbumObject co, boolean home, boolean excludeFolders) {
        return this.getNavigation(this.rootFolder, co, "", 3, home, excludeFolders);
    }

    public String getNavigation(AlbumObject co, int depth) {
        return this.getNavigation(this.rootFolder, co, "", depth, true, false);
    }

    public String getNavigation(AlbumObject folder, AlbumObject co, String relPath, int depth, boolean home, boolean excludeFolders) {
        String relp;
        StringBuilder sb = new StringBuilder(2048);
        String root = this.getRootPath();
        String string = relp = relPath.length() == 0 ? "" : relPath + "/";
        if (home) {
            sb.append("<li class=\"controls home\"><a href=\"").append(root).append(this.indexName).append("\" title=\"").append(this.getText("home")).append("\">&nbsp;</a></li>");
        }
        for (AlbumObject ao : folder.getChildren()) {
            Scope vars;
            String path;
            boolean isFolder;
            if (!ao.isIncluded() || ao.isHidden()) continue;
            Category cat = ao.getCategory();
            boolean bl = isFolder = cat == Category.folder;
            if (cat != Category.webPage && (excludeFolders || !isFolder) || (path = (String)(vars = ao.getVars()).get((Object)"closeupPath")) == null || this.indexName.equals(path)) continue;
            String t = (String)vars.get((Object)"title");
            if (cat == Category.webPage && t.equals("NewPhotos")) {
                t = this.getText("newPhotos");
            }
            sb.append("<li").append(co.isWithin(ao) ? " class=\"actual\"" : "").append(">");
            sb.append("<a href=\"").append(root).append(relp).append(path).append("\">").append(t).append("</a>");
            if (isFolder && depth > 0) {
                sb.append(this.getNavigation(ao, co, relp + path.substring(0, path.length() - this.indexName.length() - 1), depth - 1, false, false));
            }
            sb.append("</li>");
        }
        if (sb.length() > 0) {
            sb.insert(0, "<ul>");
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public String getSitemap() {
        return this.getSitemap(this.rootFolder, "", true, false);
    }

    public String getSitemap(boolean desc) {
        return this.getSitemap(this.rootFolder, "", desc, false);
    }

    public String getSitemap(boolean desc, boolean thumbs) {
        return this.getSitemap(this.rootFolder, "", desc, thumbs);
    }

    public String getSitemap(AlbumObject folder, String relPath, boolean desc, boolean thumbs) {
        StringBuilder sb = new StringBuilder(2048);
        String root = this.getRootPath();
        String relp = relPath.length() == 0 ? "" : relPath + "/";
        for (AlbumObject ao : folder.getChildren()) {
            boolean isFolder;
            if (!ao.isIncluded() || ao.isHidden()) continue;
            Category cat = ao.getCategory();
            boolean bl = isFolder = cat == Category.folder;
            if (!isFolder && cat != Category.webPage) continue;
            Scope vars = ao.getVars();
            String path = relp + vars.get((Object)"closeupPath");
            String lbl = (String)vars.get((Object)"label");
            if ("Sitemap".equals(lbl)) continue;
            sb.append("<li>");
            if (thumbs) {
                String tpath = root + (root.length() > 0 ? "/" : "");
                tpath = isFolder ? tpath + relp + this.urlEncode(lbl) + "/folderthumb.jpg" : tpath + "res/htt.png";
                sb.append("<a href=\"").append(root).append(path).append("\" class=\"thumb\"><img src=\"").append(tpath).append("\"></a><div>");
            }
            sb.append("<a href=\"").append(root).append(path).append("\">").append(vars.get((Object)"title")).append("</a>");
            if (desc) {
                String caption = this.stripHTML(cat == Category.webPage ? (String)vars.get((Object)"comment") : ao.getComment());
                if (caption.length() > 160) {
                    caption = this.shorten(this.stripHTML(caption));
                }
                if (!this.isEmpty(caption)) {
                    sb.append("<small>").append(caption).append("</small>");
                }
            }
            if (isFolder) {
                sb.append(this.getSitemap(ao, path.endsWith(this.indexName) ? path.substring(0, path.length() - this.indexName.length() - 1) : path, desc, thumbs));
            }
            if (thumbs) {
                sb.append("</div>");
            }
            sb.append("</li>");
        }
        if (sb.length() > 0) {
            sb.insert(0, "<ul>");
            sb.append("</ul>");
        }
        return sb.toString();
    }

    public String getCopiedFolderThumbPath(String orig) {
        return this.isEmpty(orig) ? "" : this.thumbsDir + "/" + orig.replace("/" + this.thumbsDir + "/", "/").replaceAll("/", "_");
    }

    private void copyFolderThumbs(AlbumObject folder) {
        String rp = folder.getPathFromRoot();
        File outDir = new File(this.rootOutputDirectory, rp);
        if (rp.length() > 0) {
            rp = rp + "/";
        }
        for (AlbumObject ao : folder.getChildren()) {
            AlbumObject rao;
            if (ao.getCategory() != Category.folder || !ao.isIncluded() || ao.isHidden()) continue;
            Scope vars = ao.getVars();
            String s = (String)vars.get((Object)"iconPath");
            if (s == null && (rao = ao.getRepresentingAlbumObject()) != null) {
                File src = new File(this.rootOutputDirectory, rao.getPathFromRoot());
                if ((src = new File(src.getParentFile(), this.thumbsDir + "/" + this.fixExtension(src.getName()))).exists()) {
                    File dst = new File(outDir, this.thumbsDir);
                    if (!dst.exists()) {
                        try {
                            dst.mkdirs();
                        }
                        catch (SecurityException e) {
                            this.log("Can't create \"thumbs\" folder:", e);
                            continue;
                        }
                    }
                    dst = new File(outDir, this.getCopiedFolderThumbPath(this.fixExtension(rao.getPathFromRoot().substring(rp.length()))));
                    try {
                        IO.copyFile((File)src, (File)dst, (boolean)true);
                    }
                    catch (IOException e) {
                        this.log("Error copying folder thumbnail:", e);
                    }
                } else {
                    System.out.println("Missing thumb: " + src.toString());
                }
            }
            this.copyFolderThumbs(ao);
        }
    }

    public void copyAllFolderThumbs() {
        String oldStatus = "";
        if (this.window != null) {
            oldStatus = this.window.statusBar.getText();
            this.window.statusBar.setText("Copying folder thumbnails...");
        }
        this.copyFolderThumbs(this.rootFolder);
        if (this.window != null) {
            this.window.statusBar.setText(oldStatus);
        }
    }

    public String getRegions(AlbumObject ao) {
        String p;
        String name;
        int i;
        Map xmp;
        StringBuilder sb = new StringBuilder(512);
        Scope vars = ao.getVars();
        if (vars == null || (xmp = (Map)vars.get((Object)"xmp")) == null) {
            return "";
        }
        if (xmp.containsKey(this.regionsPrefixPicasa)) {
            i = 1;
            while ((name = (String)xmp.get(this.regionsPrefixPicasa + "[" + i + "]/mwg-rs:Name")) != null) {
                Float h;
                Float w;
                Float y;
                p = this.regionsPrefixPicasa + "[" + i + "]/mwg-rs:Area/stArea:";
                Float x = this.getFloat(xmp.get(p + "x"));
                if (x != null && (y = this.getFloat(xmp.get(p + "y"))) != null && (w = this.getFloat(xmp.get(p + "w"))) != null && (h = this.getFloat(xmp.get(p + "h"))) != null) {
                    sb.append(name).append(";").append(String.valueOf((double)x.floatValue() - (double)w.floatValue() / 2.0)).append(";").append(String.valueOf((double)y.floatValue() - (double)h.floatValue() / 2.0));
                    sb.append(";").append(String.valueOf(w)).append(";").append(String.valueOf(h)).append("::");
                }
                ++i;
            }
        }
        if (xmp.containsKey(this.regionsPrefixMS)) {
            i = 1;
            while ((name = (String)xmp.get(this.regionsPrefixMS + "[" + i + "]/MPReg:PersonDisplayName")) != null) {
                p = (String)xmp.get(this.regionsPrefixMS + "[" + i + "]/MPReg:Rectangle");
                if (p != null) {
                    sb.append(name).append(";").append(p.replaceAll(",", ";").replaceAll(" ", "")).append("::");
                }
                ++i;
            }
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public String getRegionNames(String s) {
        StringBuilder sb = new StringBuilder(256);
        for (String r : s.split("::")) {
            sb.append(r.split(";")[0]).append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public int zipFolder(AlbumObject folder, ZipOutputStream out, String type, String zipName) throws IOException {
        byte[] buff = new byte[2048];
        boolean orig = type.equals("originals");
        boolean incl = type.equals("included") || type.equals("hires");
        File outDir = new File(this.rootOutputDirectory, folder.getPathFromRoot());
        File file = null;
        int added = 0;
        for (AlbumObject ao : folder.getChildren()) {
            Category cat;
            if (!ao.isIncluded() || ao.isHidden() || (cat = ao.getCategory()) == Category.webPage || cat == Category.folder) continue;
            if (orig) {
                file = ao.getFile();
            } else {
                String f;
                Scope vars = ao.getVars();
                if (vars != null && !this.isEmpty(f = (String)vars.get(incl ? "originalPath" : (cat == Category.image ? "imagePath" : "closeupPath")))) {
                    file = new File(outDir, f);
                }
            }
            if (file != null && file.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                }
                catch (IOException e) {
                    this.log("File not added to ZIP: " + file.getName(), e);
                }
                if (in == null) continue;
                try {
                    int len;
                    out.putNextEntry(new ZipEntry(file.getName()));
                    while ((len = in.read(buff)) > 0) {
                        out.write(buff, 0, len);
                    }
                }
                catch (IOException e) {
                    this.log("IO Exception", e);
                }
                out.closeEntry();
                in.close();
                ++added;
                continue;
            }
            if (incl) continue;
            System.out.println("File not added to ZIP: " + (file == null ? ao.getName() : file.getName()));
        }
        return added;
    }

    private void zipImages(AlbumObject folder, String type) {
        String zipName = folder.getWebName() + ".zip";
        try {
            File zip = new File(this.rootOutputDirectory, folder.getPathFromRoot());
            if (zip.exists()) {
                if ((zip = new File(zip, zipName)).exists() && zip.canWrite()) {
                    zip.delete();
                }
                ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zip));
                int added = this.zipFolder(folder, zout, type, zipName);
                zout.flush();
                zout.close();
                if (added == 0) {
                    zip.delete();
                }
            }
        }
        catch (IOException e) {
            this.log("IO Error:", e);
        }
        for (AlbumObject ao : folder.getChildren()) {
            if (ao.getCategory() != Category.folder || !ao.isIncluded() || ao.isHidden()) continue;
            this.zipImages(ao, type);
        }
    }

    private int zipAll(File folder, ZipOutputStream out, String base, String zipName) throws IOException {
        byte[] buff = new byte[2048];
        int baselen = base.length() + 1;
        int added = 0;
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                added += this.zipAll(file, out, base, zipName);
                continue;
            }
            String name = file.getName();
            if (name.equals(zipName)) continue;
            name = file.getAbsolutePath();
            if (baselen > 0) {
                name = name.substring(baselen);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
            }
            catch (IOException e) {
                this.log("File error: " + file.getName(), e);
            }
            if (in == null) continue;
            try {
                int len;
                out.putNextEntry(new ZipEntry(name));
                while ((len = in.read(buff)) > 0) {
                    out.write(buff, 0, len);
                }
            }
            catch (IOException e) {
                this.log("IO Exception", e);
            }
            out.closeEntry();
            in.close();
            ++added;
        }
        return added;
    }

    private void zipOutputDirectory() {
        String zipName = this.rootFolder.getWebName() + ".zip";
        try {
            File zip = new File(this.rootOutputDirectory, zipName);
            if (zip.exists() && zip.canWrite()) {
                zip.delete();
            }
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zip));
            int added = this.zipAll(this.rootOutputDirectory, zout, this.rootOutputDirectory.getAbsolutePath(), zipName);
            zout.flush();
            zout.close();
            if (added == 0) {
                zip.delete();
            }
        }
        catch (IOException e) {
            this.log("IO Error:", e);
        }
    }

    public void createZip(String type) {
        if (JOptionPane.showConfirmDialog((Component)this.window, this.texts.getString("ui.createZip"), "", 0) == 0) {
            String oldStatus = "";
            if (this.window != null) {
                oldStatus = this.window.statusBar.getText();
                this.window.statusBar.setText(type.equals("album") ? "Zipping album..." : "Zipping images...");
            }
            if (type.equals("album")) {
                this.zipOutputDirectory();
            } else {
                this.zipImages(this.rootFolder, type);
            }
            if (this.window != null) {
                this.window.statusBar.setText(oldStatus);
            }
        }
    }

    private String getLoc(String lan) {
        HashMap<String, String> _loc = new HashMap<String, String>();
        _loc.put("af", "af_ZA");
        _loc.put("ar", "ar_AR");
        _loc.put("az", "az_AZ");
        _loc.put("be", "be_BY");
        _loc.put("bg", "bg_BG");
        _loc.put("bn", "bn_IN");
        _loc.put("bs", "bs_BA");
        _loc.put("ca", "ca_ES");
        _loc.put("cs", "cs_CZ");
        _loc.put("cy", "cy_GB");
        _loc.put("da", "da_DK");
        _loc.put("de", "de_DE");
        _loc.put("el", "el_GR");
        _loc.put("en", "en_GB");
        _loc.put("en", "en_PI");
        _loc.put("en", "en_UD");
        _loc.put("en", "en_US");
        _loc.put("eo", "eo_EO");
        _loc.put("es", "es_ES");
        _loc.put("es", "es_LA");
        _loc.put("et", "et_EE");
        _loc.put("eu", "eu_ES");
        _loc.put("fa", "fa_IR");
        _loc.put("fb", "fb_LT");
        _loc.put("fi", "fi_FI");
        _loc.put("fo", "fo_FO");
        _loc.put("fr", "fr_CA");
        _loc.put("fr", "fr_FR");
        _loc.put("fy", "fy_NL");
        _loc.put("ga", "ga_IE");
        _loc.put("gl", "gl_ES");
        _loc.put("he", "he_IL");
        _loc.put("hi", "hi_IN");
        _loc.put("hr", "hr_HR");
        _loc.put("hu", "hu_HU");
        _loc.put("hy", "hy_AM");
        _loc.put("id", "id_ID");
        _loc.put("is", "is_IS");
        _loc.put("it", "it_IT");
        _loc.put("ja", "ja_JP");
        _loc.put("ka", "ka_GE");
        _loc.put("km", "km_KH");
        _loc.put("ko", "ko_KR");
        _loc.put("ku", "ku_TR");
        _loc.put("la", "la_VA");
        _loc.put("lt", "lt_LT");
        _loc.put("lv", "lv_LV");
        _loc.put("mk", "mk_MK");
        _loc.put("ml", "ml_IN");
        _loc.put("ms", "ms_MY");
        _loc.put("nb", "nb_NO");
        _loc.put("ne", "ne_NP");
        _loc.put("nl", "nl_NL");
        _loc.put("nn", "nn_NO");
        _loc.put("pa", "pa_IN");
        _loc.put("pl", "pl_PL");
        _loc.put("ps", "ps_AF");
        _loc.put("pt", "pt_BR");
        _loc.put("pt", "pt_PT");
        _loc.put("ro", "ro_RO");
        _loc.put("ru", "ru_RU");
        _loc.put("sk", "sk_SK");
        _loc.put("sl", "sl_SI");
        _loc.put("sq", "sq_AL");
        _loc.put("sr", "sr_RS");
        _loc.put("sv", "sv_SE");
        _loc.put("sw", "sw_KE");
        _loc.put("ta", "ta_IN");
        _loc.put("te", "te_IN");
        _loc.put("th", "th_TH");
        _loc.put("tl", "tl_PH");
        _loc.put("tr", "tr_TR");
        _loc.put("uk", "uk_UA");
        _loc.put("vi", "vi_VN");
        _loc.put("zh", "zh_CN");
        _loc.put("zh", "zh_HK");
        _loc.put("zh", "zh_TW");
        return (String)_loc.get(lan);
    }
}

