/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPNode;
import com.adobe.xmp.impl.XMPNodeUtils;
import com.adobe.xmp.impl.xpath.XMPPath;
import com.adobe.xmp.impl.xpath.XMPPathParser;
import com.adobe.xmp.options.IteratorOptions;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.properties.XMPPropertyInfo;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class XMPIteratorImpl
implements XMPIterator {
    private IteratorOptions options;
    private String baseNS = null;
    protected boolean skipSiblings = false;
    protected boolean skipSubtree = false;
    private Iterator nodeIterator = null;

    public XMPIteratorImpl(XMPMetaImpl xMPMetaImpl, String string, String string2, IteratorOptions iteratorOptions) throws XMPException {
        boolean bl;
        this.options = iteratorOptions != null ? iteratorOptions : new IteratorOptions();
        XMPNode xMPNode = null;
        String string3 = null;
        boolean bl2 = string != null && string.length() > 0;
        boolean bl3 = bl = string2 != null && string2.length() > 0;
        if (!bl2 && !bl) {
            xMPNode = xMPMetaImpl.getRoot();
        } else if (bl2 && bl) {
            XMPPath xMPPath = XMPPathParser.expandXPath(string, string2);
            XMPPath xMPPath2 = new XMPPath();
            for (int i = 0; i < xMPPath.size() - 1; ++i) {
                xMPPath2.add(xMPPath.getSegment(i));
            }
            xMPNode = XMPNodeUtils.findNode(xMPMetaImpl.getRoot(), xMPPath, false, null);
            this.baseNS = string;
            string3 = xMPPath2.toString();
        } else if (bl2 && !bl) {
            xMPNode = XMPNodeUtils.findSchemaNode(xMPMetaImpl.getRoot(), string, false);
        } else {
            throw new XMPException("Schema namespace URI is required", 101);
        }
        this.nodeIterator = xMPNode != null ? (!this.options.isJustChildren() ? new NodeIterator(xMPNode, string3, 1) : new NodeIteratorChildren(xMPNode, string3)) : Collections.EMPTY_LIST.iterator();
    }

    public void skipSubtree() {
        this.skipSubtree = true;
    }

    public void skipSiblings() {
        this.skipSubtree();
        this.skipSiblings = true;
    }

    public boolean hasNext() {
        return this.nodeIterator.hasNext();
    }

    public Object next() {
        return this.nodeIterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException("The XMPIterator does not support remove().");
    }

    protected IteratorOptions getOptions() {
        return this.options;
    }

    protected String getBaseNS() {
        return this.baseNS;
    }

    protected void setBaseNS(String string) {
        this.baseNS = string;
    }

    private class NodeIteratorChildren
    extends NodeIterator {
        private String parentPath;
        private Iterator childrenIterator;
        private int index;

        public NodeIteratorChildren(XMPNode xMPNode, String string) {
            this.index = 0;
            if (xMPNode.getOptions().isSchemaNode()) {
                XMPIteratorImpl.this.setBaseNS(xMPNode.getName());
            }
            this.parentPath = this.accumulatePath(xMPNode, string, 1);
            this.childrenIterator = xMPNode.iterateChildren();
        }

        public boolean hasNext() {
            if (this.getReturnProperty() != null) {
                return true;
            }
            if (XMPIteratorImpl.this.skipSiblings) {
                return false;
            }
            if (this.childrenIterator.hasNext()) {
                XMPNode xMPNode = (XMPNode)this.childrenIterator.next();
                ++this.index;
                String string = null;
                if (xMPNode.getOptions().isSchemaNode()) {
                    XMPIteratorImpl.this.setBaseNS(xMPNode.getName());
                } else if (xMPNode.getParent() != null) {
                    string = this.accumulatePath(xMPNode, this.parentPath, this.index);
                }
                if (!XMPIteratorImpl.this.getOptions().isJustLeafnodes() || !xMPNode.hasChildren()) {
                    this.setReturnProperty(this.createPropertyInfo(xMPNode, XMPIteratorImpl.this.getBaseNS(), string));
                    return true;
                }
                return this.hasNext();
            }
            return false;
        }
    }

    private class NodeIterator
    implements Iterator {
        protected static final int ITERATE_NODE = 0;
        protected static final int ITERATE_CHILDREN = 1;
        protected static final int ITERATE_QUALIFIER = 2;
        private int state = 0;
        private XMPNode visitedNode;
        private String path;
        private Iterator childrenIterator = null;
        private int index = 0;
        private Iterator subIterator = Collections.EMPTY_LIST.iterator();
        private XMPPropertyInfo returnProperty = null;

        public NodeIterator() {
        }

        public NodeIterator(XMPNode xMPNode, String string, int n) {
            this.visitedNode = xMPNode;
            this.state = 0;
            if (xMPNode.getOptions().isSchemaNode()) {
                XMPIteratorImpl.this.setBaseNS(xMPNode.getName());
            }
            this.path = this.accumulatePath(xMPNode, string, n);
        }

        public boolean hasNext() {
            if (this.returnProperty != null) {
                return true;
            }
            if (this.state == 0) {
                return this.reportNode();
            }
            if (this.state == 1) {
                boolean bl;
                if (this.childrenIterator == null) {
                    this.childrenIterator = this.visitedNode.iterateChildren();
                }
                if (!(bl = this.iterateChildren(this.childrenIterator)) && this.visitedNode.hasQualifier() && !XMPIteratorImpl.this.getOptions().isOmitQualifiers()) {
                    this.state = 2;
                    this.childrenIterator = null;
                    bl = this.hasNext();
                }
                return bl;
            }
            if (this.childrenIterator == null) {
                this.childrenIterator = this.visitedNode.iterateQualifier();
            }
            return this.iterateChildren(this.childrenIterator);
        }

        protected boolean reportNode() {
            this.state = 1;
            if (!(this.visitedNode.getParent() == null || XMPIteratorImpl.this.getOptions().isJustLeafnodes() && this.visitedNode.hasChildren())) {
                this.returnProperty = this.createPropertyInfo(this.visitedNode, XMPIteratorImpl.this.getBaseNS(), this.path);
                return true;
            }
            return this.hasNext();
        }

        private boolean iterateChildren(Iterator iterator) {
            if (XMPIteratorImpl.this.skipSiblings) {
                XMPIteratorImpl.this.skipSiblings = false;
                this.subIterator = Collections.EMPTY_LIST.iterator();
            }
            if (!this.subIterator.hasNext() && iterator.hasNext()) {
                XMPNode xMPNode = (XMPNode)iterator.next();
                ++this.index;
                this.subIterator = new NodeIterator(xMPNode, this.path, this.index);
            }
            if (this.subIterator.hasNext()) {
                this.returnProperty = (XMPPropertyInfo)this.subIterator.next();
                return true;
            }
            return false;
        }

        public Object next() {
            if (this.hasNext()) {
                XMPPropertyInfo xMPPropertyInfo = this.returnProperty;
                this.returnProperty = null;
                return xMPPropertyInfo;
            }
            throw new NoSuchElementException("There are no more nodes to return");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected String accumulatePath(XMPNode xMPNode, String string, int n) {
            String string2;
            String string3;
            if (xMPNode.getParent() == null || xMPNode.getOptions().isSchemaNode()) {
                return null;
            }
            if (xMPNode.getParent().getOptions().isArray()) {
                string3 = "";
                string2 = "[" + String.valueOf(n) + "]";
            } else {
                string3 = "/";
                string2 = xMPNode.getName();
            }
            if (string == null || string.length() == 0) {
                return string2;
            }
            if (XMPIteratorImpl.this.getOptions().isJustLeafname()) {
                return !string2.startsWith("?") ? string2 : string2.substring(1);
            }
            return string + string3 + string2;
        }

        protected XMPPropertyInfo createPropertyInfo(final XMPNode xMPNode, final String string, final String string2) {
            final String string3 = xMPNode.getOptions().isSchemaNode() ? null : xMPNode.getValue();
            return new XMPPropertyInfo(){

                public String getNamespace() {
                    return string;
                }

                public String getPath() {
                    return string2;
                }

                public Object getValue() {
                    return string3;
                }

                public PropertyOptions getOptions() {
                    return xMPNode.getOptions();
                }

                public String getLanguage() {
                    return null;
                }
            };
        }

        protected Iterator getChildrenIterator() {
            return this.childrenIterator;
        }

        protected void setChildrenIterator(Iterator iterator) {
            this.childrenIterator = iterator;
        }

        protected XMPPropertyInfo getReturnProperty() {
            return this.returnProperty;
        }

        protected void setReturnProperty(XMPPropertyInfo xMPPropertyInfo) {
            this.returnProperty = xMPPropertyInfo;
        }
    }
}

