<ja:if test="<%= navigation %>">	
	<script src="${resPath}/jquery.hotkeys.js" type="text/javascript"></script>
	<script src="${resPath}/galleria/jquery.galleria.js" type="text/javascript"></script>
	<script src="${resPath}/jquery.scrollimages.js" type="text/javascript"></script>	
	<ja:if test="<%= showMetadata %>">
		<script type="text/javascript"><!--//--><![CDATA[//><!--
			(function($) {
				$.fn.addMetadata = function(key, val) {
					if (val) {
						this.append($("<li>" + key + ": " + val + "</li>"));
					}
					return this;
				}
			})(jQuery);
		//--><!]]></script>
	</ja:if>
	<script type="text/javascript"><!--//--><![CDATA[//><!--	
		$(function() {
			$("#thumbnails_container").imageScroller({
				onBeforeScroll: function() { $.galleria.stop() },
				onScroll: function() { $.galleria.start() }, 
				duration: <%= scrollDuration %>, 
				imageWidth: <%= thumbItemSize %>, 
				size: <%= scrollerSize %>,
				fastSteps: <%= fastNavigationStep %>
			});
			
			var formattedThumbnailOpacity = ${unformattedThumbnailOpacity}/100;
			
			$(".thumbnails_unstyled").addClass("thumbnails");
			$("ul.thumbnails").galleria({
				history: ${enableHistory},
				clickNext: true,
				insert: "#main_image",
				onImage: function(image, caption, thumb) {
					var extras = $("#extras").css("display", "none").empty();
					image.css("display", "none").fadeIn(<%= mainImageFadeIn %>);
					caption.css("display", "none").fadeIn(<%= mainImageFadeIn %>);
					
					if (<%= showMetadata %>) {
						var extrasList = $("<ul></ul>");
						extrasList.addMetadata("$text.metadata.originalDate", thumb.data("originalDate"));
						extrasList.addMetadata("$text.metadata.cameraModel", thumb.data("cameraModel"));
						extrasList.addMetadata("$text.metadata.exposureTime", thumb.data("exposureTime"));
						extrasList.addMetadata("$text.metadata.isoEquivalent", thumb.data("isoEquivalent"));
						extrasList.addMetadata("$text.metadata.aperture", thumb.data("aperture"));
						extrasList.addMetadata("$text.metadata.focusDistance", thumb.data("focusDistance"));
						extrasList.addMetadata("$text.metadata.focalLength35mm", thumb.data("focalLength35mm"));
						extrasList.addMetadata("$text.metadata.keywords", thumb.data("keywords"));
						if (extrasList.children().length > 0) {
							extras.append(extrasList);						
							extrasList.find(":first-child").addClass("first");
							extras.css({ 
								width : (image.outerWidth() - (<%= extrasPadding %> * 2) + <%= extrasAdditionalWidth %>) + "px" 
							}).fadeIn(<%= mainImageFadeIn %>);
						}
					}
					
					var li = thumb.parents("li");
					li.siblings().children("img.selected").fadeTo(<%= selectedThumbnailFadeOut %>, formattedThumbnailOpacity);
					thumb.fadeTo("fast", 1).addClass("selected");
					image.attr("title", "$text.content.nextImage");
					
					var original = thumb.data("original");
					if (original) {
						var originalLink = $("<a></a>").attr("href", original).text("$text.content.downloadOriginal");
						caption.append(" (").append(originalLink).append(")");
					}
				},
				onThumb: function(thumb) {
					var li = thumb.parents("li");
					var fadeTo = li.is(".active") ? "1" : formattedThumbnailOpacity;
					thumb.css({display: "none", opacity: fadeTo}).fadeIn(<%= selectedThumbnailFadeIn %>);
					thumb.hover(
						function() { 
							thumb.fadeTo("fast", 1);		
						},
						function() {
							li.not(".active").children("img").fadeTo("fast", formattedThumbnailOpacity);
						}
					)
				},
				preloads: <%= preloads %>,
				fastSteps: <%= fastNavigationStep %>,
				onPrev: function() {
					$.imageScroller.scrollLeft();
				},
				onNext: function() {
					$.imageScroller.scrollRight();
				},
				onPrevFast: function() {
					$.imageScroller.fastScrollLeft();
				},
				onNextFast: function() {
					$.imageScroller.fastScrollRight();
				},
				enableSlideshow : <%= slideshowEnable %>,
				autostartSlideshow : <%= slideshowAutostart %>,
				slideshowDelay : <%= slideshowDelay %>,
				onSlideshowPlayed : function() {
					$('.play').hide();
					$('.pause').show();	
				},
				onSlideshowPaused : function() {
					$('.play').show();
					$('.pause').hide();
				}
			});
			
			$.galleria.loader = $("<div></div>").addClass("loader").append($(new Image()).attr("src","${resPath}/loader.gif").attr("title","$text.content.loading"));
			
			prepareArrow = function(arrow) {
				arrow.css({display: "none", opacity: <%= arrowOpacity %>, "padding-top": "<%= (thumbItemSize - thumbnailMargin) > arrowHeight ? ((thumbItemSize - thumbnailMargin) - arrowHeight)/2 : 0 %>px"}).fadeIn( <%= arrowFadeIn %>);			
				arrow.hover(
					function() {
						arrow.fadeTo("fast", 1);
					},
					function() {
						arrow.fadeTo("fast", <%= arrowOpacity %>);			
					}
				);	
			}
			
			var leftArrow = $("#left_arrow");
			prepareArrow(leftArrow);
			leftArrow.click(function() {
				$.galleria.prev();	
			});
			
			var rightArrow = $("#right_arrow");
			prepareArrow(rightArrow);
			rightArrow.click(function() {
				$.galleria.next();
			});
			
			if (<%= fastNavigation %>) {
				var leftFastArrow = $("#left_fast_arrow");
				prepareArrow(leftFastArrow);
				leftFastArrow.click(function() {
					$.galleria.prevFast();
				});
				
				var rightFastArrow = $("#right_fast_arrow");
				prepareArrow(rightFastArrow);
				rightFastArrow.click(function() {
					$.galleria.nextFast();
				});
			}
		});

		$(document).bind("keydown", "left", function() {
			if (!KeyboardNavigation.widgetHasFocus()) {
				$.galleria.prev();
			}
		});
		$(document).bind("keydown", "right", function() {
			if (!KeyboardNavigation.widgetHasFocus()) {
				$.galleria.next();
			}
		});
		$(document).bind("keydown", "space", function() {
			if (!KeyboardNavigation.widgetHasFocus()) {
				$.galleria.toggleSlideshow();
			}
		});

		var KeyboardNavigation = {
			widgetHasFocus: function() {
				if(typeof _jaWidgetFocus != 'undefined' && _jaWidgetFocus) {
					return true;
				}
				return false;
			}
		}
	//--><!]]></script>
</ja:if>
<ja:if test="<%= folders %>">
	<script type="text/javascript"><!--//--><![CDATA[//><!--		
		var formattedFolderIconOpacity = ${unformattedFolderIconOpacity}/100;
	
		$(function() {
			$("ul.folders li a").css({display: "none", opacity: formattedFolderIconOpacity}).fadeIn(<%= folderFadeIn %>).hover(
				function() { 
					$(this).fadeTo("fast", 1);		
				},
				function() {
					$(this).fadeTo("fast", formattedFolderIconOpacity);
				}
			);
		});
	//--><!]]></script>
</ja:if>
