/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyCore;
import component.BuddyList;
import component.IcbmCore;
import component.ImportExportConstants;
import component.LocateCore;
import component.Tool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import main.LoginCore;
import main.Oscar;
import uiutil.ChangeListener;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.HorizontalRule;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.JUtil;
import util.KeyBindings;
import util.Log;

public class ImportProps
extends PropertySheet
implements ActionListener,
ChangeListener,
ChoiceListener,
ComponentListener,
ImportExportConstants,
ItemListener,
TextListener {
    private String MODULE = "ImportProps";
    private Frame frame;
    private Tools tools;
    private ChangeListener changeListener;
    private boolean changed = false;
    private Label buddyListLabel;
    private List buddyListList;
    private Checkbox buddyCheck;
    private Checkbox nicknameCheck;
    private Checkbox connectionCheck;
    private Checkbox profileCheck;
    private Checkbox privacyCheck;
    private Checkbox imCheck;
    private CheckboxGroup typeGroup;
    private Checkbox mergeCheck;
    private Checkbox replaceCheck;
    private TextField importTextField;
    private Button openButton;
    private Button importButton;
    private Label importTypeLabel;
    private KeyBindings preferences;

    public ImportProps(Frame frame, Tools tools, ChangeListener changeListener) {
        this.frame = frame;
        this.tools = tools;
        this.changeListener = changeListener;
        this.setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        this.add("North", new Spacer());
        this.add("West", new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        this.add("Center", transparentPanel);
        TransparentPanel transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add("North", transparentPanel2);
        TransparentPanel transparentPanel3 = new TransparentPanel(new BorderLayout());
        transparentPanel2.add("North", transparentPanel3);
        transparentPanel3.add("West", new Label("Import From:"));
        this.importTextField = new TextField();
        transparentPanel3.add("Center", this.importTextField);
        this.importTextField.addTextListener(this);
        TransparentPanel transparentPanel4 = new TransparentPanel(new FlowLayout(1, 5, 0));
        transparentPanel3.add("East", transparentPanel4);
        this.openButton = new Button("Browse");
        transparentPanel4.add(this.openButton);
        this.openButton.addActionListener(this);
        transparentPanel2.add("South", new HorizontalRule(5, 5));
        transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add("West", transparentPanel2);
        this.buddyListLabel = new Label("Buddy Lists");
        transparentPanel2.add("North", this.buddyListLabel);
        this.buddyListList = new List(2, true);
        transparentPanel2.add("Center", this.buddyListList);
        this.buddyListList.addItemListener(this);
        this.buddyListList.addComponentListener(this);
        transparentPanel3 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel2.add("South", transparentPanel3);
        this.buddyCheck = new Checkbox("Buddy Preferences");
        transparentPanel3.add(this.buddyCheck);
        this.buddyCheck.addItemListener(this);
        transparentPanel3.add(new Spacer());
        transparentPanel3.add(new Spacer());
        transparentPanel2 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel.add("East", transparentPanel2);
        transparentPanel2.add(new Spacer());
        this.connectionCheck = new Checkbox("Connection Settings");
        transparentPanel2.add(this.connectionCheck);
        this.connectionCheck.addItemListener(this);
        this.nicknameCheck = new Checkbox("Saved User Name(s)");
        transparentPanel2.add(this.nicknameCheck);
        this.nicknameCheck.addItemListener(this);
        this.privacyCheck = new Checkbox("Privacy Preferences");
        transparentPanel2.add(this.privacyCheck);
        this.privacyCheck.addItemListener(this);
        this.imCheck = new Checkbox("IM Preferences");
        transparentPanel2.add(this.imCheck);
        this.imCheck.addItemListener(this);
        this.profileCheck = new Checkbox("Personal Profile");
        transparentPanel2.add(this.profileCheck);
        this.profileCheck.addItemListener(this);
        transparentPanel2.add(new Spacer());
        transparentPanel2.add(new Spacer());
        transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add("South", transparentPanel2);
        transparentPanel2.add("North", new HorizontalRule(5, 5));
        transparentPanel3 = new TransparentPanel(new BorderLayout());
        transparentPanel2.add("Center", transparentPanel3);
        transparentPanel4 = new TransparentPanel(new FlowLayout(0, 0, 0));
        transparentPanel3.add("Center", transparentPanel4);
        this.importTypeLabel = new Label("Import Type:");
        transparentPanel4.add(this.importTypeLabel);
        this.typeGroup = new CheckboxGroup();
        this.mergeCheck = new Checkbox("Merge", this.typeGroup, true);
        transparentPanel4.add(this.mergeCheck);
        this.mergeCheck.addItemListener(this);
        this.replaceCheck = new Checkbox("Replace", this.typeGroup, false);
        transparentPanel4.add(this.replaceCheck);
        this.replaceCheck.addItemListener(this);
        transparentPanel4 = new TransparentPanel(new FlowLayout(1, 5, 0));
        transparentPanel3.add("East", transparentPanel4);
        this.importButton = new Button("Import");
        transparentPanel4.add(this.importButton);
        this.importButton.addActionListener(this);
        transparentPanel2.add("South", new Spacer());
        this.setValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.openButton)) {
            String string;
            FileDialog fileDialog = new FileDialog(this.frame, "Import File", 0);
            this.setFileDialog(fileDialog, this.importTextField);
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getFile() != null && !(string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile()).equalsIgnoreCase(this.importTextField.getText())) {
                ((TextComponent)this.importTextField).setText(string);
                return;
            }
        } else if (object.equals(this.importButton)) {
            if (this.replaceCheck.getState()) {
                ChoiceUI.newChoiceUI(this, 0, null, "Import Confirmation", "You have chosen to completely replace your current preferences with the imported preferences. All your current preferences will be lost. Are you sure you want to do this?", "Yes", "Cancel", null, Oscar.WARNING_SOUND);
                return;
            }
            this.importConfiguration();
        }
    }

    public boolean changed() {
        return this.changed;
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n2 == 0) {
            this.importConfiguration();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.buddyListList.makeVisible(0);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private KeyBindings getImportConfig(String string, boolean bl) {
        KeyBindings keyBindings;
        block11: {
            FileInputStream fileInputStream;
            block10: {
                keyBindings = null;
                fileInputStream = null;
                if (string != null) {
                    try {
                        fileInputStream = new FileInputStream(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileInputStream = null;
                        if (!bl) break block10;
                        Log.log(this.MODULE, Log.WARNING, "Unable to open import file \"fileName+\".");
                    }
                }
            }
            if (fileInputStream != null) {
                try {
                    keyBindings = new KeyBindings();
                    keyBindings.read(keyBindings.getTokenizer(new InputStreamReader(fileInputStream)), '{', '}', false);
                }
                catch (IOException iOException) {
                    keyBindings = null;
                    if (!bl) break block11;
                    Log.log(this.MODULE, Log.WARNING, "Error reading import file \"fileName+\".");
                }
            }
        }
        if (keyBindings != null) {
            String string2 = keyBindings.getValue("Config.version");
            if (string2 == null || !string2.equals("1")) {
                keyBindings = null;
                if (bl) {
                    Log.log(this.MODULE, Log.WARNING, "Unrecognized import file format version " + string2 + ".");
                }
            }
        } else {
            keyBindings = new KeyBindings();
        }
        return keyBindings;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Import Help", "Import provides a way to selectively import preferences to " + Oscar.FULL_NAME + ". Specify a file to import from with " + "the Browse button. (The file must have been created using " + "the Export feature of " + Oscar.FULL_NAME + ".) Once you've " + "specified an import file, select the buddy lists and " + "other preferences you want to import. Press the Import " + "button to update your preferences. If you want to save " + "the information about how to import your preferences, " + "press the OK or Apply button in Setup.");
        return true;
    }

    private void importConfiguration() {
        KeyBindings keyBindings = this.getImportConfig(this.importTextField.getText(), true);
        if (keyBindings == null || keyBindings.size() == 0) {
            return;
        }
        KeyBindings keyBindings2 = new KeyBindings();
        KeyBindings keyBindings3 = new KeyBindings();
        this.saveBuddyListNames(keyBindings3);
        keyBindings3.setValue(BuddyCore.BUDDY_PREFS_KEY, String.valueOf(this.buddyCheck.getState()));
        keyBindings3.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.NICKNAME_KEY, String.valueOf(this.nicknameCheck.getState()));
        keyBindings3.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.LOGIN_KEY, String.valueOf(this.connectionCheck.getState()));
        keyBindings3.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.USE_PROXY_KEY, String.valueOf(this.connectionCheck.getState()));
        keyBindings3.setValue("Privacy", String.valueOf(this.privacyCheck.getState()));
        keyBindings3.setValue(LocateCore.LOCATE_KEY, String.valueOf(this.profileCheck.getState()));
        keyBindings3.setValue(IcbmCore.IM_KEY, String.valueOf(this.imCheck.getState()));
        Enumeration enumeration = this.tools.elements();
        while (enumeration.hasMoreElements()) {
            Tool tool = (Tool)enumeration.nextElement();
            tool.importProperties(keyBindings, keyBindings2, keyBindings3, this.replaceCheck.getState());
        }
        KeyBindings keyBindings4 = Oscar.config.getKeyBindings("ImportExport");
        if (keyBindings4 != null) {
            keyBindings2.setValues("ImportExport", keyBindings4);
        }
        Oscar.config = keyBindings2;
        Oscar.saveConfiguration();
        ChoiceUI.newChoiceUI("Import", "Your preferences were successfully imported. Please restart " + Oscar.FULL_NAME + " for the new preferences to take effect.", "save");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    public void removeNotify() {
        this.removeAll();
        this.MODULE = null;
        this.frame = null;
        this.tools = null;
        this.changeListener = null;
        this.buddyListLabel = null;
        this.buddyListList = null;
        this.buddyCheck = null;
        this.nicknameCheck = null;
        this.connectionCheck = null;
        this.profileCheck = null;
        this.privacyCheck = null;
        this.imCheck = null;
        this.typeGroup = null;
        this.mergeCheck = null;
        this.replaceCheck = null;
        this.importTextField = null;
        this.openButton = null;
        this.importButton = null;
        this.importTypeLabel = null;
        this.preferences = null;
        super.removeNotify();
    }

    public boolean save() {
        this.preferences = Oscar.config.getKeyBindingsOrAdd("ImportExport.import");
        this.saveBuddyListNames(this.preferences);
        this.preferences.setValue(BuddyCore.BUDDY_PREFS_KEY, String.valueOf(this.buddyCheck.getState()));
        this.preferences.setValue(IcbmCore.IM_KEY, String.valueOf(this.imCheck.getState()));
        this.preferences.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.NICKNAME_KEY, String.valueOf(this.nicknameCheck.getState()));
        this.preferences.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.LOGIN_KEY, String.valueOf(this.connectionCheck.getState()));
        this.preferences.setValue(LocateCore.LOCATE_KEY, String.valueOf(this.profileCheck.getState()));
        this.preferences.setValue("Privacy", String.valueOf(this.privacyCheck.getState()));
        if (this.replaceCheck.getState()) {
            this.preferences.setValue("type", "replace");
        } else {
            this.preferences.setValue("type", "merge");
        }
        String string = this.importTextField.getText();
        if (string == null || string.length() == 0) {
            this.preferences.deleteKey("file");
        } else {
            this.preferences.setValue("file", string.replace(File.separatorChar, '/'));
        }
        this.setChanged(false);
        return true;
    }

    private void saveBuddyListNames(KeyBindings keyBindings) {
        String[] stringArray = this.buddyListList.getSelectedItems();
        keyBindings.deleteKey(BuddyCore.BUDDY_LIST_KEY);
        keyBindings.addKeyBindings(BuddyCore.BUDDY_LIST_KEY);
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            keyBindings.appendValue(BuddyCore.BUDDY_LIST_KEY, stringArray[n]);
            ++n;
        }
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    private void setFileDialog(FileDialog fileDialog, TextField textField) {
        String string = textField.getText();
        if (string != null) {
            String string2;
            int n = string.lastIndexOf(File.separator);
            if (n != -1) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            } else {
                string2 = string;
                string = null;
            }
            if (string != null) {
                fileDialog.setDirectory(string);
            }
            fileDialog.setFile(string2);
        }
    }

    private void settingsEnabled(boolean bl) {
        this.buddyListLabel.setEnabled(bl);
        this.buddyListLabel.setAlignment(0);
        this.buddyListList.setEnabled(bl);
        this.buddyCheck.setEnabled(bl);
        this.nicknameCheck.setEnabled(bl);
        this.connectionCheck.setEnabled(bl);
        this.profileCheck.setEnabled(bl);
        this.privacyCheck.setEnabled(bl);
        this.imCheck.setEnabled(bl);
        this.importTypeLabel.setEnabled(bl);
        this.importTypeLabel.setAlignment(0);
        this.mergeCheck.setEnabled(bl);
        this.replaceCheck.setEnabled(bl);
        this.importButton.setEnabled(bl);
    }

    public void setValues() {
        this.preferences = Oscar.config.getKeyBindingsOrAdd("ImportExport.import");
        KeyBindings keyBindings = null;
        String string = this.preferences.getValue("file");
        if (string != null) {
            string = string.replace('/', File.separatorChar);
        }
        keyBindings = this.getImportConfig(string, true);
        this.setValuesForBuddyList(keyBindings.getKeyBindings(BuddyCore.BUDDY_LIST_KEY), this.preferences);
        string = this.preferences.getValueDefault(BuddyCore.BUDDY_PREFS_KEY, "true");
        this.buddyCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.NICKNAME_KEY, "true");
        this.nicknameCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.LOGIN_KEY, "true");
        this.connectionCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault(LocateCore.LOCATE_KEY, "true");
        this.profileCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault("Privacy", "true");
        this.privacyCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault(IcbmCore.IM_KEY, "true");
        this.imCheck.setState(JUtil.isTrue(string));
        string = this.preferences.getValueDefault("type", "merge");
        if (string.equalsIgnoreCase("replace")) {
            this.replaceCheck.setState(true);
        } else {
            this.mergeCheck.setState(true);
        }
        string = this.preferences.getValueDefault("file", "");
        ((TextComponent)this.importTextField).setText(string.replace('/', File.separatorChar));
        this.settingsEnabled(keyBindings != null && keyBindings.size() > 0);
        this.setChanged(false);
    }

    private void setValuesForBuddyList(KeyBindings keyBindings, KeyBindings keyBindings2) {
        KeyBindings keyBindings3 = null;
        BuddyCore buddyCore = (BuddyCore)this.tools.get("Buddy List");
        BuddyList[] buddyListArray = new BuddyList[]{};
        int n = 0;
        if (keyBindings != null) {
            buddyListArray = buddyCore.getBuddyListsFromKeyBindings(keyBindings);
        }
        this.buddyListList.removeAll();
        if (keyBindings2 != null) {
            keyBindings3 = keyBindings2.getValues(BuddyCore.BUDDY_LIST_KEY);
        }
        if (keyBindings3 != null) {
            n = keyBindings3.size();
        }
        int n2 = 0;
        while (n2 < buddyListArray.length) {
            this.buddyListList.addItem(buddyListArray[n2].name());
            if (keyBindings3 == null) {
                this.buddyListList.select(n2);
            }
            int n3 = 0;
            while (n3 < n) {
                String string = (String)keyBindings3.elementAt(n3);
                if (string.equals(buddyListArray[n2].name())) {
                    this.buddyListList.select(n2);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.preferences = Oscar.config.getKeyBindingsOrAdd("ImportExport.import");
        KeyBindings keyBindings = this.getImportConfig(this.importTextField.getText(), false);
        this.setValuesForBuddyList(keyBindings.getKeyBindings(BuddyCore.BUDDY_LIST_KEY), this.preferences);
        this.settingsEnabled(keyBindings != null && keyBindings.size() > 0);
        this.setChanged(true);
    }
}

